
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_detail_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_detail_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `account_subtype_id` bigint unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_detail_types` WRITE;
/*!40000 ALTER TABLE `account_detail_types` DISABLE KEYS */;
INSERT INTO `account_detail_types` VALUES (1,0,1,'Allowance for bad debts','Use Allowance for bad debts to estimate the part of Accounts Receivable that you think you might not collect. Use this only if you are keeping your books on the accrual basis.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(2,0,1,'Assets available for sale','Use Assets available for sale to track assets that are available for sale that are not expected to be held for a long period of time.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(3,0,1,'Development costs','Use Development costs to track amounts you deposit or set aside to arrange for financing, such as an SBA loan, or for deposits in anticipation of the purchase of property or other assets. When the deposit is refunded, or the purchase takes place, remove the amount from this account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(4,0,1,'Employee cash advances','Use Employee cash advances to track employee wages and salary you issue to an employee early, or other non-salary money given to employees. If you make a loan to an employee, use the Current asset account type called Loans to others, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(5,0,1,'Inventory','Use Inventory to track the cost of goods your business purchases for resale. When the goods are sold, assign the sale to a Cost of sales account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(6,0,1,'Investments - Other','Use Investments - Other to track the value of investments not covered by other investment account types. Examples include publicly-traded shares, coins, or gold.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(7,0,1,'Loans to officers','If you operate your business as a Corporation, use Loans to officers to track money loaned to officers of your business.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(8,0,1,'Loans to others','Use Loans to others to track money your business loans to other people or businesses. This type of account is also referred to as Notes Receivable. For early salary payments to employees, use Employee cash advances, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(9,0,1,'Loans to Shareholders','If you operate your business as a Corporation, use Loans to Shareholders to track money your business loans to its shareholders',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(10,0,1,'Other current assets','Use Other current assets for current assets not covered by the other types. Current assets are likely to be converted to cash or used up in a year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(11,0,1,'Prepaid expenses','Use Prepaid expenses to track payments for expenses that you won\'t recognise until your next accounting period. When you recognise the expense, make a journal entry to transfer money from this account to the expense account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(12,0,1,'Retainage','Use Retainage if your customers regularly hold back a portion of a contract amount until you have completed a project. This type of account is often used in the construction industry, and only if you record income on an accrual basis.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(13,0,1,'Undeposited funds','Use Undeposited funds for cash or cheques from sales that haven\'t been deposited yet. For petty cash, use Cash on hand, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(14,0,2,'Accumulated amortisation of non-current assets','Use Accumulated amortisation of non-current assets to track how much you\'ve amortised an asset whose type is Non-Current Asset.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(15,0,2,'Assets held for sale','Use Assets held for sale to track assets of a company that are available for sale that are not expected to be held for a long period of time.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(16,0,2,'Deferred tax','Use Deferred tax for tax liabilities or assets that are to be used in future accounting periods.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(17,0,2,'Goodwill','Use Goodwill only if you have acquired another company. It represents the intangible assets of the acquired company which gave it an advantage, such as favourable government relations, business name, outstanding credit ratings, location, superior management, customer lists, product quality, or good labour relations.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(18,0,2,'Intangible assets','Use Intangible assets to track intangible assets that you plan to amortise. Examples include franchises, customer lists, copyrights, and patents.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(19,0,2,'Lease buyout','Use Lease buyout to track lease payments to be applied toward the purchase of a leased asset. You don\'t track the leased asset itself until you purchase it.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(20,0,2,'Licences','Use Licences to track non-professional licences for permission to engage in an activity, like selling alcohol or radio broadcasting. For fees associated with professional licences granted to individuals, use a Legal and professional fees expense account, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(21,0,2,'Long-term investments','Use Long-term investments to track investments that have a maturity date of longer than one year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(22,0,2,'Organisational costs','Use Organisational costs to track costs incurred when forming a partnership or corporation. The costs include the legal and accounting costs necessary to organise the company, facilitate the filings of the legal documents, and other paperwork.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(23,0,2,'Other non-current assets','Use Other non-current assets to track assets not covered by other types. Non-current assets are long-term assets that are expected to provide value for more than one year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(24,0,2,'Security deposits','Use Security deposits to track funds you\'ve paid to cover any potential costs incurred by damage, loss, or theft. The funds should be returned to you at the end of the contract. If you accept down payments, advance payments, security deposits, or other kinds of deposits, use an Other Current liabilities account with the detail type Other Current liabilities.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(25,0,3,'Accumulated depletion','Use Accumulated depletion to track how much you deplete a natural resource.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(26,0,3,'Accumulated depreciation on property, plant and equipment','Use Accumulated depreciation on property, plant and equipment to track how much you depreciate a fixed asset (a physical asset you do not expect to convert to cash during one year of normal operations).',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(27,0,3,'Buildings','Use Buildings to track the cost of structures you own and use for your business. If you have a business in your home, consult your accountant. Use a Land account for the land portion of any real property you own, splitting the cost of the property between land and building in a logical method. A common method is to mimic the land-to-building ratio on the property tax statement.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(28,0,3,'Depletable assets','Use Depletable assets to track natural resources, such as timberlands, oil wells, and mineral deposits.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(29,0,3,'Furniture and fixtures','Use Furniture and fixtures to track any furniture and fixtures your business owns and uses, like a dental chair or sales booth.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(30,0,3,'Land','Use Land to track assets that are not easily convertible to cash or not expected to become cash within the next year. For example, leasehold improvements.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(31,0,3,'Leasehold improvements','Use Leasehold improvements to track improvements to a leased asset that increases the asset\'s value. For example, if you carpet a leased office space and are not reimbursed, that\'s a leasehold improvement.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(32,0,3,'Machinery and equipment','Use Machinery and equipment to track computer hardware, as well as any other non-furniture fixtures or devices owned and used for your business. This includes equipment that you ride, like tractors and lawn mowers. Cars and lorries, however, should be tracked with Vehicle accounts, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(33,0,3,'Other fixed asset','Use Other fixed asset for fixed assets that are not covered by other asset types. Fixed assets are physical property that you use in your business and that you do not expect to convert to cash or be used up during one year of normal operations.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(34,0,3,'Vehicles','Use Vehicles to track the value of vehicles your business owns and uses for business. This includes off-road vehicles, air planes, helicopters, and boats. If you use a vehicle for both business and personal use, consult your accountant to see how you should track its value.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(35,0,4,'Accounts Receivable(A/R)','Accounts receivable (also called A/R, Debtors, or Trade and other receivables) tracks money that customers owe you for products or services, and payments customers make. Ultimate Pos -Accounting Module  automatically creates one Accounts receivable account for you. Most businesses need only one. Each customer has a register, which functions like an Accounts receivable account for each customer.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(36,0,5,'Bank','Use Bank accounts to track all your current activity, including debit card transactions. Each current account your company has at a bank or other financial institution should have its own Bank type account in Ultimate POS.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(37,0,5,'Cash and Cash Equivalents','Use Cash and Cash Equivalents to track cash or assets that can be converted into cash immediately. For example, marketable securities and Treasury bills.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(38,0,5,'Cash on hand','Use a Cash on hand account to track cash your company keeps for occasional expenses, also called petty cash. To track cash from sales that have not been deposited yet, use a pre-created account called Undeposited funds, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(39,0,5,'Client trust accounts','Use Client trust accounts for money held by you for the benefit of someone else. For example, trust accounts are often used by attorneys to keep track of expense money their customers have given them. Often, to keep the amount in a trust account from looking like it\'s yours, the amount is offset in a \"contra\" liability account (a Current Liability).',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(40,0,5,'Money market','Use Money market to track amounts in money market accounts. For investments, see Current Assets, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(41,0,5,'Rents held in trust','Use Rents held in trust to track deposits and rent held on behalf of the property owners. Typically only property managers use this type of account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(42,0,5,'Savings','Use Savings accounts to track your savings and CD activity. Each savings account your company has at a bank or other financial institution should have its own Savings type account. For investments, see Current Assets, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(43,0,6,'Accrued Liabilities','Use Accrued Liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(44,0,6,'Client Trust accounts - liabilities','Use Client Trust accounts - liabilities to offset Client Trust accounts in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This \"contra\" account takes care of that, as long as the two balances match.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(45,0,6,'Current tax liability','Use Current tax liability to track the total amount of taxes collected but not yet paid to the government.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(46,0,6,'Current portion of obligations under finance leases','Use Current portion of obligations under finance leases to track the value of lease payments due within the next 12 months.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(47,0,6,'Dividends payable','Use Dividends payable to track dividends that are owed to shareholders but have not yet been paid.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(48,0,6,'Income tax payable','Use Income tax payable to track monies that are due to pay the company\'s income tax liabilties.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(49,0,6,'Insurance payable','Use Insurance payable to keep track of insurance amounts due. This account is most useful for businesses with monthly recurring insurance expenses.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(50,0,6,'Line of credit','Use Line of credit to track the balance due on any lines of credit your business has. Each line of credit your business has should have its own Line of credit account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(51,0,6,'Loan payable','Use Loan payable to track loans your business owes which are payable within the next twelve months. For longer-term loans, use the Long-term liability called Notes payable, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(52,0,6,'Other current liabilities','Use Other current liabilities to track monies owed by the company and due within one year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(53,0,6,'Payroll clearing','Use Payroll clearing to keep track of any non-tax amounts that you have deducted from employee paycheques or that you owe as a result of doing payroll. When you forward money to the appropriate suppliers, deduct the amount from the balance of this account. Do not use this account for tax amounts you have withheld or owe from paying employee wages. For those amounts, use the Payroll tax payable account instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(54,0,6,'Payroll liabilities','Use Payroll liabilities to keep track of tax amounts that you owe to government agencies as a result of paying wages. This includes taxes withheld, health care premiums, employment insurance, government pensions, etc. When you forward the money to the government agency, deduct the amount from the balance of this account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(55,0,6,'Prepaid expenses payable','Use Prepaid expenses payable to track items such as property taxes that are due, but not yet deductible as an expense because the period they cover has not yet passed.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(56,0,6,'Rents in trust - Liability','Use Rents in trust - liability to offset the Rents in trust amount in assets. Amounts in these accounts are held by your business on behalf of others. They do not belong to your business, so should not appear to be yours on your balance sheet. This \"contra\" account takes care of that, as long as the two balances match.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(57,0,6,'Sales and service tax payable','Use Sales and service tax payable to track tax you have collected, but not yet remitted to your government tax agency. This includes value-added tax, goods and services tax, sales tax, and other consumption tax.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(58,0,7,'Accrued holiday payable','Use Accrued holiday payable to track holiday earned but that has not been paid out to employees.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(59,0,7,'Accrued Non-current liabilities','Use Accrued Non-current liabilities to track expenses that a business has incurred but has not yet paid. For example, pensions for companies that contribute to a pension fund for their employees for their retirement.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(60,0,7,'Liabilities related to assets held for sale','Use Liabilities related to assets held for sale to track any liabilities that are directly related to assets being sold or written off.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(61,0,7,'Long-term debt','Use Long-term debt to track loans and obligations with a maturity of longer than one year. For example, mortgages.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(62,0,7,'Notes payable','Use Notes payable to track the amounts your business owes in long-term (over twelve months) loans. For shorter loans, use the Current liability account type called Loan payable, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(63,0,7,'Other non-current liabilities','Use Other non-current liabilities to track liabilities due in more than twelve months that don\'t fit the other Non-Current liability account types.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(64,0,7,'Shareholder notes payable','Use Shareholder notes payable to track long-term loan balances your business owes its shareholders.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(65,0,8,'Accounts Payable (A/P)','Accounts payable (also called A/P, Trade and other payables, or Creditors) tracks amounts you owe to your suppliers. Ultimate POS automatically creates one Accounts Payable account for you. Most businesses need only one.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(66,0,9,'Credit Card','Credit card accounts track the balance due on your business credit cards. Create one Credit card account for each credit card account your business uses.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(67,0,10,'Accumulated Adjustment','Some corporations use this account to track adjustments to owner\'s equity that are not attributable to net income.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(68,0,10,'Dividend disbursed','Use Dividend disbursed to track a payment given to its shareholders out of the company\'s retained earnings.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(69,0,10,'Equity in earnings of subsidiaries','Use Equity in earnings of subsidiaries to track the original investment in shares of subsidiaries plus the share of earnings or losses from the operations of the subsidiary.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(70,0,10,'Opening balance equity','Ultimate POS creates this account the first time you enter an opening balance for a balance sheet account. As you enter opening balances, Ultimate POS records the amounts in Opening balance equity. This ensures that you have a correct balance sheet for your company, even before you\'ve finished entering all your company\'s assets and liabilities.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(71,0,10,'Ordinary shares','Corporations use Ordinary shares to track its ordinary shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the stock.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(72,0,10,'Other comprehensive income','Use Other comprehensive income to track the increases or decreases in income from various businesses that is not yet absorbed by the company.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(73,0,10,'Owner\'s Equity','Corporations use Owner\'s equity to show the cumulative net income or loss of their business as of the beginning of the financial year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(74,0,10,'Paid-in capital or Surplus','Corporations use Paid-in capital to track amounts received from shareholders in exchange for shares that are over and above the shares\' stated (or par) value.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(75,0,10,'Partner contributions','Partnerships use Partner contributions to track amounts partners contribute to the partnership during the year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(76,0,10,'Partner distributions','Partnerships use Partner distributions to track amounts distributed by the partnership to its partners during the year. Don\'t use this for regular payments to partners for interest or service. For regular payments, use a Guaranteed payments account (a Expense account in Payroll expenses), instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(77,0,10,'Partner\'s Equity','Partnerships use Partner\'s equity to show the income remaining in the partnership for each partner as of the end of the prior year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(78,0,10,'Preferred Shares','Corporations use this account to track its preferred shares in the hands of shareholders. The amount in this account should be the stated (or par) value of the shares.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(79,0,10,'Retained earnings','Ultimate POS adds this account when you create your company. Retained earnings tracks net income from previous financial years. Ultimate POS automatically transfers your profit (or loss) to Retained earnings at the end of each financial year.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(80,0,10,'Share capital','Use Share capital to track the funds raised by issuing shares.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(81,0,10,'Treasury shares','Corporations use Treasury shares to track amounts paid by the corporation to buy its own shares back from shareholders.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(82,0,11,'Discounts/refunds given','Use Discounts/refunds given to track discounts you give to customers. This account typically has a negative balance so it offsets other income. For discounts from suppliers, use an expense account, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(83,0,11,'Non-profit income','Use Non-profit income to track money coming in if you are a non-profit organisation.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(84,0,11,'Other primary income','Use Other primary income to track income from normal business operations that doesn\'t fall into another Income type.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(85,0,11,'Revenue - General','Use Revenue - General to track income from normal business operations that do not fit under any other category.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(86,0,11,'Sales - retail','Use Sales - retail to track sales of goods/services that have a mark-up cost to consumers.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(87,0,11,'Sales - wholesale','Use Sales - wholesale to track the sale of goods in quantity for resale purposes.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(88,0,11,'Sales of Product Income','Use Sales of product income to track income from selling products. This can include all kinds of products, like crops and livestock, rental fees, performances, and food served.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(89,0,11,'Service/fee income','Use Service/fee income to track income from services you perform or ordinary usage fees you charge. For fees customers pay you for late payments or other uncommon situations, use an Other Income account type called Other miscellaneous income, instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(90,0,11,'Unapplied Cash Payment Income','Unapplied Cash Payment Income reports the Cash Basis income from customers payments you\'ve received but not applied to invoices or charges. In general, you would never use this directly on a purchase or sale transaction.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(91,0,12,'Dividend income','Use Dividend income to track taxable dividends from investments.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(92,0,12,'Interest earned','Use Interest earned to track interest from bank or savings accounts, investments, or interest payments to you on loans your business made.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(93,0,12,'Loss on disposal of assets','Use Loss on disposal of assets to track losses realised on the disposal of assets.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(94,0,12,'Other investment income','Use Other investment income to track other types of investment income that isn\'t from dividends or interest.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(95,0,12,'Other miscellaneous income','Use Other miscellaneous income to track income that isn\'t from normal business operations, and doesn\'t fall into another Other Income type.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(96,0,12,'Other operating income','Use Other operating income to track income from activities other than normal business operations. For example, Investment interest, foreign exchange gains, and rent income.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(97,0,12,'Tax-exempt interest','Use Tax-exempt interest to record interest that isn\'t taxable, such as interest on money in tax-exempt retirement accounts, or interest from tax-exempt bonds.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(98,0,12,'Unrealised loss on securities, net of tax','Use Unrealised loss on securities, net of tax to track losses on securities that have occurred but are yet been realised through a transaction. For example, shares whose value has fallen but that are still being held.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(99,0,13,'Advertising/Promotional','Use Advertising/promotional to track money spent promoting your company. You may want different accounts of this type to track different promotional efforts (Yellow Pages, newspaper, radio, flyers, events, and so on). If the promotion effort is a meal, use Promotional meals instead.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(100,0,13,'Amortisation Expense','Use Amortisation expense to track writing off of assets (such as intangible assets or investments) over the projected life of the assets.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(101,0,13,'Auto','Use Auto to track costs associated with vehicles. You may want different accounts of this type to track petrol, repairs, and maintenance. If your business owns a car or lorry, you may want to track its value as a Fixed Asset, in addition to tracking its expenses.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(102,0,13,'Bad debt','Use Bad debt to track debt you have written off.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(103,0,13,'Bank charges','Use Bank charges for any fees you pay to financial institutions.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(104,0,13,'Charitable contributions','Use Charitable contributions to track gifts to charity.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(105,0,13,'Commissions and fees','Use Commissions and fees to track amounts paid to agents (such as brokers) in order for them to execute a trade.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(106,0,13,'Cost of labour','Use Cost of labour to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable. This account is also available as a Cost of Sales (COS) account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(107,0,13,'Dues and subscriptions','Use Dues and subscriptions to track dues and subscriptions related to running your business. You may want different accounts of this type for professional dues, fees for licences that can\'t be transferred, magazines, newspapers, industry publications, or service subscriptions.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(108,0,13,'Equipment rental','Use Equipment rental to track the cost of renting equipment to produce products or services. This account is also available as a Cost of Sales account. If you purchase equipment, use a Fixed asset account type called Machinery and equipment.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(109,0,13,'Finance costs','Use Finance costs to track the costs of obtaining loans or credit. Examples of finance costs would be credit card fees, interest and mortgage costs.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(110,0,13,'Income tax expense','Use Income tax expense to track income taxes that the company has paid to meet their tax obligations.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(111,0,13,'Insurance','Use Insurance to track insurance payments. You may want different accounts of this type for different types of insurance (auto, general liability, and so on).',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(112,0,13,'Interest paid','Use Interest paid for all types of interest you pay, including mortgage interest, finance charges on credit cards, or interest on loans.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(113,0,13,'Legal and professional fees','Use Legal and professional fees to track money to pay to professionals to help you run your business. You may want different accounts of this type for payments to your accountant, attorney, or other consultants.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(114,0,13,'Loss on discontinued operations, net of tax','Use Loss on discontinued operations, net of tax to track the loss realised when a part of the business ceases to operate or when a product line is discontinued.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(115,0,13,'Management compensation','Use Management compensation to track remuneration paid to Management, Executives and non-Executives. For example, salary, fees, and benefits.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(116,0,13,'Meals and entertainment','Use Meals and entertainment to track how much you spend on dining with your employees to promote morale. If you dine with a customer to promote your business, use a Promotional meals account, instead. Be sure to include who you ate with and the purpose of the meal when you enter the transaction.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(117,0,13,'Office/general administrative expenses','Use Office/general administrative expenses to track all types of general or office-related expenses.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(118,0,13,'Other miscellaneous service cost','Use Other miscellaneous service cost to track costs related to providing services that don\'t fall into another Expense type. This account is also available as a Cost of Sales (COS) account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(119,0,13,'Other selling expenses','Use Other selling expenses to track selling expenses incurred that do not fall under any other category.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(120,0,13,'Payroll expenses','Use Payroll expenses to track payroll expenses. You may want different accounts of this type for things like: Compensation of officers, Guaranteed payments, Workers compensation, Salaries and wages, Payroll taxes',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(121,0,13,'Rent or lease of buildings','Use Rent or lease of buildings to track rent payments you make.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(122,0,13,'Repair and maintenance','Use Repair and maintenance to track any repairs and periodic maintenance fees. You may want different accounts of this type to track different types repair & maintenance expenses (auto, equipment, landscape, and so on).',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(123,0,13,'Shipping and delivery expense','Use Shipping and delivery expense to track the cost of shipping and delivery of goods to customers.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(124,0,13,'Supplies & materials','Use Supplies & materials to track the cost of raw goods and parts used or consumed when producing a product or providing a service. This account is also available as a Cost of Sales account.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(125,0,13,'Taxes paid','Use Taxes paid to track taxes you pay. You may want different accounts of this type for payments to different tax agencies.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(126,0,13,'Travel expenses - general and admin expenses','Use Travel expenses - general and admin expenses to track travelling costs incurred that are not directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when performing job interviews.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(127,0,13,'Travel expenses - selling expense','Use Travel expenses - selling expense to track travelling costs incurred that are directly related to the revenue-generating operation of the company. For example, flight tickets and hotel costs when selling products and services.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(128,0,13,'Unapplied Cash Bill Payment Expense','Unapplied Cash Bill Payment Expense reports the Cash Basis expense from supplier payment cheques you\'ve sent but not yet applied to supplier bills. In general, you would never use this directly on a purchase or sale transaction.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(129,0,13,'Utilities','Use Utilities to track utility payments. You may want different accounts of this type to track different types of utility payments (gas and electric, telephone, water, and so on).',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(130,0,14,'Cost of labour - COS','Use Cost of labour - COS to track the cost of paying employees to produce products or supply services. It includes all employment costs, including food and transportation, if applicable.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(131,0,14,'Equipment rental - COS','Use Equipment rental - COS to track the cost of renting equipment to produce products or services. If you purchase equipment, use a Fixed Asset account type called Machinery and equipment.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(132,0,14,'Freight and delivery - COS','Use Freight and delivery - COS to track the cost of shipping/delivery of obtaining raw materials and producing finished goods for resale.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(133,0,14,'Other costs of sales - COS','Use Other costs of sales - COS to track costs related to services or sales that you provide that don\'t fall into another Cost of Sales type.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(134,0,14,'Supplies and materials - COS','Use Supplies and materials - COS to track the cost of raw goods and parts used or consumed when producing a product or providing a service.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(135,0,15,'Amortisation','Use Amortisation to track amortisation of intangible assets. Amortisation is spreading the cost of an intangible asset over its useful life, like depreciation of fixed assets. You may want an amortisation account for each intangible asset you have.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(136,0,15,'Depreciation','Use Depreciation to track how much you depreciate fixed assets. You may want a depreciation account for each fixed asset you have.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(137,0,15,'Exchange Gain or Loss','Use Exchange Gain or Loss to track gains or losses that occur as a result of exchange rate fluctuations.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(138,0,15,'Other expense','Use Other expense to track unusual or infrequent expenses that don\'t fall into another Other Expense type.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(139,0,15,'Penalties and settlements','Use Penalties and settlements to track money you pay for violating laws or regulations, settling lawsuits, or other penalties.',1,'2023-08-17 03:15:59','2023-08-17 03:15:59');
/*!40000 ALTER TABLE `account_detail_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_subtypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_subtypes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `account_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_subtypes` WRITE;
/*!40000 ALTER TABLE `account_subtypes` DISABLE KEYS */;
INSERT INTO `account_subtypes` VALUES (1,0,'asset','Current Assets',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(2,0,'asset','Non- Current Assets',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(3,0,'asset','Fixed Assets',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(4,0,'asset','Accounts Receivable(A/R)',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(5,0,'asset','Cash and Cash Equivalents (CCE)',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(6,0,'liability','Current Liabilities',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(7,0,'liability','Non- Current Liabilities',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(8,0,'liability','Accounts Payable (A/P)',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(9,0,'liability','Credit Card',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(10,0,'equity','Owner\'s Equity',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(11,0,'income','Income',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(12,0,'income','Other Income',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(13,0,'expense','Expense',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(14,0,'expense','Cost of Sales',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59'),(15,0,'expense','Other Expense',NULL,1,'2023-08-17 03:15:59','2023-08-17 03:15:59');
/*!40000 ALTER TABLE `account_subtypes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int NOT NULL,
  `type` enum('debit','credit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int NOT NULL,
  `transaction_id` int DEFAULT NULL,
  `transaction_payment_id` int DEFAULT NULL,
  `transfer_transaction_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=923 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES (1,2,'credit','opening_balance',-1349253.0000,NULL,'2023-05-18 11:41:13',3,NULL,NULL,NULL,NULL,NULL,'2023-05-18 16:41:13','2023-05-18 16:41:13'),(2,3,'credit','opening_balance',4808697.0000,NULL,'2023-05-18 11:42:11',3,NULL,NULL,NULL,NULL,NULL,'2023-05-18 16:42:11','2023-05-18 16:42:11'),(3,3,'credit',NULL,4536.0000,NULL,'2023-05-18 14:02:16',3,5760,2,NULL,NULL,NULL,'2023-05-19 03:35:57','2023-05-19 03:35:57'),(4,2,'debit',NULL,750000.0000,NULL,'2023-05-19 13:27:00',3,5872,4,NULL,NULL,NULL,'2023-05-19 20:23:24','2023-05-19 20:23:24'),(5,3,'credit',NULL,30600.0000,NULL,'2023-05-15 19:23:00',3,NULL,7,NULL,NULL,NULL,'2023-05-20 00:24:49','2023-05-20 00:24:49'),(6,3,'credit',NULL,100000.0000,NULL,'2023-05-15 19:28:00',3,NULL,10,NULL,NULL,'2023-05-20 00:44:56','2023-05-20 00:28:53','2023-05-20 00:44:56'),(7,3,'credit',NULL,100000.0000,NULL,'2023-05-15 19:28:00',3,NULL,12,NULL,NULL,'2023-05-20 00:47:28','2023-05-20 00:31:26','2023-05-20 00:47:28'),(8,3,'credit',NULL,16680.0000,NULL,'2023-05-15 19:32:00',3,NULL,14,NULL,NULL,NULL,'2023-05-20 00:32:40','2023-05-20 00:32:40'),(9,3,'credit',NULL,25000.0000,NULL,'2023-05-15 19:37:00',3,NULL,16,NULL,NULL,NULL,'2023-05-20 00:38:00','2023-05-20 00:38:00'),(10,3,'credit',NULL,90000.0000,NULL,'2023-05-17 19:48:00',3,NULL,18,NULL,NULL,NULL,'2023-05-20 00:49:25','2023-05-20 00:49:25'),(11,3,'credit',NULL,15000.0000,NULL,'2023-05-17 19:49:00',3,NULL,21,NULL,NULL,NULL,'2023-05-20 00:51:05','2023-05-20 00:51:05'),(12,3,'credit',NULL,53500.0000,NULL,'2023-05-17 19:51:00',3,NULL,22,NULL,NULL,NULL,'2023-05-20 00:51:50','2023-05-20 00:51:50'),(13,3,'credit',NULL,20900.0000,NULL,'2023-05-17 19:52:00',3,NULL,24,NULL,NULL,NULL,'2023-05-20 00:52:38','2023-05-20 00:52:38'),(14,3,'credit',NULL,23200.0000,NULL,'2023-05-17 19:53:00',3,NULL,26,NULL,NULL,NULL,'2023-05-20 00:53:14','2023-05-20 00:53:14'),(15,3,'credit',NULL,11000.0000,NULL,'2023-05-18 19:53:00',3,NULL,28,NULL,NULL,NULL,'2023-05-20 00:53:46','2023-05-20 00:53:46'),(16,3,'credit',NULL,10000.0000,NULL,'2023-05-18 19:54:00',3,NULL,30,NULL,NULL,NULL,'2023-05-20 00:54:23','2023-05-20 00:54:23'),(17,3,'credit',NULL,5000.0000,NULL,'2023-05-18 19:54:00',3,NULL,32,NULL,NULL,NULL,'2023-05-20 00:54:51','2023-05-20 00:54:51'),(18,3,'credit',NULL,10000.0000,NULL,'2023-05-18 19:55:00',3,NULL,34,NULL,NULL,NULL,'2023-05-20 00:55:22','2023-05-20 00:55:22'),(19,3,'credit',NULL,100000.0000,NULL,'2023-05-15 21:28:00',3,NULL,36,NULL,NULL,NULL,'2023-05-20 02:29:48','2023-05-20 02:29:48'),(20,3,'credit',NULL,13200.0000,NULL,'2023-05-17 08:39:00',3,NULL,38,NULL,NULL,'2023-05-25 18:40:31','2023-05-20 13:40:10','2023-05-25 18:40:31'),(21,3,'credit',NULL,5000.0000,NULL,'2023-05-20 13:11:00',3,NULL,47,NULL,NULL,NULL,'2023-05-20 18:12:23','2023-05-20 18:12:23'),(22,3,'credit',NULL,30000.0000,NULL,'2023-05-23 10:17:00',3,NULL,184,NULL,NULL,NULL,'2023-05-23 15:18:19','2023-05-23 15:18:19'),(23,3,'credit',NULL,5000.0000,NULL,'2023-05-23 13:25:00',3,NULL,200,NULL,NULL,NULL,'2023-05-23 18:25:56','2023-05-23 18:25:56'),(24,3,'credit',NULL,20000.0000,NULL,'2023-05-23 13:26:00',3,NULL,202,NULL,NULL,NULL,'2023-05-23 18:26:44','2023-05-23 18:26:44'),(25,3,'credit',NULL,9000.0000,NULL,'2023-05-23 13:32:00',3,NULL,205,NULL,NULL,NULL,'2023-05-23 18:34:12','2023-05-23 18:34:12'),(26,3,'credit',NULL,5000.0000,NULL,'2023-05-23 13:37:00',3,NULL,207,NULL,NULL,NULL,'2023-05-23 18:38:39','2023-05-23 18:38:39'),(27,3,'credit',NULL,5000.0000,NULL,'2023-05-23 15:58:00',3,NULL,216,NULL,NULL,NULL,'2023-05-23 20:58:52','2023-05-23 20:58:52'),(28,3,'credit',NULL,5000.0000,NULL,'2023-05-24 09:16:00',3,NULL,269,NULL,NULL,NULL,'2023-05-24 14:17:05','2023-05-24 14:17:05'),(29,3,'credit',NULL,80000.0000,NULL,'2023-05-24 10:25:00',3,NULL,272,NULL,NULL,NULL,'2023-05-24 15:32:10','2023-05-24 15:32:10'),(30,3,'credit',NULL,15000.0000,NULL,'2023-05-24 12:51:00',3,NULL,280,NULL,NULL,NULL,'2023-05-24 17:52:10','2023-05-24 17:52:10'),(31,3,'credit',NULL,10000.0000,NULL,'2023-05-24 14:00:00',3,NULL,285,NULL,NULL,'2023-05-25 18:14:00','2023-05-24 19:01:21','2023-05-25 18:14:00'),(32,3,'credit',NULL,10000.0000,NULL,'2023-05-24 14:00:00',3,NULL,287,NULL,NULL,'2023-05-25 18:13:28','2023-05-24 19:01:25','2023-05-25 18:13:28'),(33,3,'credit',NULL,10000.0000,NULL,'2023-05-24 14:00:00',3,NULL,289,NULL,NULL,'2023-05-25 18:13:14','2023-05-24 19:03:27','2023-05-25 18:13:14'),(34,3,'credit',NULL,10000.0000,NULL,'2023-05-24 14:00:00',3,NULL,296,NULL,NULL,'2023-05-25 18:13:09','2023-05-24 19:43:01','2023-05-25 18:13:09'),(35,3,'credit',NULL,15000.0000,NULL,'2023-05-24 12:51:00',3,NULL,298,NULL,NULL,'2023-05-25 18:20:22','2023-05-24 19:43:55','2023-05-25 18:20:22'),(36,3,'credit',NULL,37500.0000,NULL,'2023-05-25 11:19:00',3,NULL,367,NULL,NULL,NULL,'2023-05-25 16:20:13','2023-05-25 16:20:13'),(37,3,'credit',NULL,5000.0000,NULL,'2023-05-26 08:54:00',3,NULL,426,NULL,NULL,NULL,'2023-05-26 13:54:57','2023-05-26 13:54:57'),(38,3,'credit',NULL,10000.0000,NULL,'2023-05-26 12:45:00',3,NULL,434,NULL,NULL,NULL,'2023-05-26 17:45:19','2023-05-26 17:45:19'),(39,3,'credit',NULL,25000.0000,NULL,'2023-05-30 17:21:00',3,NULL,720,NULL,NULL,NULL,'2023-05-30 22:21:45','2023-05-30 22:21:45'),(40,3,'credit',NULL,3200.0000,NULL,'2023-05-30 17:22:00',3,NULL,722,NULL,NULL,NULL,'2023-05-30 22:22:15','2023-05-30 22:22:15'),(41,3,'credit',NULL,15000.0000,NULL,'2023-05-30 17:22:00',3,NULL,724,NULL,NULL,NULL,'2023-05-30 22:22:52','2023-05-30 22:22:52'),(42,3,'credit',NULL,12000.0000,NULL,'2023-05-30 17:23:00',3,NULL,726,NULL,NULL,NULL,'2023-05-30 22:23:30','2023-05-30 22:23:30'),(43,3,'credit',NULL,5000.0000,NULL,'2023-05-30 17:25:00',3,NULL,728,NULL,NULL,NULL,'2023-05-30 22:26:06','2023-05-30 22:26:06'),(44,3,'credit',NULL,26400.0000,NULL,'2023-05-30 17:26:00',3,NULL,731,NULL,NULL,NULL,'2023-05-30 22:27:08','2023-05-30 22:27:08'),(45,3,'credit',NULL,15600.0000,NULL,'2023-05-30 17:28:00',3,NULL,734,NULL,NULL,NULL,'2023-05-30 22:28:32','2023-05-30 22:28:32'),(46,3,'credit',NULL,14000.0000,NULL,'2023-05-30 17:29:00',3,NULL,736,NULL,NULL,NULL,'2023-05-30 22:29:47','2023-05-30 22:29:47'),(47,3,'credit',NULL,47800.0000,NULL,'2023-05-30 09:31:00',3,NULL,833,NULL,NULL,NULL,'2023-06-01 14:31:49','2023-06-01 14:31:49'),(48,3,'credit',NULL,26400.0000,NULL,'2023-05-30 09:32:00',3,NULL,835,NULL,NULL,NULL,'2023-06-01 14:33:05','2023-06-01 14:33:05'),(49,3,'credit',NULL,26460.0000,NULL,'2023-05-31 09:34:00',3,NULL,839,NULL,NULL,NULL,'2023-06-01 14:35:30','2023-06-01 14:35:30'),(50,3,'credit',NULL,170000.0000,NULL,'2023-05-31 09:35:00',3,NULL,841,NULL,NULL,NULL,'2023-06-01 14:37:23','2023-06-01 14:37:23'),(51,3,'credit',NULL,30000.0000,NULL,'2023-05-31 09:37:00',3,NULL,843,NULL,NULL,NULL,'2023-06-01 14:38:26','2023-06-01 14:38:26'),(52,3,'credit',NULL,15000.0000,NULL,'2023-06-01 09:39:00',3,NULL,845,NULL,NULL,NULL,'2023-06-01 14:39:39','2023-06-01 14:39:39'),(53,3,'credit',NULL,5068.0000,NULL,'2023-05-31 09:42:00',3,NULL,847,NULL,NULL,NULL,'2023-06-01 14:42:38','2023-06-01 14:42:38'),(54,3,'credit',NULL,5000.0000,NULL,'2023-05-31 09:42:00',3,NULL,849,NULL,NULL,NULL,'2023-06-01 14:43:23','2023-06-01 14:43:23'),(55,3,'credit',NULL,10000.0000,NULL,'2023-05-31 09:46:00',3,NULL,851,NULL,NULL,NULL,'2023-06-01 14:47:09','2023-06-01 14:47:09'),(56,3,'credit',NULL,3200.0000,NULL,'2023-05-31 09:49:00',3,NULL,853,NULL,NULL,NULL,'2023-06-01 14:49:37','2023-06-01 14:49:37'),(57,3,'credit',NULL,50800.0000,NULL,'2023-05-31 09:52:00',3,NULL,855,NULL,NULL,NULL,'2023-06-01 14:52:54','2023-06-01 14:52:54'),(58,3,'credit',NULL,6500.0000,NULL,'2023-05-31 09:53:00',3,NULL,858,NULL,NULL,NULL,'2023-06-01 14:53:50','2023-06-01 14:53:50'),(59,3,'credit',NULL,200000.0000,NULL,'2023-05-31 09:57:00',3,NULL,861,NULL,NULL,NULL,'2023-06-01 14:58:33','2023-06-01 14:58:33'),(60,3,'credit',NULL,11000.0000,NULL,'2023-05-31 10:13:00',3,NULL,864,NULL,NULL,NULL,'2023-06-01 15:13:57','2023-06-01 15:13:57'),(61,3,'credit',NULL,63000.0000,NULL,'2023-06-01 10:14:00',3,NULL,866,NULL,NULL,NULL,'2023-06-01 15:14:46','2023-06-01 15:14:46'),(62,3,'credit',NULL,10000.0000,NULL,'2023-06-01 18:38:00',3,NULL,897,NULL,NULL,NULL,'2023-06-01 23:38:26','2023-06-01 23:38:26'),(63,3,'credit',NULL,10000.0000,NULL,'2023-06-01 18:39:00',3,NULL,900,NULL,NULL,NULL,'2023-06-01 23:39:29','2023-06-01 23:39:29'),(64,3,'credit',NULL,10000.0000,NULL,'2023-06-01 18:39:00',3,NULL,902,NULL,NULL,NULL,'2023-06-01 23:39:53','2023-06-01 23:39:53'),(65,3,'credit',NULL,63060.0000,NULL,'2023-06-01 18:37:00',3,NULL,904,NULL,NULL,NULL,'2023-06-01 23:41:02','2023-06-01 23:41:02'),(66,3,'credit',NULL,30000.0000,NULL,'2023-06-01 09:02:00',3,NULL,931,NULL,NULL,NULL,'2023-06-02 14:03:31','2023-06-02 14:03:31'),(67,3,'credit',NULL,5000.0000,NULL,'2023-05-11 12:37:00',3,NULL,947,NULL,NULL,NULL,'2023-06-02 17:38:32','2023-06-02 17:38:32'),(68,3,'credit',NULL,62500.0000,NULL,'2023-06-02 12:38:00',3,NULL,949,NULL,NULL,NULL,'2023-06-02 17:39:06','2023-06-02 17:39:06'),(69,3,'credit',NULL,15000.0000,NULL,'2023-05-24 12:40:00',3,NULL,951,NULL,NULL,NULL,'2023-06-02 17:41:10','2023-06-02 17:41:10'),(70,3,'credit',NULL,17800.0000,NULL,'2023-06-02 12:41:00',3,NULL,953,NULL,NULL,NULL,'2023-06-02 17:41:49','2023-06-02 17:41:49'),(71,3,'credit',NULL,3000.0000,NULL,'2023-06-02 12:45:00',3,NULL,956,NULL,NULL,NULL,'2023-06-02 17:46:13','2023-06-02 17:46:13'),(72,3,'credit',NULL,20000.0000,NULL,'2023-06-02 12:55:00',3,NULL,959,NULL,NULL,NULL,'2023-06-02 17:56:35','2023-06-02 17:56:35'),(73,3,'credit',NULL,15100.0000,NULL,'2023-05-24 12:57:00',3,NULL,962,NULL,NULL,NULL,'2023-06-02 17:58:32','2023-06-02 17:58:32'),(74,3,'credit',NULL,105532.0000,NULL,'2023-06-02 12:58:00',3,NULL,964,NULL,NULL,NULL,'2023-06-02 17:59:08','2023-06-02 17:59:08'),(75,3,'credit',NULL,2200.0000,NULL,'2023-06-02 12:59:00',3,NULL,968,NULL,NULL,NULL,'2023-06-02 17:59:40','2023-06-02 17:59:40'),(76,3,'credit',NULL,25000.0000,NULL,'2023-06-02 13:04:00',3,NULL,970,NULL,NULL,NULL,'2023-06-02 18:04:43','2023-06-02 18:04:43'),(77,3,'credit',NULL,3100.0000,NULL,'2023-06-02 13:06:00',3,NULL,972,NULL,NULL,NULL,'2023-06-02 18:06:26','2023-06-02 18:06:26'),(78,3,'credit',NULL,5000.0000,NULL,'2023-06-02 13:07:00',3,NULL,976,NULL,NULL,NULL,'2023-06-02 18:08:07','2023-06-02 18:08:07'),(79,3,'credit',NULL,72980.0000,NULL,'2023-06-02 13:13:00',3,NULL,979,NULL,NULL,NULL,'2023-06-02 18:13:53','2023-06-02 18:13:53'),(80,3,'credit',NULL,3402.0000,NULL,'2023-06-02 13:24:00',3,NULL,982,NULL,NULL,NULL,'2023-06-02 18:25:07','2023-06-02 18:25:07'),(81,3,'credit',NULL,14060.0000,NULL,'2023-06-02 14:03:00',3,NULL,984,NULL,NULL,NULL,'2023-06-02 19:06:09','2023-06-02 19:06:09'),(82,3,'credit',NULL,26400.0000,NULL,'2023-05-29 14:45:00',3,NULL,992,NULL,NULL,NULL,'2023-06-02 19:46:11','2023-06-02 19:46:11'),(83,3,'credit',NULL,80.0000,NULL,'2023-06-02 14:49:00',3,NULL,994,NULL,NULL,NULL,'2023-06-02 19:49:56','2023-06-02 19:49:56'),(84,3,'credit',NULL,43114.0000,NULL,'2023-06-02 15:50:00',3,NULL,1002,NULL,NULL,NULL,'2023-06-02 20:51:00','2023-06-02 20:51:00'),(85,3,'credit',NULL,3510.0000,NULL,'2023-06-12 16:33:00',3,NULL,1009,NULL,NULL,NULL,'2023-06-02 21:33:39','2023-06-02 21:33:39'),(86,3,'credit',NULL,21000.0000,NULL,'2023-06-02 17:07:00',3,NULL,1017,NULL,NULL,NULL,'2023-06-02 22:09:05','2023-06-02 22:09:05'),(87,3,'credit',NULL,10400.0000,NULL,'2023-06-03 13:12:00',3,NULL,1075,NULL,NULL,NULL,'2023-06-03 18:13:03','2023-06-03 18:13:03'),(88,3,'credit',NULL,66250.0000,NULL,'2023-06-04 11:09:00',3,NULL,1161,NULL,NULL,NULL,'2023-06-04 16:09:24','2023-06-04 16:09:24'),(89,3,'credit',NULL,10000.0000,NULL,'2023-06-04 11:25:00',3,NULL,1163,NULL,NULL,NULL,'2023-06-04 16:25:36','2023-06-04 16:25:36'),(90,3,'credit',NULL,5000.0000,NULL,'2023-06-05 11:40:00',3,NULL,1241,NULL,NULL,NULL,'2023-06-05 16:41:07','2023-06-05 16:41:07'),(91,3,'credit',NULL,26400.0000,NULL,'2023-06-05 11:41:00',3,NULL,1243,NULL,NULL,NULL,'2023-06-05 16:41:40','2023-06-05 16:41:40'),(92,3,'credit',NULL,20000.0000,NULL,'2023-06-05 17:46:00',3,NULL,1273,NULL,NULL,NULL,'2023-06-05 22:46:42','2023-06-05 22:46:42'),(93,3,'credit',NULL,40000.0000,NULL,'2023-06-05 17:47:00',3,NULL,1275,NULL,NULL,NULL,'2023-06-05 22:47:30','2023-06-05 22:47:30'),(94,3,'credit',NULL,17000.0000,NULL,'2023-06-05 17:47:00',3,NULL,1277,NULL,NULL,NULL,'2023-06-05 22:48:07','2023-06-05 22:48:07'),(95,3,'credit',NULL,5000.0000,NULL,'2023-06-05 17:48:00',3,NULL,1279,NULL,NULL,NULL,'2023-06-05 22:48:42','2023-06-05 22:48:42'),(96,3,'credit',NULL,8800.0000,NULL,'2023-06-05 17:49:00',3,NULL,1281,NULL,NULL,NULL,'2023-06-05 22:49:12','2023-06-05 22:49:12'),(97,3,'credit',NULL,13250.0000,NULL,'2023-06-05 17:49:00',3,NULL,1283,NULL,NULL,NULL,'2023-06-05 22:49:38','2023-06-05 22:49:38'),(98,3,'credit',NULL,17000.0000,NULL,'2023-06-05 17:49:00',3,NULL,1285,NULL,NULL,NULL,'2023-06-05 22:50:07','2023-06-05 22:50:07'),(99,3,'credit',NULL,15022.0000,NULL,'2023-06-05 17:50:00',3,NULL,1287,NULL,NULL,NULL,'2023-06-05 22:50:42','2023-06-05 22:50:42'),(100,3,'credit',NULL,32000.0000,NULL,'2023-06-05 17:51:00',3,NULL,1289,NULL,NULL,NULL,'2023-06-05 22:51:18','2023-06-05 22:51:18'),(101,3,'credit',NULL,15000.0000,NULL,'2023-06-05 17:51:00',3,NULL,1291,NULL,NULL,NULL,'2023-06-05 22:51:54','2023-06-05 22:51:54'),(102,3,'credit',NULL,15700.0000,NULL,'2023-06-05 17:52:00',3,NULL,1293,NULL,NULL,NULL,'2023-06-05 22:52:33','2023-06-05 22:52:33'),(103,3,'credit',NULL,19540.0000,NULL,'2023-06-05 17:53:00',3,NULL,1295,NULL,NULL,NULL,'2023-06-05 22:53:22','2023-06-05 22:53:22'),(104,3,'credit',NULL,13250.0000,NULL,'2023-06-05 17:54:00',3,NULL,1297,NULL,NULL,NULL,'2023-06-05 22:54:55','2023-06-05 22:54:55'),(105,3,'credit',NULL,23000.0000,NULL,'2023-06-05 23:35:00',3,NULL,1342,NULL,NULL,NULL,'2023-06-06 04:36:09','2023-06-06 04:36:09'),(106,3,'credit',NULL,10000.0000,NULL,'2023-06-05 23:38:00',3,NULL,1344,NULL,NULL,NULL,'2023-06-06 04:38:58','2023-06-06 04:38:58'),(107,3,'credit',NULL,30000.0000,NULL,'2023-06-06 00:16:00',3,NULL,1349,NULL,NULL,NULL,'2023-06-06 05:16:45','2023-06-06 05:16:45'),(108,3,'credit',NULL,11412.0000,NULL,'2023-06-06 12:27:00',3,NULL,1360,NULL,NULL,NULL,'2023-06-06 17:27:49','2023-06-06 17:27:49'),(109,3,'credit',NULL,25000.0000,NULL,'2023-06-06 15:44:00',3,NULL,1383,NULL,NULL,NULL,'2023-06-06 20:44:43','2023-06-06 20:44:43'),(110,3,'credit',NULL,45000.0000,NULL,'2023-06-06 19:44:00',3,NULL,1421,NULL,NULL,NULL,'2023-06-07 00:45:05','2023-06-07 00:45:05'),(111,3,'credit',NULL,5750.0000,NULL,'2023-06-06 19:46:00',3,NULL,1423,NULL,NULL,NULL,'2023-06-07 00:46:26','2023-06-07 00:46:26'),(112,3,'credit',NULL,35000.0000,NULL,'2023-06-06 19:47:00',3,NULL,1426,NULL,NULL,NULL,'2023-06-07 00:47:43','2023-06-07 00:47:43'),(113,3,'credit',NULL,2400.0000,NULL,'2023-06-06 19:48:00',3,NULL,1429,NULL,NULL,NULL,'2023-06-07 00:48:38','2023-06-07 00:48:38'),(114,3,'credit',NULL,50000.0000,NULL,'2023-06-06 19:50:00',3,NULL,1431,NULL,NULL,NULL,'2023-06-07 00:51:13','2023-06-07 00:51:13'),(115,3,'credit',NULL,290.0000,NULL,'2023-06-06 19:51:00',3,NULL,1433,NULL,NULL,NULL,'2023-06-07 00:52:08','2023-06-07 00:52:08'),(116,3,'credit',NULL,20000.0000,NULL,'2023-06-06 19:53:00',3,NULL,1437,NULL,NULL,NULL,'2023-06-07 00:53:21','2023-06-07 00:53:21'),(117,3,'credit',NULL,55028.0000,NULL,'2023-06-06 19:54:00',3,NULL,1439,NULL,NULL,NULL,'2023-06-07 00:55:13','2023-06-07 00:55:13'),(118,3,'credit',NULL,12000.0000,NULL,'2023-06-06 20:05:00',3,NULL,1443,NULL,NULL,NULL,'2023-06-07 01:06:10','2023-06-07 01:06:10'),(119,3,'credit',NULL,44000.0000,NULL,'2023-06-06 21:32:00',3,NULL,1457,NULL,NULL,NULL,'2023-06-07 02:33:13','2023-06-07 02:33:13'),(120,3,'credit',NULL,8000.0000,NULL,'2023-06-07 18:36:00',3,NULL,1516,NULL,NULL,NULL,'2023-06-07 23:37:15','2023-06-07 23:37:15'),(121,3,'credit',NULL,5150.0000,NULL,'2023-06-07 18:38:00',3,NULL,1518,NULL,NULL,NULL,'2023-06-07 23:38:23','2023-06-07 23:38:23'),(122,3,'credit',NULL,20000.0000,NULL,'2023-06-07 18:39:00',3,NULL,1520,NULL,NULL,NULL,'2023-06-07 23:39:53','2023-06-07 23:39:53'),(123,3,'credit',NULL,17362.0000,NULL,'2023-06-07 18:40:00',3,NULL,1522,NULL,NULL,NULL,'2023-06-07 23:40:47','2023-06-07 23:40:47'),(124,3,'credit',NULL,16000.0000,NULL,'2023-06-07 18:41:00',3,NULL,1526,NULL,NULL,NULL,'2023-06-07 23:41:30','2023-06-07 23:41:30'),(125,3,'credit',NULL,20000.0000,NULL,'2023-06-05 18:42:00',3,NULL,1528,NULL,NULL,NULL,'2023-06-07 23:43:41','2023-06-07 23:43:41'),(126,3,'credit',NULL,8000.0000,NULL,'2023-06-07 18:43:00',3,NULL,1530,NULL,NULL,NULL,'2023-06-07 23:44:16','2023-06-07 23:44:16'),(127,3,'credit',NULL,18000.0000,NULL,'2023-06-08 14:48:00',3,NULL,1599,NULL,NULL,NULL,'2023-06-08 19:49:22','2023-06-08 19:49:22'),(128,3,'credit',NULL,2000.0000,NULL,'2023-06-08 14:51:00',3,NULL,1601,NULL,NULL,NULL,'2023-06-08 19:51:43','2023-06-08 19:51:43'),(129,3,'credit',NULL,11930.0000,NULL,'2023-06-09 16:11:00',3,NULL,1680,NULL,NULL,NULL,'2023-06-09 21:11:58','2023-06-09 21:11:58'),(130,3,'credit',NULL,16500.0000,NULL,'2023-06-09 16:13:00',3,NULL,1683,NULL,NULL,NULL,'2023-06-09 21:13:26','2023-06-09 21:13:26'),(131,3,'credit',NULL,5300.0000,NULL,'2023-06-09 16:14:00',3,NULL,1686,NULL,NULL,NULL,'2023-06-09 21:14:33','2023-06-09 21:14:33'),(132,3,'credit',NULL,15174.0000,NULL,'2023-06-09 16:16:00',3,NULL,1688,NULL,NULL,NULL,'2023-06-09 21:16:40','2023-06-09 21:16:40'),(133,3,'credit',NULL,5400.0000,NULL,'2023-06-09 16:17:00',3,NULL,1690,NULL,NULL,NULL,'2023-06-09 21:18:06','2023-06-09 21:18:06'),(134,3,'credit',NULL,5500.0000,NULL,'2023-06-09 16:18:00',3,NULL,1692,NULL,NULL,NULL,'2023-06-09 21:18:55','2023-06-09 21:18:55'),(135,3,'credit',NULL,3000.0000,NULL,'2023-06-09 16:19:00',3,NULL,1694,NULL,NULL,NULL,'2023-06-09 21:19:39','2023-06-09 21:19:39'),(136,3,'credit',NULL,150000.0000,NULL,'2023-06-09 16:20:00',3,NULL,1696,NULL,NULL,NULL,'2023-06-09 21:20:32','2023-06-09 21:20:32'),(137,3,'credit',NULL,32000.0000,NULL,'2023-06-09 16:21:00',3,NULL,1699,NULL,NULL,NULL,'2023-06-09 21:21:23','2023-06-09 21:21:23'),(138,3,'credit',NULL,12000.0000,NULL,'2023-06-09 16:21:00',3,NULL,1701,NULL,NULL,NULL,'2023-06-09 21:21:55','2023-06-09 21:21:55'),(139,3,'credit',NULL,28100.0000,NULL,'2023-06-09 16:22:00',3,NULL,1703,NULL,NULL,NULL,'2023-06-09 21:22:36','2023-06-09 21:22:36'),(140,3,'credit',NULL,9984.0000,NULL,'2023-06-09 16:23:00',3,NULL,1705,NULL,NULL,NULL,'2023-06-09 21:23:16','2023-06-09 21:23:16'),(141,3,'credit',NULL,6000.0000,NULL,'2023-06-10 11:33:00',3,NULL,1831,NULL,NULL,NULL,'2023-06-11 16:34:10','2023-06-11 16:34:10'),(142,3,'credit',NULL,8538.0000,NULL,'2023-06-12 13:09:00',3,NULL,1934,NULL,NULL,NULL,'2023-06-12 18:09:50','2023-06-12 18:09:50'),(143,3,'credit',NULL,5100.0000,NULL,'2023-06-13 17:48:00',3,NULL,2089,NULL,NULL,NULL,'2023-06-13 22:49:25','2023-06-13 22:49:25'),(144,3,'credit',NULL,20775.0000,NULL,'2023-06-13 18:26:00',3,NULL,2098,NULL,NULL,NULL,'2023-06-13 23:26:23','2023-06-13 23:26:23'),(145,3,'credit',NULL,22000.0000,NULL,'2023-06-13 18:28:00',3,NULL,2101,NULL,NULL,NULL,'2023-06-13 23:29:26','2023-06-13 23:29:26'),(146,3,'credit',NULL,6000.0000,NULL,'2023-06-13 18:30:00',3,NULL,2103,NULL,NULL,NULL,'2023-06-13 23:30:49','2023-06-13 23:30:49'),(147,3,'credit',NULL,10000.0000,NULL,'2023-06-13 18:32:00',3,NULL,2105,NULL,NULL,NULL,'2023-06-13 23:32:58','2023-06-13 23:32:58'),(148,3,'credit',NULL,42162.0000,NULL,'2023-06-13 18:35:00',3,NULL,2108,NULL,NULL,NULL,'2023-06-13 23:36:01','2023-06-13 23:36:01'),(149,3,'credit',NULL,13000.0000,NULL,'2023-06-13 18:37:00',3,NULL,2110,NULL,NULL,NULL,'2023-06-13 23:37:56','2023-06-13 23:37:56'),(150,3,'credit',NULL,55000.0000,NULL,'2023-06-13 18:39:00',3,NULL,2112,NULL,NULL,NULL,'2023-06-13 23:39:38','2023-06-13 23:39:38'),(151,3,'credit',NULL,71850.0000,NULL,'2023-06-13 18:40:00',3,NULL,2114,NULL,NULL,NULL,'2023-06-13 23:40:50','2023-06-13 23:40:50'),(152,3,'credit',NULL,35000.0000,NULL,'2023-06-13 20:15:00',3,NULL,2121,NULL,NULL,NULL,'2023-06-14 01:15:48','2023-06-14 01:15:48'),(153,3,'credit',NULL,10000.0000,NULL,'2023-06-13 20:17:00',3,NULL,2124,NULL,NULL,NULL,'2023-06-14 01:17:39','2023-06-14 01:17:39'),(154,3,'credit',NULL,30000.0000,NULL,'2023-06-13 20:18:00',3,NULL,2126,NULL,NULL,NULL,'2023-06-14 01:18:58','2023-06-14 01:18:58'),(155,3,'credit',NULL,10550.0000,NULL,'2023-06-13 20:20:00',3,NULL,2129,NULL,NULL,NULL,'2023-06-14 01:21:07','2023-06-14 01:21:07'),(156,3,'credit',NULL,5000.0000,NULL,'2023-06-13 20:28:00',3,NULL,2131,NULL,NULL,NULL,'2023-06-14 01:29:05','2023-06-14 01:29:05'),(157,3,'credit',NULL,27550.0000,NULL,'2023-06-13 20:42:00',3,NULL,2135,NULL,NULL,NULL,'2023-06-14 01:42:24','2023-06-14 01:42:24'),(158,3,'credit',NULL,10000.0000,NULL,'2023-06-15 09:35:00',3,NULL,2218,NULL,NULL,NULL,'2023-06-15 14:35:52','2023-06-15 14:35:52'),(159,3,'credit',NULL,20000.0000,NULL,'2023-06-15 09:40:00',3,NULL,2221,NULL,NULL,NULL,'2023-06-15 14:40:48','2023-06-15 14:40:48'),(160,3,'credit',NULL,16000.0000,NULL,'2023-06-15 09:42:00',3,NULL,2224,NULL,NULL,NULL,'2023-06-15 14:43:23','2023-06-15 14:43:23'),(161,3,'credit',NULL,10000.0000,NULL,'2023-06-15 09:44:00',3,NULL,2228,NULL,NULL,NULL,'2023-06-15 14:44:49','2023-06-15 14:44:49'),(162,3,'credit',NULL,17000.0000,NULL,'2023-06-15 09:45:00',3,NULL,2230,NULL,NULL,NULL,'2023-06-15 14:45:39','2023-06-15 14:45:39'),(163,3,'credit',NULL,10000.0000,NULL,'2023-06-15 09:46:00',3,NULL,2232,NULL,NULL,NULL,'2023-06-15 14:46:25','2023-06-15 14:46:25'),(164,3,'credit',NULL,14000.0000,NULL,'2023-06-15 09:46:00',3,NULL,2235,NULL,NULL,NULL,'2023-06-15 14:47:22','2023-06-15 14:47:22'),(165,3,'credit',NULL,1500.0000,NULL,'2023-06-15 09:49:00',3,NULL,2237,NULL,NULL,NULL,'2023-06-15 14:49:28','2023-06-15 14:49:28'),(166,3,'credit',NULL,125264.0000,NULL,'2023-06-15 09:50:00',3,NULL,2239,NULL,NULL,NULL,'2023-06-15 14:50:22','2023-06-15 14:50:22'),(167,3,'credit',NULL,10000.0000,NULL,'2023-06-15 09:51:00',3,NULL,2241,NULL,NULL,NULL,'2023-06-15 14:51:37','2023-06-15 14:51:37'),(168,3,'credit',NULL,7500.0000,NULL,'2023-06-15 09:52:00',3,NULL,2243,NULL,NULL,NULL,'2023-06-15 14:52:19','2023-06-15 14:52:19'),(169,3,'credit',NULL,12166.0000,NULL,'2023-06-15 09:52:00',3,NULL,2245,NULL,NULL,NULL,'2023-06-15 14:52:54','2023-06-15 14:52:54'),(170,3,'credit',NULL,33540.0000,NULL,'2023-06-15 09:53:00',3,NULL,2247,NULL,NULL,NULL,'2023-06-15 14:54:11','2023-06-15 14:54:11'),(171,3,'credit',NULL,20000.0000,NULL,'2023-06-15 09:58:00',3,NULL,2250,NULL,NULL,NULL,'2023-06-15 14:59:15','2023-06-15 14:59:15'),(172,3,'credit',NULL,150000.0000,NULL,'2023-06-15 12:19:00',3,NULL,2259,NULL,NULL,NULL,'2023-06-15 17:25:01','2023-06-15 17:25:01'),(173,3,'credit',NULL,5000.0000,NULL,'2023-06-15 12:33:00',3,NULL,2265,NULL,NULL,NULL,'2023-06-15 17:33:53','2023-06-15 17:33:53'),(174,3,'credit',NULL,41325.0000,NULL,'2023-06-15 16:02:00',3,NULL,2284,NULL,NULL,NULL,'2023-06-15 21:03:05','2023-06-15 21:03:05'),(175,3,'credit',NULL,28100.0000,NULL,'2023-06-16 08:46:00',3,NULL,2332,NULL,NULL,NULL,'2023-06-16 13:46:55','2023-06-16 13:46:55'),(176,3,'credit',NULL,10000.0000,NULL,'2023-06-16 19:59:00',3,NULL,2390,NULL,NULL,NULL,'2023-06-17 00:59:43','2023-06-17 00:59:43'),(177,2,'credit',NULL,7000.0000,NULL,'2023-06-16 20:01:00',3,NULL,2392,NULL,NULL,NULL,'2023-06-17 01:02:18','2023-06-17 01:02:18'),(178,3,'credit',NULL,700.0000,NULL,'2023-06-16 20:02:00',3,NULL,2394,NULL,NULL,NULL,'2023-06-17 01:03:25','2023-06-17 01:03:25'),(179,3,'credit',NULL,27550.0000,NULL,'2023-06-09 10:21:00',3,NULL,2435,NULL,NULL,NULL,'2023-06-17 15:21:51','2023-06-17 15:21:51'),(180,3,'credit',NULL,30916.0000,NULL,'2023-06-18 16:52:00',3,NULL,2556,NULL,NULL,NULL,'2023-06-18 21:52:29','2023-06-18 21:52:29'),(181,3,'credit',NULL,100000.0000,NULL,'2023-06-18 16:53:00',3,NULL,2558,NULL,NULL,NULL,'2023-06-18 21:54:16','2023-06-18 21:54:16'),(182,3,'credit',NULL,10000.0000,NULL,'2023-06-19 18:39:00',3,NULL,2653,NULL,NULL,NULL,'2023-06-19 23:39:21','2023-06-19 23:39:21'),(183,3,'credit',NULL,9550.0000,NULL,'2023-06-19 18:40:00',3,NULL,2655,NULL,NULL,NULL,'2023-06-19 23:40:19','2023-06-19 23:40:19'),(184,3,'credit',NULL,5000.0000,NULL,'2023-06-19 18:40:00',3,NULL,2657,NULL,NULL,NULL,'2023-06-19 23:41:05','2023-06-19 23:41:05'),(185,3,'credit',NULL,47485.0000,NULL,'2023-06-19 18:41:00',3,NULL,2659,NULL,NULL,NULL,'2023-06-19 23:41:47','2023-06-19 23:41:47'),(186,3,'credit',NULL,20000.0000,NULL,'2023-06-19 18:42:00',3,NULL,2661,NULL,NULL,NULL,'2023-06-19 23:42:28','2023-06-19 23:42:28'),(187,3,'credit',NULL,25000.0000,NULL,'2023-06-19 18:42:00',3,NULL,2663,NULL,NULL,NULL,'2023-06-19 23:43:19','2023-06-19 23:43:19'),(188,3,'credit',NULL,5000.0000,NULL,'2023-06-19 18:43:00',3,NULL,2666,NULL,NULL,NULL,'2023-06-19 23:43:51','2023-06-19 23:43:51'),(189,3,'credit',NULL,5000.0000,NULL,'2023-06-20 20:56:00',3,NULL,2747,NULL,NULL,NULL,'2023-06-21 01:56:49','2023-06-21 01:56:49'),(190,3,'credit',NULL,10000.0000,NULL,'2023-06-13 20:57:00',3,NULL,2749,NULL,NULL,NULL,'2023-06-21 01:58:45','2023-06-21 01:58:45'),(191,3,'credit',NULL,5000.0000,NULL,'2023-06-20 20:59:00',3,NULL,2752,NULL,NULL,NULL,'2023-06-21 01:59:19','2023-06-21 01:59:19'),(192,2,'debit',NULL,700000.0000,NULL,'2023-06-21 09:04:00',3,17721,2775,NULL,NULL,NULL,'2023-06-21 14:52:30','2023-06-21 14:52:30'),(193,3,'credit',NULL,20180.0000,NULL,'2023-06-21 10:39:00',3,NULL,2779,NULL,NULL,NULL,'2023-06-21 15:39:39','2023-06-21 15:39:39'),(194,3,'credit',NULL,10000.0000,NULL,'2023-06-21 13:23:00',3,NULL,2795,NULL,NULL,NULL,'2023-06-21 18:24:10','2023-06-21 18:24:10'),(195,3,'credit',NULL,21625.0000,NULL,'2023-06-21 13:24:00',3,NULL,2798,NULL,NULL,NULL,'2023-06-21 18:25:12','2023-06-21 18:25:12'),(196,3,'credit',NULL,5000.0000,NULL,'2023-06-21 13:25:00',3,NULL,2800,NULL,NULL,NULL,'2023-06-21 18:26:11','2023-06-21 18:26:11'),(197,3,'credit',NULL,5000.0000,NULL,'2023-06-21 13:26:00',3,NULL,2802,NULL,NULL,NULL,'2023-06-21 18:27:01','2023-06-21 18:27:01'),(198,3,'credit',NULL,27000.0000,NULL,'2023-06-21 13:27:00',3,NULL,2804,NULL,NULL,NULL,'2023-06-21 18:27:47','2023-06-21 18:27:47'),(199,3,'credit',NULL,6020.0000,NULL,'2023-06-15 08:37:00',3,NULL,2885,NULL,NULL,NULL,'2023-06-22 13:39:50','2023-06-22 13:39:50'),(200,3,'credit',NULL,5245.0000,NULL,'2023-06-13 08:40:00',3,NULL,2887,NULL,NULL,NULL,'2023-06-22 13:40:50','2023-06-22 13:40:50'),(201,3,'credit',NULL,7000.0000,NULL,'2023-06-22 08:41:00',3,NULL,2889,NULL,NULL,NULL,'2023-06-22 13:41:36','2023-06-22 13:41:36'),(202,3,'credit',NULL,107552.0000,NULL,'2023-06-22 09:15:00',3,NULL,2897,NULL,NULL,NULL,'2023-06-22 14:15:41','2023-06-22 14:15:41'),(203,3,'credit',NULL,4480.0000,NULL,'2023-06-22 13:35:00',3,NULL,2916,NULL,NULL,NULL,'2023-06-22 18:35:41','2023-06-22 18:35:41'),(204,3,'credit',NULL,16800.0000,NULL,'2023-06-22 13:36:00',3,NULL,2918,NULL,NULL,NULL,'2023-06-22 18:36:27','2023-06-22 18:36:27'),(205,3,'credit',NULL,17550.0000,NULL,'2023-06-22 13:38:00',3,NULL,2920,NULL,NULL,NULL,'2023-06-22 18:38:54','2023-06-22 18:38:54'),(206,3,'credit',NULL,5000.0000,NULL,'2023-06-22 13:39:00',3,NULL,2922,NULL,NULL,NULL,'2023-06-22 18:39:49','2023-06-22 18:39:49'),(207,4,'debit',NULL,4000.0000,NULL,'2023-06-23 12:53:00',33,17976,3042,NULL,NULL,NULL,'2023-06-23 17:54:19','2023-06-23 17:54:19'),(208,3,'credit',NULL,100000.0000,NULL,'2023-06-23 16:30:00',3,NULL,3059,NULL,NULL,NULL,'2023-06-23 21:30:44','2023-06-23 21:30:44'),(209,3,'credit',NULL,10175.0000,NULL,'2023-06-23 16:31:00',3,NULL,3062,NULL,NULL,NULL,'2023-06-23 21:31:30','2023-06-23 21:31:30'),(210,3,'credit',NULL,35000.0000,NULL,'2023-06-23 16:32:00',3,NULL,3064,NULL,NULL,NULL,'2023-06-23 21:32:37','2023-06-23 21:32:37'),(211,3,'credit',NULL,18000.0000,NULL,'2023-06-23 19:32:00',3,NULL,3093,NULL,NULL,NULL,'2023-06-24 00:32:24','2023-06-24 00:32:24'),(212,3,'credit',NULL,12972.0000,NULL,'2023-06-24 10:35:00',3,NULL,3140,NULL,NULL,NULL,'2023-06-24 15:36:13','2023-06-24 15:36:13'),(213,3,'credit',NULL,22035.0000,NULL,'2023-06-24 11:11:00',3,NULL,3147,NULL,NULL,NULL,'2023-06-24 16:12:06','2023-06-24 16:12:06'),(214,3,'credit',NULL,17550.0000,NULL,'2023-06-24 14:55:00',3,NULL,3165,NULL,NULL,NULL,'2023-06-24 19:55:52','2023-06-24 19:55:52'),(215,3,'credit',NULL,10000.0000,NULL,'2023-06-24 14:57:00',3,NULL,3167,NULL,NULL,NULL,'2023-06-24 19:57:28','2023-06-24 19:57:28'),(216,3,'credit',NULL,15000.0000,NULL,'2023-06-24 15:25:00',3,NULL,3172,NULL,NULL,NULL,'2023-06-24 20:26:32','2023-06-24 20:26:32'),(217,3,'credit',NULL,950.0000,NULL,'2023-06-24 16:26:00',3,NULL,3184,NULL,NULL,NULL,'2023-06-24 21:26:41','2023-06-24 21:26:41'),(218,3,'credit',NULL,15000.0000,NULL,'2023-06-25 10:27:00',3,NULL,3242,NULL,NULL,NULL,'2023-06-25 15:27:55','2023-06-25 15:27:55'),(219,3,'credit',NULL,15000.0000,NULL,'2023-06-26 10:59:00',3,NULL,3343,NULL,NULL,NULL,'2023-06-26 16:00:01','2023-06-26 16:00:01'),(220,3,'credit',NULL,136250.0000,NULL,'2023-06-26 11:00:00',3,NULL,3346,NULL,NULL,NULL,'2023-06-26 16:01:10','2023-06-26 16:01:10'),(221,3,'credit',NULL,112172.0000,NULL,'2023-06-26 13:15:00',3,NULL,3356,NULL,NULL,NULL,'2023-06-26 18:18:31','2023-06-26 18:18:31'),(222,3,'credit',NULL,7000.0000,NULL,'2023-06-26 13:22:00',3,NULL,3358,NULL,NULL,NULL,'2023-06-26 18:23:08','2023-06-26 18:23:08'),(223,3,'credit',NULL,15000.0000,NULL,'2023-06-26 13:23:00',3,NULL,3360,NULL,NULL,NULL,'2023-06-26 18:23:58','2023-06-26 18:23:58'),(224,3,'credit',NULL,10000.0000,NULL,'2023-06-26 13:24:00',3,NULL,3362,NULL,NULL,NULL,'2023-06-26 18:24:58','2023-06-26 18:24:58'),(225,3,'credit',NULL,3000.0000,NULL,'2023-06-26 13:25:00',3,NULL,3364,NULL,NULL,NULL,'2023-06-26 18:26:05','2023-06-26 18:26:05'),(226,3,'credit',NULL,7000.0000,NULL,'2023-06-26 13:26:00',3,NULL,3366,NULL,NULL,NULL,'2023-06-26 18:26:46','2023-06-26 18:26:46'),(227,3,'credit',NULL,56574.0000,NULL,'2023-06-26 15:06:00',3,NULL,3377,NULL,NULL,NULL,'2023-06-26 20:06:46','2023-06-26 20:06:46'),(228,4,'credit',NULL,5000.0000,NULL,'2023-06-26 15:56:00',33,18284,3388,NULL,NULL,'2023-07-08 21:05:14','2023-06-26 20:56:12','2023-07-08 21:05:14'),(229,3,'credit',NULL,5000.0000,NULL,'2023-06-27 09:00:00',3,NULL,3457,NULL,NULL,NULL,'2023-06-27 14:01:21','2023-06-27 14:01:21'),(230,3,'credit',NULL,150000.0000,NULL,'2023-06-27 11:38:00',3,NULL,3465,NULL,NULL,NULL,'2023-06-27 16:38:44','2023-06-27 16:38:44'),(231,3,'credit',NULL,20730.0000,NULL,'2023-06-27 13:47:00',3,NULL,3489,NULL,NULL,NULL,'2023-06-27 18:47:24','2023-06-27 18:47:24'),(232,3,'credit',NULL,20000.0000,NULL,'2023-06-27 13:48:00',3,NULL,3492,NULL,NULL,NULL,'2023-06-27 18:49:07','2023-06-27 18:49:07'),(233,3,'credit',NULL,10000.0000,NULL,'2023-06-27 13:49:00',3,NULL,3494,NULL,NULL,NULL,'2023-06-27 18:50:02','2023-06-27 18:50:02'),(234,3,'credit',NULL,3000.0000,NULL,'2023-06-27 13:50:00',3,NULL,3496,NULL,NULL,NULL,'2023-06-27 18:51:31','2023-06-27 18:51:31'),(235,3,'credit',NULL,8965.0000,NULL,'2023-06-27 11:47:00',3,NULL,3595,NULL,NULL,NULL,'2023-06-30 16:47:38','2023-06-30 16:47:38'),(236,3,'credit',NULL,15000.0000,NULL,'2023-06-27 11:48:00',3,NULL,3597,NULL,NULL,NULL,'2023-06-30 16:48:47','2023-06-30 16:48:47'),(237,3,'credit',NULL,30000.0000,NULL,'2023-06-27 11:50:00',3,NULL,3599,NULL,NULL,NULL,'2023-06-30 16:50:57','2023-06-30 16:50:57'),(238,3,'credit',NULL,3000.0000,NULL,'2023-06-12 12:02:00',3,NULL,3601,NULL,NULL,NULL,'2023-06-30 17:03:12','2023-06-30 17:03:12'),(239,3,'credit',NULL,3000.0000,NULL,'2023-06-13 12:04:00',3,NULL,3603,NULL,NULL,NULL,'2023-06-30 17:04:45','2023-06-30 17:04:45'),(240,3,'credit',NULL,30000.0000,NULL,'2023-06-28 12:07:00',3,NULL,3606,NULL,NULL,NULL,'2023-06-30 17:08:48','2023-06-30 17:08:48'),(241,3,'credit',NULL,8550.0000,NULL,'2023-06-27 12:12:00',3,NULL,3608,NULL,NULL,NULL,'2023-06-30 17:13:29','2023-06-30 17:13:29'),(242,3,'credit',NULL,13775.0000,NULL,'2023-06-27 12:16:00',3,NULL,3610,NULL,NULL,NULL,'2023-06-30 17:19:50','2023-06-30 17:19:50'),(243,3,'credit',NULL,7464.0000,NULL,'2023-06-28 12:23:00',3,NULL,3612,NULL,NULL,NULL,'2023-06-30 17:23:45','2023-06-30 17:23:45'),(244,2,'credit',NULL,72400.0000,NULL,'2023-06-27 12:26:00',3,NULL,3614,NULL,NULL,NULL,'2023-06-30 17:26:58','2023-06-30 17:26:58'),(245,3,'credit',NULL,39000.0000,NULL,'2023-06-27 12:29:00',3,NULL,3616,NULL,NULL,NULL,'2023-06-30 17:29:30','2023-06-30 17:29:30'),(246,3,'credit',NULL,70000.0000,NULL,'2023-06-27 12:30:00',3,NULL,3619,NULL,NULL,NULL,'2023-06-30 17:30:25','2023-06-30 17:30:25'),(247,3,'credit',NULL,15000.0000,NULL,'2023-06-27 12:31:00',3,NULL,3621,NULL,NULL,NULL,'2023-06-30 17:31:48','2023-06-30 17:31:48'),(248,3,'credit',NULL,150000.0000,NULL,'2023-06-28 13:53:00',3,NULL,3633,NULL,NULL,NULL,'2023-06-30 18:53:44','2023-06-30 18:53:44'),(249,3,'credit',NULL,200000.0000,NULL,'2023-06-28 13:54:00',3,NULL,3637,NULL,NULL,NULL,'2023-06-30 18:54:37','2023-06-30 18:54:37'),(250,3,'credit',NULL,40000.0000,NULL,'2023-06-28 13:58:00',3,NULL,3639,NULL,NULL,NULL,'2023-06-30 18:59:13','2023-06-30 18:59:13'),(251,3,'credit',NULL,16200.0000,NULL,'2023-06-28 14:01:00',3,NULL,3642,NULL,NULL,NULL,'2023-06-30 19:01:42','2023-06-30 19:01:42'),(252,3,'credit',NULL,105320.0000,NULL,'2023-06-28 14:02:00',3,NULL,3644,NULL,NULL,NULL,'2023-06-30 19:03:20','2023-06-30 19:03:20'),(253,3,'credit',NULL,40100.0000,NULL,'2023-06-28 14:04:00',3,NULL,3650,NULL,NULL,NULL,'2023-06-30 19:05:13','2023-06-30 19:05:13'),(254,3,'credit',NULL,26310.0000,NULL,'2023-06-26 14:36:00',3,NULL,3765,NULL,NULL,NULL,'2023-07-06 19:36:31','2023-07-06 19:36:31'),(255,3,'credit',NULL,9366.0000,NULL,'2023-06-30 14:36:00',3,NULL,3767,NULL,NULL,NULL,'2023-07-06 19:38:48','2023-07-06 19:38:48'),(256,3,'credit',NULL,20000.0000,NULL,'2023-07-03 10:18:00',3,NULL,3823,NULL,NULL,NULL,'2023-07-07 15:18:43','2023-07-07 15:18:43'),(257,3,'credit',NULL,6070.0000,NULL,'2023-07-03 10:20:00',3,NULL,3825,NULL,NULL,NULL,'2023-07-07 15:21:22','2023-07-07 15:21:22'),(258,3,'credit',NULL,15000.0000,NULL,'2023-07-03 10:22:00',3,NULL,3827,NULL,NULL,NULL,'2023-07-07 15:22:44','2023-07-07 15:22:44'),(259,3,'credit',NULL,4025.0000,NULL,'2023-07-03 10:23:00',3,NULL,3829,NULL,NULL,NULL,'2023-07-07 15:26:11','2023-07-07 15:26:11'),(260,3,'credit',NULL,6500.0000,NULL,'2023-07-03 10:39:00',3,NULL,3831,NULL,NULL,NULL,'2023-07-07 15:39:58','2023-07-07 15:39:58'),(261,3,'credit',NULL,32005.0000,NULL,'2023-07-04 10:42:00',3,NULL,3833,NULL,NULL,NULL,'2023-07-07 15:42:32','2023-07-07 15:42:32'),(262,3,'credit',NULL,46000.0000,NULL,'2023-07-04 10:43:00',3,NULL,3835,NULL,NULL,NULL,'2023-07-07 15:43:28','2023-07-07 15:43:28'),(263,3,'credit',NULL,30456.0000,NULL,'2023-07-04 11:39:00',3,NULL,3840,NULL,NULL,NULL,'2023-07-07 16:40:03','2023-07-07 16:40:03'),(264,3,'credit',NULL,500.0000,NULL,'2023-07-04 12:17:00',3,NULL,3847,NULL,NULL,NULL,'2023-07-07 17:17:22','2023-07-07 17:17:22'),(265,3,'credit',NULL,15790.0000,NULL,'2023-07-04 12:18:00',3,NULL,3849,NULL,NULL,NULL,'2023-07-07 17:18:32','2023-07-07 17:18:32'),(266,3,'credit',NULL,1700.0000,NULL,'2023-05-01 13:04:00',3,NULL,3859,NULL,NULL,NULL,'2023-07-07 18:05:18','2023-07-07 18:05:18'),(267,3,'credit',NULL,1700.0000,NULL,'2023-05-28 13:05:00',3,NULL,3861,NULL,NULL,NULL,'2023-07-07 18:06:05','2023-07-07 18:06:05'),(268,3,'credit',NULL,160000.0000,NULL,'2023-07-05 13:24:00',3,NULL,3866,NULL,NULL,NULL,'2023-07-07 18:24:50','2023-07-07 18:24:50'),(269,3,'credit',NULL,100000.0000,NULL,'2023-07-05 13:28:00',3,NULL,3870,NULL,NULL,NULL,'2023-07-07 18:30:36','2023-07-07 18:30:36'),(270,3,'credit',NULL,15000.0000,NULL,'2023-07-05 13:31:00',3,NULL,3873,NULL,NULL,NULL,'2023-07-07 18:32:49','2023-07-07 18:32:49'),(271,3,'credit',NULL,10000.0000,NULL,'2023-07-05 13:34:00',3,NULL,3876,NULL,NULL,NULL,'2023-07-07 18:35:58','2023-07-07 18:35:58'),(272,3,'credit',NULL,45000.0000,NULL,'2023-07-06 13:39:00',3,NULL,3879,NULL,NULL,NULL,'2023-07-07 18:40:21','2023-07-07 18:40:21'),(273,3,'credit',NULL,7012.0000,NULL,'2023-07-07 13:41:00',3,NULL,3881,NULL,NULL,NULL,'2023-07-07 18:41:34','2023-07-07 18:41:34'),(274,3,'credit',NULL,21200.0000,NULL,'2023-07-07 13:44:00',3,NULL,3883,NULL,NULL,NULL,'2023-07-07 18:44:17','2023-07-07 18:44:17'),(275,3,'credit',NULL,5000.0000,NULL,'2023-07-07 13:46:00',3,NULL,3885,NULL,NULL,NULL,'2023-07-07 18:46:58','2023-07-07 18:46:58'),(276,3,'credit',NULL,3915.0000,NULL,'2023-07-07 13:48:00',3,NULL,3887,NULL,NULL,NULL,'2023-07-07 18:48:32','2023-07-07 18:48:32'),(277,3,'credit',NULL,5905.0000,NULL,'2023-07-07 13:49:00',3,NULL,3889,NULL,NULL,NULL,'2023-07-07 18:50:01','2023-07-07 18:50:01'),(278,3,'credit',NULL,10000.0000,NULL,'2023-07-08 16:03:00',3,NULL,3996,NULL,NULL,NULL,'2023-07-08 21:06:48','2023-07-08 21:06:48'),(279,3,'credit',NULL,0.0000,NULL,'2023-07-08 16:23:00',3,NULL,4001,NULL,NULL,NULL,'2023-07-08 21:23:59','2023-07-08 21:23:59'),(280,3,'credit',NULL,31900.0000,NULL,'2023-07-07 11:03:00',3,NULL,4169,NULL,NULL,NULL,'2023-07-10 16:06:11','2023-07-10 16:06:11'),(281,3,'credit',NULL,40005.0000,NULL,'2023-07-10 11:06:00',3,NULL,4172,NULL,NULL,NULL,'2023-07-10 16:07:29','2023-07-10 16:07:29'),(282,3,'credit',NULL,13775.0000,NULL,'2023-07-02 11:45:00',3,NULL,4180,NULL,NULL,NULL,'2023-07-10 16:46:46','2023-07-10 16:46:46'),(283,3,'credit',NULL,15000.0000,NULL,'2023-07-07 11:49:00',3,NULL,4182,NULL,NULL,NULL,'2023-07-10 16:50:29','2023-07-10 16:50:29'),(284,2,'debit',NULL,2500000.0000,NULL,'2023-07-10 13:19:00',3,19033,4193,NULL,NULL,NULL,'2023-07-10 18:20:57','2023-07-10 18:20:57'),(285,3,'credit',NULL,3088.0000,NULL,'2023-07-10 17:15:00',3,NULL,4214,NULL,NULL,NULL,'2023-07-10 22:15:41','2023-07-10 22:15:41'),(286,3,'credit',NULL,70000.0000,NULL,'2023-07-04 17:16:00',3,NULL,4216,NULL,NULL,NULL,'2023-07-10 22:16:50','2023-07-10 22:16:50'),(287,3,'credit',NULL,10000.0000,NULL,'2023-07-04 09:36:00',3,NULL,4270,NULL,NULL,NULL,'2023-07-11 14:36:55','2023-07-11 14:36:55'),(288,3,'credit',NULL,6700.0000,NULL,'2023-07-04 09:38:00',3,NULL,4272,NULL,NULL,NULL,'2023-07-11 14:39:31','2023-07-11 14:39:31'),(289,3,'credit',NULL,50000.0000,NULL,'2023-07-04 09:48:00',3,NULL,4274,NULL,NULL,NULL,'2023-07-11 14:48:54','2023-07-11 14:48:54'),(290,3,'credit',NULL,2120.0000,NULL,'2023-07-05 09:53:00',3,NULL,4276,NULL,NULL,NULL,'2023-07-11 14:54:18','2023-07-11 14:54:18'),(291,3,'credit',NULL,25000.0000,NULL,'2023-07-05 09:55:00',3,NULL,4278,NULL,NULL,NULL,'2023-07-11 14:56:06','2023-07-11 14:56:06'),(292,3,'credit',NULL,27550.0000,NULL,'2023-07-06 09:56:00',3,NULL,4280,NULL,NULL,NULL,'2023-07-11 14:57:29','2023-07-11 14:57:29'),(293,3,'credit',NULL,10000.0000,NULL,'2023-07-08 09:57:00',3,NULL,4282,NULL,NULL,NULL,'2023-07-11 14:59:05','2023-07-11 14:59:05'),(294,3,'credit',NULL,40000.0000,NULL,'2023-07-06 10:00:00',3,NULL,4284,NULL,NULL,NULL,'2023-07-11 15:01:07','2023-07-11 15:01:07'),(295,3,'credit',NULL,100000.0000,NULL,'2023-07-07 10:02:00',3,NULL,4287,NULL,NULL,NULL,'2023-07-11 15:03:13','2023-07-11 15:03:13'),(296,3,'credit',NULL,13775.0000,NULL,'2023-07-07 10:05:00',3,NULL,4292,NULL,NULL,NULL,'2023-07-11 15:05:23','2023-07-11 15:05:23'),(297,3,'credit',NULL,25274.0000,NULL,'2023-07-07 10:11:00',3,NULL,4299,NULL,NULL,NULL,'2023-07-11 15:11:59','2023-07-11 15:11:59'),(298,3,'credit',NULL,45000.0000,NULL,'2023-07-07 10:12:00',3,NULL,4301,NULL,NULL,NULL,'2023-07-11 15:13:19','2023-07-11 15:13:19'),(299,3,'credit',NULL,10000.0000,NULL,'2023-07-08 10:13:00',3,NULL,4303,NULL,NULL,NULL,'2023-07-11 15:14:42','2023-07-11 15:14:42'),(300,3,'credit',NULL,99800.0000,NULL,'2023-07-10 10:15:00',3,NULL,4306,NULL,NULL,NULL,'2023-07-11 15:16:41','2023-07-11 15:16:41'),(301,3,'credit',NULL,30000.0000,NULL,'2023-07-10 10:17:00',3,NULL,4309,NULL,NULL,NULL,'2023-07-11 15:18:11','2023-07-11 15:18:11'),(302,3,'credit',NULL,5000.0000,NULL,'2023-07-10 10:20:00',3,NULL,4315,NULL,NULL,NULL,'2023-07-11 15:20:45','2023-07-11 15:20:45'),(303,3,'credit',NULL,8600.0000,NULL,'2023-07-12 16:55:00',3,NULL,4412,NULL,NULL,NULL,'2023-07-12 21:55:53','2023-07-12 21:55:53'),(304,3,'credit',NULL,7000.0000,NULL,'2023-07-12 16:58:00',3,NULL,4415,NULL,NULL,NULL,'2023-07-12 21:59:24','2023-07-12 21:59:24'),(305,3,'credit',NULL,6000.0000,NULL,'2023-07-12 17:00:00',3,NULL,4417,NULL,NULL,NULL,'2023-07-12 22:00:56','2023-07-12 22:00:56'),(306,3,'credit',NULL,15000.0000,NULL,'2023-07-12 17:01:00',3,NULL,4419,NULL,NULL,NULL,'2023-07-12 22:02:42','2023-07-12 22:02:42'),(307,3,'debit',NULL,32000.0000,NULL,'2023-07-13 22:57:00',3,19369,4536,NULL,NULL,NULL,'2023-07-14 04:00:01','2023-07-14 04:00:01'),(308,3,'credit',NULL,22880.0000,NULL,'2023-07-13 23:13:00',3,NULL,4539,NULL,NULL,NULL,'2023-07-14 04:13:23','2023-07-14 04:13:23'),(309,3,'credit',NULL,10000.0000,NULL,'2023-07-14 11:35:00',3,NULL,4561,NULL,NULL,NULL,'2023-07-14 16:35:46','2023-07-14 16:35:46'),(310,3,'credit',NULL,5834.0000,NULL,'2023-07-14 11:36:00',3,NULL,4565,NULL,NULL,NULL,'2023-07-14 16:36:24','2023-07-14 16:36:24'),(311,3,'credit',NULL,1550500.0000,NULL,'2023-07-14 11:57:00',3,NULL,4573,NULL,NULL,NULL,'2023-07-14 16:57:43','2023-07-14 16:57:43'),(312,3,'credit',NULL,7500.0000,NULL,'2023-07-14 16:30:00',3,NULL,4594,NULL,NULL,NULL,'2023-07-14 21:30:41','2023-07-14 21:30:41'),(313,3,'credit',NULL,150000.0000,NULL,'2023-07-14 16:34:00',3,NULL,4596,NULL,NULL,NULL,'2023-07-14 21:34:54','2023-07-14 21:34:54'),(314,3,'credit',NULL,107200.0000,NULL,'2023-07-17 17:58:00',3,NULL,4874,NULL,NULL,NULL,'2023-07-17 22:58:35','2023-07-17 22:58:35'),(315,3,'credit',NULL,13000.0000,NULL,'2023-07-17 17:59:00',3,NULL,4879,NULL,NULL,NULL,'2023-07-17 22:59:36','2023-07-17 22:59:36'),(316,3,'credit',NULL,13100.0000,NULL,'2023-07-17 18:00:00',3,NULL,4881,NULL,NULL,NULL,'2023-07-17 23:01:52','2023-07-17 23:01:52'),(317,3,'credit',NULL,25000.0000,NULL,'2023-07-15 18:03:00',3,NULL,4883,NULL,NULL,NULL,'2023-07-17 23:03:26','2023-07-17 23:03:26'),(318,3,'credit',NULL,10000.0000,NULL,'2023-07-16 18:04:00',3,NULL,4885,NULL,NULL,NULL,'2023-07-17 23:04:45','2023-07-17 23:04:45'),(319,3,'credit',NULL,338440.0000,NULL,'2023-07-17 18:05:00',3,NULL,4887,NULL,NULL,NULL,'2023-07-17 23:05:45','2023-07-17 23:05:45'),(320,3,'credit',NULL,133500.0000,NULL,'2023-07-17 18:06:00',3,NULL,4891,NULL,NULL,NULL,'2023-07-17 23:08:19','2023-07-17 23:08:19'),(321,3,'credit',NULL,8775.0000,NULL,'2023-07-17 18:09:00',3,NULL,4895,NULL,NULL,NULL,'2023-07-17 23:09:22','2023-07-17 23:09:22'),(322,3,'credit',NULL,100000.0000,NULL,'2023-07-17 18:12:00',3,NULL,4898,NULL,NULL,NULL,'2023-07-17 23:12:25','2023-07-17 23:12:25'),(323,3,'credit',NULL,21120.0000,NULL,'2023-07-17 18:12:00',3,NULL,4902,NULL,NULL,NULL,'2023-07-17 23:13:54','2023-07-17 23:13:54'),(324,3,'credit',NULL,30000.0000,NULL,'2023-07-17 18:14:00',3,NULL,4904,NULL,NULL,NULL,'2023-07-17 23:15:13','2023-07-17 23:15:13'),(325,3,'credit',NULL,20400.0000,NULL,'2023-07-17 18:15:00',3,NULL,4907,NULL,NULL,NULL,'2023-07-17 23:16:12','2023-07-17 23:16:12'),(326,3,'credit',NULL,40000.0000,NULL,'2023-07-17 18:16:00',3,NULL,4909,NULL,NULL,NULL,'2023-07-17 23:16:59','2023-07-17 23:16:59'),(327,3,'credit',NULL,12550.0000,NULL,'2023-07-17 18:17:00',3,NULL,4911,NULL,NULL,NULL,'2023-07-17 23:18:08','2023-07-17 23:18:08'),(328,3,'debit',NULL,32000.0000,NULL,'2023-07-17 21:14:00',3,19761,4941,NULL,NULL,NULL,'2023-07-18 02:16:29','2023-07-18 02:16:29'),(329,3,'credit',NULL,5960.0000,NULL,'2023-07-18 18:04:00',3,NULL,5006,NULL,NULL,NULL,'2023-07-18 23:05:22','2023-07-18 23:05:22'),(330,3,'credit',NULL,80000.0000,NULL,'2023-07-18 18:07:00',3,NULL,5008,NULL,NULL,NULL,'2023-07-18 23:08:10','2023-07-18 23:08:10'),(331,3,'credit',NULL,5000.0000,NULL,'2023-07-18 18:09:00',3,NULL,5011,NULL,NULL,NULL,'2023-07-18 23:09:35','2023-07-18 23:09:35'),(332,3,'credit',NULL,35310.0000,NULL,'2023-07-18 18:11:00',3,NULL,5014,NULL,NULL,NULL,'2023-07-18 23:11:38','2023-07-18 23:11:38'),(333,3,'credit',NULL,100900.0000,NULL,'2023-07-19 09:59:00',3,NULL,5069,NULL,NULL,NULL,'2023-07-19 14:59:57','2023-07-19 14:59:57'),(334,3,'credit',NULL,5000.0000,NULL,'2023-07-19 10:00:00',3,NULL,5072,NULL,NULL,NULL,'2023-07-19 15:00:49','2023-07-19 15:00:49'),(335,3,'credit',NULL,20000.0000,NULL,'2023-07-19 10:02:00',3,NULL,5074,NULL,NULL,NULL,'2023-07-19 15:02:38','2023-07-19 15:02:38'),(336,3,'credit',NULL,13850.0000,NULL,'2023-07-19 10:02:00',3,NULL,5076,NULL,NULL,NULL,'2023-07-19 15:03:11','2023-07-19 15:03:11'),(337,3,'credit',NULL,12160.0000,NULL,'2023-07-19 10:03:00',3,NULL,5078,NULL,NULL,NULL,'2023-07-19 15:03:55','2023-07-19 15:03:55'),(338,3,'credit',NULL,21000.0000,NULL,'2023-07-19 10:04:00',3,NULL,5080,NULL,NULL,NULL,'2023-07-19 15:04:30','2023-07-19 15:04:30'),(339,3,'credit',NULL,18000.0000,NULL,'2023-07-19 10:04:00',3,NULL,5082,NULL,NULL,NULL,'2023-07-19 15:05:11','2023-07-19 15:05:11'),(340,3,'credit',NULL,10000.0000,NULL,'2023-07-19 10:13:00',3,NULL,5085,NULL,NULL,NULL,'2023-07-19 15:13:26','2023-07-19 15:13:26'),(341,3,'credit',NULL,44900.0000,NULL,'2023-07-19 10:14:00',3,NULL,5087,NULL,NULL,NULL,'2023-07-19 15:14:38','2023-07-19 15:14:38'),(342,3,'credit',NULL,19000.0000,NULL,'2023-07-19 10:15:00',3,NULL,5089,NULL,NULL,NULL,'2023-07-19 15:15:20','2023-07-19 15:15:20'),(343,3,'credit',NULL,3560.0000,NULL,'2023-07-19 10:20:00',3,NULL,5092,NULL,NULL,NULL,'2023-07-19 15:21:21','2023-07-19 15:21:21'),(344,3,'credit',NULL,15000.0000,NULL,'2023-07-19 10:21:00',3,NULL,5094,NULL,NULL,NULL,'2023-07-19 15:21:50','2023-07-19 15:21:50'),(345,3,'credit',NULL,80950.0000,NULL,'2023-07-19 10:22:00',3,NULL,5097,NULL,NULL,NULL,'2023-07-19 15:22:52','2023-07-19 15:22:52'),(346,3,'credit',NULL,10735.0000,NULL,'2023-07-19 13:33:00',3,NULL,5121,NULL,NULL,NULL,'2023-07-19 18:33:23','2023-07-19 18:33:23'),(347,3,'credit',NULL,55865.0000,NULL,'2023-07-19 15:37:00',3,NULL,5134,NULL,NULL,NULL,'2023-07-19 20:39:05','2023-07-19 20:39:05'),(348,3,'credit',NULL,70200.0000,NULL,'2023-07-19 15:55:00',3,NULL,5142,NULL,NULL,NULL,'2023-07-19 20:56:02','2023-07-19 20:56:02'),(349,3,'credit',NULL,10000.0000,NULL,'2023-07-19 15:56:00',3,NULL,5146,NULL,NULL,NULL,'2023-07-19 20:56:45','2023-07-19 20:56:45'),(350,3,'credit',NULL,23550.0000,NULL,'2023-07-19 15:57:00',3,NULL,5148,NULL,NULL,NULL,'2023-07-19 20:57:18','2023-07-19 20:57:18'),(351,3,'credit',NULL,215300.0000,NULL,'2023-07-19 15:57:00',3,NULL,5150,NULL,NULL,NULL,'2023-07-19 20:57:58','2023-07-19 20:57:58'),(352,3,'credit',NULL,17700.0000,NULL,'2023-07-19 15:58:00',3,NULL,5152,NULL,NULL,NULL,'2023-07-19 20:58:44','2023-07-19 20:58:44'),(353,3,'credit',NULL,35000.0000,NULL,'2023-07-19 15:59:00',3,NULL,5154,NULL,NULL,NULL,'2023-07-19 20:59:20','2023-07-19 20:59:20'),(354,3,'credit',NULL,10400.0000,NULL,'2023-07-19 15:59:00',3,NULL,5157,NULL,NULL,NULL,'2023-07-19 20:59:54','2023-07-19 20:59:54'),(355,3,'credit',NULL,170000.0000,NULL,'2023-07-20 15:58:00',3,NULL,5239,NULL,NULL,NULL,'2023-07-20 20:58:58','2023-07-20 20:58:58'),(356,3,'credit',NULL,40000.0000,NULL,'2023-07-20 15:59:00',3,NULL,5242,NULL,NULL,NULL,'2023-07-20 20:59:32','2023-07-20 20:59:32'),(357,3,'credit',NULL,12425.0000,NULL,'2023-07-20 15:59:00',3,NULL,5245,NULL,NULL,NULL,'2023-07-20 21:00:10','2023-07-20 21:00:10'),(358,3,'credit',NULL,3600.0000,NULL,'2023-07-20 16:00:00',3,NULL,5247,NULL,NULL,NULL,'2023-07-20 21:00:40','2023-07-20 21:00:40'),(359,3,'credit',NULL,5000.0000,NULL,'2023-07-20 16:01:00',3,NULL,5249,NULL,NULL,NULL,'2023-07-20 21:01:59','2023-07-20 21:01:59'),(360,3,'credit',NULL,24050.0000,NULL,'2023-07-20 16:05:00',3,NULL,5251,NULL,NULL,NULL,'2023-07-20 21:05:21','2023-07-20 21:05:21'),(361,3,'credit',NULL,10000.0000,NULL,'2023-07-20 16:05:00',3,NULL,5253,NULL,NULL,NULL,'2023-07-20 21:05:52','2023-07-20 21:05:52'),(362,3,'credit',NULL,18600.0000,NULL,'2023-07-20 16:06:00',3,NULL,5255,NULL,NULL,NULL,'2023-07-20 21:06:29','2023-07-20 21:06:29'),(363,3,'credit',NULL,20000.0000,NULL,'2023-07-21 16:49:00',3,NULL,5355,NULL,NULL,NULL,'2023-07-21 21:50:34','2023-07-21 21:50:34'),(364,3,'credit',NULL,10000.0000,NULL,'2023-07-21 16:51:00',3,NULL,5358,NULL,NULL,NULL,'2023-07-21 21:51:33','2023-07-21 21:51:33'),(365,3,'credit',NULL,44850.0000,NULL,'2023-07-21 16:51:00',3,NULL,5360,NULL,NULL,NULL,'2023-07-21 21:52:08','2023-07-21 21:52:08'),(366,3,'credit',NULL,15000.0000,NULL,'2023-07-21 16:52:00',3,NULL,5362,NULL,NULL,NULL,'2023-07-21 21:52:57','2023-07-21 21:52:57'),(367,3,'credit',NULL,14525.0000,NULL,'2023-07-21 16:53:00',3,NULL,5364,NULL,NULL,NULL,'2023-07-21 21:53:40','2023-07-21 21:53:40'),(368,3,'credit',NULL,8000.0000,NULL,'2023-07-21 16:56:00',3,NULL,5366,NULL,NULL,NULL,'2023-07-21 21:56:14','2023-07-21 21:56:14'),(369,3,'credit',NULL,20000.0000,NULL,'2023-07-21 16:56:00',3,NULL,5368,NULL,NULL,NULL,'2023-07-21 21:57:02','2023-07-21 21:57:02'),(370,3,'credit',NULL,27550.0000,NULL,'2023-07-21 16:57:00',3,NULL,5370,NULL,NULL,NULL,'2023-07-21 21:58:09','2023-07-21 21:58:09'),(371,3,'credit',NULL,37000.0000,NULL,'2023-07-22 12:37:00',3,NULL,5428,NULL,NULL,NULL,'2023-07-22 17:38:40','2023-07-22 17:38:40'),(372,3,'credit',NULL,30000.0000,NULL,'2023-07-22 12:39:00',3,NULL,5430,NULL,NULL,NULL,'2023-07-22 17:40:11','2023-07-22 17:40:11'),(373,3,'credit',NULL,50000.0000,NULL,'2023-07-22 12:41:00',3,NULL,5433,NULL,NULL,NULL,'2023-07-22 17:41:49','2023-07-22 17:41:49'),(374,3,'credit',NULL,6500.0000,NULL,'2023-07-22 12:48:00',3,NULL,5438,NULL,NULL,NULL,'2023-07-22 17:48:40','2023-07-22 17:48:40'),(375,3,'credit',NULL,14000.0000,NULL,'2023-07-22 12:50:00',3,NULL,5440,NULL,NULL,NULL,'2023-07-22 17:51:25','2023-07-22 17:51:25'),(376,3,'credit',NULL,30000.0000,NULL,'2023-07-22 12:53:00',3,NULL,5442,NULL,NULL,NULL,'2023-07-22 17:54:39','2023-07-22 17:54:39'),(377,3,'credit',NULL,28050.0000,NULL,'2023-07-22 12:59:00',3,NULL,5445,NULL,NULL,NULL,'2023-07-22 18:00:19','2023-07-22 18:00:19'),(378,3,'credit',NULL,29614.0000,NULL,'2023-07-24 18:04:00',3,NULL,5632,NULL,NULL,NULL,'2023-07-24 23:04:20','2023-07-24 23:04:20'),(379,3,'credit',NULL,30000.0000,NULL,'2023-07-24 18:05:00',3,NULL,5634,NULL,NULL,NULL,'2023-07-24 23:05:30','2023-07-24 23:05:30'),(380,3,'credit',NULL,5000.0000,NULL,'2023-07-24 18:07:00',3,NULL,5636,NULL,NULL,NULL,'2023-07-24 23:08:57','2023-07-24 23:08:57'),(381,3,'credit',NULL,5000.0000,NULL,'2023-07-24 18:09:00',3,NULL,5638,NULL,NULL,NULL,'2023-07-24 23:10:19','2023-07-24 23:10:19'),(382,3,'credit',NULL,5000.0000,NULL,'2023-07-24 18:12:00',3,NULL,5640,NULL,NULL,NULL,'2023-07-24 23:12:32','2023-07-24 23:12:32'),(383,3,'credit',NULL,60000.0000,NULL,'2023-07-24 18:18:00',3,NULL,5645,NULL,NULL,NULL,'2023-07-24 23:19:14','2023-07-24 23:19:14'),(384,3,'credit',NULL,10000.0000,NULL,'2023-07-24 18:24:00',3,NULL,5648,NULL,NULL,NULL,'2023-07-24 23:24:23','2023-07-24 23:24:23'),(385,3,'credit',NULL,12700.0000,NULL,'2023-07-24 18:25:00',3,NULL,5650,NULL,NULL,NULL,'2023-07-24 23:26:15','2023-07-24 23:26:15'),(386,3,'credit',NULL,20000.0000,NULL,'2023-07-24 18:27:00',3,NULL,5653,NULL,NULL,NULL,'2023-07-24 23:27:18','2023-07-24 23:27:18'),(387,3,'credit',NULL,19975.0000,NULL,'2023-07-24 18:28:00',3,NULL,5655,NULL,NULL,NULL,'2023-07-24 23:28:44','2023-07-24 23:28:44'),(388,3,'credit',NULL,6000.0000,NULL,'2023-07-24 18:29:00',3,NULL,5657,NULL,NULL,NULL,'2023-07-24 23:29:50','2023-07-24 23:29:50'),(389,3,'credit',NULL,19000.0000,NULL,'2023-07-24 18:32:00',3,NULL,5661,NULL,NULL,NULL,'2023-07-24 23:32:32','2023-07-24 23:32:32'),(390,3,'credit',NULL,46185.0000,NULL,'2023-07-24 18:36:00',3,NULL,5664,NULL,NULL,NULL,'2023-07-24 23:37:07','2023-07-24 23:37:07'),(391,3,'credit',NULL,10000.0000,NULL,'2023-07-25 13:18:00',3,NULL,5863,NULL,NULL,NULL,'2023-07-27 18:18:24','2023-07-27 18:18:24'),(392,3,'credit',NULL,5000.0000,NULL,'2023-07-27 13:22:00',3,NULL,5865,NULL,NULL,NULL,'2023-07-27 18:23:01','2023-07-27 18:23:01'),(393,3,'credit',NULL,15000.0000,NULL,'2023-07-25 13:24:00',3,NULL,5867,NULL,NULL,NULL,'2023-07-27 18:25:00','2023-07-27 18:25:00'),(394,3,'credit',NULL,10000.0000,NULL,'2023-07-25 13:31:00',3,NULL,5869,NULL,NULL,NULL,'2023-07-27 18:32:19','2023-07-27 18:32:19'),(395,3,'credit',NULL,27550.0000,NULL,'2023-07-25 13:33:00',3,NULL,5871,NULL,NULL,NULL,'2023-07-27 18:33:24','2023-07-27 18:33:24'),(396,3,'credit',NULL,10000.0000,NULL,'2023-07-26 13:33:00',3,NULL,5873,NULL,NULL,NULL,'2023-07-27 18:34:10','2023-07-27 18:34:10'),(397,3,'credit',NULL,11300.0000,NULL,'2023-07-26 13:34:00',3,NULL,5875,NULL,NULL,NULL,'2023-07-27 18:35:12','2023-07-27 18:35:12'),(398,3,'credit',NULL,14500.0000,NULL,'2023-07-26 13:39:00',3,NULL,5878,NULL,NULL,NULL,'2023-07-27 18:39:45','2023-07-27 18:39:45'),(399,3,'credit',NULL,30000.0000,NULL,'2023-07-27 13:40:00',3,NULL,5880,NULL,NULL,NULL,'2023-07-27 18:41:11','2023-07-27 18:41:11'),(400,3,'credit',NULL,107343.0000,NULL,'2023-07-27 16:16:00',3,NULL,5890,NULL,NULL,NULL,'2023-07-27 21:17:48','2023-07-27 21:17:48'),(401,3,'credit',NULL,20000.0000,NULL,'2023-07-27 16:20:00',3,NULL,5893,NULL,NULL,NULL,'2023-07-27 21:20:21','2023-07-27 21:20:21'),(402,3,'credit',NULL,8000.0000,NULL,'2023-07-27 16:23:00',3,NULL,5895,NULL,NULL,NULL,'2023-07-27 21:23:32','2023-07-27 21:23:32'),(403,3,'credit',NULL,26910.0000,NULL,'2023-07-27 16:24:00',3,NULL,5897,NULL,NULL,NULL,'2023-07-27 21:25:25','2023-07-27 21:25:25'),(404,3,'credit',NULL,82000.0000,NULL,'2023-07-31 13:19:00',3,NULL,6095,NULL,NULL,NULL,'2023-07-31 18:19:26','2023-07-31 18:19:26'),(405,3,'credit',NULL,7400.0000,NULL,'2023-07-31 13:25:00',3,NULL,6097,NULL,NULL,NULL,'2023-07-31 18:26:51','2023-07-31 18:26:51'),(406,3,'credit',NULL,5000.0000,NULL,'2023-07-31 13:34:00',3,NULL,6101,NULL,NULL,NULL,'2023-07-31 18:34:36','2023-07-31 18:34:36'),(407,3,'credit',NULL,10000.0000,NULL,'2023-07-31 13:35:00',3,NULL,6104,NULL,NULL,NULL,'2023-07-31 18:36:10','2023-07-31 18:36:10'),(408,3,'credit',NULL,150000.0000,NULL,'2023-07-31 13:36:00',3,NULL,6106,NULL,NULL,NULL,'2023-07-31 18:37:04','2023-07-31 18:37:04'),(409,3,'credit',NULL,27500.0000,NULL,'2023-07-31 13:37:00',3,NULL,6108,NULL,NULL,NULL,'2023-07-31 18:37:46','2023-07-31 18:37:46'),(410,3,'credit',NULL,6000.0000,NULL,'2023-07-31 13:38:00',3,NULL,6110,NULL,NULL,NULL,'2023-07-31 18:38:59','2023-07-31 18:38:59'),(411,3,'credit',NULL,20000.0000,NULL,'2023-07-31 13:39:00',3,NULL,6112,NULL,NULL,NULL,'2023-07-31 18:40:17','2023-07-31 18:40:17'),(412,3,'credit',NULL,15000.0000,NULL,'2023-07-31 13:41:00',3,NULL,6115,NULL,NULL,NULL,'2023-07-31 18:41:47','2023-07-31 18:41:47'),(413,3,'credit',NULL,280000.0000,NULL,'2023-08-01 13:09:00',3,NULL,6337,NULL,NULL,NULL,'2023-08-02 18:09:59','2023-08-02 18:09:59'),(414,3,'credit',NULL,25000.0000,NULL,'2023-08-01 13:10:00',3,NULL,6342,NULL,NULL,NULL,'2023-08-02 18:11:12','2023-08-02 18:11:12'),(415,3,'credit',NULL,10000.0000,NULL,'2023-08-01 13:12:00',3,NULL,6345,NULL,NULL,NULL,'2023-08-02 18:12:43','2023-08-02 18:12:43'),(416,3,'credit',NULL,10000.0000,NULL,'2023-08-01 13:13:00',3,NULL,6347,NULL,NULL,NULL,'2023-08-02 18:13:59','2023-08-02 18:13:59'),(417,3,'credit',NULL,15000.0000,NULL,'2023-08-01 13:14:00',3,NULL,6349,NULL,NULL,NULL,'2023-08-02 18:15:20','2023-08-02 18:15:20'),(418,3,'credit',NULL,80000.0000,NULL,'2023-08-01 13:15:00',3,NULL,6351,NULL,NULL,NULL,'2023-08-02 18:16:14','2023-08-02 18:16:14'),(419,3,'credit',NULL,71500.0000,NULL,'2023-08-01 13:16:00',3,NULL,6354,NULL,NULL,NULL,'2023-08-02 18:16:57','2023-08-02 18:16:57'),(420,3,'credit',NULL,20000.0000,NULL,'2023-08-01 13:17:00',3,NULL,6356,NULL,NULL,NULL,'2023-08-02 18:17:50','2023-08-02 18:17:50'),(421,3,'credit',NULL,22425.0000,NULL,'2023-08-02 13:18:00',3,NULL,6359,NULL,NULL,NULL,'2023-08-02 18:18:42','2023-08-02 18:18:42'),(422,3,'credit',NULL,45000.0000,NULL,'2023-08-02 13:19:00',3,NULL,6361,NULL,NULL,NULL,'2023-08-02 18:19:55','2023-08-02 18:19:55'),(423,3,'credit',NULL,41325.0000,NULL,'2023-08-02 13:20:00',3,NULL,6364,NULL,NULL,NULL,'2023-08-02 18:20:44','2023-08-02 18:20:44'),(424,3,'credit',NULL,54250.0000,NULL,'2023-08-02 13:21:00',3,NULL,6366,NULL,NULL,NULL,'2023-08-02 18:21:48','2023-08-02 18:21:48'),(425,3,'credit',NULL,120000.0000,NULL,'2023-08-02 13:22:00',3,NULL,6368,NULL,NULL,NULL,'2023-08-02 18:22:40','2023-08-02 18:22:40'),(426,3,'credit',NULL,15000.0000,NULL,'2023-08-02 13:23:00',3,NULL,6370,NULL,NULL,NULL,'2023-08-02 18:24:12','2023-08-02 18:24:12'),(427,3,'credit',NULL,12000.0000,NULL,'2023-08-02 13:24:00',3,NULL,6372,NULL,NULL,NULL,'2023-08-02 18:25:20','2023-08-02 18:25:20'),(428,3,'credit',NULL,35000.0000,NULL,'2023-08-02 13:26:00',3,NULL,6376,NULL,NULL,NULL,'2023-08-02 18:27:08','2023-08-02 18:27:08'),(429,3,'credit',NULL,16200.0000,NULL,'2023-08-02 18:21:00',3,NULL,6412,NULL,NULL,NULL,'2023-08-02 23:21:47','2023-08-02 23:21:47'),(430,3,'credit',NULL,15000.0000,NULL,'2023-08-02 18:23:00',3,NULL,6414,NULL,NULL,NULL,'2023-08-02 23:23:28','2023-08-02 23:23:28'),(431,3,'credit',NULL,14000.0000,NULL,'2023-08-02 18:23:00',3,NULL,6416,NULL,NULL,NULL,'2023-08-02 23:24:08','2023-08-02 23:24:08'),(432,3,'credit',NULL,20000.0000,NULL,'2023-08-02 18:24:00',3,NULL,6418,NULL,NULL,NULL,'2023-08-02 23:24:44','2023-08-02 23:24:44'),(433,3,'credit',NULL,10000.0000,NULL,'2023-08-02 18:25:00',3,NULL,6420,NULL,NULL,NULL,'2023-08-02 23:25:14','2023-08-02 23:25:14'),(434,3,'credit',NULL,8700.0000,NULL,'2023-08-02 18:26:00',3,NULL,6422,NULL,NULL,NULL,'2023-08-02 23:26:45','2023-08-02 23:26:45'),(435,3,'credit',NULL,7000.0000,NULL,'2023-08-02 18:27:00',3,NULL,6424,NULL,NULL,NULL,'2023-08-02 23:27:13','2023-08-02 23:27:13'),(436,3,'credit',NULL,100000.0000,NULL,'2023-08-02 18:27:00',3,NULL,6427,NULL,NULL,NULL,'2023-08-02 23:27:45','2023-08-02 23:27:45'),(437,3,'credit',NULL,10000.0000,NULL,'2023-08-02 18:28:00',3,NULL,6429,NULL,NULL,NULL,'2023-08-02 23:28:29','2023-08-02 23:28:29'),(438,3,'credit',NULL,25000.0000,NULL,'2023-08-02 18:28:00',3,NULL,6431,NULL,NULL,NULL,'2023-08-02 23:29:08','2023-08-02 23:29:08'),(439,3,'credit',NULL,7000.0000,NULL,'2023-08-02 18:29:00',3,NULL,6433,NULL,NULL,NULL,'2023-08-02 23:29:39','2023-08-02 23:29:39'),(440,3,'credit',NULL,70000.0000,NULL,'2023-08-02 18:30:00',3,NULL,6435,NULL,NULL,NULL,'2023-08-02 23:30:24','2023-08-02 23:30:24'),(441,2,'debit',NULL,1435000.0000,NULL,'2023-08-04 20:54:00',3,21348,6653,NULL,NULL,NULL,'2023-08-05 02:04:24','2023-08-05 02:04:24'),(442,3,'credit',NULL,34000.0000,NULL,'2023-08-04 21:06:00',3,NULL,6654,NULL,NULL,NULL,'2023-08-05 02:06:49','2023-08-05 02:06:49'),(443,3,'credit',NULL,20000.0000,NULL,'2023-08-04 21:07:00',3,NULL,6656,NULL,NULL,NULL,'2023-08-05 02:07:22','2023-08-05 02:07:22'),(444,3,'credit',NULL,15025.0000,NULL,'2023-08-04 21:07:00',3,NULL,6659,NULL,NULL,NULL,'2023-08-05 02:07:55','2023-08-05 02:07:55'),(445,3,'credit',NULL,10000.0000,NULL,'2023-08-04 21:09:00',3,NULL,6661,NULL,NULL,NULL,'2023-08-05 02:09:12','2023-08-05 02:09:12'),(446,3,'credit',NULL,3000.0000,NULL,'2023-08-04 21:10:00',3,NULL,6663,NULL,NULL,NULL,'2023-08-05 02:10:58','2023-08-05 02:10:58'),(447,3,'credit',NULL,3000.0000,NULL,'2023-08-04 21:10:00',3,NULL,6665,NULL,NULL,NULL,'2023-08-05 02:11:31','2023-08-05 02:11:31'),(448,3,'credit',NULL,20134.0000,NULL,'2023-08-04 21:12:00',3,NULL,6666,NULL,NULL,NULL,'2023-08-05 02:12:17','2023-08-05 02:12:17'),(449,3,'credit',NULL,4000.0000,NULL,'2023-08-04 21:12:00',3,NULL,6669,NULL,NULL,NULL,'2023-08-05 02:12:53','2023-08-05 02:12:53'),(450,3,'credit',NULL,11000.0000,NULL,'2023-08-04 21:13:00',3,NULL,6671,NULL,NULL,NULL,'2023-08-05 02:13:37','2023-08-05 02:13:37'),(451,3,'credit',NULL,11000.0000,NULL,'2023-08-04 21:13:00',3,NULL,6673,NULL,NULL,NULL,'2023-08-05 02:14:08','2023-08-05 02:14:08'),(452,2,'credit',NULL,20000.0000,NULL,'2023-08-04 21:14:00',3,NULL,6675,NULL,NULL,NULL,'2023-08-05 02:14:43','2023-08-05 02:14:43'),(453,3,'credit',NULL,10000.0000,NULL,'2023-08-04 21:15:00',3,NULL,6677,NULL,NULL,NULL,'2023-08-05 02:15:21','2023-08-05 02:15:21'),(454,3,'credit',NULL,10000.0000,NULL,'2023-08-04 21:16:00',3,NULL,6682,NULL,NULL,NULL,'2023-08-05 02:16:53','2023-08-05 02:16:53'),(455,3,'credit',NULL,20000.0000,NULL,'2023-08-04 21:17:00',3,NULL,6684,NULL,NULL,NULL,'2023-08-05 02:17:24','2023-08-05 02:17:24'),(456,3,'credit',NULL,30000.0000,NULL,'2023-08-04 21:17:00',3,NULL,6686,NULL,NULL,NULL,'2023-08-05 02:17:55','2023-08-05 02:17:55'),(457,3,'credit',NULL,30000.0000,NULL,'2023-08-04 21:18:00',3,NULL,6689,NULL,NULL,NULL,'2023-08-05 02:18:25','2023-08-05 02:18:25'),(458,3,'credit',NULL,10000.0000,NULL,'2023-08-05 14:08:00',3,NULL,6742,NULL,NULL,NULL,'2023-08-05 19:08:24','2023-08-05 19:08:24'),(459,3,'credit',NULL,80000.0000,NULL,'2023-08-05 19:00:00',3,NULL,6777,NULL,NULL,NULL,'2023-08-06 00:00:29','2023-08-06 00:00:29'),(460,3,'credit',NULL,13182.0000,NULL,'2023-08-05 19:01:00',3,NULL,6780,NULL,NULL,NULL,'2023-08-06 00:01:16','2023-08-06 00:01:16'),(461,3,'credit',NULL,7866.0000,NULL,'2023-08-05 19:01:00',3,NULL,6782,NULL,NULL,NULL,'2023-08-06 00:02:00','2023-08-06 00:02:00'),(462,3,'credit',NULL,12700.0000,NULL,'2023-08-05 19:02:00',3,NULL,6785,NULL,NULL,NULL,'2023-08-06 00:03:18','2023-08-06 00:03:18'),(463,3,'credit',NULL,4720.0000,NULL,'2023-08-05 19:03:00',3,NULL,6786,NULL,NULL,NULL,'2023-08-06 00:04:06','2023-08-06 00:04:06'),(464,3,'credit',NULL,20600.0000,NULL,'2023-08-05 19:04:00',3,NULL,6787,NULL,NULL,NULL,'2023-08-06 00:05:11','2023-08-06 00:05:11'),(465,3,'credit',NULL,57425.0000,NULL,'2023-08-05 19:05:00',3,NULL,6789,NULL,NULL,NULL,'2023-08-06 00:05:43','2023-08-06 00:05:43'),(466,3,'credit',NULL,20000.0000,NULL,'2023-08-05 19:06:00',3,NULL,6791,NULL,NULL,NULL,'2023-08-06 00:06:15','2023-08-06 00:06:15'),(467,3,'credit',NULL,66344.0000,NULL,'2023-08-05 19:06:00',3,NULL,6793,NULL,NULL,NULL,'2023-08-06 00:07:13','2023-08-06 00:07:13'),(468,3,'credit',NULL,10600.0000,NULL,'2023-08-05 19:07:00',3,NULL,6795,NULL,NULL,NULL,'2023-08-06 00:07:39','2023-08-06 00:07:39'),(469,3,'credit',NULL,20000.0000,NULL,'2023-08-05 19:08:00',3,NULL,6796,NULL,NULL,NULL,'2023-08-06 00:08:31','2023-08-06 00:08:31'),(470,3,'credit',NULL,21390.0000,NULL,'2023-08-05 19:08:00',3,NULL,6800,NULL,NULL,NULL,'2023-08-06 00:09:42','2023-08-06 00:09:42'),(471,3,'credit',NULL,11250.0000,NULL,'2023-08-05 19:31:00',3,NULL,6805,NULL,NULL,NULL,'2023-08-06 00:32:11','2023-08-06 00:32:11'),(472,3,'credit',NULL,45000.0000,NULL,'2023-08-06 11:51:00',3,NULL,6859,NULL,NULL,NULL,'2023-08-06 16:52:04','2023-08-06 16:52:04'),(473,2,'debit',NULL,250000.0000,NULL,'2023-08-06 19:00:00',3,21593,6936,NULL,NULL,NULL,'2023-08-07 00:11:11','2023-08-07 00:11:11'),(474,3,'credit',NULL,10000.0000,NULL,'2023-08-06 19:33:00',3,NULL,6940,NULL,NULL,NULL,'2023-08-07 00:34:11','2023-08-07 00:34:11'),(475,3,'credit',NULL,7000.0000,NULL,'2023-08-06 19:34:00',3,NULL,6942,NULL,NULL,NULL,'2023-08-07 00:34:33','2023-08-07 00:34:33'),(476,3,'credit',NULL,70000.0000,NULL,'2023-08-06 19:34:00',3,NULL,6944,NULL,NULL,NULL,'2023-08-07 00:35:02','2023-08-07 00:35:02'),(477,3,'credit',NULL,20925.0000,NULL,'2023-08-06 19:35:00',3,NULL,6946,NULL,NULL,NULL,'2023-08-07 00:35:41','2023-08-07 00:35:41'),(478,3,'credit',NULL,20000.0000,NULL,'2023-08-07 08:57:00',3,NULL,7236,NULL,NULL,NULL,'2023-08-11 08:57:47','2023-08-11 08:57:47'),(479,3,'credit',NULL,20000.0000,NULL,'2023-08-07 08:58:00',3,NULL,7238,NULL,NULL,NULL,'2023-08-11 08:58:16','2023-08-11 08:58:16'),(480,3,'credit',NULL,30000.0000,NULL,'2023-08-07 08:58:00',3,NULL,7240,NULL,NULL,NULL,'2023-08-11 08:58:55','2023-08-11 08:58:55'),(481,3,'credit',NULL,30000.0000,NULL,'2023-08-07 08:59:00',3,NULL,7242,NULL,NULL,NULL,'2023-08-11 08:59:20','2023-08-11 08:59:20'),(482,3,'credit',NULL,11800.0000,NULL,'2023-08-07 08:59:00',3,NULL,7244,NULL,NULL,NULL,'2023-08-11 08:59:49','2023-08-11 08:59:49'),(483,3,'credit',NULL,61300.0000,NULL,'2023-08-07 09:02:00',3,NULL,7248,NULL,NULL,NULL,'2023-08-11 09:03:01','2023-08-11 09:03:01'),(484,3,'credit',NULL,8000.0000,NULL,'2023-08-07 09:03:00',3,NULL,7250,NULL,NULL,NULL,'2023-08-11 09:03:47','2023-08-11 09:03:47'),(485,3,'credit',NULL,100000.0000,NULL,'2023-08-07 09:06:00',3,NULL,7253,NULL,NULL,NULL,'2023-08-11 09:06:55','2023-08-11 09:06:55'),(486,3,'credit',NULL,7000.0000,NULL,'2023-08-07 09:07:00',3,NULL,7255,NULL,NULL,NULL,'2023-08-11 09:07:29','2023-08-11 09:07:29'),(487,3,'credit',NULL,10000.0000,NULL,'2023-08-07 09:07:00',3,NULL,7257,NULL,NULL,NULL,'2023-08-11 09:07:57','2023-08-11 09:07:57'),(488,3,'credit',NULL,40000.0000,NULL,'2023-08-08 09:08:00',3,NULL,7259,NULL,NULL,NULL,'2023-08-11 09:08:22','2023-08-11 09:08:22'),(489,3,'credit',NULL,5000.0000,NULL,'2023-08-08 09:08:00',3,NULL,7261,NULL,NULL,NULL,'2023-08-11 09:08:55','2023-08-11 09:08:55'),(490,3,'credit',NULL,4000.0000,NULL,'2023-08-08 09:09:00',3,NULL,7263,NULL,NULL,NULL,'2023-08-11 09:09:19','2023-08-11 09:09:19'),(491,3,'credit',NULL,12440.0000,NULL,'2023-08-08 09:09:00',3,NULL,7265,NULL,NULL,NULL,'2023-08-11 09:09:50','2023-08-11 09:09:50'),(492,3,'credit',NULL,10000.0000,NULL,'2023-08-09 09:10:00',3,NULL,7267,NULL,NULL,NULL,'2023-08-11 09:10:25','2023-08-11 09:10:25'),(493,3,'credit',NULL,12550.0000,NULL,'2023-08-09 09:10:00',3,NULL,7269,NULL,NULL,NULL,'2023-08-11 09:10:57','2023-08-11 09:10:57'),(494,3,'credit',NULL,20000.0000,NULL,'2023-08-09 09:11:00',3,NULL,7271,NULL,NULL,NULL,'2023-08-11 09:11:29','2023-08-11 09:11:29'),(495,3,'credit',NULL,16000.0000,NULL,'2023-08-09 09:11:00',3,NULL,7273,NULL,NULL,NULL,'2023-08-11 09:11:56','2023-08-11 09:11:56'),(496,3,'credit',NULL,45000.0000,NULL,'2023-08-09 09:12:00',3,NULL,7275,NULL,NULL,NULL,'2023-08-11 09:12:19','2023-08-11 09:12:19'),(497,3,'credit',NULL,10000.0000,NULL,'2023-08-09 09:12:00',3,NULL,7277,NULL,NULL,NULL,'2023-08-11 09:12:51','2023-08-11 09:12:51'),(498,3,'credit',NULL,5000.0000,NULL,'2023-08-09 09:13:00',3,NULL,7279,NULL,NULL,NULL,'2023-08-11 09:13:13','2023-08-11 09:13:13'),(499,3,'credit',NULL,10000.0000,NULL,'2023-08-09 09:13:00',3,NULL,7281,NULL,NULL,NULL,'2023-08-11 09:13:37','2023-08-11 09:13:37'),(500,3,'debit',NULL,35000.0000,NULL,'2023-08-11 09:42:00',3,21915,7291,NULL,NULL,NULL,'2023-08-11 09:47:48','2023-08-11 09:47:48'),(501,3,'credit',NULL,32000.0000,NULL,'2023-08-11 10:31:00',3,NULL,7293,NULL,NULL,NULL,'2023-08-11 10:32:02','2023-08-11 10:32:02'),(502,3,'credit',NULL,10000.0000,NULL,'2023-08-11 15:49:00',3,NULL,7330,NULL,NULL,NULL,'2023-08-11 15:50:38','2023-08-11 15:50:38'),(503,3,'credit',NULL,5975.0000,NULL,'2023-08-11 15:51:00',3,NULL,7332,NULL,NULL,NULL,'2023-08-11 15:51:42','2023-08-11 15:51:42'),(504,3,'credit',NULL,11200.0000,NULL,'2023-08-11 15:51:00',3,NULL,7334,NULL,NULL,NULL,'2023-08-11 15:52:45','2023-08-11 15:52:45'),(505,3,'credit',NULL,11085.0000,NULL,'2023-08-11 15:53:00',3,NULL,7337,NULL,NULL,NULL,'2023-08-11 15:53:19','2023-08-11 15:53:19'),(506,3,'credit',NULL,52280.0000,NULL,'2023-08-11 15:53:00',3,NULL,7340,NULL,NULL,NULL,'2023-08-11 15:53:51','2023-08-11 15:53:51'),(507,3,'credit',NULL,41350.0000,NULL,'2023-08-11 15:54:00',3,NULL,7343,NULL,NULL,NULL,'2023-08-11 15:54:42','2023-08-11 15:54:42'),(508,3,'credit',NULL,50000.0000,NULL,'2023-08-11 11:00:00',3,NULL,7509,NULL,NULL,NULL,'2023-08-13 11:01:15','2023-08-13 11:01:15'),(509,3,'credit',NULL,40000.0000,NULL,'2023-08-11 11:01:00',3,NULL,7511,NULL,NULL,NULL,'2023-08-13 11:01:48','2023-08-13 11:01:48'),(510,3,'credit',NULL,107176.0000,NULL,'2023-08-11 11:30:00',3,NULL,7516,NULL,NULL,NULL,'2023-08-13 11:30:52','2023-08-13 11:30:52'),(511,3,'credit',NULL,17800.0000,NULL,'2023-08-12 12:15:00',3,NULL,7651,NULL,NULL,NULL,'2023-08-15 12:17:22','2023-08-15 12:17:22'),(512,3,'credit',NULL,27600.0000,NULL,'2023-08-12 12:17:00',3,NULL,7654,NULL,NULL,NULL,'2023-08-15 12:17:56','2023-08-15 12:17:56'),(513,3,'credit',NULL,10000.0000,NULL,'2023-08-12 12:18:00',3,NULL,7656,NULL,NULL,NULL,'2023-08-15 12:19:08','2023-08-15 12:19:08'),(514,3,'credit',NULL,9000.0000,NULL,'2023-08-12 12:19:00',3,NULL,7658,NULL,NULL,NULL,'2023-08-15 12:20:11','2023-08-15 12:20:11'),(515,3,'credit',NULL,30840.0000,NULL,'2023-08-12 12:20:00',3,NULL,7660,NULL,NULL,NULL,'2023-08-15 12:20:59','2023-08-15 12:20:59'),(516,3,'credit',NULL,10000.0000,NULL,'2023-08-12 12:21:00',3,NULL,7662,NULL,NULL,NULL,'2023-08-15 12:21:28','2023-08-15 12:21:28'),(517,3,'credit',NULL,15684.0000,NULL,'2023-08-13 12:21:00',3,NULL,7664,NULL,NULL,NULL,'2023-08-15 12:22:08','2023-08-15 12:22:08'),(518,3,'credit',NULL,5000.0000,NULL,'2023-08-13 12:22:00',3,NULL,7666,NULL,NULL,NULL,'2023-08-15 12:22:56','2023-08-15 12:22:56'),(519,3,'credit',NULL,22000.0000,NULL,'2023-08-13 12:23:00',3,NULL,7668,NULL,NULL,NULL,'2023-08-15 12:23:53','2023-08-15 12:23:53'),(520,3,'credit',NULL,17000.0000,NULL,'2023-08-13 12:24:00',3,NULL,7670,NULL,NULL,NULL,'2023-08-15 12:24:50','2023-08-15 12:24:50'),(521,3,'credit',NULL,50000.0000,NULL,'2023-08-13 12:25:00',3,NULL,7672,NULL,NULL,NULL,'2023-08-15 12:25:23','2023-08-15 12:25:23'),(522,3,'credit',NULL,166228.0000,NULL,'2023-08-13 12:25:00',3,NULL,7675,NULL,NULL,NULL,'2023-08-15 12:25:58','2023-08-15 12:25:58'),(523,3,'credit',NULL,70000.0000,NULL,'2023-08-14 12:26:00',3,NULL,7677,NULL,NULL,NULL,'2023-08-15 12:26:56','2023-08-15 12:26:56'),(524,3,'credit',NULL,48000.0000,NULL,'2023-08-14 12:27:00',3,NULL,7680,NULL,NULL,NULL,'2023-08-15 12:27:25','2023-08-15 12:27:25'),(525,3,'credit',NULL,105000.0000,NULL,'2023-08-15 12:27:00',3,NULL,7684,NULL,NULL,NULL,'2023-08-15 12:28:01','2023-08-15 12:28:01'),(526,3,'credit',NULL,19000.0000,NULL,'2023-08-15 12:28:00',3,NULL,7689,NULL,NULL,NULL,'2023-08-15 12:29:05','2023-08-15 12:29:05'),(527,3,'credit',NULL,30000.0000,NULL,'2023-08-15 12:29:00',3,NULL,7691,NULL,NULL,NULL,'2023-08-15 12:29:44','2023-08-15 12:29:44'),(528,3,'credit',NULL,30000.0000,NULL,'2023-08-15 12:29:00',3,NULL,7694,NULL,NULL,NULL,'2023-08-15 12:30:07','2023-08-15 12:30:07'),(529,3,'credit',NULL,6500.0000,NULL,'2023-08-15 12:30:00',3,NULL,7697,NULL,NULL,NULL,'2023-08-15 12:30:32','2023-08-15 12:30:32'),(530,3,'credit',NULL,6600.0000,NULL,'2023-08-15 12:30:00',3,NULL,7699,NULL,NULL,NULL,'2023-08-15 12:30:57','2023-08-15 12:30:57'),(531,3,'credit',NULL,9000.0000,NULL,'2023-08-15 12:31:00',3,NULL,7702,NULL,NULL,NULL,'2023-08-15 12:31:24','2023-08-15 12:31:24'),(532,3,'credit',NULL,8000.0000,NULL,'2023-08-15 12:31:00',3,NULL,7704,NULL,NULL,NULL,'2023-08-15 12:31:51','2023-08-15 12:31:51'),(533,2,'debit',NULL,2412000.0000,NULL,'2023-08-15 20:01:00',3,22353,7776,NULL,NULL,NULL,'2023-08-15 20:02:52','2023-08-15 20:02:52'),(534,3,'credit',NULL,5000.0000,NULL,'2023-08-16 19:51:00',3,NULL,7868,NULL,NULL,NULL,'2023-08-16 19:52:11','2023-08-16 19:52:11'),(535,3,'credit',NULL,8529.0000,NULL,'2023-08-16 19:52:00',3,NULL,7870,NULL,NULL,NULL,'2023-08-16 19:52:43','2023-08-16 19:52:43'),(536,3,'credit',NULL,10000.0000,NULL,'2023-08-16 19:53:00',3,NULL,7872,NULL,NULL,NULL,'2023-08-16 19:53:29','2023-08-16 19:53:29'),(537,3,'credit',NULL,17000.0000,NULL,'2023-08-16 19:53:00',3,NULL,7874,NULL,NULL,NULL,'2023-08-16 19:53:55','2023-08-16 19:53:55'),(538,3,'credit',NULL,10000.0000,NULL,'2023-08-18 15:22:00',3,NULL,7981,NULL,NULL,NULL,'2023-08-18 15:22:37','2023-08-18 15:22:37'),(539,3,'credit',NULL,27624.0000,NULL,'2023-08-18 15:26:00',3,NULL,7983,NULL,NULL,NULL,'2023-08-18 15:26:35','2023-08-18 15:26:35'),(540,3,'credit',NULL,5000.0000,NULL,'2023-08-18 15:26:00',3,NULL,7985,NULL,NULL,NULL,'2023-08-18 15:27:10','2023-08-18 15:27:10'),(541,3,'credit',NULL,15000.0000,NULL,'2023-08-18 15:27:00',3,NULL,7987,NULL,NULL,NULL,'2023-08-18 15:27:56','2023-08-18 15:27:56'),(542,3,'credit',NULL,5592.0000,NULL,'2023-08-18 15:28:00',3,NULL,7989,NULL,NULL,NULL,'2023-08-18 15:28:35','2023-08-18 15:28:35'),(543,3,'credit',NULL,326096.0000,NULL,'2023-08-18 17:41:00',3,NULL,8000,NULL,NULL,NULL,'2023-08-18 17:41:41','2023-08-18 17:41:41'),(544,3,'credit',NULL,82000.0000,NULL,'2023-08-18 17:48:00',3,NULL,8004,NULL,NULL,NULL,'2023-08-18 17:49:06','2023-08-18 17:49:06'),(545,3,'credit',NULL,55200.0000,NULL,'2023-08-18 17:49:00',3,NULL,8006,NULL,NULL,NULL,'2023-08-18 17:50:09','2023-08-18 17:50:09'),(546,3,'credit',NULL,39000.0000,NULL,'2023-08-18 17:50:00',3,NULL,8009,NULL,NULL,NULL,'2023-08-18 17:50:35','2023-08-18 17:50:35'),(547,3,'credit',NULL,112680.0000,NULL,'2023-08-18 17:51:00',3,NULL,8013,NULL,NULL,NULL,'2023-08-18 17:51:25','2023-08-18 17:51:25'),(548,3,'credit',NULL,30700.0000,NULL,'2023-08-18 17:51:00',3,NULL,8015,NULL,NULL,NULL,'2023-08-18 17:51:45','2023-08-18 17:51:45'),(549,3,'credit',NULL,30000.0000,NULL,'2023-08-18 17:52:00',3,NULL,8019,NULL,NULL,NULL,'2023-08-18 17:52:24','2023-08-18 17:52:24'),(550,3,'credit',NULL,13600.0000,NULL,'2023-08-18 17:52:00',3,NULL,8021,NULL,NULL,NULL,'2023-08-18 17:52:48','2023-08-18 17:52:48'),(551,3,'credit',NULL,15600.0000,NULL,'2023-08-18 17:52:00',3,NULL,8024,NULL,NULL,NULL,'2023-08-18 17:53:09','2023-08-18 17:53:09'),(552,3,'credit',NULL,8500.0000,NULL,'2023-08-18 17:54:00',3,NULL,8026,NULL,NULL,NULL,'2023-08-18 17:54:14','2023-08-18 17:54:14'),(553,3,'credit',NULL,82000.0000,NULL,'2023-08-18 17:54:00',3,NULL,8028,NULL,NULL,NULL,'2023-08-18 17:54:45','2023-08-18 17:54:45'),(554,3,'credit',NULL,12100.0000,NULL,'2023-08-18 17:54:00',3,NULL,8031,NULL,NULL,NULL,'2023-08-18 17:55:08','2023-08-18 17:55:08'),(555,3,'credit',NULL,31780.0000,NULL,'2023-08-18 17:55:00',3,NULL,8034,NULL,NULL,NULL,'2023-08-18 17:55:31','2023-08-18 17:55:31'),(556,3,'debit',NULL,38000.0000,NULL,'2023-08-19 14:36:00',3,22659,8103,NULL,NULL,NULL,'2023-08-19 14:42:04','2023-08-19 14:42:04'),(557,3,'credit',NULL,19000.0000,NULL,'2023-08-19 10:39:00',3,NULL,8723,NULL,NULL,NULL,'2023-08-27 10:40:03','2023-08-27 10:40:03'),(558,3,'credit',NULL,3000.0000,NULL,'2023-08-19 10:40:00',3,NULL,8725,NULL,NULL,NULL,'2023-08-27 10:40:57','2023-08-27 10:40:57'),(559,3,'credit',NULL,27600.0000,NULL,'2023-08-19 10:41:00',3,NULL,8727,NULL,NULL,NULL,'2023-08-27 10:41:29','2023-08-27 10:41:29'),(560,3,'credit',NULL,15000.0000,NULL,'2023-08-19 10:41:00',3,NULL,8729,NULL,NULL,NULL,'2023-08-27 10:45:27','2023-08-27 10:45:27'),(561,3,'credit',NULL,7600.0000,NULL,'2023-08-21 10:46:00',3,NULL,8732,NULL,NULL,NULL,'2023-08-27 10:46:14','2023-08-27 10:46:14'),(562,3,'credit',NULL,6000.0000,NULL,'2023-08-21 10:46:00',3,NULL,8734,NULL,NULL,NULL,'2023-08-27 10:46:44','2023-08-27 10:46:44'),(563,3,'credit',NULL,18700.0000,NULL,'2023-08-21 10:46:00',3,NULL,8736,NULL,NULL,NULL,'2023-08-27 10:47:17','2023-08-27 10:47:17'),(564,3,'credit',NULL,12800.0000,NULL,'2023-08-21 10:47:00',3,NULL,8738,NULL,NULL,NULL,'2023-08-27 10:47:45','2023-08-27 10:47:45'),(565,3,'credit',NULL,30000.0000,NULL,'2023-08-21 10:48:00',3,NULL,8740,NULL,NULL,NULL,'2023-08-27 10:48:26','2023-08-27 10:48:26'),(566,3,'credit',NULL,10000.0000,NULL,'2023-08-21 10:48:00',3,NULL,8743,NULL,NULL,NULL,'2023-08-27 10:48:52','2023-08-27 10:48:52'),(567,3,'credit',NULL,6000.0000,NULL,'2023-08-21 10:49:00',3,NULL,8745,NULL,NULL,NULL,'2023-08-27 10:49:19','2023-08-27 10:49:19'),(568,3,'credit',NULL,3000.0000,NULL,'2023-08-21 10:49:00',3,NULL,8747,NULL,NULL,NULL,'2023-08-27 10:49:43','2023-08-27 10:49:43'),(569,3,'credit',NULL,10000.0000,NULL,'2023-08-21 10:49:00',3,NULL,8749,NULL,NULL,NULL,'2023-08-27 10:50:06','2023-08-27 10:50:06'),(570,3,'credit',NULL,57000.0000,NULL,'2023-08-21 10:50:00',3,NULL,8751,NULL,NULL,NULL,'2023-08-27 10:50:35','2023-08-27 10:50:35'),(571,3,'credit',NULL,10000.0000,NULL,'2023-08-22 10:50:00',3,NULL,8754,NULL,NULL,NULL,'2023-08-27 10:51:02','2023-08-27 10:51:02'),(572,3,'credit',NULL,10000.0000,NULL,'2023-08-22 10:51:00',3,NULL,8756,NULL,NULL,NULL,'2023-08-27 10:51:26','2023-08-27 10:51:26'),(573,3,'credit',NULL,12425.0000,NULL,'2023-08-22 10:51:00',3,NULL,8758,NULL,NULL,NULL,'2023-08-27 10:51:48','2023-08-27 10:51:48'),(574,3,'credit',NULL,3000.0000,NULL,'2023-08-22 10:52:00',3,NULL,8760,NULL,NULL,NULL,'2023-08-27 10:52:23','2023-08-27 10:52:23'),(575,3,'credit',NULL,40800.0000,NULL,'2023-08-22 10:52:00',3,NULL,8762,NULL,NULL,NULL,'2023-08-27 10:52:47','2023-08-27 10:52:47'),(576,3,'credit',NULL,7000.0000,NULL,'2023-08-22 10:52:00',3,NULL,8764,NULL,NULL,NULL,'2023-08-27 10:53:09','2023-08-27 10:53:09'),(577,3,'credit',NULL,10800.0000,NULL,'2023-08-22 10:53:00',3,NULL,8766,NULL,NULL,NULL,'2023-08-27 10:53:32','2023-08-27 10:53:32'),(578,3,'credit',NULL,10000.0000,NULL,'2023-08-23 10:53:00',3,NULL,8768,NULL,NULL,NULL,'2023-08-27 10:53:56','2023-08-27 10:53:56'),(579,3,'credit',NULL,25000.0000,NULL,'2023-08-23 10:54:00',3,NULL,8770,NULL,NULL,NULL,'2023-08-27 10:54:21','2023-08-27 10:54:21'),(580,3,'credit',NULL,1800.0000,NULL,'2023-08-25 11:45:00',3,NULL,8773,NULL,NULL,NULL,'2023-08-27 11:45:48','2023-08-27 11:45:48'),(581,3,'credit',NULL,5000.0000,NULL,'2023-08-26 11:46:00',3,NULL,8775,NULL,NULL,NULL,'2023-08-27 11:47:49','2023-08-27 11:47:49'),(582,3,'credit',NULL,20000.0000,NULL,'2023-07-23 11:48:00',3,NULL,8777,NULL,NULL,NULL,'2023-08-27 11:49:50','2023-08-27 11:49:50'),(583,3,'credit',NULL,14800.0000,NULL,'2023-08-23 11:50:00',3,NULL,8779,NULL,NULL,NULL,'2023-08-27 11:50:24','2023-08-27 11:50:24'),(584,3,'credit',NULL,21000.0000,NULL,'2023-08-24 11:51:00',3,NULL,8781,NULL,NULL,NULL,'2023-08-27 11:51:51','2023-08-27 11:51:51'),(585,3,'credit',NULL,76500.0000,NULL,'2023-08-23 11:52:00',3,NULL,8783,NULL,NULL,NULL,'2023-08-27 11:54:57','2023-08-27 11:54:57'),(586,3,'credit',NULL,15000.0000,NULL,'2023-08-25 11:56:00',3,NULL,8785,NULL,NULL,NULL,'2023-08-27 11:57:18','2023-08-27 11:57:18'),(587,3,'credit',NULL,12912.0000,NULL,'2023-08-25 11:57:00',3,NULL,8787,NULL,NULL,NULL,'2023-08-27 11:59:13','2023-08-27 11:59:13'),(588,3,'credit',NULL,2940.0000,NULL,'2023-08-26 12:01:00',3,NULL,8789,NULL,NULL,NULL,'2023-08-27 12:01:35','2023-08-27 12:01:35'),(589,3,'credit',NULL,25674.0000,NULL,'2023-07-10 12:48:00',3,NULL,8815,NULL,NULL,NULL,'2023-08-27 12:48:47','2023-08-27 12:48:47'),(590,3,'credit',NULL,10000.0000,NULL,'2023-08-22 13:12:00',3,NULL,8826,NULL,NULL,NULL,'2023-08-27 13:12:24','2023-08-27 13:12:24'),(591,3,'credit',NULL,18800.0000,NULL,'2023-08-23 13:12:00',3,NULL,8828,NULL,NULL,NULL,'2023-08-27 13:12:49','2023-08-27 13:12:49'),(592,3,'credit',NULL,85968.0000,NULL,'2023-08-27 13:21:00',3,NULL,8831,NULL,NULL,NULL,'2023-08-27 13:21:58','2023-08-27 13:21:58'),(593,3,'credit',NULL,23500.0000,NULL,'2023-08-23 13:27:00',3,NULL,8836,NULL,NULL,NULL,'2023-08-27 13:28:28','2023-08-27 13:28:28'),(594,3,'credit',NULL,50.0000,NULL,'2023-08-27 13:32:00',3,NULL,8840,NULL,NULL,NULL,'2023-08-27 13:32:16','2023-08-27 13:32:16'),(595,3,'credit',NULL,11800.0000,NULL,'2023-08-25 13:49:00',3,NULL,8847,NULL,NULL,NULL,'2023-08-27 13:49:30','2023-08-27 13:49:30'),(596,3,'credit',NULL,8000.0000,NULL,'2023-08-26 13:50:00',3,NULL,8849,NULL,NULL,NULL,'2023-08-27 13:50:56','2023-08-27 13:50:56'),(597,3,'credit',NULL,23000.0000,NULL,'2023-08-28 09:45:00',3,NULL,9133,NULL,NULL,NULL,'2023-08-30 09:46:05','2023-08-30 09:46:05'),(598,3,'credit',NULL,15000.0000,NULL,'2023-08-28 09:46:00',3,NULL,9135,NULL,NULL,NULL,'2023-08-30 09:47:09','2023-08-30 09:47:09'),(599,3,'credit',NULL,41400.0000,NULL,'2023-08-28 09:51:00',3,NULL,9138,NULL,NULL,NULL,'2023-08-30 09:51:26','2023-08-30 09:51:26'),(600,3,'credit',NULL,10000.0000,NULL,'2023-08-28 09:52:00',3,NULL,9140,NULL,NULL,NULL,'2023-08-30 09:52:26','2023-08-30 09:52:26'),(601,3,'credit',NULL,5000.0000,NULL,'2023-08-28 09:53:00',3,NULL,9142,NULL,NULL,NULL,'2023-08-30 09:54:22','2023-08-30 09:54:22'),(602,3,'credit',NULL,80000.0000,NULL,'2023-08-28 09:55:00',3,NULL,9144,NULL,NULL,NULL,'2023-08-30 09:55:40','2023-08-30 09:55:40'),(603,3,'credit',NULL,28500.0000,NULL,'2023-09-30 15:10:00',3,NULL,9365,NULL,NULL,NULL,'2023-09-01 15:12:02','2023-09-01 15:12:02'),(604,3,'credit',NULL,5000.0000,NULL,'2023-09-30 15:13:00',3,NULL,9367,NULL,NULL,NULL,'2023-09-01 15:15:23','2023-09-01 15:15:23'),(605,3,'credit',NULL,28800.0000,NULL,'2023-09-30 15:23:00',3,NULL,9371,NULL,NULL,NULL,'2023-09-01 15:23:44','2023-09-01 15:23:44'),(606,3,'credit',NULL,8900.0000,NULL,'2023-09-30 15:26:00',3,NULL,9373,NULL,NULL,NULL,'2023-09-01 15:27:12','2023-09-01 15:27:12'),(607,3,'credit',NULL,6000.0000,NULL,'2023-09-01 15:37:00',3,NULL,9380,NULL,NULL,NULL,'2023-09-01 15:37:53','2023-09-01 15:37:53'),(608,3,'credit',NULL,7000.0000,NULL,'2023-09-01 15:38:00',3,NULL,9382,NULL,NULL,NULL,'2023-09-01 15:38:59','2023-09-01 15:38:59'),(609,3,'credit',NULL,5000.0000,NULL,'2023-09-01 15:39:00',3,NULL,9384,NULL,NULL,NULL,'2023-09-01 15:39:51','2023-09-01 15:39:51'),(610,3,'credit',NULL,300.0000,NULL,'2023-09-30 15:54:00',3,NULL,9393,NULL,NULL,NULL,'2023-09-01 15:54:12','2023-09-01 15:54:12'),(611,3,'credit',NULL,20000.0000,NULL,'2023-09-01 15:59:00',3,NULL,9398,NULL,NULL,NULL,'2023-09-01 15:59:37','2023-09-01 15:59:37'),(612,3,'credit',NULL,25245.0000,NULL,'2023-07-22 16:00:00',3,NULL,9400,NULL,NULL,NULL,'2023-09-01 16:02:47','2023-09-01 16:02:47'),(613,3,'credit',NULL,5000.0000,NULL,'2023-08-23 16:05:00',3,NULL,9402,NULL,NULL,NULL,'2023-09-01 16:06:07','2023-09-01 16:06:07'),(614,3,'credit',NULL,15000.0000,NULL,'2023-09-01 16:06:00',3,NULL,9404,NULL,NULL,NULL,'2023-09-01 16:06:49','2023-09-01 16:06:49'),(615,3,'credit',NULL,40892.0000,NULL,'2023-08-08 13:07:00',3,NULL,9488,NULL,NULL,NULL,'2023-09-02 13:10:52','2023-09-02 13:10:52'),(616,3,'credit',NULL,15488.0000,NULL,'2023-09-01 13:12:00',3,NULL,9490,NULL,NULL,NULL,'2023-09-02 13:12:31','2023-09-02 13:12:31'),(617,3,'credit',NULL,9540.0000,NULL,'2023-08-05 13:19:00',3,NULL,9494,NULL,NULL,NULL,'2023-09-02 13:19:34','2023-09-02 13:19:34'),(618,3,'credit',NULL,15060.0000,NULL,'2023-09-01 13:19:00',3,NULL,9496,NULL,NULL,NULL,'2023-09-02 13:20:08','2023-09-02 13:20:08'),(619,3,'credit',NULL,15828.0000,NULL,'2023-09-01 13:20:00',3,NULL,9498,NULL,NULL,NULL,'2023-09-02 13:20:54','2023-09-02 13:20:54'),(620,3,'credit',NULL,20712.0000,NULL,'2023-08-18 13:21:00',3,NULL,9500,NULL,NULL,NULL,'2023-09-02 13:21:48','2023-09-02 13:21:48'),(621,3,'credit',NULL,10000.0000,NULL,'2023-09-01 13:22:00',3,NULL,9502,NULL,NULL,NULL,'2023-09-02 13:22:19','2023-09-02 13:22:19'),(622,3,'credit',NULL,4720.0000,NULL,'2023-08-05 13:22:00',3,NULL,9504,NULL,NULL,NULL,'2023-09-02 13:23:35','2023-09-02 13:23:35'),(623,3,'credit',NULL,14600.0000,NULL,'2023-09-01 13:23:00',3,NULL,9506,NULL,NULL,NULL,'2023-09-02 13:24:19','2023-09-02 13:24:19'),(624,3,'credit',NULL,12000.0000,NULL,'2023-09-01 13:25:00',3,NULL,9508,NULL,NULL,NULL,'2023-09-02 13:25:20','2023-09-02 13:25:20'),(625,3,'credit',NULL,20200.0000,NULL,'2023-09-01 13:25:00',3,NULL,9511,NULL,NULL,NULL,'2023-09-02 13:25:59','2023-09-02 13:25:59'),(626,3,'credit',NULL,1500.0000,NULL,'2023-08-05 13:26:00',3,NULL,9513,NULL,NULL,NULL,'2023-09-02 13:27:05','2023-09-02 13:27:05'),(627,3,'credit',NULL,12100.0000,NULL,'2023-08-18 13:27:00',3,NULL,9515,NULL,NULL,NULL,'2023-09-02 13:27:59','2023-09-02 13:27:59'),(628,3,'credit',NULL,12000.0000,NULL,'2023-09-01 13:28:00',3,NULL,9517,NULL,NULL,NULL,'2023-09-02 13:28:31','2023-09-02 13:28:31'),(629,3,'credit',NULL,148140.0000,NULL,'2023-09-02 18:06:00',3,NULL,9559,NULL,NULL,NULL,'2023-09-02 18:06:55','2023-09-02 18:06:55'),(630,3,'credit',NULL,50000.0000,NULL,'2023-08-01 18:07:00',3,NULL,9562,NULL,NULL,NULL,'2023-09-02 18:12:11','2023-09-02 18:12:11'),(631,3,'credit',NULL,58730.0000,NULL,'2023-09-02 18:13:00',3,NULL,9565,NULL,NULL,NULL,'2023-09-02 18:14:22','2023-09-02 18:14:22'),(632,3,'credit',NULL,23980.0000,NULL,'2023-09-02 18:34:00',3,NULL,9575,NULL,NULL,NULL,'2023-09-02 18:34:27','2023-09-02 18:34:27'),(633,3,'credit',NULL,30239.0000,NULL,'2023-09-03 13:39:00',3,NULL,9633,NULL,NULL,NULL,'2023-09-03 13:40:30','2023-09-03 13:40:30'),(634,3,'credit',NULL,62157.0000,NULL,'2023-09-03 14:39:00',3,NULL,9646,NULL,NULL,NULL,'2023-09-03 14:39:27','2023-09-03 14:39:27'),(635,3,'credit',NULL,76396.0000,NULL,'2023-09-03 18:30:00',3,NULL,9674,NULL,NULL,NULL,'2023-09-03 18:31:14','2023-09-03 18:31:14'),(636,3,'credit',NULL,24000.0000,NULL,'2023-09-03 18:32:00',3,NULL,9678,NULL,NULL,NULL,'2023-09-03 18:33:02','2023-09-03 18:33:02'),(637,3,'credit',NULL,31000.0000,NULL,'2023-09-04 19:02:00',3,NULL,9780,NULL,NULL,NULL,'2023-09-04 19:02:53','2023-09-04 19:02:53'),(638,3,'credit',NULL,15000.0000,NULL,'2023-09-04 19:03:00',3,NULL,9782,NULL,NULL,NULL,'2023-09-04 19:03:31','2023-09-04 19:03:31'),(639,3,'credit',NULL,14000.0000,NULL,'2023-09-04 19:03:00',3,NULL,9784,NULL,NULL,NULL,'2023-09-04 19:03:59','2023-09-04 19:03:59'),(640,3,'credit',NULL,22000.0000,NULL,'2023-09-04 19:04:00',3,NULL,9787,NULL,NULL,NULL,'2023-09-04 19:04:26','2023-09-04 19:04:26'),(641,3,'credit',NULL,8020.0000,NULL,'2023-09-04 19:04:00',3,NULL,9789,NULL,NULL,NULL,'2023-09-04 19:04:57','2023-09-04 19:04:57'),(642,3,'credit',NULL,7080.0000,NULL,'2023-09-04 19:05:00',3,NULL,9792,NULL,NULL,NULL,'2023-09-04 19:05:36','2023-09-04 19:05:36'),(643,3,'credit',NULL,200000.0000,NULL,'2023-09-04 19:05:00',3,NULL,9794,NULL,NULL,NULL,'2023-09-04 19:06:04','2023-09-04 19:06:04'),(644,3,'credit',NULL,10000.0000,NULL,'2023-09-04 19:06:00',3,NULL,9796,NULL,NULL,NULL,'2023-09-04 19:06:36','2023-09-04 19:06:36'),(645,3,'credit',NULL,36040.0000,NULL,'2023-09-04 19:08:00',3,NULL,9798,NULL,NULL,NULL,'2023-09-04 19:09:46','2023-09-04 19:09:46'),(646,3,'credit',NULL,20000.0000,NULL,'2023-09-04 19:15:00',3,NULL,9804,NULL,NULL,NULL,'2023-09-04 19:15:55','2023-09-04 19:15:55'),(647,3,'credit',NULL,665.0000,NULL,'2023-09-04 19:16:00',3,NULL,9806,NULL,NULL,NULL,'2023-09-04 19:16:38','2023-09-04 19:16:38'),(648,3,'credit',NULL,10000.0000,NULL,'2023-09-04 19:17:00',3,NULL,9809,NULL,NULL,NULL,'2023-09-04 19:17:25','2023-09-04 19:17:25'),(649,3,'credit',NULL,8700.0000,NULL,'2023-09-04 19:17:00',3,NULL,9812,NULL,NULL,NULL,'2023-09-04 19:18:02','2023-09-04 19:18:02'),(650,3,'credit',NULL,20000.0000,NULL,'2023-09-04 19:18:00',3,NULL,9815,NULL,NULL,NULL,'2023-09-04 19:18:53','2023-09-04 19:18:53'),(651,3,'credit',NULL,90800.0000,NULL,'2023-09-04 19:19:00',3,NULL,9818,NULL,NULL,NULL,'2023-09-04 19:19:45','2023-09-04 19:19:45'),(652,3,'credit',NULL,16792.0000,NULL,'2023-09-04 19:20:00',3,NULL,9821,NULL,NULL,NULL,'2023-09-04 19:20:18','2023-09-04 19:20:18'),(653,3,'credit',NULL,5300.0000,NULL,'2023-09-04 19:20:00',3,NULL,9823,NULL,NULL,NULL,'2023-09-04 19:20:57','2023-09-04 19:20:57'),(654,3,'credit',NULL,107593.0000,NULL,'2023-09-05 12:45:00',3,NULL,9883,NULL,NULL,NULL,'2023-09-05 12:46:06','2023-09-05 12:46:06'),(655,3,'credit',NULL,151600.0000,NULL,'2023-09-05 12:46:00',3,NULL,9886,NULL,NULL,NULL,'2023-09-05 12:46:49','2023-09-05 12:46:49'),(656,3,'credit',NULL,80000.0000,NULL,'2023-09-05 12:47:00',3,NULL,9888,NULL,NULL,NULL,'2023-09-05 12:47:30','2023-09-05 12:47:30'),(657,3,'credit',NULL,50950.0000,NULL,'2023-09-05 12:47:00',3,NULL,9890,NULL,NULL,NULL,'2023-09-05 12:48:10','2023-09-05 12:48:10'),(658,3,'credit',NULL,25000.0000,NULL,'2023-09-05 12:48:00',3,NULL,9895,NULL,NULL,NULL,'2023-09-05 12:49:22','2023-09-05 12:49:22'),(659,3,'credit',NULL,11200.0000,NULL,'2023-09-04 13:02:00',3,NULL,9899,NULL,NULL,NULL,'2023-09-05 13:02:48','2023-09-05 13:02:48'),(660,3,'credit',NULL,31350.0000,NULL,'2023-09-05 15:49:00',3,NULL,9920,NULL,NULL,NULL,'2023-09-05 15:50:29','2023-09-05 15:50:29'),(661,3,'credit',NULL,80000.0000,NULL,'2023-09-05 15:51:00',3,NULL,9922,NULL,NULL,NULL,'2023-09-05 15:51:49','2023-09-05 15:51:49'),(662,3,'credit',NULL,5000.0000,NULL,'2023-09-05 09:27:00',3,NULL,9996,NULL,NULL,NULL,'2023-09-06 09:28:15','2023-09-06 09:28:15'),(663,3,'credit',NULL,9000.0000,NULL,'2023-09-05 09:28:00',3,NULL,9998,NULL,NULL,NULL,'2023-09-06 09:28:40','2023-09-06 09:28:40'),(664,3,'credit',NULL,10000.0000,NULL,'2023-09-06 17:41:00',3,NULL,10038,NULL,NULL,NULL,'2023-09-06 17:42:23','2023-09-06 17:42:23'),(665,3,'credit',NULL,8000.0000,NULL,'2023-09-06 17:43:00',3,NULL,10040,NULL,NULL,NULL,'2023-09-06 17:43:17','2023-09-06 17:43:17'),(666,2,'debit',NULL,1000000.0000,NULL,'2023-09-09 11:47:00',3,24781,10337,NULL,NULL,NULL,'2023-09-10 12:02:33','2023-09-10 12:02:33'),(667,3,'credit',NULL,57400.0000,NULL,'2023-09-10 12:17:00',3,NULL,10339,NULL,NULL,NULL,'2023-09-10 12:17:54','2023-09-10 12:17:54'),(668,3,'credit',NULL,6000.0000,NULL,'2023-09-08 13:23:00',3,NULL,10351,NULL,NULL,NULL,'2023-09-10 13:23:28','2023-09-10 13:23:28'),(669,3,'credit',NULL,5000.0000,NULL,'2023-09-08 13:23:00',3,NULL,10353,NULL,NULL,NULL,'2023-09-10 13:24:01','2023-09-10 13:24:01'),(670,3,'credit',NULL,20000.0000,NULL,'2023-09-08 13:25:00',3,NULL,10355,NULL,NULL,NULL,'2023-09-10 13:25:57','2023-09-10 13:25:57'),(671,3,'credit',NULL,10000.0000,NULL,'2023-09-08 13:26:00',3,NULL,10357,NULL,NULL,NULL,'2023-09-10 13:26:30','2023-09-10 13:26:30'),(672,3,'credit',NULL,2800.0000,NULL,'2023-09-09 13:27:00',3,NULL,10359,NULL,NULL,NULL,'2023-09-10 13:28:08','2023-09-10 13:28:08'),(673,3,'credit',NULL,34500.0000,NULL,'2023-09-09 17:05:00',3,NULL,10391,NULL,NULL,NULL,'2023-09-10 17:08:03','2023-09-10 17:08:03'),(674,3,'credit',NULL,98626.0000,NULL,'2023-09-09 17:09:00',3,NULL,10393,NULL,NULL,NULL,'2023-09-10 17:09:57','2023-09-10 17:09:57'),(675,3,'credit',NULL,14548.0000,NULL,'2023-09-10 17:10:00',3,NULL,10397,NULL,NULL,NULL,'2023-09-10 17:15:06','2023-09-10 17:15:06'),(676,3,'credit',NULL,10000.0000,NULL,'2023-09-10 17:16:00',3,NULL,10400,NULL,NULL,NULL,'2023-09-10 17:17:25','2023-09-10 17:17:25'),(677,3,'credit',NULL,20000.0000,NULL,'2023-09-04 17:17:00',3,NULL,10402,NULL,NULL,NULL,'2023-09-10 17:18:26','2023-09-10 17:18:26'),(678,3,'credit',NULL,20000.0000,NULL,'2023-09-10 19:30:00',3,NULL,10429,NULL,NULL,NULL,'2023-09-10 19:30:24','2023-09-10 19:30:24'),(679,3,'credit',NULL,23280.0000,NULL,'2023-09-11 17:05:00',3,NULL,10502,NULL,NULL,NULL,'2023-09-11 17:12:10','2023-09-11 17:12:10'),(680,3,'credit',NULL,6000.0000,NULL,'2023-09-11 17:12:00',3,NULL,10505,NULL,NULL,NULL,'2023-09-11 17:13:12','2023-09-11 17:13:12'),(681,3,'credit',NULL,69000.0000,NULL,'2023-09-11 17:14:00',3,NULL,10508,NULL,NULL,NULL,'2023-09-11 17:15:01','2023-09-11 17:15:01'),(682,3,'credit',NULL,25400.0000,NULL,'2023-09-09 17:15:00',3,NULL,10510,NULL,NULL,NULL,'2023-09-11 17:15:46','2023-09-11 17:15:46'),(683,3,'credit',NULL,11600.0000,NULL,'2023-09-11 17:16:00',3,NULL,10512,NULL,NULL,NULL,'2023-09-11 17:16:50','2023-09-11 17:16:50'),(684,3,'credit',NULL,6000.0000,NULL,'2023-09-11 17:17:00',3,NULL,10514,NULL,NULL,NULL,'2023-09-11 17:17:39','2023-09-11 17:17:39'),(685,3,'credit',NULL,117000.0000,NULL,'2023-09-11 17:20:00',3,NULL,10518,NULL,NULL,NULL,'2023-09-11 17:21:11','2023-09-11 17:21:11'),(686,3,'credit',NULL,4000.0000,NULL,'2023-09-11 17:22:00',3,NULL,10521,NULL,NULL,NULL,'2023-09-11 17:22:31','2023-09-11 17:22:31'),(687,3,'credit',NULL,4000.0000,NULL,'2023-09-11 17:23:00',3,NULL,10523,NULL,NULL,NULL,'2023-09-11 17:23:16','2023-09-11 17:23:16'),(688,3,'credit',NULL,115275.0000,NULL,'2023-09-11 17:23:00',3,NULL,10525,NULL,NULL,NULL,'2023-09-11 17:23:47','2023-09-11 17:23:47'),(689,3,'credit',NULL,4440.0000,NULL,'2023-09-11 17:24:00',3,NULL,10527,NULL,NULL,NULL,'2023-09-11 17:24:24','2023-09-11 17:24:24'),(690,3,'credit',NULL,12928.0000,NULL,'2023-09-11 17:25:00',3,NULL,10529,NULL,NULL,NULL,'2023-09-11 17:25:48','2023-09-11 17:25:48'),(691,3,'credit',NULL,10390.0000,NULL,'2023-09-11 17:35:00',3,NULL,10532,NULL,NULL,NULL,'2023-09-11 17:35:28','2023-09-11 17:35:28'),(692,3,'credit',NULL,30900.0000,NULL,'2023-09-11 17:43:00',3,NULL,10537,NULL,NULL,NULL,'2023-09-11 17:43:33','2023-09-11 17:43:33'),(693,3,'credit',NULL,17700.0000,NULL,'2023-09-11 17:55:00',3,NULL,10541,NULL,NULL,NULL,'2023-09-11 17:56:07','2023-09-11 17:56:07'),(694,3,'credit',NULL,75000.0000,NULL,'2023-09-11 18:11:00',3,NULL,10545,NULL,NULL,NULL,'2023-09-11 18:12:34','2023-09-11 18:12:34'),(695,3,'credit',NULL,44.0000,NULL,'2023-09-11 18:12:00',3,NULL,10548,NULL,NULL,NULL,'2023-09-11 18:13:58','2023-09-11 18:13:58'),(696,3,'credit',NULL,42000.0000,NULL,'2023-09-11 18:18:00',3,NULL,10550,NULL,NULL,NULL,'2023-09-11 18:18:32','2023-09-11 18:18:32'),(697,3,'credit',NULL,7700.0000,NULL,'2023-09-11 19:31:00',3,NULL,10570,NULL,NULL,NULL,'2023-09-11 19:31:32','2023-09-11 19:31:32'),(698,3,'credit',NULL,7500.0000,NULL,'2023-09-12 15:05:00',3,NULL,10609,NULL,NULL,NULL,'2023-09-12 15:06:16','2023-09-12 15:06:16'),(699,3,'credit',NULL,14840.0000,NULL,'2023-09-12 15:07:00',3,NULL,10612,NULL,NULL,NULL,'2023-09-12 15:09:33','2023-09-12 15:09:33'),(700,3,'credit',NULL,10000.0000,NULL,'2023-08-28 15:13:00',3,NULL,10614,NULL,NULL,NULL,'2023-09-12 15:15:36','2023-09-12 15:15:36'),(701,3,'credit',NULL,15500.0000,NULL,'2023-09-04 15:15:00',3,NULL,10616,NULL,NULL,NULL,'2023-09-12 15:16:16','2023-09-12 15:16:16'),(702,3,'credit',NULL,12000.0000,NULL,'2023-09-12 15:16:00',3,NULL,10618,NULL,NULL,NULL,'2023-09-12 15:17:11','2023-09-12 15:17:11'),(703,3,'credit',NULL,28800.0000,NULL,'2023-09-12 15:18:00',3,NULL,10620,NULL,NULL,NULL,'2023-09-12 15:18:16','2023-09-12 15:18:16'),(704,3,'credit',NULL,18368.0000,NULL,'2023-09-12 15:19:00',3,NULL,10622,NULL,NULL,NULL,'2023-09-12 15:19:53','2023-09-12 15:19:53'),(705,3,'credit',NULL,1500.0000,NULL,'2023-09-13 12:03:00',3,NULL,10679,NULL,NULL,NULL,'2023-09-13 12:03:51','2023-09-13 12:03:51'),(706,3,'credit',NULL,10000.0000,NULL,'2023-09-13 12:08:00',3,NULL,10685,NULL,NULL,NULL,'2023-09-13 12:09:12','2023-09-13 12:09:12'),(707,3,'credit',NULL,4000.0000,NULL,'2023-09-13 12:09:00',3,NULL,10687,NULL,NULL,NULL,'2023-09-13 12:09:42','2023-09-13 12:09:42'),(708,3,'credit',NULL,23000.0000,NULL,'2023-09-13 12:15:00',3,NULL,10689,NULL,NULL,NULL,'2023-09-13 12:15:35','2023-09-13 12:15:35'),(709,3,'credit',NULL,10000.0000,NULL,'2023-09-13 17:03:00',3,NULL,10840,NULL,NULL,NULL,'2023-09-15 17:04:14','2023-09-15 17:04:14'),(710,3,'credit',NULL,8000.0000,NULL,'2023-09-13 17:05:00',3,NULL,10842,NULL,NULL,NULL,'2023-09-15 17:06:48','2023-09-15 17:06:48'),(711,3,'credit',NULL,10000.0000,NULL,'2023-09-14 17:14:00',3,NULL,10849,NULL,NULL,NULL,'2023-09-15 17:15:02','2023-09-15 17:15:02'),(712,3,'credit',NULL,10000.0000,NULL,'2023-09-14 17:15:00',3,NULL,10851,NULL,NULL,NULL,'2023-09-15 17:16:15','2023-09-15 17:16:15'),(713,3,'credit',NULL,50000.0000,NULL,'2023-09-15 17:16:00',3,NULL,10854,NULL,NULL,NULL,'2023-09-15 17:17:43','2023-09-15 17:17:43'),(714,3,'credit',NULL,10000.0000,NULL,'2023-09-15 17:18:00',3,NULL,10857,NULL,NULL,NULL,'2023-09-15 17:19:47','2023-09-15 17:19:47'),(715,3,'credit',NULL,11136.0000,NULL,'2023-09-15 17:21:00',3,NULL,10859,NULL,NULL,NULL,'2023-09-15 17:21:48','2023-09-15 17:21:48'),(716,3,'credit',NULL,12500.0000,NULL,'2023-09-15 17:22:00',3,NULL,10861,NULL,NULL,NULL,'2023-09-15 17:23:00','2023-09-15 17:23:00'),(717,3,'credit',NULL,30000.0000,NULL,'2023-09-16 12:09:00',3,NULL,10917,NULL,NULL,NULL,'2023-09-16 12:11:23','2023-09-16 12:11:23'),(718,3,'credit',NULL,10000.0000,NULL,'2023-07-05 10:10:00',3,NULL,10990,NULL,NULL,NULL,'2023-09-17 10:10:51','2023-09-17 10:10:51'),(719,3,'credit',NULL,10000.0000,NULL,'2023-09-16 10:11:00',3,NULL,10992,NULL,NULL,NULL,'2023-09-17 10:11:27','2023-09-17 10:11:27'),(720,3,'credit',NULL,16500.0000,NULL,'2023-09-18 15:55:00',3,NULL,11100,NULL,NULL,NULL,'2023-09-18 15:57:07','2023-09-18 15:57:07'),(721,3,'credit',NULL,6800.0000,NULL,'2023-09-18 15:59:00',3,NULL,11102,NULL,NULL,NULL,'2023-09-18 16:00:14','2023-09-18 16:00:14'),(722,3,'credit',NULL,25000.0000,NULL,'2023-09-18 16:01:00',3,NULL,11104,NULL,NULL,NULL,'2023-09-18 16:01:58','2023-09-18 16:01:58'),(723,3,'credit',NULL,4800.0000,NULL,'2023-09-18 16:02:00',3,NULL,11106,NULL,NULL,NULL,'2023-09-18 16:02:33','2023-09-18 16:02:33'),(724,3,'credit',NULL,10000.0000,NULL,'2023-09-18 19:54:00',3,NULL,11155,NULL,NULL,NULL,'2023-09-18 19:54:22','2023-09-18 19:54:22'),(725,3,'credit',NULL,18000.0000,NULL,'2023-09-18 19:54:00',3,NULL,11157,NULL,NULL,NULL,'2023-09-18 19:54:59','2023-09-18 19:54:59'),(726,3,'credit',NULL,60000.0000,NULL,'2023-09-18 19:55:00',3,NULL,11159,NULL,NULL,NULL,'2023-09-18 19:55:25','2023-09-18 19:55:25'),(727,3,'credit',NULL,3000.0000,NULL,'2023-09-18 19:55:00',3,NULL,11161,NULL,NULL,NULL,'2023-09-18 19:56:02','2023-09-18 19:56:02'),(728,3,'credit',NULL,56460.0000,NULL,'2023-09-18 22:28:00',3,NULL,11175,NULL,NULL,NULL,'2023-09-18 22:28:59','2023-09-18 22:28:59'),(729,2,'debit',NULL,1046000.0000,NULL,'2023-09-18 09:27:00',3,25551,11189,NULL,NULL,NULL,'2023-09-19 09:29:53','2023-09-19 09:29:53'),(730,3,'credit',NULL,92500.0000,NULL,'2023-09-19 19:05:00',3,NULL,11243,NULL,NULL,NULL,'2023-09-19 19:06:10','2023-09-19 19:06:10'),(731,3,'credit',NULL,10200.0000,NULL,'2023-09-19 19:36:00',3,NULL,11251,NULL,NULL,NULL,'2023-09-19 19:37:16','2023-09-19 19:37:16'),(732,3,'credit',NULL,31000.0000,NULL,'2023-09-19 19:40:00',3,NULL,11255,NULL,NULL,NULL,'2023-09-19 19:40:41','2023-09-19 19:40:41'),(733,3,'credit',NULL,3000.0000,NULL,'2023-09-19 19:54:00',3,NULL,11259,NULL,NULL,NULL,'2023-09-19 19:54:53','2023-09-19 19:54:53'),(734,3,'credit',NULL,30000.0000,NULL,'2023-09-19 20:00:00',3,NULL,11264,NULL,NULL,NULL,'2023-09-19 20:00:58','2023-09-19 20:00:58'),(735,3,'credit',NULL,100000.0000,NULL,'2023-09-20 18:21:00',3,NULL,11317,NULL,NULL,NULL,'2023-09-20 18:22:12','2023-09-20 18:22:12'),(736,3,'credit',NULL,20000.0000,NULL,'2023-09-20 18:22:00',3,NULL,11319,NULL,NULL,NULL,'2023-09-20 18:22:57','2023-09-20 18:22:57'),(737,3,'credit',NULL,8900.0000,NULL,'2023-09-20 18:27:00',3,NULL,11321,NULL,NULL,NULL,'2023-09-20 18:27:22','2023-09-20 18:27:22'),(738,3,'credit',NULL,11500.0000,NULL,'2023-09-20 18:28:00',3,NULL,11323,NULL,NULL,NULL,'2023-09-20 18:28:42','2023-09-20 18:28:42'),(739,3,'credit',NULL,3000.0000,NULL,'2023-09-20 18:29:00',3,NULL,11325,NULL,NULL,NULL,'2023-09-20 18:29:50','2023-09-20 18:29:50'),(740,3,'credit',NULL,5000.0000,NULL,'2023-09-20 18:31:00',3,NULL,11327,NULL,NULL,NULL,'2023-09-20 18:31:52','2023-09-20 18:31:52'),(741,3,'credit',NULL,11000.0000,NULL,'2023-09-20 18:32:00',3,NULL,11329,NULL,NULL,NULL,'2023-09-20 18:33:32','2023-09-20 18:33:32'),(742,3,'credit',NULL,6180.0000,NULL,'2023-09-20 18:34:00',3,NULL,11331,NULL,NULL,NULL,'2023-09-20 18:34:37','2023-09-20 18:34:37'),(743,3,'credit',NULL,11100.0000,NULL,'2023-09-20 18:35:00',3,NULL,11333,NULL,NULL,NULL,'2023-09-20 18:35:21','2023-09-20 18:35:21'),(744,3,'credit',NULL,25000.0000,NULL,'2023-09-20 18:35:00',3,NULL,11335,NULL,NULL,NULL,'2023-09-20 18:36:45','2023-09-20 18:36:45'),(745,3,'credit',NULL,15700.0000,NULL,'2023-09-20 18:37:00',3,NULL,11337,NULL,NULL,NULL,'2023-09-20 18:37:14','2023-09-20 18:37:14'),(746,3,'credit',NULL,5000.0000,NULL,'2023-09-21 18:19:00',3,NULL,11384,NULL,NULL,NULL,'2023-09-21 16:20:14','2023-09-21 16:20:14'),(747,3,'credit',NULL,34932.0000,NULL,'2023-09-21 18:31:00',3,NULL,11389,NULL,NULL,NULL,'2023-09-21 16:31:43','2023-09-21 16:31:43'),(748,3,'credit',NULL,25000.0000,NULL,'2023-09-23 17:32:00',3,NULL,11499,NULL,NULL,NULL,'2023-09-23 15:33:03','2023-09-23 15:33:03'),(749,3,'credit',NULL,12500.0000,NULL,'2023-09-23 17:34:00',3,NULL,11501,NULL,NULL,NULL,'2023-09-23 15:35:00','2023-09-23 15:35:00'),(750,3,'credit',NULL,10000.0000,NULL,'2023-09-23 17:35:00',3,NULL,11503,NULL,NULL,NULL,'2023-09-23 15:35:37','2023-09-23 15:35:37'),(751,3,'credit',NULL,9000.0000,NULL,'2023-09-23 17:36:00',3,NULL,11505,NULL,NULL,NULL,'2023-09-23 15:36:41','2023-09-23 15:36:41'),(752,3,'credit',NULL,200000.0000,NULL,'2023-09-24 14:47:00',3,NULL,11552,NULL,NULL,NULL,'2023-09-24 12:48:21','2023-09-24 12:48:21'),(753,3,'credit',NULL,20000.0000,NULL,'2023-09-24 15:02:00',3,NULL,11557,NULL,NULL,NULL,'2023-09-24 13:02:29','2023-09-24 13:02:29'),(754,3,'credit',NULL,15700.0000,NULL,'2023-09-24 15:03:00',3,NULL,11559,NULL,NULL,NULL,'2023-09-24 13:03:32','2023-09-24 13:03:32'),(755,3,'credit',NULL,10000.0000,NULL,'2023-09-24 15:14:00',3,NULL,11562,NULL,NULL,NULL,'2023-09-24 13:14:48','2023-09-24 13:14:48'),(756,3,'credit',NULL,25000.0000,NULL,'2023-09-24 15:41:00',3,NULL,11566,NULL,NULL,NULL,'2023-09-24 13:42:15','2023-09-24 13:42:15'),(757,3,'credit',NULL,436250.0000,NULL,'2023-09-25 10:10:00',3,NULL,11646,NULL,NULL,NULL,'2023-09-26 08:10:54','2023-09-26 08:10:54'),(758,3,'credit',NULL,20000.0000,NULL,'2023-09-25 10:13:00',3,NULL,11648,NULL,NULL,NULL,'2023-09-26 08:13:57','2023-09-26 08:13:57'),(759,3,'credit',NULL,6000.0000,NULL,'2023-09-26 10:16:00',3,NULL,11650,NULL,NULL,NULL,'2023-09-26 08:16:50','2023-09-26 08:16:50'),(760,3,'credit',NULL,50000.0000,NULL,'2023-09-25 10:17:00',3,NULL,11652,NULL,NULL,NULL,'2023-09-26 08:17:54','2023-09-26 08:17:54'),(761,3,'credit',NULL,5000.0000,NULL,'2023-09-25 10:18:00',3,NULL,11654,NULL,NULL,NULL,'2023-09-26 08:18:34','2023-09-26 08:18:34'),(762,3,'credit',NULL,100900.0000,NULL,'2023-09-25 10:19:00',3,NULL,11656,NULL,NULL,NULL,'2023-09-26 08:19:28','2023-09-26 08:19:28'),(763,3,'credit',NULL,5000.0000,NULL,'2023-09-27 09:46:00',3,NULL,11729,NULL,NULL,NULL,'2023-09-27 07:46:52','2023-09-27 07:46:52'),(764,3,'credit',NULL,111900.0000,NULL,'2023-09-27 09:47:00',3,NULL,11733,NULL,NULL,NULL,'2023-09-27 07:48:10','2023-09-27 07:48:10'),(765,3,'credit',NULL,33200.0000,NULL,'2023-09-26 09:50:00',3,NULL,11735,NULL,NULL,NULL,'2023-09-27 07:50:49','2023-09-27 07:50:49'),(766,3,'credit',NULL,10000.0000,NULL,'2023-09-27 09:51:00',3,NULL,11737,NULL,NULL,NULL,'2023-09-27 07:52:12','2023-09-27 07:52:12'),(767,3,'credit',NULL,20000.0000,NULL,'2023-09-27 09:44:00',3,NULL,11835,NULL,NULL,NULL,'2023-09-28 07:46:20','2023-09-28 07:46:20'),(768,3,'credit',NULL,4980.0000,NULL,'2023-09-28 10:44:00',3,NULL,11930,NULL,NULL,NULL,'2023-09-29 08:45:04','2023-09-29 08:45:04'),(769,3,'credit',NULL,32000.0000,NULL,'2023-09-28 10:52:00',3,NULL,11937,NULL,NULL,NULL,'2023-09-29 08:53:15','2023-09-29 08:53:15'),(770,3,'credit',NULL,21564.0000,NULL,'2023-09-28 16:53:00',3,NULL,11974,NULL,NULL,NULL,'2023-09-29 14:53:35','2023-09-29 14:53:35'),(771,3,'credit',NULL,31500.0000,NULL,'2023-09-28 16:58:00',3,NULL,11977,NULL,NULL,NULL,'2023-09-29 14:58:54','2023-09-29 14:58:54'),(772,3,'credit',NULL,35000.0000,NULL,'2023-09-28 17:03:00',3,NULL,11981,NULL,NULL,NULL,'2023-09-29 15:04:00','2023-09-29 15:04:00'),(773,3,'credit',NULL,13230.0000,NULL,'2023-09-28 17:07:00',3,NULL,11986,NULL,NULL,NULL,'2023-09-29 15:07:47','2023-09-29 15:07:47'),(774,3,'credit',NULL,10000.0000,NULL,'2023-09-28 17:09:00',3,NULL,11989,NULL,NULL,NULL,'2023-09-29 15:09:33','2023-09-29 15:09:33'),(775,3,'credit',NULL,10000.0000,NULL,'2023-09-28 17:12:00',3,NULL,11992,NULL,NULL,NULL,'2023-09-29 15:13:04','2023-09-29 15:13:04'),(776,3,'credit',NULL,5000.0000,NULL,'2023-09-28 17:13:00',3,NULL,11994,NULL,NULL,NULL,'2023-09-29 15:14:44','2023-09-29 15:14:44'),(777,3,'credit',NULL,13000.0000,NULL,'2023-09-29 17:15:00',3,NULL,11996,NULL,NULL,NULL,'2023-09-29 15:15:47','2023-09-29 15:15:47'),(778,3,'credit',NULL,8000.0000,NULL,'2023-09-28 17:17:00',3,NULL,11998,NULL,NULL,NULL,'2023-09-29 15:17:25','2023-09-29 15:17:25'),(779,3,'credit',NULL,57600.0000,NULL,'2023-09-28 18:05:00',3,NULL,12088,NULL,NULL,NULL,'2023-09-30 16:05:44','2023-09-30 16:05:44'),(780,3,'credit',NULL,23000.0000,NULL,'2023-09-29 18:06:00',3,NULL,12091,NULL,NULL,NULL,'2023-09-30 16:06:43','2023-09-30 16:06:43'),(781,3,'credit',NULL,7460.0000,NULL,'2023-09-28 18:07:00',3,NULL,12094,NULL,NULL,NULL,'2023-09-30 16:08:21','2023-09-30 16:08:21'),(782,3,'credit',NULL,25000.0000,NULL,'2023-10-01 14:02:00',3,NULL,12244,NULL,NULL,NULL,'2023-10-02 12:03:03','2023-10-02 12:03:03'),(783,3,'credit',NULL,5000.0000,NULL,'2023-10-01 14:04:00',3,NULL,12247,NULL,NULL,NULL,'2023-10-02 12:04:45','2023-10-02 12:04:45'),(784,3,'credit',NULL,46850.0000,NULL,'2023-10-02 18:33:00',3,NULL,12294,NULL,NULL,NULL,'2023-10-02 16:33:28','2023-10-02 16:33:28'),(785,3,'credit',NULL,16000.0000,NULL,'2023-10-01 18:34:00',3,NULL,12296,NULL,NULL,NULL,'2023-10-02 16:34:35','2023-10-02 16:34:35'),(786,3,'credit',NULL,15000.0000,NULL,'2023-10-01 18:35:00',3,NULL,12298,NULL,NULL,NULL,'2023-10-02 16:35:26','2023-10-02 16:35:26'),(787,3,'credit',NULL,35000.0000,NULL,'2023-10-02 18:36:00',3,NULL,12300,NULL,NULL,NULL,'2023-10-02 16:36:32','2023-10-02 16:36:32'),(788,3,'credit',NULL,20000.0000,NULL,'2023-10-02 18:37:00',3,NULL,12302,NULL,NULL,NULL,'2023-10-02 16:38:06','2023-10-02 16:38:06'),(789,3,'credit',NULL,4400.0000,NULL,'2023-10-02 18:38:00',3,NULL,12304,NULL,NULL,NULL,'2023-10-02 16:39:06','2023-10-02 16:39:06'),(790,3,'credit',NULL,50700.0000,NULL,'2023-10-02 18:39:00',3,NULL,12306,NULL,NULL,NULL,'2023-10-02 16:39:51','2023-10-02 16:39:51'),(791,3,'credit',NULL,10000.0000,NULL,'2023-09-04 18:40:00',3,NULL,12308,NULL,NULL,NULL,'2023-10-02 16:41:19','2023-10-02 16:41:19'),(792,3,'credit',NULL,9235.0000,NULL,'2023-09-09 18:41:00',3,NULL,12310,NULL,NULL,NULL,'2023-10-02 16:41:59','2023-10-02 16:41:59'),(793,3,'credit',NULL,17800.0000,NULL,'2023-10-02 18:44:00',3,NULL,12313,NULL,NULL,NULL,'2023-10-02 16:44:28','2023-10-02 16:44:28'),(794,3,'credit',NULL,30000.0000,NULL,'2023-10-02 18:44:00',3,NULL,12315,NULL,NULL,NULL,'2023-10-02 16:44:59','2023-10-02 16:44:59'),(795,3,'credit',NULL,20556.0000,NULL,'2023-10-02 18:48:00',3,NULL,12319,NULL,NULL,NULL,'2023-10-02 16:48:40','2023-10-02 16:48:40'),(796,3,'credit',NULL,8000.0000,NULL,'2023-10-02 18:50:00',3,NULL,12321,NULL,NULL,NULL,'2023-10-02 16:50:17','2023-10-02 16:50:17'),(797,3,'credit',NULL,86000.0000,NULL,'2023-10-02 18:50:00',3,NULL,12323,NULL,NULL,NULL,'2023-10-02 16:50:55','2023-10-02 16:50:55'),(798,3,'credit',NULL,25620.0000,NULL,'2023-10-02 21:37:00',3,NULL,12343,NULL,NULL,NULL,'2023-10-02 19:37:32','2023-10-02 19:37:32'),(799,2,'debit',NULL,1043500.0000,NULL,'2023-10-03 09:49:00',3,26688,12363,NULL,NULL,NULL,'2023-10-03 07:57:09','2023-10-03 07:57:09'),(800,3,'credit',NULL,52640.0000,NULL,'2023-10-03 15:15:00',3,NULL,12487,NULL,NULL,NULL,'2023-10-04 13:16:18','2023-10-04 13:16:18'),(801,3,'credit',NULL,35000.0000,NULL,'2023-10-03 15:24:00',3,NULL,12489,NULL,NULL,NULL,'2023-10-04 13:24:46','2023-10-04 13:24:46'),(802,3,'credit',NULL,50508.0000,NULL,'2023-10-03 15:31:00',3,NULL,12495,NULL,NULL,NULL,'2023-10-04 13:31:44','2023-10-04 13:31:44'),(803,3,'credit',NULL,20000.0000,NULL,'2023-10-03 15:33:00',3,NULL,12498,NULL,NULL,NULL,'2023-10-04 13:34:14','2023-10-04 13:34:14'),(804,3,'credit',NULL,40000.0000,NULL,'2023-10-03 15:50:00',3,NULL,12506,NULL,NULL,NULL,'2023-10-04 13:50:48','2023-10-04 13:50:48'),(805,3,'credit',NULL,5000.0000,NULL,'2023-10-03 15:57:00',3,NULL,12512,NULL,NULL,NULL,'2023-10-04 13:57:29','2023-10-04 13:57:29'),(806,3,'credit',NULL,17000.0000,NULL,'2023-10-03 15:58:00',3,NULL,12514,NULL,NULL,NULL,'2023-10-04 13:58:36','2023-10-04 13:58:36'),(807,3,'credit',NULL,13000.0000,NULL,'2023-10-03 15:59:00',3,NULL,12516,NULL,NULL,NULL,'2023-10-04 13:59:33','2023-10-04 13:59:33'),(808,3,'credit',NULL,45000.0000,NULL,'2023-10-03 16:00:00',3,NULL,12518,NULL,NULL,NULL,'2023-10-04 14:00:55','2023-10-04 14:00:55'),(809,3,'credit',NULL,30000.0000,NULL,'2023-10-04 16:02:00',3,NULL,12520,NULL,NULL,NULL,'2023-10-04 14:02:16','2023-10-04 14:02:16'),(810,3,'credit',NULL,30000.0000,NULL,'2023-10-04 16:06:00',3,NULL,12524,NULL,NULL,NULL,'2023-10-04 14:06:33','2023-10-04 14:06:33'),(811,3,'credit',NULL,60000.0000,NULL,'2023-10-04 16:11:00',3,NULL,12527,NULL,NULL,NULL,'2023-10-04 14:11:49','2023-10-04 14:11:49'),(812,3,'credit',NULL,10000.0000,NULL,'2023-10-04 16:12:00',3,NULL,12531,NULL,NULL,NULL,'2023-10-04 14:13:58','2023-10-04 14:13:58'),(813,3,'credit',NULL,12000.0000,NULL,'2023-10-04 16:15:00',3,NULL,12533,NULL,NULL,NULL,'2023-10-04 14:15:34','2023-10-04 14:15:34'),(814,3,'credit',NULL,43628.0000,NULL,'2023-10-05 15:44:00',3,NULL,12632,NULL,NULL,NULL,'2023-10-05 13:45:54','2023-10-05 13:45:54'),(815,3,'credit',NULL,10000.0000,NULL,'2023-10-05 15:47:00',3,NULL,12635,NULL,NULL,NULL,'2023-10-05 13:48:22','2023-10-05 13:48:22'),(816,3,'credit',NULL,15840.0000,NULL,'2023-10-05 15:48:00',3,NULL,12637,NULL,NULL,NULL,'2023-10-05 13:49:27','2023-10-05 13:49:27'),(817,3,'credit',NULL,100000.0000,NULL,'2023-10-05 15:50:00',3,NULL,12639,NULL,NULL,NULL,'2023-10-05 13:51:24','2023-10-05 13:51:24'),(818,3,'credit',NULL,43760.0000,NULL,'2023-09-23 16:21:00',3,NULL,12648,NULL,NULL,NULL,'2023-10-05 14:21:15','2023-10-05 14:21:15'),(819,3,'credit',NULL,49020.0000,NULL,'2023-10-06 16:48:00',3,NULL,12839,NULL,NULL,NULL,'2023-10-07 14:48:40','2023-10-07 14:48:40'),(820,3,'credit',NULL,3500.0000,NULL,'2023-10-06 16:49:00',3,NULL,12841,NULL,NULL,NULL,'2023-10-07 14:49:25','2023-10-07 14:49:25'),(821,3,'credit',NULL,100000.0000,NULL,'2023-10-06 16:49:00',3,NULL,12843,NULL,NULL,NULL,'2023-10-07 14:50:10','2023-10-07 14:50:10'),(822,3,'credit',NULL,15000.0000,NULL,'2023-10-06 16:50:00',3,NULL,12845,NULL,NULL,NULL,'2023-10-07 14:51:11','2023-10-07 14:51:11'),(823,3,'credit',NULL,13300.0000,NULL,'2023-10-06 16:52:00',3,NULL,12847,NULL,NULL,NULL,'2023-10-07 14:52:19','2023-10-07 14:52:19'),(824,3,'credit',NULL,10000.0000,NULL,'2023-10-06 16:52:00',3,NULL,12849,NULL,NULL,NULL,'2023-10-07 14:53:22','2023-10-07 14:53:22'),(825,3,'credit',NULL,33695.0000,NULL,'2023-10-06 16:53:00',3,NULL,12851,NULL,NULL,NULL,'2023-10-07 14:54:40','2023-10-07 14:54:40'),(826,3,'credit',NULL,20000.0000,NULL,'2023-10-06 16:55:00',3,NULL,12854,NULL,NULL,NULL,'2023-10-07 14:55:36','2023-10-07 14:55:36'),(827,3,'credit',NULL,5300.0000,NULL,'2023-10-06 17:01:00',3,NULL,12856,NULL,NULL,NULL,'2023-10-07 15:02:02','2023-10-07 15:02:02'),(828,3,'credit',NULL,11424.0000,NULL,'2023-10-06 17:03:00',3,NULL,12859,NULL,NULL,NULL,'2023-10-07 15:03:52','2023-10-07 15:03:52'),(829,3,'credit',NULL,20000.0000,NULL,'2023-10-07 17:05:00',3,NULL,12861,NULL,NULL,NULL,'2023-10-07 15:05:56','2023-10-07 15:05:56'),(830,3,'credit',NULL,10000.0000,NULL,'2023-10-07 17:06:00',3,NULL,12863,NULL,NULL,NULL,'2023-10-07 15:06:41','2023-10-07 15:06:41'),(831,3,'credit',NULL,28800.0000,NULL,'2023-10-07 17:07:00',3,NULL,12865,NULL,NULL,NULL,'2023-10-07 15:07:22','2023-10-07 15:07:22'),(832,3,'credit',NULL,5000.0000,NULL,'2023-10-07 17:07:00',3,NULL,12867,NULL,NULL,NULL,'2023-10-07 15:08:01','2023-10-07 15:08:01'),(833,3,'credit',NULL,15000.0000,NULL,'2023-10-07 17:08:00',3,NULL,12869,NULL,NULL,NULL,'2023-10-07 15:08:52','2023-10-07 15:08:52'),(834,3,'credit',NULL,10000.0000,NULL,'2023-10-07 17:09:00',3,NULL,12871,NULL,NULL,NULL,'2023-10-07 15:09:57','2023-10-07 15:09:57'),(835,3,'credit',NULL,15000.0000,NULL,'2023-10-07 17:10:00',3,NULL,12874,NULL,NULL,NULL,'2023-10-07 15:10:40','2023-10-07 15:10:40'),(836,3,'credit',NULL,20000.0000,NULL,'2023-10-07 17:11:00',3,NULL,12876,NULL,NULL,NULL,'2023-10-07 15:11:45','2023-10-07 15:11:45'),(837,3,'credit',NULL,20230.0000,NULL,'2023-10-07 17:12:00',3,NULL,12878,NULL,NULL,NULL,'2023-10-07 15:12:33','2023-10-07 15:12:33'),(838,3,'credit',NULL,8000.0000,NULL,'2023-10-07 17:12:00',3,NULL,12880,NULL,NULL,NULL,'2023-10-07 15:13:03','2023-10-07 15:13:03'),(839,3,'credit',NULL,7000.0000,NULL,'2023-10-07 17:13:00',3,NULL,12882,NULL,NULL,NULL,'2023-10-07 15:13:25','2023-10-07 15:13:25'),(840,3,'credit',NULL,21000.0000,NULL,'2023-10-07 17:13:00',3,NULL,12884,NULL,NULL,NULL,'2023-10-07 15:13:52','2023-10-07 15:13:52'),(841,3,'credit',NULL,10000.0000,NULL,'2023-10-07 17:14:00',3,NULL,12886,NULL,NULL,NULL,'2023-10-07 15:14:25','2023-10-07 15:14:25'),(842,3,'credit',NULL,30000.0000,NULL,'2023-10-07 15:51:00',3,NULL,12970,NULL,NULL,NULL,'2023-10-08 13:51:43','2023-10-08 13:51:43'),(843,3,'credit',NULL,6000.0000,NULL,'2023-10-07 15:52:00',3,NULL,12972,NULL,NULL,NULL,'2023-10-08 13:53:34','2023-10-08 13:53:34'),(844,3,'credit',NULL,15544.0000,NULL,'2023-10-07 15:54:00',3,NULL,12974,NULL,NULL,NULL,'2023-10-08 13:54:35','2023-10-08 13:54:35'),(845,3,'credit',NULL,50000.0000,NULL,'2023-10-08 15:54:00',3,NULL,12976,NULL,NULL,NULL,'2023-10-08 13:55:46','2023-10-08 13:55:46'),(846,3,'credit',NULL,12350.0000,NULL,'2023-10-08 15:56:00',3,NULL,12979,NULL,NULL,NULL,'2023-10-08 13:56:17','2023-10-08 13:56:17'),(847,3,'credit',NULL,8956.0000,NULL,'2023-10-09 15:37:00',3,NULL,13041,NULL,NULL,NULL,'2023-10-09 13:37:31','2023-10-09 13:37:31'),(848,3,'credit',NULL,3700.0000,NULL,'2023-10-09 15:38:00',3,NULL,13045,NULL,NULL,NULL,'2023-10-09 13:39:29','2023-10-09 13:39:29'),(849,3,'credit',NULL,8900.0000,NULL,'2023-10-09 15:39:00',3,NULL,13048,NULL,NULL,NULL,'2023-10-09 13:39:56','2023-10-09 13:39:56'),(850,3,'credit',NULL,14000.0000,NULL,'2023-10-09 15:40:00',3,NULL,13050,NULL,NULL,NULL,'2023-10-09 13:40:50','2023-10-09 13:40:50'),(851,3,'credit',NULL,5000.0000,NULL,'2023-10-09 15:41:00',3,NULL,13052,NULL,NULL,NULL,'2023-10-09 13:41:37','2023-10-09 13:41:37'),(852,3,'credit',NULL,7800.0000,NULL,'2023-10-09 15:42:00',3,NULL,13054,NULL,NULL,NULL,'2023-10-09 13:42:31','2023-10-09 13:42:31'),(853,3,'credit',NULL,10000.0000,NULL,'2023-10-09 15:43:00',3,NULL,13056,NULL,NULL,NULL,'2023-10-09 13:43:56','2023-10-09 13:43:56'),(854,3,'credit',NULL,20000.0000,NULL,'2023-10-09 15:44:00',3,NULL,13058,NULL,NULL,NULL,'2023-10-09 13:45:02','2023-10-09 13:45:02'),(855,3,'credit',NULL,523500.0000,NULL,'2023-10-09 15:45:00',3,NULL,13060,NULL,NULL,NULL,'2023-10-09 13:45:51','2023-10-09 13:45:51'),(856,3,'credit',NULL,1000.0000,NULL,'2023-10-09 15:46:00',3,NULL,13062,NULL,NULL,NULL,'2023-10-09 13:46:49','2023-10-09 13:46:49'),(857,3,'credit',NULL,10000.0000,NULL,'2023-10-09 15:47:00',3,NULL,13064,NULL,NULL,NULL,'2023-10-09 13:47:45','2023-10-09 13:47:45'),(858,3,'credit',NULL,16536.0000,NULL,'2023-10-10 17:02:00',3,NULL,13146,NULL,NULL,NULL,'2023-10-10 15:02:13','2023-10-10 15:02:13'),(859,3,'credit',NULL,19000.0000,NULL,'2023-10-10 17:06:00',3,NULL,13149,NULL,NULL,NULL,'2023-10-10 15:07:15','2023-10-10 15:07:15'),(860,3,'credit',NULL,20000.0000,NULL,'2023-10-10 17:16:00',3,NULL,13155,NULL,NULL,NULL,'2023-10-10 15:16:16','2023-10-10 15:16:16'),(861,3,'credit',NULL,20000.0000,NULL,'2023-10-11 21:55:00',3,NULL,13272,NULL,NULL,NULL,'2023-10-11 19:56:10','2023-10-11 19:56:10'),(862,3,'credit',NULL,10000.0000,NULL,'2023-10-11 21:59:00',3,NULL,13274,NULL,NULL,NULL,'2023-10-11 20:00:20','2023-10-11 20:00:20'),(863,3,'credit',NULL,70000.0000,NULL,'2023-10-11 22:01:00',3,NULL,13276,NULL,NULL,NULL,'2023-10-11 20:02:26','2023-10-11 20:02:26'),(864,3,'credit',NULL,13800.0000,NULL,'2023-10-11 22:03:00',3,NULL,13279,NULL,NULL,NULL,'2023-10-11 20:05:35','2023-10-11 20:05:35'),(865,3,'credit',NULL,10000.0000,NULL,'2023-10-11 22:10:00',3,NULL,13281,NULL,NULL,NULL,'2023-10-11 20:13:54','2023-10-11 20:13:54'),(866,3,'credit',NULL,5000.0000,NULL,'2023-10-11 22:16:00',3,NULL,13285,NULL,NULL,NULL,'2023-10-11 20:17:05','2023-10-11 20:17:05'),(867,3,'credit',NULL,15000.0000,NULL,'2023-10-11 22:18:00',3,NULL,13288,NULL,NULL,NULL,'2023-10-11 20:19:14','2023-10-11 20:19:14'),(868,3,'credit',NULL,32300.0000,NULL,'2023-10-11 22:22:00',3,NULL,13292,NULL,NULL,NULL,'2023-10-11 20:22:52','2023-10-11 20:22:52'),(869,3,'credit',NULL,250000.0000,NULL,'2023-10-11 22:24:00',3,NULL,13296,NULL,NULL,NULL,'2023-10-11 20:28:04','2023-10-11 20:28:04'),(870,3,'credit',NULL,37188.0000,NULL,'2023-10-12 19:05:00',3,NULL,13382,NULL,NULL,NULL,'2023-10-12 17:05:31','2023-10-12 17:05:31'),(871,3,'credit',NULL,20560.0000,NULL,'2023-10-12 19:06:00',3,NULL,13386,NULL,NULL,NULL,'2023-10-12 17:07:14','2023-10-12 17:07:14'),(872,3,'credit',NULL,10000.0000,NULL,'2023-10-12 19:09:00',3,NULL,13389,NULL,NULL,NULL,'2023-10-12 17:09:32','2023-10-12 17:09:32'),(873,3,'credit',NULL,10000.0000,NULL,'2023-10-11 19:17:00',3,NULL,13393,NULL,NULL,NULL,'2023-10-12 17:17:44','2023-10-12 17:17:44'),(874,3,'credit',NULL,12000.0000,NULL,'2023-10-12 19:21:00',3,NULL,13395,NULL,NULL,NULL,'2023-10-12 17:21:47','2023-10-12 17:21:47'),(875,3,'credit',NULL,10000.0000,NULL,'2023-10-12 19:28:00',3,NULL,13399,NULL,NULL,NULL,'2023-10-12 17:29:01','2023-10-12 17:29:01'),(876,3,'credit',NULL,15000.0000,NULL,'2023-10-12 19:29:00',3,NULL,13401,NULL,NULL,NULL,'2023-10-12 17:29:43','2023-10-12 17:29:43'),(877,3,'credit',NULL,6000.0000,NULL,'2023-10-12 19:32:00',3,NULL,13403,NULL,NULL,NULL,'2023-10-12 17:32:49','2023-10-12 17:32:49'),(878,3,'credit',NULL,40000.0000,NULL,'2023-10-12 19:33:00',3,NULL,13405,NULL,NULL,NULL,'2023-10-12 17:33:59','2023-10-12 17:33:59'),(879,3,'credit',NULL,8300.0000,NULL,'2023-10-12 19:10:00',3,NULL,13631,NULL,NULL,NULL,'2023-10-15 17:11:00','2023-10-15 17:11:00'),(880,3,'credit',NULL,15900.0000,NULL,'2023-10-07 19:17:00',3,NULL,13635,NULL,NULL,NULL,'2023-10-15 17:18:04','2023-10-15 17:18:04'),(881,3,'credit',NULL,10600.0000,NULL,'2023-10-12 19:20:00',3,NULL,13637,NULL,NULL,NULL,'2023-10-15 17:20:26','2023-10-15 17:20:26'),(882,3,'credit',NULL,20800.0000,NULL,'2023-10-12 19:24:00',3,NULL,13640,NULL,NULL,NULL,'2023-10-15 17:24:57','2023-10-15 17:24:57'),(883,3,'credit',NULL,5000.0000,NULL,'2023-10-12 19:58:00',3,NULL,13648,NULL,NULL,NULL,'2023-10-15 17:58:17','2023-10-15 17:58:17'),(884,3,'credit',NULL,101500.0000,NULL,'2023-10-13 20:30:00',3,NULL,13653,NULL,NULL,NULL,'2023-10-15 18:31:08','2023-10-15 18:31:08'),(885,3,'credit',NULL,30100.0000,NULL,'2023-10-13 20:31:00',3,NULL,13655,NULL,NULL,NULL,'2023-10-15 18:32:13','2023-10-15 18:32:13'),(886,3,'credit',NULL,17700.0000,NULL,'2023-10-13 20:32:00',3,NULL,13658,NULL,NULL,NULL,'2023-10-15 18:33:13','2023-10-15 18:33:13'),(887,3,'credit',NULL,10000.0000,NULL,'2023-10-14 20:33:00',3,NULL,13660,NULL,NULL,NULL,'2023-10-15 18:34:08','2023-10-15 18:34:08'),(888,3,'credit',NULL,30000.0000,NULL,'2023-10-13 20:36:00',3,NULL,13662,NULL,NULL,NULL,'2023-10-15 18:37:05','2023-10-15 18:37:05'),(889,3,'credit',NULL,7120.0000,NULL,'2023-10-13 20:39:00',3,NULL,13666,NULL,NULL,NULL,'2023-10-15 18:39:58','2023-10-15 18:39:58'),(890,3,'credit',NULL,140000.0000,NULL,'2023-10-15 20:44:00',3,NULL,13669,NULL,NULL,NULL,'2023-10-15 18:45:09','2023-10-15 18:45:09'),(891,3,'credit',NULL,33200.0000,NULL,'2023-10-15 20:46:00',3,NULL,13672,NULL,NULL,NULL,'2023-10-15 18:46:42','2023-10-15 18:46:42'),(892,3,'credit',NULL,9800.0000,NULL,'2023-10-14 20:55:00',3,NULL,13682,NULL,NULL,NULL,'2023-10-15 18:56:15','2023-10-15 18:56:15'),(893,3,'credit',NULL,8500.0000,NULL,'2023-10-14 20:56:00',3,NULL,13685,NULL,NULL,NULL,'2023-10-15 18:56:53','2023-10-15 18:56:53'),(894,3,'credit',NULL,8000.0000,NULL,'2023-10-14 20:58:00',3,NULL,13687,NULL,NULL,NULL,'2023-10-15 18:58:41','2023-10-15 18:58:41'),(895,3,'credit',NULL,4000.0000,NULL,'2023-10-14 20:59:00',3,NULL,13689,NULL,NULL,NULL,'2023-10-15 18:59:30','2023-10-15 18:59:30'),(896,3,'credit',NULL,11000.0000,NULL,'2023-10-15 21:02:00',3,NULL,13691,NULL,NULL,NULL,'2023-10-15 19:02:33','2023-10-15 19:02:33'),(897,3,'credit',NULL,85104.0000,NULL,'2023-10-12 09:09:00',3,NULL,13703,NULL,NULL,NULL,'2023-10-16 07:09:35','2023-10-16 07:09:35'),(898,3,'credit',NULL,20000.0000,NULL,'2023-10-16 12:23:00',3,NULL,13767,NULL,NULL,NULL,'2023-10-17 10:23:46','2023-10-17 10:23:46'),(899,3,'credit',NULL,10000.0000,NULL,'2023-10-16 12:29:00',3,NULL,13769,NULL,NULL,NULL,'2023-10-17 10:29:56','2023-10-17 10:29:56'),(900,3,'credit',NULL,15000.0000,NULL,'2023-10-16 12:30:00',3,NULL,13771,NULL,NULL,NULL,'2023-10-17 10:31:04','2023-10-17 10:31:04'),(901,3,'credit',NULL,5000.0000,NULL,'2023-10-16 12:38:00',3,NULL,13773,NULL,NULL,NULL,'2023-10-17 10:39:07','2023-10-17 10:39:07'),(902,3,'credit',NULL,5000.0000,NULL,'2023-10-17 12:53:00',3,NULL,13777,NULL,NULL,NULL,'2023-10-17 10:56:16','2023-10-17 10:56:16'),(903,3,'credit',NULL,8800.0000,NULL,'2023-10-17 13:03:00',3,NULL,13779,NULL,NULL,NULL,'2023-10-17 11:04:10','2023-10-17 11:04:10'),(904,3,'credit',NULL,47600.0000,NULL,'2023-10-17 16:57:00',3,NULL,13941,NULL,NULL,NULL,'2023-10-19 14:58:09','2023-10-19 14:58:09'),(905,3,'credit',NULL,6400.0000,NULL,'2023-10-17 16:58:00',3,NULL,13945,NULL,NULL,NULL,'2023-10-19 14:59:07','2023-10-19 14:59:07'),(906,3,'credit',NULL,24216.0000,NULL,'2023-10-19 17:06:00',3,NULL,13952,NULL,NULL,NULL,'2023-10-19 15:06:18','2023-10-19 15:06:18'),(907,3,'credit',NULL,30000.0000,NULL,'2023-10-19 17:06:00',3,NULL,13954,NULL,NULL,NULL,'2023-10-19 15:06:51','2023-10-19 15:06:51'),(908,3,'credit',NULL,11760.0000,NULL,'2023-10-19 17:07:00',3,NULL,13956,NULL,NULL,NULL,'2023-10-19 15:08:07','2023-10-19 15:08:07'),(909,3,'credit',NULL,15000.0000,NULL,'2023-10-19 17:09:00',3,NULL,13958,NULL,NULL,NULL,'2023-10-19 15:09:11','2023-10-19 15:09:11'),(910,3,'credit',NULL,34000.0000,NULL,'2023-10-17 17:11:00',3,NULL,13961,NULL,NULL,NULL,'2023-10-19 15:11:50','2023-10-19 15:11:50'),(911,3,'credit',NULL,28800.0000,NULL,'2023-10-19 17:14:00',3,NULL,13966,NULL,NULL,NULL,'2023-10-19 15:14:40','2023-10-19 15:14:40'),(912,3,'credit',NULL,20000.0000,NULL,'2023-10-20 17:02:00',3,NULL,14028,NULL,NULL,NULL,'2023-10-20 15:02:28','2023-10-20 15:02:28'),(913,3,'credit',NULL,46600.0000,NULL,'2023-10-20 17:05:00',3,NULL,14030,NULL,NULL,NULL,'2023-10-20 15:06:00','2023-10-20 15:06:00'),(914,3,'credit',NULL,10000.0000,NULL,'2023-10-20 17:06:00',3,NULL,14032,NULL,NULL,NULL,'2023-10-20 15:06:33','2023-10-20 15:06:33'),(915,3,'credit',NULL,6000.0000,NULL,'2023-10-20 17:07:00',3,NULL,14035,NULL,NULL,NULL,'2023-10-20 15:08:56','2023-10-20 15:08:56'),(916,3,'credit',NULL,10000.0000,NULL,'2023-10-20 17:09:00',3,NULL,14037,NULL,NULL,NULL,'2023-10-20 15:09:30','2023-10-20 15:09:30'),(917,3,'credit',NULL,26230.0000,NULL,'2023-10-20 17:10:00',3,NULL,14041,NULL,NULL,NULL,'2023-10-20 15:10:17','2023-10-20 15:10:17'),(918,3,'credit',NULL,8000.0000,NULL,'2023-10-20 17:10:00',3,NULL,14043,NULL,NULL,NULL,'2023-10-20 15:11:01','2023-10-20 15:11:01'),(919,3,'credit',NULL,5350.0000,NULL,'2023-10-20 17:11:00',3,NULL,14045,NULL,NULL,NULL,'2023-10-20 15:11:41','2023-10-20 15:11:41'),(920,3,'credit',NULL,10000.0000,NULL,'2023-10-20 17:12:00',3,NULL,14048,NULL,NULL,NULL,'2023-10-20 15:12:23','2023-10-20 15:12:23'),(921,3,'credit',NULL,50000.0000,NULL,'2023-10-20 17:12:00',3,NULL,14051,NULL,NULL,NULL,'2023-10-20 15:13:10','2023-10-20 15:13:10'),(922,3,'credit',NULL,36000.0000,NULL,'2023-10-20 17:13:00',3,NULL,14053,NULL,NULL,NULL,'2023-10-20 15:13:43','2023-10-20 15:13:43');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int DEFAULT NULL,
  `business_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
INSERT INTO `account_types` VALUES (1,'Bank Account',NULL,3,'2023-05-18 16:31:06','2023-05-18 16:31:06'),(2,'Cash Counter',NULL,3,'2023-05-18 16:31:30','2023-05-18 16:31:30'),(3,'Cash counter',NULL,8,'2023-06-23 18:56:53','2023-06-23 18:56:53'),(4,'Bank Acount',NULL,8,'2023-06-23 18:57:20','2023-06-23 18:57:20');
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `account_type_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,3,'Habib Metro','6042920311714100000','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,3,0,NULL,'2023-05-18 16:35:23','2023-05-18 16:35:23'),(2,3,'HBL Microfinance','191021667648016','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,3,0,NULL,'2023-05-18 16:41:13','2023-05-18 16:41:13'),(3,3,'Cash Counter','123345','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',2,NULL,3,0,NULL,'2023-05-18 16:42:11','2023-05-18 16:42:11'),(4,8,'Counter Sale','112254585','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',3,NULL,33,0,NULL,'2023-06-23 17:46:24','2023-06-23 18:57:51'),(5,8,'Bank Alfala Gilgit Gate way hotel','01191006251478','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',4,NULL,33,0,NULL,'2023-06-23 18:56:16','2023-06-23 18:57:41');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int DEFAULT NULL,
  `subject_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int DEFAULT NULL,
  `causer_id` int DEFAULT NULL,
  `causer_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=17104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 18:39:12','2023-05-15 18:39:12'),(2,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 21:30:19','2023-05-15 21:30:19'),(3,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 21:40:40','2023-05-15 21:40:40'),(4,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 21:43:39','2023-05-15 21:43:39'),(5,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 21:47:39','2023-05-15 21:47:39'),(6,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 21:54:13','2023-05-15 21:54:13'),(7,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-15 23:47:36','2023-05-15 23:47:36'),(8,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 00:03:57','2023-05-16 00:03:57'),(9,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 00:25:36','2023-05-16 00:25:36'),(10,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 00:25:45','2023-05-16 00:25:45'),(11,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 03:45:43','2023-05-16 03:45:43'),(12,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 04:32:29','2023-05-16 04:32:29'),(13,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 04:32:42','2023-05-16 04:32:42'),(14,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 05:21:51','2023-05-16 05:21:51'),(15,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 09:13:02','2023-05-16 09:13:02'),(16,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 16:08:32','2023-05-16 16:08:32'),(17,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 16:29:27','2023-05-16 16:29:27'),(18,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 17:40:30','2023-05-16 17:40:30'),(19,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 17:44:22','2023-05-16 17:44:22'),(20,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 17:50:10','2023-05-16 17:50:10'),(21,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 20:34:16','2023-05-16 20:34:16'),(22,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-16 20:27:25','2023-05-16 20:27:25'),(23,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 21:23:08','2023-05-16 21:23:08'),(24,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 21:25:27','2023-05-16 21:25:27'),(25,'default','added',180,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17}}',NULL,'2023-05-16 21:30:36','2023-05-16 21:30:36'),(26,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-16 22:22:29','2023-05-16 22:22:29'),(27,'default','added',4,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:07:12','2023-05-17 01:07:12'),(28,'default','added',5,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:07:31','2023-05-17 01:07:31'),(29,'default','edited',4,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:08:15','2023-05-17 01:08:15'),(30,'default','added',6,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:08:59','2023-05-17 01:08:59'),(31,'default','added',7,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:10:00','2023-05-17 01:10:00'),(32,'default','added',8,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:10:09','2023-05-17 01:10:09'),(33,'default','added',9,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:10:37','2023-05-17 01:10:37'),(34,'default','added',10,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:11:05','2023-05-17 01:11:05'),(35,'default','added',11,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:11:34','2023-05-17 01:11:34'),(36,'default','added',12,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:12:21','2023-05-17 01:12:21'),(37,'default','added',13,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:12:52','2023-05-17 01:12:52'),(38,'default','added',14,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:13:25','2023-05-17 01:13:25'),(39,'default','added',15,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:13:59','2023-05-17 01:13:59'),(40,'default','added',16,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:15:34','2023-05-17 01:15:34'),(41,'default','added',17,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:16:09','2023-05-17 01:16:09'),(42,'default','added',18,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:16:48','2023-05-17 01:16:48'),(43,'default','added',4,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Gulab Hussain\"}',NULL,'2023-05-17 01:21:03','2023-05-17 01:21:03'),(44,'default','edited',2,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr KAKATAR PHARMACY\"}',NULL,'2023-05-17 01:22:09','2023-05-17 01:22:09'),(45,'default','added',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-17 01:23:32','2023-05-17 01:23:32'),(46,'default','edited',2,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr KAKATAR PHARMACY\"}',NULL,'2023-05-17 01:40:41','2023-05-17 01:40:41'),(47,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:40:54','2023-05-17 01:40:54'),(48,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:49:54','2023-05-17 01:49:54'),(49,'default','edited',2,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr KAKATAR PHARMACY\"}',NULL,'2023-05-17 01:51:06','2023-05-17 01:51:06'),(50,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:52:47','2023-05-17 01:52:47'),(51,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-17 01:53:08','2023-05-17 01:53:08'),(52,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 01:59:54','2023-05-17 01:59:54'),(53,'default','sell_deleted',180,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":180,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17.0000\"}}',NULL,'2023-05-17 02:00:32','2023-05-17 02:00:32'),(54,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-17 18:30:13','2023-05-17 18:30:13'),(55,'default','added',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-17 18:35:29','2023-05-17 18:35:29'),(56,'default','added',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-17 18:38:33','2023-05-17 18:38:33'),(57,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-17 19:32:24','2023-05-17 19:32:24'),(58,'default','added',1959,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7799.04}}',NULL,'2023-05-17 19:54:17','2023-05-17 19:54:17'),(59,'default','edited',1959,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9196.78},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7799.0400\"}}',NULL,'2023-05-17 19:57:39','2023-05-17 19:57:39'),(60,'default','edited',1959,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"9196.7800\"}}',NULL,'2023-05-17 21:13:41','2023-05-17 21:13:42'),(61,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-17 22:18:29','2023-05-17 22:18:29'),(62,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-18 01:32:17','2023-05-18 01:32:17'),(63,'default','added',5738,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2280.56}}',NULL,'2023-05-18 02:03:39','2023-05-18 02:03:39'),(64,'default','edited',5738,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5099.12},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2280.5600\"}}',NULL,'2023-05-18 02:36:53','2023-05-18 02:36:53'),(65,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 02:36:29','2023-05-18 02:36:29'),(66,'default','edited',1959,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-18 04:06:41','2023-05-18 04:06:41'),(67,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 05:53:25','2023-05-18 05:53:25'),(68,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 06:45:06','2023-05-18 06:45:06'),(69,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 07:06:23','2023-05-18 07:06:23'),(70,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 08:28:23','2023-05-18 08:28:23'),(71,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 09:46:14','2023-05-18 09:46:14'),(72,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 13:18:13','2023-05-18 13:18:13'),(73,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:06:14','2023-05-18 16:06:14'),(74,'default','imported',19,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(75,'default','imported',20,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(76,'default','imported',21,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(77,'default','imported',22,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(78,'default','imported',23,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(79,'default','imported',24,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(80,'default','imported',25,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(81,'default','imported',26,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(82,'default','imported',27,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(83,'default','imported',28,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:17:21','2023-05-18 16:17:21'),(84,'default','added',29,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:26:13','2023-05-18 16:26:13'),(85,'default','added',30,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:27:56','2023-05-18 16:27:56'),(86,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 16:46:45','2023-05-18 16:46:45'),(87,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 17:34:43','2023-05-18 17:34:44'),(88,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 17:37:27','2023-05-18 17:37:27'),(89,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 17:45:34','2023-05-18 17:45:34'),(90,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 18:03:58','2023-05-18 18:03:58'),(91,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 18:33:16','2023-05-18 18:33:16'),(92,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 18:33:42','2023-05-18 18:33:42'),(93,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-18 19:30:29','2023-05-18 19:30:29'),(94,'default','added',5760,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4296}}',NULL,'2023-05-18 19:02:18','2023-05-18 19:02:18'),(95,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 19:14:49','2023-05-18 19:14:49'),(96,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 19:20:58','2023-05-18 19:20:58'),(97,'default','edited',5760,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4536},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4296.0000\"}}',NULL,'2023-05-18 19:22:40','2023-05-18 19:22:40'),(98,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 19:34:15','2023-05-18 19:34:15'),(99,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-18 20:16:09','2023-05-18 20:16:09'),(100,'default','edited',1959,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-18 20:22:49','2023-05-18 20:22:49'),(101,'default','added',5761,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2141.82}}',NULL,'2023-05-18 20:40:14','2023-05-18 20:40:14'),(102,'default','edited',5761,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7509.93},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2141.8200\"}}',NULL,'2023-05-18 21:08:35','2023-05-18 21:08:35'),(103,'default','edited',1959,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-18 21:14:54','2023-05-18 21:14:54'),(104,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 20:48:06','2023-05-18 20:48:06'),(105,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 21:21:39','2023-05-18 21:21:39'),(106,'default','edited',5761,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10608.51},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7509.9300\"}}',NULL,'2023-05-18 22:01:23','2023-05-18 22:01:24'),(107,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-18 22:04:33','2023-05-18 22:04:33'),(108,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-18 22:54:22','2023-05-18 22:54:22'),(109,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-18 23:17:23','2023-05-18 23:17:23'),(110,'default','added',5762,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":14525.13}}',NULL,'2023-05-18 23:59:15','2023-05-18 23:59:15'),(111,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 00:15:43','2023-05-19 00:15:43'),(112,'default','edited',5762,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"14525.1300\"}}',NULL,'2023-05-19 00:59:30','2023-05-19 00:59:30'),(113,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-19 01:11:15','2023-05-19 01:11:15'),(114,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-19 01:13:13','2023-05-19 01:13:13'),(115,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-19 01:13:43','2023-05-19 01:13:43'),(116,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-19 01:14:30','2023-05-19 01:14:30'),(117,'default','edited',2,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr MUHAMMAD HANIF\"}',NULL,'2023-05-19 01:43:45','2023-05-19 01:43:45'),(118,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:19:04','2023-05-19 01:19:04'),(119,'default','edited',5738,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5714.51},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5099.1200\"}}',NULL,'2023-05-19 01:52:40','2023-05-19 01:52:40'),(120,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:23:26','2023-05-19 01:23:26'),(121,'default','added',5763,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10467.88}}',NULL,'2023-05-19 02:04:37','2023-05-19 02:04:37'),(122,'default','imported',31,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:26','2023-05-19 01:47:26'),(123,'default','imported',32,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:27','2023-05-19 01:47:27'),(124,'default','imported',33,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:27','2023-05-19 01:47:27'),(125,'default','imported',34,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:28','2023-05-19 01:47:28'),(126,'default','imported',35,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:29','2023-05-19 01:47:29'),(127,'default','imported',36,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:29','2023-05-19 01:47:29'),(128,'default','imported',37,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:30','2023-05-19 01:47:30'),(129,'default','imported',38,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:30','2023-05-19 01:47:30'),(130,'default','imported',39,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:31','2023-05-19 01:47:31'),(131,'default','imported',40,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:31','2023-05-19 01:47:31'),(132,'default','imported',41,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:32','2023-05-19 01:47:32'),(133,'default','imported',42,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:32','2023-05-19 01:47:32'),(134,'default','imported',43,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:32','2023-05-19 01:47:32'),(135,'default','imported',44,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:33','2023-05-19 01:47:33'),(136,'default','imported',45,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:33','2023-05-19 01:47:33'),(137,'default','imported',46,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:34','2023-05-19 01:47:34'),(138,'default','imported',47,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:34','2023-05-19 01:47:34'),(139,'default','imported',48,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:35','2023-05-19 01:47:35'),(140,'default','imported',49,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:35','2023-05-19 01:47:35'),(141,'default','imported',50,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:36','2023-05-19 01:47:36'),(142,'default','imported',51,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:36','2023-05-19 01:47:36'),(143,'default','imported',52,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:37','2023-05-19 01:47:37'),(144,'default','imported',53,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:37','2023-05-19 01:47:37'),(145,'default','imported',54,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:38','2023-05-19 01:47:38'),(146,'default','imported',55,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:38','2023-05-19 01:47:38'),(147,'default','imported',56,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:39','2023-05-19 01:47:39'),(148,'default','imported',57,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:39','2023-05-19 01:47:39'),(149,'default','imported',58,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:40','2023-05-19 01:47:40'),(150,'default','imported',59,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:40','2023-05-19 01:47:41'),(151,'default','imported',60,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:41','2023-05-19 01:47:41'),(152,'default','imported',61,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:41','2023-05-19 01:47:41'),(153,'default','imported',62,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:42','2023-05-19 01:47:42'),(154,'default','imported',63,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:42','2023-05-19 01:47:42'),(155,'default','imported',64,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:43','2023-05-19 01:47:43'),(156,'default','imported',65,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:43','2023-05-19 01:47:43'),(157,'default','imported',66,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:44','2023-05-19 01:47:44'),(158,'default','imported',67,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:44','2023-05-19 01:47:44'),(159,'default','imported',68,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:45','2023-05-19 01:47:45'),(160,'default','imported',69,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:46','2023-05-19 01:47:46'),(161,'default','imported',70,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:46','2023-05-19 01:47:46'),(162,'default','imported',71,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:47','2023-05-19 01:47:47'),(163,'default','imported',72,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:47','2023-05-19 01:47:47'),(164,'default','imported',73,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:47','2023-05-19 01:47:47'),(165,'default','imported',74,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:47','2023-05-19 01:47:47'),(166,'default','imported',75,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:48','2023-05-19 01:47:48'),(167,'default','imported',76,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:48','2023-05-19 01:47:48'),(168,'default','imported',77,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:49','2023-05-19 01:47:49'),(169,'default','imported',78,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:49','2023-05-19 01:47:49'),(170,'default','imported',79,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:49','2023-05-19 01:47:49'),(171,'default','imported',80,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:49','2023-05-19 01:47:49'),(172,'default','imported',81,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:50','2023-05-19 01:47:50'),(173,'default','imported',82,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:50','2023-05-19 01:47:50'),(174,'default','imported',83,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:50','2023-05-19 01:47:50'),(175,'default','imported',84,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:51','2023-05-19 01:47:51'),(176,'default','imported',85,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:52','2023-05-19 01:47:52'),(177,'default','imported',86,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:52','2023-05-19 01:47:52'),(178,'default','imported',87,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:53','2023-05-19 01:47:53'),(179,'default','imported',88,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:53','2023-05-19 01:47:53'),(180,'default','imported',89,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:54','2023-05-19 01:47:54'),(181,'default','imported',90,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:54','2023-05-19 01:47:54'),(182,'default','imported',91,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:54','2023-05-19 01:47:54'),(183,'default','imported',92,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:55','2023-05-19 01:47:55'),(184,'default','imported',93,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:55','2023-05-19 01:47:55'),(185,'default','imported',94,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:55','2023-05-19 01:47:55'),(186,'default','imported',95,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:56','2023-05-19 01:47:56'),(187,'default','imported',96,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:56','2023-05-19 01:47:56'),(188,'default','imported',97,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:56','2023-05-19 01:47:56'),(189,'default','imported',98,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:56','2023-05-19 01:47:56'),(190,'default','imported',99,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:56','2023-05-19 01:47:57'),(191,'default','imported',100,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:57','2023-05-19 01:47:57'),(192,'default','imported',101,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:57','2023-05-19 01:47:57'),(193,'default','imported',102,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:58','2023-05-19 01:47:58'),(194,'default','imported',103,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:58','2023-05-19 01:47:58'),(195,'default','imported',104,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:59','2023-05-19 01:47:59'),(196,'default','imported',105,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:59','2023-05-19 01:47:59'),(197,'default','imported',106,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:47:59','2023-05-19 01:47:59'),(198,'default','imported',107,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:00','2023-05-19 01:48:00'),(199,'default','imported',108,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:00','2023-05-19 01:48:00'),(200,'default','imported',109,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:01','2023-05-19 01:48:01'),(201,'default','imported',110,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:01','2023-05-19 01:48:01'),(202,'default','imported',111,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:02','2023-05-19 01:48:02'),(203,'default','imported',112,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:02','2023-05-19 01:48:02'),(204,'default','imported',113,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:03','2023-05-19 01:48:03'),(205,'default','imported',114,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:04','2023-05-19 01:48:04'),(206,'default','imported',115,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:04','2023-05-19 01:48:04'),(207,'default','imported',116,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:04','2023-05-19 01:48:04'),(208,'default','imported',117,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:05','2023-05-19 01:48:05'),(209,'default','imported',118,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:06','2023-05-19 01:48:06'),(210,'default','imported',119,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:06','2023-05-19 01:48:06'),(211,'default','imported',120,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:07','2023-05-19 01:48:07'),(212,'default','imported',121,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:07','2023-05-19 01:48:07'),(213,'default','imported',122,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:08','2023-05-19 01:48:08'),(214,'default','imported',123,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:08','2023-05-19 01:48:08'),(215,'default','imported',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:08','2023-05-19 01:48:08'),(216,'default','imported',125,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:48:08','2023-05-19 01:48:08'),(217,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 01:58:30','2023-05-19 01:58:30'),(218,'default','edited',5763,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":19248.99},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"10467.8800\"}}',NULL,'2023-05-19 02:43:36','2023-05-19 02:43:36'),(219,'default','edited',5738,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5714.5100\"}}',NULL,'2023-05-19 03:31:23','2023-05-19 03:31:23'),(220,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 03:49:45','2023-05-19 03:49:45'),(221,'default','edited',5738,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-19 04:54:56','2023-05-19 04:54:56'),(222,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 04:55:51','2023-05-19 04:55:51'),(223,'default','edited',5738,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-19 05:28:39','2023-05-19 05:28:39'),(224,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 04:59:52','2023-05-19 04:59:52'),(225,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 05:00:16','2023-05-19 05:00:16'),(226,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 05:04:22','2023-05-19 05:04:22'),(227,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 05:20:55','2023-05-19 05:20:55'),(228,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 05:21:59','2023-05-19 05:21:59'),(229,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 05:22:52','2023-05-19 05:22:52'),(230,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 05:23:34','2023-05-19 05:23:34'),(231,'default','logout',9,'App\\User',NULL,4,9,'App\\User','[]',NULL,'2023-05-19 05:45:53','2023-05-19 05:45:53'),(232,'default','login',9,'App\\User',NULL,4,9,'App\\User','[]',NULL,'2023-05-19 05:47:35','2023-05-19 05:47:35'),(233,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 06:18:38','2023-05-19 06:18:38'),(234,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 06:19:01','2023-05-19 06:19:01'),(235,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 06:19:10','2023-05-19 06:19:10'),(236,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 06:19:19','2023-05-19 06:19:19'),(237,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 06:51:23','2023-05-19 06:51:23'),(238,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 07:18:10','2023-05-19 07:18:10'),(239,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 07:23:41','2023-05-19 07:23:41'),(240,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 07:25:18','2023-05-19 07:25:18'),(241,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 07:29:30','2023-05-19 07:29:30'),(242,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 12:50:40','2023-05-19 12:50:40'),(243,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 14:14:24','2023-05-19 14:14:24'),(244,'default','added',5865,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13200}}',NULL,'2023-05-19 14:20:39','2023-05-19 14:20:39'),(245,'default','added',5866,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6960}}',NULL,'2023-05-19 14:22:13','2023-05-19 14:22:13'),(246,'default','added',5867,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26400}}',NULL,'2023-05-19 14:33:26','2023-05-19 14:33:26'),(247,'default','added',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26400}}',NULL,'2023-05-19 14:36:13','2023-05-19 14:36:13'),(248,'default','added',5869,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14060}}',NULL,'2023-05-19 14:37:09','2023-05-19 14:37:09'),(249,'default','added',5870,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17326}}',NULL,'2023-05-19 14:48:44','2023-05-19 14:48:44'),(250,'default','added',5871,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8256}}',NULL,'2023-05-19 15:02:19','2023-05-19 15:02:19'),(251,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 16:23:38','2023-05-19 16:23:38'),(252,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 17:32:10','2023-05-19 17:32:10'),(253,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 17:35:00','2023-05-19 17:35:00'),(254,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 18:29:22','2023-05-19 18:29:22'),(255,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 18:29:36','2023-05-19 18:29:36'),(256,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-19 18:34:05','2023-05-19 18:34:05'),(257,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-19 19:21:31','2023-05-19 19:21:31'),(258,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-19 19:41:59','2023-05-19 19:41:59'),(259,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-19 20:35:30','2023-05-19 20:35:30'),(260,'default','added',5872,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":807187.13}}',NULL,'2023-05-19 20:23:24','2023-05-19 20:23:24'),(261,'default','edited',5872,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":813808.55},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"807187.1300\"}}',NULL,'2023-05-19 21:22:28','2023-05-19 21:22:28'),(262,'default','added',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90150}}',NULL,'2023-05-20 00:19:53','2023-05-20 00:19:53'),(263,'default','added',5874,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000}}',NULL,'2023-05-20 00:21:09','2023-05-20 00:21:09'),(264,'default','payment_edited',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-20 00:24:49','2023-05-20 00:24:49'),(265,'default','payment_edited',5803,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:24:49','2023-05-20 00:24:49'),(266,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:26:51','2023-05-20 00:26:51'),(267,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:28:53','2023-05-20 00:28:53'),(268,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:31:27','2023-05-20 00:31:27'),(269,'default','payment_edited',5867,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-20 00:32:40','2023-05-20 00:32:40'),(270,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 01:03:42','2023-05-20 01:03:42'),(271,'default','payment_edited',5811,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:38:00','2023-05-20 00:38:00'),(272,'default','login',10,'App\\User',NULL,5,10,'App\\User','[]',NULL,'2023-05-20 00:38:41','2023-05-20 00:38:41'),(273,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-20 00:43:41','2023-05-20 00:43:41'),(274,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:44:56','2023-05-20 00:44:56'),(275,'default','payment_deleted',11,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":11,\"ref_no\":\"PP2023\\/0003\"}',NULL,'2023-05-20 00:44:56','2023-05-20 00:44:56'),(276,'default','payment_deleted',10,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":10,\"ref_no\":\"SP2023\\/0007\"}',NULL,'2023-05-20 00:44:56','2023-05-20 00:44:56'),(277,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:47:28','2023-05-20 00:47:28'),(278,'default','payment_deleted',13,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":13,\"ref_no\":\"PP2023\\/0004\"}',NULL,'2023-05-20 00:47:28','2023-05-20 00:47:28'),(279,'default','payment_deleted',12,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":12,\"ref_no\":\"SP2023\\/0008\"}',NULL,'2023-05-20 00:47:28','2023-05-20 00:47:28'),(280,'default','payment_edited',5869,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14060.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14060.0000\"}}',NULL,'2023-05-20 00:49:25','2023-05-20 00:49:25'),(281,'default','payment_edited',5807,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:49:25','2023-05-20 00:49:25'),(282,'default','payment_edited',5805,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:51:50','2023-05-20 00:51:50'),(283,'default','payment_edited',5786,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:52:39','2023-05-20 00:52:39'),(284,'default','payment_edited',5795,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:53:14','2023-05-20 00:53:14'),(285,'default','payment_edited',5798,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:53:46','2023-05-20 00:53:46'),(286,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:54:23','2023-05-20 00:54:23'),(287,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:54:36','2023-05-20 00:54:36'),(288,'default','payment_edited',5756,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:54:51','2023-05-20 00:54:51'),(289,'default','payment_edited',5835,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 00:55:22','2023-05-20 00:55:22'),(290,'default','edited',5874,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21000.0000\"}}',NULL,'2023-05-20 01:11:02','2023-05-20 01:11:02'),(291,'default','edited',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-20 01:12:51','2023-05-20 01:12:51'),(292,'default','edited',5874,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21000.0000\"}}',NULL,'2023-05-20 01:13:17','2023-05-20 01:13:17'),(293,'default','edited',5869,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14060},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14060.0000\"}}',NULL,'2023-05-20 01:14:26','2023-05-20 01:14:27'),(294,'default','payment_edited',5874,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21000.0000\"}}',NULL,'2023-05-20 01:17:06','2023-05-20 01:17:06'),(295,'default','payment_edited',5869,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14060.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14060.0000\"}}',NULL,'2023-05-20 01:17:58','2023-05-20 01:17:58'),(296,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 01:48:37','2023-05-20 01:48:37'),(297,'default','payment_edited',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-20 01:18:39','2023-05-20 01:18:39'),(298,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-20 01:41:36','2023-05-20 01:41:36'),(299,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 02:43:09','2023-05-20 02:43:09'),(300,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:13:57','2023-05-20 02:13:57'),(301,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-20 02:19:30','2023-05-20 02:19:30'),(302,'default','edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":90150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-20 02:21:04','2023-05-20 02:21:04'),(303,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:21:37','2023-05-20 02:21:37'),(304,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:26:26','2023-05-20 02:26:26'),(305,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:29:48','2023-05-20 02:29:48'),(306,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:46:08','2023-05-20 02:46:08'),(307,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 02:46:58','2023-05-20 02:46:58'),(308,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 03:17:27','2023-05-20 03:17:27'),(309,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:08:34','2023-05-20 13:08:34'),(310,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:24:39','2023-05-20 13:24:39'),(311,'default','added',5876,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3120}}',NULL,'2023-05-20 13:26:45','2023-05-20 13:26:45'),(312,'default','payment_edited',5865,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13200.0000\"}}',NULL,'2023-05-20 13:40:10','2023-05-20 13:40:10'),(313,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:40:10','2023-05-20 13:40:10'),(314,'default','edited',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:41:49','2023-05-20 13:41:49'),(315,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:43:02','2023-05-20 13:43:02'),(316,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-20 13:43:02','2023-05-20 13:43:02'),(317,'default','payment_edited',5876,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3120.0000\"}}',NULL,'2023-05-20 13:43:02','2023-05-20 13:43:02'),(318,'default','payment_edited',5839,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:46:43','2023-05-20 13:46:43'),(319,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 13:52:13','2023-05-20 13:52:13'),(320,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 16:27:06','2023-05-20 16:27:06'),(321,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 17:49:42','2023-05-20 17:49:42'),(322,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-20 18:37:00','2023-05-20 18:37:00'),(323,'default','payment_edited',5818,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 18:12:23','2023-05-20 18:12:23'),(324,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-20 18:56:03','2023-05-20 18:56:03'),(325,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 20:26:43','2023-05-20 20:26:43'),(326,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 20:33:19','2023-05-20 20:33:19'),(327,'default','purchase_deleted',5763,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"19248.9900\"}}',NULL,'2023-05-20 20:38:43','2023-05-20 20:38:43'),(328,'default','purchase_deleted',5761,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"10608.5100\"}}',NULL,'2023-05-20 20:38:48','2023-05-20 20:38:48'),(329,'default','purchase_deleted',1959,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-20 20:38:55','2023-05-20 20:38:55'),(330,'default','purchase_deleted',5738,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-20 20:39:01','2023-05-20 20:39:01'),(331,'default','purchase_deleted',5762,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-20 20:39:08','2023-05-20 20:39:08'),(332,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 22:11:09','2023-05-20 22:11:09'),(333,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 22:20:40','2023-05-20 22:20:40'),(334,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 22:53:51','2023-05-20 22:53:51'),(335,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 22:31:12','2023-05-20 22:31:13'),(336,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 23:12:16','2023-05-20 23:12:16'),(337,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 22:42:38','2023-05-20 22:42:38'),(338,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 22:47:04','2023-05-20 22:47:04'),(339,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-20 23:20:58','2023-05-20 23:20:58'),(340,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-20 23:29:38','2023-05-20 23:29:38'),(341,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 03:10:59','2023-05-21 03:10:59'),(342,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-21 04:31:30','2023-05-21 04:31:30'),(343,'default','added',128,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-05-21 04:45:15','2023-05-21 04:45:15'),(344,'default','logout',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-21 05:17:05','2023-05-21 05:17:05'),(345,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:17:54','2023-05-21 05:17:54'),(346,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-21 05:19:33','2023-05-21 05:19:33'),(347,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:21:45','2023-05-21 05:21:45'),(348,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:24:52','2023-05-21 05:24:52'),(349,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:24:52','2023-05-21 05:24:52'),(350,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:25:28','2023-05-21 05:25:28'),(351,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 05:27:28','2023-05-21 05:27:28'),(352,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-21 05:28:25','2023-05-21 05:28:25'),(353,'default','added',15137,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":62650.91}}',NULL,'2023-05-21 05:42:11','2023-05-21 05:42:11'),(354,'default','added',15138,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1967.75}}',NULL,'2023-05-21 06:03:30','2023-05-21 06:03:30'),(355,'default','added',15139,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575.24}}',NULL,'2023-05-21 06:05:25','2023-05-21 06:05:25'),(356,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 14:51:18','2023-05-21 14:51:18'),(357,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-21 15:30:26','2023-05-21 15:30:26'),(358,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:18:49','2023-05-21 17:18:49'),(359,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:19:10','2023-05-21 17:19:10'),(360,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:20:42','2023-05-21 17:20:42'),(361,'default','edited',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-21 17:21:16','2023-05-21 17:21:16'),(362,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:21:51','2023-05-21 17:21:51'),(363,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:22:53','2023-05-21 17:22:53'),(364,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:25:05','2023-05-21 17:25:05'),(365,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:25:31','2023-05-21 17:25:31'),(366,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:29:09','2023-05-21 17:29:09'),(367,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:29:23','2023-05-21 17:29:23'),(368,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:30:19','2023-05-21 17:30:19'),(369,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:32:49','2023-05-21 17:32:49'),(370,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:33:05','2023-05-21 17:33:05'),(371,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:36:03','2023-05-21 17:36:03'),(372,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:36:17','2023-05-21 17:36:17'),(373,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:36:50','2023-05-21 17:36:50'),(374,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:37:41','2023-05-21 17:37:41'),(375,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:37:56','2023-05-21 17:37:56'),(376,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:38:47','2023-05-21 17:38:47'),(377,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:39:38','2023-05-21 17:39:38'),(378,'default','edited',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-21 17:40:00','2023-05-21 17:40:00'),(379,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-21 17:40:28','2023-05-21 17:40:28'),(380,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-21 17:41:12','2023-05-21 17:41:12'),(381,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:41:28','2023-05-21 17:41:28'),(382,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:41:49','2023-05-21 17:41:49'),(383,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 17:42:24','2023-05-21 17:42:24'),(384,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 17:42:37','2023-05-21 17:42:37'),(385,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 17:43:02','2023-05-21 17:43:02'),(386,'default','edited',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-21 17:43:32','2023-05-21 17:43:32'),(387,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 18:13:50','2023-05-21 18:13:50'),(388,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 18:14:24','2023-05-21 18:14:24'),(389,'default','logout',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 18:16:58','2023-05-21 18:16:58'),(390,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 18:17:14','2023-05-21 18:17:14'),(391,'default','login',6,'App\\User',NULL,2,6,'App\\User','[]',NULL,'2023-05-21 18:19:03','2023-05-21 18:19:03'),(392,'default','added',11,'App\\User',NULL,2,2,'App\\User','{\"name\":\"MR HASSAN KHALID\"}',NULL,'2023-05-21 18:21:25','2023-05-21 18:21:25'),(393,'default','deleted',11,'App\\User',NULL,2,2,'App\\User','{\"name\":\"MR HASSAN KHALID\",\"id\":11}',NULL,'2023-05-21 18:21:43','2023-05-21 18:21:43'),(394,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 18:22:42','2023-05-21 18:22:42'),(395,'default','edited',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\"}',NULL,'2023-05-21 18:23:35','2023-05-21 18:23:35'),(396,'default','deleted',6,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr HASSAN KHALID\",\"id\":6}',NULL,'2023-05-21 18:26:11','2023-05-21 18:26:11'),(397,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 18:33:05','2023-05-21 18:33:06'),(398,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 18:33:55','2023-05-21 18:33:55'),(399,'default','added',15140,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540}}',NULL,'2023-05-21 18:37:52','2023-05-21 18:37:52'),(400,'default','added',15141,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-21 18:41:53','2023-05-21 18:41:53'),(401,'default','added',15142,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129.72}}',NULL,'2023-05-21 18:45:46','2023-05-21 18:45:46'),(402,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-21 18:52:50','2023-05-21 18:52:50'),(403,'default','edited',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-21 18:59:38','2023-05-21 18:59:38'),(404,'default','added',15143,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.18}}',NULL,'2023-05-21 19:01:21','2023-05-21 19:01:21'),(405,'default','edited',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\"}',NULL,'2023-05-21 19:13:08','2023-05-21 19:13:08'),(406,'default','logout',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-21 19:13:52','2023-05-21 19:13:52'),(407,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-21 19:15:41','2023-05-21 19:15:41'),(408,'default','edited',4,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Gulab Hussain\"}',NULL,'2023-05-21 19:22:11','2023-05-21 19:22:11'),(409,'default','added',15144,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-21 19:24:23','2023-05-21 19:24:23'),(410,'default','edited',4,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Gulab Hussain\"}',NULL,'2023-05-21 19:26:45','2023-05-21 19:26:45'),(411,'default','edited',4,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Gulab Hussain\"}',NULL,'2023-05-21 19:30:30','2023-05-21 19:30:30'),(412,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 19:30:46','2023-05-21 19:30:46'),(413,'default','edited',4,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Gulab Hussain\"}',NULL,'2023-05-21 19:34:52','2023-05-21 19:34:52'),(414,'default','added',129,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-21 19:42:56','2023-05-21 19:42:56'),(415,'default','added',15145,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":314.96}}',NULL,'2023-05-21 20:17:12','2023-05-21 20:17:12'),(416,'default','added',15146,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":12574.62}}',NULL,'2023-05-21 20:19:06','2023-05-21 20:19:06'),(417,'default','edited',15146,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":12834.42},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"12574.6200\"}}',NULL,'2023-05-21 20:20:25','2023-05-21 20:20:25'),(418,'default','added',15147,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11230.8}}',NULL,'2023-05-21 20:38:53','2023-05-21 20:38:53'),(419,'default','added',15148,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-05-21 20:50:06','2023-05-21 20:50:06'),(420,'default','added',15149,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-21 20:54:51','2023-05-21 20:54:51'),(421,'default','edited',15146,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"12834.4200\"}}',NULL,'2023-05-21 20:59:34','2023-05-21 20:59:34'),(422,'default','added',15150,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":351.6}}',NULL,'2023-05-21 21:00:33','2023-05-21 21:00:33'),(423,'default','added',15151,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":513.78}}',NULL,'2023-05-21 21:25:04','2023-05-21 21:25:04'),(424,'default','edited',15146,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-21 21:28:58','2023-05-21 21:28:58'),(425,'default','edited',15137,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":113145.81},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"62650.9100\"}}',NULL,'2023-05-21 21:59:36','2023-05-21 21:59:36'),(426,'default','edited',15146,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-21 22:14:29','2023-05-21 22:14:29'),(427,'default','added',15152,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":538.8}}',NULL,'2023-05-21 22:50:52','2023-05-21 22:50:52'),(428,'default','added',15153,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.54}}',NULL,'2023-05-21 22:54:33','2023-05-21 22:54:33'),(429,'default','added',15154,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-05-21 22:57:38','2023-05-21 22:57:38'),(430,'default','added',15155,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}',NULL,'2023-05-21 23:02:09','2023-05-21 23:02:09'),(431,'default','added',15156,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1090}}',NULL,'2023-05-21 23:04:28','2023-05-21 23:04:28'),(432,'default','added',15157,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":106.89}}',NULL,'2023-05-21 23:38:00','2023-05-21 23:38:00'),(433,'default','added',15158,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-05-21 23:41:00','2023-05-21 23:41:00'),(434,'default','added',15159,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24846.15}}',NULL,'2023-05-21 23:50:45','2023-05-21 23:50:45'),(435,'default','added',15160,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-21 23:51:09','2023-05-21 23:51:09'),(436,'default','added',15161,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-21 23:55:12','2023-05-21 23:55:12'),(437,'default','added',15162,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}',NULL,'2023-05-22 00:03:06','2023-05-22 00:03:06'),(438,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-22 00:01:19','2023-05-22 00:01:20'),(439,'default','added',15163,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":858.43}}',NULL,'2023-05-22 00:33:12','2023-05-22 00:33:12'),(440,'default','added',15164,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1870}}',NULL,'2023-05-22 00:35:32','2023-05-22 00:35:32'),(441,'default','added',130,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-05-22 00:40:44','2023-05-22 00:40:44'),(442,'default','added',15165,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":90112.34}}',NULL,'2023-05-22 01:05:17','2023-05-22 01:05:17'),(443,'default','added',15166,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":938.5}}',NULL,'2023-05-22 01:10:00','2023-05-22 01:10:00'),(444,'default','added',15167,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-05-22 01:23:43','2023-05-22 01:23:43'),(445,'default','added',15168,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":17001.48}}',NULL,'2023-05-22 01:56:11','2023-05-22 01:56:11'),(446,'default','added',15169,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1827}}',NULL,'2023-05-22 01:59:17','2023-05-22 01:59:17'),(447,'default','added',131,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-05-22 02:01:55','2023-05-22 02:01:55'),(448,'default','added',15170,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4097}}',NULL,'2023-05-22 02:05:37','2023-05-22 02:05:37'),(449,'default','added',15171,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-22 02:16:36','2023-05-22 02:16:36'),(450,'default','added',15172,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-05-22 02:25:23','2023-05-22 02:25:23'),(451,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 02:30:43','2023-05-22 02:30:43'),(452,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 02:31:18','2023-05-22 02:31:18'),(453,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-22 02:01:58','2023-05-22 02:01:58'),(454,'default','added',15173,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-05-22 02:33:28','2023-05-22 02:33:28'),(455,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 02:40:35','2023-05-22 02:40:35'),(456,'default','added',15174,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1649.44}}',NULL,'2023-05-22 02:43:22','2023-05-22 02:43:22'),(457,'default','added',15175,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225.89}}',NULL,'2023-05-22 02:46:29','2023-05-22 02:46:29'),(458,'default','added',15176,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-22 02:47:23','2023-05-22 02:47:23'),(459,'default','added',15177,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1944}}',NULL,'2023-05-22 02:52:30','2023-05-22 02:52:30'),(460,'default','added',15178,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10301.54}}',NULL,'2023-05-22 02:54:12','2023-05-22 02:54:12'),(461,'default','added',15179,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":184.21}}',NULL,'2023-05-22 03:07:56','2023-05-22 03:07:56'),(462,'default','added',15180,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":108.9}}',NULL,'2023-05-22 03:11:51','2023-05-22 03:11:51'),(463,'default','added',15181,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":28739.92}}',NULL,'2023-05-22 03:20:54','2023-05-22 03:20:54'),(464,'default','added',15182,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18763.2}}',NULL,'2023-05-22 03:23:08','2023-05-22 03:23:08'),(465,'default','added',15183,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-05-22 03:25:24','2023-05-22 03:25:24'),(466,'default','added',15184,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52.36}}',NULL,'2023-05-22 03:33:20','2023-05-22 03:33:20'),(467,'default','edited',15181,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":28739.96},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"28739.9200\"}}',NULL,'2023-05-22 03:38:42','2023-05-22 03:38:42'),(468,'default','added',15185,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":373.23}}',NULL,'2023-05-22 03:50:51','2023-05-22 03:50:51'),(469,'default','edited',15182,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":27710.57},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"18763.2000\"}}',NULL,'2023-05-22 03:54:46','2023-05-22 03:54:46'),(470,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-22 03:54:55','2023-05-22 03:54:55'),(471,'default','added',15186,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3069.94}}',NULL,'2023-05-22 04:04:30','2023-05-22 04:04:30'),(472,'default','added',15187,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-05-22 04:06:42','2023-05-22 04:06:42'),(473,'default','edited',15182,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"27710.5700\"}}',NULL,'2023-05-22 04:19:00','2023-05-22 04:19:00'),(474,'default','edited',15182,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-22 04:23:23','2023-05-22 04:23:23'),(475,'default','added',15188,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1467.83}}',NULL,'2023-05-22 04:29:42','2023-05-22 04:29:42'),(476,'default','added',15189,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":677.76}}',NULL,'2023-05-22 04:34:13','2023-05-22 04:34:13'),(477,'default','added',15190,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24422.3}}',NULL,'2023-05-22 04:47:48','2023-05-22 04:47:48'),(478,'default','added',15191,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-05-22 04:48:37','2023-05-22 04:48:37'),(479,'default','added',15192,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":243.75}}',NULL,'2023-05-22 04:52:06','2023-05-22 04:52:06'),(480,'default','added',15193,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":217.72}}',NULL,'2023-05-22 04:52:58','2023-05-22 04:52:58'),(481,'default','added',15194,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2483.2}}',NULL,'2023-05-22 04:58:33','2023-05-22 04:58:33'),(482,'default','added',15195,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":437.69}}',NULL,'2023-05-22 05:05:24','2023-05-22 05:05:24'),(483,'default','edited',15195,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":337.71},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"437.6900\"}}',NULL,'2023-05-22 05:08:26','2023-05-22 05:08:26'),(484,'default','added',15196,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4686.25}}',NULL,'2023-05-22 05:09:49','2023-05-22 05:09:49'),(485,'default','added',15197,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-05-22 05:12:29','2023-05-22 05:12:29'),(486,'default','added',15198,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":122.12}}',NULL,'2023-05-22 05:35:43','2023-05-22 05:35:43'),(487,'default','edited',15196,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":17797.81},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"4686.2500\"}}',NULL,'2023-05-22 05:54:46','2023-05-22 05:54:46'),(488,'default','added',15199,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4151.74}}',NULL,'2023-05-22 06:11:13','2023-05-22 06:11:13'),(489,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 14:49:35','2023-05-22 14:49:35'),(490,'default','added',15200,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-05-22 14:51:49','2023-05-22 14:51:49'),(491,'default','added',15201,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":651.6}}',NULL,'2023-05-22 14:52:29','2023-05-22 14:52:29'),(492,'default','added',15202,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-22 15:12:05','2023-05-22 15:12:05'),(493,'default','edited',15201,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"651.6000\"}}',NULL,'2023-05-22 15:19:54','2023-05-22 15:19:54'),(494,'default','added',15203,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550.53}}',NULL,'2023-05-22 16:11:06','2023-05-22 16:11:06'),(495,'default','added',15204,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2540.79}}',NULL,'2023-05-22 16:12:30','2023-05-22 16:12:30'),(496,'default','added',15205,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76}}',NULL,'2023-05-22 16:15:24','2023-05-22 16:15:24'),(497,'default','added',15206,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1398.4}}',NULL,'2023-05-22 16:32:58','2023-05-22 16:32:58'),(498,'default','added',15207,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":649}}',NULL,'2023-05-22 16:36:09','2023-05-22 16:36:09'),(499,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-22 16:45:08','2023-05-22 16:45:08'),(500,'default','added',15208,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-22 16:46:57','2023-05-22 16:46:57'),(501,'default','added',15209,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":146.7}}',NULL,'2023-05-22 16:53:47','2023-05-22 16:53:47'),(502,'default','added',15210,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-05-22 17:02:49','2023-05-22 17:02:49'),(503,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 17:24:02','2023-05-22 17:24:02'),(504,'default','added',15211,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5899.47}}',NULL,'2023-05-22 18:02:29','2023-05-22 18:02:29'),(505,'default','added',15212,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-22 18:16:18','2023-05-22 18:16:18'),(506,'default','added',15213,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980.57}}',NULL,'2023-05-22 18:24:52','2023-05-22 18:24:52'),(507,'default','added',132,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 18:28:30','2023-05-22 18:28:30'),(508,'default','added',15214,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42070.41}}',NULL,'2023-05-22 18:54:31','2023-05-22 18:54:31'),(509,'default','added',15215,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-22 19:02:20','2023-05-22 19:02:20'),(510,'default','added',15216,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1047.06}}',NULL,'2023-05-22 19:03:03','2023-05-22 19:03:03'),(511,'default','added',15217,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-22 19:03:31','2023-05-22 19:03:31'),(512,'default','added',15218,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19.74}}',NULL,'2023-05-22 19:05:03','2023-05-22 19:05:03'),(513,'default','added',15219,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":984.2}}',NULL,'2023-05-22 19:08:24','2023-05-22 19:08:24'),(514,'default','added',15220,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":266.8}}',NULL,'2023-05-22 19:08:49','2023-05-22 19:08:49'),(515,'default','added',15221,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68.7}}',NULL,'2023-05-22 19:15:46','2023-05-22 19:15:46'),(516,'default','added',15222,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-05-22 19:20:17','2023-05-22 19:20:17'),(517,'default','added',15223,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-05-22 19:20:33','2023-05-22 19:20:33'),(518,'default','added',15224,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45.8}}',NULL,'2023-05-22 19:25:07','2023-05-22 19:25:07'),(519,'default','added',15225,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7912.82}}',NULL,'2023-05-22 19:28:17','2023-05-22 19:28:17'),(520,'default','added',15226,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9941.64}}',NULL,'2023-05-22 19:34:40','2023-05-22 19:34:40'),(521,'default','added',15227,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13679.22}}',NULL,'2023-05-22 20:14:34','2023-05-22 20:14:34'),(522,'default','added',15228,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-22 20:44:15','2023-05-22 20:44:15'),(523,'default','added',15229,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":735.75}}',NULL,'2023-05-22 20:58:43','2023-05-22 20:58:43'),(524,'default','added',15230,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":327.88}}',NULL,'2023-05-22 20:59:46','2023-05-22 20:59:46'),(525,'default','added',15231,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-22 21:03:25','2023-05-22 21:03:25'),(526,'default','added',15232,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-22 21:17:13','2023-05-22 21:17:13'),(527,'default','added',15233,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-22 21:20:19','2023-05-22 21:20:19'),(528,'default','added',15234,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9243.11}}',NULL,'2023-05-22 21:24:03','2023-05-22 21:24:03'),(529,'default','added',15235,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":12272.41}}',NULL,'2023-05-22 21:38:05','2023-05-22 21:38:05'),(530,'default','added',15236,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1657.5}}',NULL,'2023-05-22 21:39:47','2023-05-22 21:39:47'),(531,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-22 21:16:20','2023-05-22 21:16:20'),(532,'default','added',15237,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":379.46}}',NULL,'2023-05-22 21:52:59','2023-05-22 21:52:59'),(533,'default','added',15238,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-05-22 22:01:14','2023-05-22 22:01:14'),(534,'default','added',15239,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":963.48}}',NULL,'2023-05-22 22:05:09','2023-05-22 22:05:09'),(535,'default','added',15240,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2884.4}}',NULL,'2023-05-22 22:40:24','2023-05-22 22:40:24'),(536,'default','added',15241,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3450.38}}',NULL,'2023-05-22 22:48:28','2023-05-22 22:48:28'),(537,'default','added',15242,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2651.34}}',NULL,'2023-05-22 23:06:13','2023-05-22 23:06:13'),(538,'default','added',15243,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":612.78}}',NULL,'2023-05-22 23:10:05','2023-05-22 23:10:05'),(539,'default','added',15244,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-05-22 23:12:02','2023-05-22 23:12:02'),(540,'default','added',15245,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-22 23:12:24','2023-05-22 23:12:24'),(541,'default','added',15246,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-22 23:16:25','2023-05-22 23:16:25'),(542,'default','added',15247,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-22 23:17:17','2023-05-22 23:17:17'),(543,'default','added',15248,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-22 23:19:56','2023-05-22 23:19:56'),(544,'default','added',15249,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-22 23:20:47','2023-05-22 23:20:47'),(545,'default','edited',15211,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":44731.96},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5899.4700\"}}',NULL,'2023-05-22 23:26:32','2023-05-22 23:26:32'),(546,'default','added',15250,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-22 23:37:26','2023-05-22 23:37:26'),(547,'default','added',15251,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-05-22 23:55:10','2023-05-22 23:55:10'),(548,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-22 23:57:50','2023-05-22 23:57:50'),(549,'default','added',15252,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-22 23:58:36','2023-05-22 23:58:36'),(550,'default','added',15253,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4859.33}}',NULL,'2023-05-23 00:14:27','2023-05-23 00:14:27'),(551,'default','added',15254,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":473.1}}',NULL,'2023-05-23 00:18:06','2023-05-23 00:18:06'),(552,'default','added',15255,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1474.23}}',NULL,'2023-05-23 00:20:06','2023-05-23 00:20:06'),(553,'default','added',15256,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":704.03}}',NULL,'2023-05-23 00:21:02','2023-05-23 00:21:02'),(554,'default','added',15257,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":990.02}}',NULL,'2023-05-23 00:22:10','2023-05-23 00:22:10'),(555,'default','sell_deleted',15252,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":15252,\"invoice_no\":\"0095\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"}}',NULL,'2023-05-23 00:29:53','2023-05-23 00:29:53'),(556,'default','added',15258,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":492.1}}',NULL,'2023-05-23 00:36:41','2023-05-23 00:36:41'),(557,'default','added',15259,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":207.98}}',NULL,'2023-05-23 00:37:01','2023-05-23 00:37:01'),(558,'default','added',15260,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-23 00:37:49','2023-05-23 00:37:49'),(559,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-23 00:10:20','2023-05-23 00:10:20'),(560,'default','added',15261,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":664.6}}',NULL,'2023-05-23 00:46:41','2023-05-23 00:46:41'),(561,'default','added',15262,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":660.3}}',NULL,'2023-05-23 00:49:47','2023-05-23 00:49:47'),(562,'default','added',15263,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-23 00:51:21','2023-05-23 00:51:21'),(563,'default','added',15264,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-23 00:53:29','2023-05-23 00:53:29'),(564,'default','added',15265,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-23 00:54:09','2023-05-23 00:54:09'),(565,'default','added',15266,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-05-23 00:57:45','2023-05-23 00:57:45'),(566,'default','added',15267,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1649.44}}',NULL,'2023-05-23 01:06:54','2023-05-23 01:06:54'),(567,'default','added',15268,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9684.61}}',NULL,'2023-05-23 01:08:25','2023-05-23 01:08:25'),(568,'default','added',15269,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-23 01:08:39','2023-05-23 01:08:39'),(569,'default','added',15270,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":19249.61}}',NULL,'2023-05-23 01:19:12','2023-05-23 01:19:12'),(570,'default','added',15271,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.48}}',NULL,'2023-05-23 01:26:51','2023-05-23 01:26:51'),(571,'default','added',15272,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":22769.67}}',NULL,'2023-05-23 01:35:18','2023-05-23 01:35:18'),(572,'default','added',15273,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180.11}}',NULL,'2023-05-23 01:41:57','2023-05-23 01:41:57'),(573,'default','added',15274,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-05-23 01:44:15','2023-05-23 01:44:15'),(574,'default','added',15275,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-05-23 01:47:42','2023-05-23 01:47:42'),(575,'default','added',15276,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-23 01:57:55','2023-05-23 01:57:55'),(576,'default','added',15277,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-23 02:01:52','2023-05-23 02:01:53'),(577,'default','added',15278,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":599}}',NULL,'2023-05-23 02:06:10','2023-05-23 02:06:10'),(578,'default','added',15279,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":795}}',NULL,'2023-05-23 02:11:17','2023-05-23 02:11:17'),(579,'default','added',15280,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-23 02:35:40','2023-05-23 02:35:40'),(580,'default','added',15281,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":797.78}}',NULL,'2023-05-23 02:50:55','2023-05-23 02:50:56'),(581,'default','added',15282,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1285.71}}',NULL,'2023-05-23 03:20:27','2023-05-23 03:20:27'),(582,'default','added',15283,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":322.1}}',NULL,'2023-05-23 03:23:34','2023-05-23 03:23:34'),(583,'default','added',15284,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":40005.01}}',NULL,'2023-05-23 03:28:11','2023-05-23 03:28:11'),(584,'default','added',15285,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-23 03:30:53','2023-05-23 03:30:53'),(585,'default','added',15286,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":30089.42}}',NULL,'2023-05-23 03:36:37','2023-05-23 03:36:37'),(586,'default','added',15287,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-05-23 03:40:35','2023-05-23 03:40:35'),(587,'default','added',15288,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580}}',NULL,'2023-05-23 04:01:43','2023-05-23 04:01:43'),(588,'default','added',15289,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":472.68}}',NULL,'2023-05-23 04:02:57','2023-05-23 04:02:57'),(589,'default','added',15290,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":894.89}}',NULL,'2023-05-23 04:03:03','2023-05-23 04:03:03'),(590,'default','added',15291,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-05-23 04:15:37','2023-05-23 04:15:37'),(591,'default','added',15292,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47.48}}',NULL,'2023-05-23 04:40:30','2023-05-23 04:40:30'),(592,'default','added',15293,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":307.58}}',NULL,'2023-05-23 04:54:05','2023-05-23 04:54:05'),(593,'default','added',15294,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":747.76}}',NULL,'2023-05-23 04:58:33','2023-05-23 04:58:33'),(594,'default','added',15295,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89}}',NULL,'2023-05-23 05:00:08','2023-05-23 05:00:08'),(595,'default','added',15296,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-23 05:00:34','2023-05-23 05:00:34'),(596,'default','login',17,'App\\User',NULL,6,17,'App\\User','[]',NULL,'2023-05-23 05:55:20','2023-05-23 05:55:20'),(597,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 06:11:50','2023-05-23 06:11:50'),(598,'default','added',18,'App\\User',NULL,3,3,'App\\User','{\"name\":\"Mr irfan irfan\"}',NULL,'2023-05-23 07:07:44','2023-05-23 07:07:44'),(599,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-23 15:33:36','2023-05-23 15:33:36'),(600,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 15:12:37','2023-05-23 15:12:37'),(601,'default','payment_edited',5834,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 15:18:19','2023-05-23 15:18:19'),(602,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-23 15:50:42','2023-05-23 15:50:42'),(603,'default','added',15297,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":539.94}}',NULL,'2023-05-23 15:52:56','2023-05-23 15:52:56'),(604,'default','added',15298,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":78.54}}',NULL,'2023-05-23 16:05:16','2023-05-23 16:05:16'),(605,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-23 16:13:40','2023-05-23 16:13:40'),(606,'default','login',17,'App\\User',NULL,6,17,'App\\User','[]',NULL,'2023-05-23 15:52:45','2023-05-23 15:52:45'),(607,'default','added',15299,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20171.87}}',NULL,'2023-05-23 16:26:56','2023-05-23 16:26:56'),(608,'default','added',15300,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-23 16:39:03','2023-05-23 16:39:03'),(609,'default','added',15301,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":93.84}}',NULL,'2023-05-23 17:01:41','2023-05-23 17:01:41'),(610,'default','added',15302,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":437.73}}',NULL,'2023-05-23 17:14:28','2023-05-23 17:14:28'),(611,'default','added',15303,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-05-23 17:36:12','2023-05-23 17:36:12'),(612,'default','edited',15303,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"220.0000\"}}',NULL,'2023-05-23 17:36:34','2023-05-23 17:36:34'),(613,'default','added',15304,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-23 17:45:37','2023-05-23 17:45:37'),(614,'default','added',15305,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":446}}',NULL,'2023-05-23 17:58:11','2023-05-23 17:58:11'),(615,'default','logout',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-23 17:58:26','2023-05-23 17:58:26'),(616,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-23 17:59:00','2023-05-23 17:59:00'),(617,'default','added',15306,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.8}}',NULL,'2023-05-23 18:02:19','2023-05-23 18:02:19'),(618,'default','added',15307,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-23 18:15:23','2023-05-23 18:15:23'),(619,'default','added',15308,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1503.54}}',NULL,'2023-05-23 18:17:34','2023-05-23 18:17:34'),(620,'default','added',15309,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-23 18:20:04','2023-05-23 18:20:04'),(621,'default','added',15310,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":315.67}}',NULL,'2023-05-23 18:52:12','2023-05-23 18:52:13'),(622,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 18:24:56','2023-05-23 18:24:56'),(623,'default','payment_edited',5753,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 18:25:56','2023-05-23 18:25:56'),(624,'default','payment_edited',5811,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 18:26:44','2023-05-23 18:26:44'),(625,'default','added',15311,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.29}}',NULL,'2023-05-23 19:00:51','2023-05-23 19:00:51'),(626,'default','payment_edited',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-23 18:34:12','2023-05-23 18:34:12'),(627,'default','payment_edited',5756,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 18:38:39','2023-05-23 18:38:39'),(628,'default','edited',15299,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":32396.9},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"20171.8700\"}}',NULL,'2023-05-23 19:38:38','2023-05-23 19:38:38'),(629,'default','logout',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-23 20:23:57','2023-05-23 20:23:57'),(630,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-23 20:24:15','2023-05-23 20:24:15'),(631,'default','edited',15299,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":41480.89},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"32396.9000\"}}',NULL,'2023-05-23 20:25:04','2023-05-23 20:25:04'),(632,'default','added',15312,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129.99}}',NULL,'2023-05-23 20:43:31','2023-05-23 20:43:31'),(633,'default','added',15313,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-05-23 20:54:19','2023-05-23 20:54:19'),(634,'default','added',15314,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-05-23 20:54:59','2023-05-23 20:54:59'),(635,'default','added',15315,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1472.5}}',NULL,'2023-05-23 20:56:17','2023-05-23 20:56:17'),(636,'default','edited',15314,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350.0000\"}}',NULL,'2023-05-23 21:00:32','2023-05-23 21:00:32'),(637,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-23 21:00:54','2023-05-23 21:00:54'),(638,'default','added',15316,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-05-23 21:23:28','2023-05-23 21:23:28'),(639,'default','added',15317,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2023-05-23 21:23:46','2023-05-23 21:23:46'),(640,'default','added',15318,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1726.56}}',NULL,'2023-05-23 21:26:35','2023-05-23 21:26:35'),(641,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 20:56:50','2023-05-23 20:56:50'),(642,'default','payment_edited',5808,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-23 20:58:52','2023-05-23 20:58:52'),(643,'default','edited',15299,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"41480.8900\"}}',NULL,'2023-05-23 21:37:31','2023-05-23 21:37:31'),(644,'default','added',15319,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":462.71}}',NULL,'2023-05-23 21:41:27','2023-05-23 21:41:27'),(645,'default','added',15320,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1520}}',NULL,'2023-05-23 21:53:41','2023-05-23 21:53:41'),(646,'default','added',15321,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8505.08}}',NULL,'2023-05-23 21:54:35','2023-05-23 21:54:35'),(647,'default','added',15322,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":761.4}}',NULL,'2023-05-23 21:59:04','2023-05-23 21:59:04'),(648,'default','added',15323,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-23 21:59:21','2023-05-23 21:59:21'),(649,'default','added',15324,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-23 22:13:08','2023-05-23 22:13:08'),(650,'default','added',15325,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":224.4}}',NULL,'2023-05-23 22:16:55','2023-05-23 22:16:55'),(651,'default','added',15326,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10075.54}}',NULL,'2023-05-23 22:26:13','2023-05-23 22:26:13'),(652,'default','added',15327,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.1}}',NULL,'2023-05-23 22:28:49','2023-05-23 22:28:49'),(653,'default','added',15328,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":48519.61}}',NULL,'2023-05-23 22:29:37','2023-05-23 22:29:37'),(654,'default','edited',15328,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"48519.6100\"}}',NULL,'2023-05-23 22:34:51','2023-05-23 22:34:51'),(655,'default','added',15329,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":27728.16}}',NULL,'2023-05-23 22:36:27','2023-05-23 22:36:27'),(656,'default','added',15330,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2225.79}}',NULL,'2023-05-23 22:40:15','2023-05-23 22:40:15'),(657,'default','added',15331,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86.9}}',NULL,'2023-05-23 22:48:08','2023-05-23 22:48:08'),(658,'default','added',15332,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1041.27}}',NULL,'2023-05-23 22:53:33','2023-05-23 22:53:33'),(659,'default','added',15333,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-23 22:53:47','2023-05-23 22:53:47'),(660,'default','added',15334,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":742.3}}',NULL,'2023-05-23 22:56:32','2023-05-23 22:56:32'),(661,'default','added',15335,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-05-23 22:59:24','2023-05-23 22:59:24'),(662,'default','added',15336,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":241.52}}',NULL,'2023-05-23 23:01:06','2023-05-23 23:01:06'),(663,'default','added',15337,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.21}}',NULL,'2023-05-23 23:02:06','2023-05-23 23:02:06'),(664,'default','added',15338,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-05-23 23:03:05','2023-05-23 23:03:06'),(665,'default','added',15339,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-05-23 23:04:08','2023-05-23 23:04:08'),(666,'default','added',15340,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-05-23 23:04:50','2023-05-23 23:04:50'),(667,'default','added',15341,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-23 23:12:34','2023-05-23 23:12:34'),(668,'default','edited',15326,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20222.74},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"10075.5400\"}}',NULL,'2023-05-23 23:23:33','2023-05-23 23:23:33'),(669,'default','added',15342,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1410}}',NULL,'2023-05-23 23:27:06','2023-05-23 23:27:06'),(670,'default','added',15343,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":316.37}}',NULL,'2023-05-23 23:30:00','2023-05-23 23:30:00'),(671,'default','added',15344,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396}}',NULL,'2023-05-23 23:31:43','2023-05-23 23:31:43'),(672,'default','added',15345,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800.2}}',NULL,'2023-05-23 23:36:14','2023-05-23 23:36:14'),(673,'default','added',15346,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":346.5}}',NULL,'2023-05-23 23:39:33','2023-05-23 23:39:33'),(674,'default','added',15347,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-23 23:40:00','2023-05-23 23:40:00'),(675,'default','added',15348,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":32196.89}}',NULL,'2023-05-23 23:53:38','2023-05-23 23:53:38'),(676,'default','added',15349,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":12299.95}}',NULL,'2023-05-24 00:01:28','2023-05-24 00:01:28'),(677,'default','added',15350,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-05-24 00:12:02','2023-05-24 00:12:02'),(678,'default','added',15351,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-24 00:19:24','2023-05-24 00:19:24'),(679,'default','added',15352,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-05-24 00:22:22','2023-05-24 00:22:22'),(680,'default','added',15353,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-24 00:39:25','2023-05-24 00:39:25'),(681,'default','added',15354,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-24 00:53:49','2023-05-24 00:53:49'),(682,'default','added',15355,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-24 01:00:34','2023-05-24 01:00:34'),(683,'default','added',15356,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-24 01:00:47','2023-05-24 01:00:47'),(684,'default','added',15357,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-05-24 01:22:36','2023-05-24 01:22:36'),(685,'default','added',15358,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3247.72}}',NULL,'2023-05-24 01:31:40','2023-05-24 01:31:40'),(686,'default','added',15359,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":209}}',NULL,'2023-05-24 01:31:53','2023-05-24 01:31:53'),(687,'default','added',15360,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-05-24 01:39:37','2023-05-24 01:39:37'),(688,'default','edited',15326,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":29098.45},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"20222.7400\"}}',NULL,'2023-05-24 01:52:27','2023-05-24 01:52:27'),(689,'default','added',15361,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-24 01:55:18','2023-05-24 01:55:18'),(690,'default','added',15362,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":271.8}}',NULL,'2023-05-24 02:03:21','2023-05-24 02:03:21'),(691,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-24 02:02:42','2023-05-24 02:02:42'),(692,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-24 02:03:39','2023-05-24 02:03:39'),(693,'default','added',15363,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3972.05}}',NULL,'2023-05-24 02:42:33','2023-05-24 02:42:33'),(694,'default','added',15364,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":25512.42}}',NULL,'2023-05-24 02:47:16','2023-05-24 02:47:16'),(695,'default','added',15365,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100.23}}',NULL,'2023-05-24 02:50:47','2023-05-24 02:50:47'),(696,'default','added',15366,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.1}}',NULL,'2023-05-24 02:52:22','2023-05-24 02:52:22'),(697,'default','added',15367,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":726.9}}',NULL,'2023-05-24 02:56:38','2023-05-24 02:56:38'),(698,'default','added',15368,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":502.04}}',NULL,'2023-05-24 02:57:39','2023-05-24 02:57:39'),(699,'default','added',15369,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-05-24 03:25:58','2023-05-24 03:25:58'),(700,'default','added',15370,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237.5}}',NULL,'2023-05-24 03:49:55','2023-05-24 03:49:55'),(701,'default','added',15371,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1608.26}}',NULL,'2023-05-24 04:04:25','2023-05-24 04:04:25'),(702,'default','added',15372,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":243.75}}',NULL,'2023-05-24 04:06:02','2023-05-24 04:06:02'),(703,'default','added',15373,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":123.8}}',NULL,'2023-05-24 04:11:24','2023-05-24 04:11:24'),(704,'default','added',15374,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-24 04:35:37','2023-05-24 04:35:37'),(705,'default','added',15375,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20069.06}}',NULL,'2023-05-24 04:59:04','2023-05-24 04:59:04'),(706,'default','added',15376,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-05-24 05:07:21','2023-05-24 05:07:21'),(707,'default','added',15377,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-24 05:07:41','2023-05-24 05:07:41'),(708,'default','added',15378,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-24 05:14:46','2023-05-24 05:14:46'),(709,'default','added',15380,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":550.53}}',NULL,'2023-05-24 05:15:29','2023-05-24 05:15:29'),(710,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 14:14:03','2023-05-24 14:14:03'),(711,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 14:17:05','2023-05-24 14:17:05'),(712,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 14:23:00','2023-05-24 14:23:00'),(713,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-24 15:32:36','2023-05-24 15:32:36'),(714,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-24 15:32:58','2023-05-24 15:32:58'),(715,'default','added',15381,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132}}',NULL,'2023-05-24 15:42:52','2023-05-24 15:42:52'),(716,'default','added',15382,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-24 16:03:41','2023-05-24 16:03:41'),(717,'default','added',15383,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-05-24 16:13:11','2023-05-24 16:13:11'),(718,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-24 16:22:55','2023-05-24 16:22:55'),(719,'default','added',15384,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":367.5}}',NULL,'2023-05-24 16:48:45','2023-05-24 16:48:45'),(720,'default','edited',15363,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4335.85},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3972.0500\"}}',NULL,'2023-05-24 17:11:18','2023-05-24 17:11:18'),(721,'default','added',15385,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-24 17:12:59','2023-05-24 17:12:59'),(722,'default','added',15386,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1002}}',NULL,'2023-05-24 17:43:33','2023-05-24 17:43:33'),(723,'default','added',15387,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1739}}',NULL,'2023-05-24 17:46:46','2023-05-24 17:46:46'),(724,'default','added',15388,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":703.2}}',NULL,'2023-05-24 18:02:28','2023-05-24 18:02:28'),(725,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 17:50:11','2023-05-24 17:50:11'),(726,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 17:52:10','2023-05-24 17:52:10'),(727,'default','added',15389,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.6}}',NULL,'2023-05-24 18:37:36','2023-05-24 18:37:36'),(728,'default','added',15390,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48.5}}',NULL,'2023-05-24 18:40:38','2023-05-24 18:40:38'),(729,'default','added',15391,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":277.52}}',NULL,'2023-05-24 19:18:10','2023-05-24 19:18:10'),(730,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 19:01:22','2023-05-24 19:01:22'),(731,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 19:01:25','2023-05-24 19:01:25'),(732,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 19:03:27','2023-05-24 19:03:27'),(733,'default','added',15392,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-05-24 19:34:28','2023-05-24 19:34:28'),(734,'default','added',15393,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-24 19:35:41','2023-05-24 19:35:41'),(735,'default','added',15394,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1119}}',NULL,'2023-05-24 19:47:55','2023-05-24 19:47:55'),(736,'default','added',15395,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1441.83}}',NULL,'2023-05-24 19:55:44','2023-05-24 19:55:44'),(737,'default','added',15396,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":131.8}}',NULL,'2023-05-24 20:11:46','2023-05-24 20:11:46'),(738,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 19:43:01','2023-05-24 19:43:01'),(739,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 19:43:55','2023-05-24 19:43:55'),(740,'default','added',15397,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99.76}}',NULL,'2023-05-24 20:37:44','2023-05-24 20:37:44'),(741,'default','added',15398,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-05-24 20:51:48','2023-05-24 20:51:48'),(742,'default','added',15399,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-24 21:06:45','2023-05-24 21:06:45'),(743,'default','added',15400,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.9}}',NULL,'2023-05-24 21:12:11','2023-05-24 21:12:11'),(744,'default','added',15401,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-24 21:40:08','2023-05-24 21:40:08'),(745,'default','added',15403,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4196.47}}',NULL,'2023-05-24 21:58:41','2023-05-24 21:58:41'),(746,'default','added',15404,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-24 22:24:01','2023-05-24 22:24:01'),(747,'default','added',15405,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-05-24 22:25:43','2023-05-24 22:25:43'),(748,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-24 22:31:07','2023-05-24 22:31:07'),(749,'default','added',15406,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275}}',NULL,'2023-05-24 22:33:17','2023-05-24 22:33:17'),(750,'default','added',15407,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":119.23}}',NULL,'2023-05-24 23:04:26','2023-05-24 23:04:26'),(751,'default','added',15408,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-24 23:05:49','2023-05-24 23:05:49'),(752,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 22:40:28','2023-05-24 22:40:28'),(753,'default','added',15409,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-05-24 23:11:53','2023-05-24 23:11:53'),(754,'default','added',15410,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-24 23:24:28','2023-05-24 23:24:28'),(755,'default','added',15411,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396.1}}',NULL,'2023-05-24 23:33:03','2023-05-24 23:33:03'),(756,'default','logout',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-24 23:33:24','2023-05-24 23:33:24'),(757,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-24 23:33:48','2023-05-24 23:33:48'),(758,'default','added',15412,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":921.25}}',NULL,'2023-05-24 23:37:23','2023-05-24 23:37:23'),(759,'default','edited',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\"}',NULL,'2023-05-24 23:39:39','2023-05-24 23:39:39'),(760,'default','added',15413,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":624.25}}',NULL,'2023-05-24 23:44:44','2023-05-24 23:44:44'),(761,'default','added',15414,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-05-24 23:48:58','2023-05-24 23:48:58'),(762,'default','added',15415,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-05-24 23:58:30','2023-05-24 23:58:30'),(763,'default','added',15416,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-25 00:02:48','2023-05-25 00:02:48'),(764,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-24 23:36:00','2023-05-24 23:36:00'),(765,'default','added',15417,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-05-24 23:38:15','2023-05-24 23:38:15'),(766,'default','added',15418,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6552}}',NULL,'2023-05-24 23:40:16','2023-05-24 23:40:16'),(767,'default','added',15419,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2658}}',NULL,'2023-05-24 23:45:18','2023-05-24 23:45:18'),(768,'default','added',15420,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":578.28}}',NULL,'2023-05-25 00:15:50','2023-05-25 00:15:50'),(769,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-25 00:16:59','2023-05-25 00:16:59'),(770,'default','added',15421,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-25 00:17:26','2023-05-25 00:17:26'),(771,'default','added',15422,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15096}}',NULL,'2023-05-24 23:48:15','2023-05-24 23:48:15'),(772,'default','added',15423,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5412}}',NULL,'2023-05-24 23:49:33','2023-05-24 23:49:33'),(773,'default','added',15424,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":734.2}}',NULL,'2023-05-25 00:20:19','2023-05-25 00:20:19'),(774,'default','added',15425,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1448.1}}',NULL,'2023-05-25 00:36:40','2023-05-25 00:36:40'),(775,'default','added',15426,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 01:00:10','2023-05-25 01:00:10'),(776,'default','added',15428,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 01:03:12','2023-05-25 01:03:12'),(777,'default','added',15430,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 01:05:25','2023-05-25 01:05:25'),(778,'default','added',15432,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 01:09:18','2023-05-25 01:09:18'),(779,'default','added',134,'App\\Contact',NULL,2,5,'App\\User','[]',NULL,'2023-05-25 01:11:22','2023-05-25 01:11:22'),(780,'default','added',15434,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-25 01:18:12','2023-05-25 01:18:12'),(781,'default','added',15435,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-05-25 01:24:50','2023-05-25 01:24:50'),(782,'default','added',15436,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76}}',NULL,'2023-05-25 01:26:25','2023-05-25 01:26:25'),(783,'default','added',15437,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-25 01:26:53','2023-05-25 01:26:53'),(784,'default','added',15438,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":585}}',NULL,'2023-05-25 01:28:49','2023-05-25 01:28:49'),(785,'default','added',15439,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-25 01:31:25','2023-05-25 01:31:25'),(786,'default','logout',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-25 01:45:55','2023-05-25 01:45:55'),(787,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-25 01:46:24','2023-05-25 01:46:24'),(788,'default','edited',15227,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":14786.94},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"13679.2200\"}}',NULL,'2023-05-25 01:57:08','2023-05-25 01:57:08'),(789,'default','added',15440,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":565.25}}',NULL,'2023-05-25 01:57:35','2023-05-25 01:57:35'),(790,'default','added',15441,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-25 01:59:35','2023-05-25 01:59:35'),(791,'default','added',15442,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5984.36}}',NULL,'2023-05-25 02:03:32','2023-05-25 02:03:32'),(792,'default','added',15443,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1649.44}}',NULL,'2023-05-25 02:06:54','2023-05-25 02:06:54'),(793,'default','added',15444,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1624.14}}',NULL,'2023-05-25 02:11:43','2023-05-25 02:11:43'),(794,'default','added',15445,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2096.62}}',NULL,'2023-05-25 02:16:06','2023-05-25 02:16:06'),(795,'default','edited',15445,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":96.62},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2096.6200\"}}',NULL,'2023-05-25 02:30:55','2023-05-25 02:30:55'),(796,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 02:03:49','2023-05-25 02:03:49'),(797,'default','added',15446,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11015.12}}',NULL,'2023-05-25 02:36:16','2023-05-25 02:36:16'),(798,'default','added',15447,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":732.4}}',NULL,'2023-05-25 03:04:52','2023-05-25 03:04:52'),(799,'default','added',15448,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2023-05-25 03:08:38','2023-05-25 03:08:38'),(800,'default','added',15449,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":498.75}}',NULL,'2023-05-25 03:09:02','2023-05-25 03:09:02'),(801,'default','added',15450,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140.4}}',NULL,'2023-05-25 03:09:58','2023-05-25 03:09:58'),(802,'default','added',15451,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":36074.02}}',NULL,'2023-05-25 03:11:37','2023-05-25 03:11:37'),(803,'default','added',15452,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":812.28}}',NULL,'2023-05-25 03:24:03','2023-05-25 03:24:03'),(804,'default','added',15453,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-05-25 03:34:57','2023-05-25 03:34:57'),(805,'default','added',15454,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.8}}',NULL,'2023-05-25 03:44:27','2023-05-25 03:44:27'),(806,'default','added',15455,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1739}}',NULL,'2023-05-25 03:46:46','2023-05-25 03:46:46'),(807,'default','added',15456,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":324.4}}',NULL,'2023-05-25 04:11:16','2023-05-25 04:11:16'),(808,'default','added',15457,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88}}',NULL,'2023-05-25 04:15:03','2023-05-25 04:15:03'),(809,'default','added',15458,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-25 04:15:28','2023-05-25 04:15:28'),(810,'default','added',15459,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":610}}',NULL,'2023-05-25 04:23:37','2023-05-25 04:23:37'),(811,'default','added',15460,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340}}',NULL,'2023-05-25 04:23:37','2023-05-25 04:23:37'),(812,'default','added',15461,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":485.5}}',NULL,'2023-05-25 04:28:03','2023-05-25 04:28:03'),(813,'default','added',15462,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":30430.2}}',NULL,'2023-05-25 04:33:37','2023-05-25 04:33:37'),(814,'default','added',15463,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80.86}}',NULL,'2023-05-25 04:34:17','2023-05-25 04:34:17'),(815,'default','added',15464,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.83}}',NULL,'2023-05-25 04:36:07','2023-05-25 04:36:07'),(816,'default','added',15465,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.35}}',NULL,'2023-05-25 04:36:30','2023-05-25 04:36:30'),(817,'default','added',15466,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-25 04:37:23','2023-05-25 04:37:23'),(818,'default','added',15467,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.05}}',NULL,'2023-05-25 04:38:44','2023-05-25 04:38:44'),(819,'default','added',15468,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8823.33}}',NULL,'2023-05-25 04:43:12','2023-05-25 04:43:12'),(820,'default','added',15469,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":918.39}}',NULL,'2023-05-25 04:50:33','2023-05-25 04:50:33'),(821,'default','added',15470,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-25 04:57:15','2023-05-25 04:57:15'),(822,'default','added',15471,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2534.4}}',NULL,'2023-05-25 04:58:29','2023-05-25 04:58:29'),(823,'default','added',15472,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-05-25 05:01:53','2023-05-25 05:01:53'),(824,'default','added',15473,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-25 05:03:29','2023-05-25 05:03:29'),(825,'default','added',15474,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":730}}',NULL,'2023-05-25 05:24:36','2023-05-25 05:24:36'),(826,'default','added',15475,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.79}}',NULL,'2023-05-25 05:32:07','2023-05-25 05:32:07'),(827,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 13:57:10','2023-05-25 13:57:10'),(828,'default','added',15476,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8028}}',NULL,'2023-05-25 14:06:22','2023-05-25 14:06:22'),(829,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 14:10:48','2023-05-25 14:10:48'),(830,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-25 15:26:36','2023-05-25 15:26:36'),(831,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-25 15:46:07','2023-05-25 15:46:07'),(832,'default','login',7,'App\\User',NULL,2,7,'App\\User','[]',NULL,'2023-05-25 15:47:12','2023-05-25 15:47:12'),(833,'default','added',15477,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2023-05-25 15:47:53','2023-05-25 15:47:53'),(834,'default','added',15478,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-25 15:56:57','2023-05-25 15:56:57'),(835,'default','added',15479,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-05-25 16:00:25','2023-05-25 16:00:25'),(836,'default','added',15480,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":248.23}}',NULL,'2023-05-25 16:01:38','2023-05-25 16:01:38'),(837,'default','added',15481,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-25 16:23:00','2023-05-25 16:23:00'),(838,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 16:14:11','2023-05-25 16:14:11'),(839,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 16:18:09','2023-05-25 16:18:09'),(840,'default','payment_edited',5811,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 16:20:13','2023-05-25 16:20:13'),(841,'default','payment_edited',15423,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5412.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5412.0000\"}}',NULL,'2023-05-25 16:20:13','2023-05-25 16:20:13'),(842,'default','edited',15451,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":64706.9},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"36074.0200\"}}',NULL,'2023-05-25 16:52:04','2023-05-25 16:52:04'),(843,'default','added',15482,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1104}}',NULL,'2023-05-25 16:46:33','2023-05-25 16:46:33'),(844,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 17:36:26','2023-05-25 17:36:26'),(845,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:13:09','2023-05-25 18:13:09'),(846,'default','payment_deleted',297,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":297,\"ref_no\":\"PP2023\\/0029\"}',NULL,'2023-05-25 18:13:09','2023-05-25 18:13:09'),(847,'default','payment_deleted',296,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":296,\"ref_no\":\"SP2023\\/0043\"}',NULL,'2023-05-25 18:13:09','2023-05-25 18:13:09'),(848,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:13:14','2023-05-25 18:13:14'),(849,'default','payment_deleted',290,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":290,\"ref_no\":\"PP2023\\/0028\"}',NULL,'2023-05-25 18:13:14','2023-05-25 18:13:14'),(850,'default','payment_deleted',289,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":289,\"ref_no\":\"SP2023\\/0042\"}',NULL,'2023-05-25 18:13:14','2023-05-25 18:13:14'),(851,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:13:28','2023-05-25 18:13:28'),(852,'default','payment_deleted',288,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":288,\"ref_no\":\"PP2023\\/0027\"}',NULL,'2023-05-25 18:13:28','2023-05-25 18:13:28'),(853,'default','payment_deleted',287,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":287,\"ref_no\":\"SP2023\\/0041\"}',NULL,'2023-05-25 18:13:28','2023-05-25 18:13:28'),(854,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:14:00','2023-05-25 18:14:00'),(855,'default','payment_deleted',286,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":286,\"ref_no\":\"PP2023\\/0026\"}',NULL,'2023-05-25 18:14:00','2023-05-25 18:14:00'),(856,'default','added',15483,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-25 18:46:42','2023-05-25 18:46:42'),(857,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:19:05','2023-05-25 18:19:05'),(858,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:19:38','2023-05-25 18:19:38'),(859,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:20:22','2023-05-25 18:20:22'),(860,'default','payment_deleted',299,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":299,\"ref_no\":\"PP2023\\/0030\"}',NULL,'2023-05-25 18:20:22','2023-05-25 18:20:22'),(861,'default','payment_deleted',298,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":298,\"ref_no\":\"SP2023\\/0044\"}',NULL,'2023-05-25 18:20:22','2023-05-25 18:20:22'),(862,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(863,'default','payment_deleted',42,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":42,\"ref_no\":\"PP2023\\/0016\"}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(864,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"90150.0000\"}}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(865,'default','payment_deleted',43,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":43,\"ref_no\":\"SP2023\\/0026\"}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(866,'default','payment_edited',5876,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3120.0000\"}}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(867,'default','payment_deleted',44,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":44,\"ref_no\":\"SP2023\\/0027\"}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(868,'default','payment_deleted',41,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":41,\"ref_no\":\"SP2023\\/0025\"}',NULL,'2023-05-25 18:24:22','2023-05-25 18:24:22'),(869,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:25:07','2023-05-25 18:25:07'),(870,'default','payment_deleted',40,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":40,\"ref_no\":\"PP2023\\/0015\"}',NULL,'2023-05-25 18:25:07','2023-05-25 18:25:07'),(871,'default','added',15484,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":188.1}}',NULL,'2023-05-25 18:56:26','2023-05-25 18:56:26'),(872,'default','payment_edited',5865,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13200.0000\"}}',NULL,'2023-05-25 18:40:31','2023-05-25 18:40:31'),(873,'default','payment_deleted',39,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":39,\"ref_no\":\"SP2023\\/0024\"}',NULL,'2023-05-25 18:40:31','2023-05-25 18:40:31'),(874,'default','payment_deleted',38,'App\\TransactionPayment',NULL,3,3,'App\\User','{\"id\":38,\"ref_no\":\"SP2023\\/0023\"}',NULL,'2023-05-25 18:40:31','2023-05-25 18:40:31'),(875,'default','payment_edited',5865,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13200.0000\"}}',NULL,'2023-05-25 18:42:04','2023-05-25 18:42:04'),(876,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:42:04','2023-05-25 18:42:04'),(877,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 18:58:46','2023-05-25 18:58:46'),(878,'default','added',15485,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-25 20:17:11','2023-05-25 20:17:11'),(879,'default','added',15486,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-05-25 20:18:30','2023-05-25 20:18:30'),(880,'default','added',15487,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-25 20:24:08','2023-05-25 20:24:08'),(881,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-25 20:27:52','2023-05-25 20:27:52'),(882,'default','added',15488,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1455.3}}',NULL,'2023-05-25 20:30:17','2023-05-25 20:30:17'),(883,'default','added',15489,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3930.3}}',NULL,'2023-05-25 20:34:15','2023-05-25 20:34:15'),(884,'default','edited',15487,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":831.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30.0000\"}}',NULL,'2023-05-25 20:35:11','2023-05-25 20:35:12'),(885,'default','login',5,'App\\User',NULL,2,5,'App\\User','[]',NULL,'2023-05-25 21:10:43','2023-05-25 21:10:43'),(886,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-25 21:21:13','2023-05-25 21:21:13'),(887,'default','added',15490,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 21:29:38','2023-05-25 21:29:38'),(888,'default','added',15492,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-05-25 21:34:07','2023-05-25 21:34:07'),(889,'default','added',15493,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 21:54:21','2023-05-25 21:54:21'),(890,'default','edited',15451,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"64706.9000\"}}',NULL,'2023-05-25 21:56:55','2023-05-25 21:56:55'),(891,'default','added',15495,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-25 22:01:17','2023-05-25 22:01:17'),(892,'default','edited',15451,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-05-25 22:22:31','2023-05-25 22:22:31'),(893,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 21:55:57','2023-05-25 21:55:57'),(894,'default','added',135,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-05-25 21:57:02','2023-05-25 21:57:02'),(895,'default','added',15496,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10500}}',NULL,'2023-05-25 21:58:19','2023-05-25 21:58:19'),(896,'default','added',15497,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-05-25 22:44:28','2023-05-25 22:44:28'),(897,'default','added',15498,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-25 22:51:21','2023-05-25 22:51:21'),(898,'default','added',15499,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-25 22:52:30','2023-05-25 22:52:30'),(899,'default','added',15500,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24538.22}}',NULL,'2023-05-25 22:55:47','2023-05-25 22:55:47'),(900,'default','added',15501,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":118447}}',NULL,'2023-05-25 23:01:49','2023-05-25 23:01:49'),(901,'default','added',15502,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4109.52}}',NULL,'2023-05-25 23:25:30','2023-05-25 23:25:30'),(902,'default','added',15503,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 23:35:01','2023-05-25 23:35:01'),(903,'default','added',15505,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-25 23:35:51','2023-05-25 23:35:51'),(904,'default','added',15506,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-05-25 23:38:28','2023-05-25 23:38:28'),(905,'default','edited',15500,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":52036.93},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"24538.2200\"}}',NULL,'2023-05-25 23:39:03','2023-05-25 23:39:03'),(906,'default','added',15507,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-05-25 23:39:44','2023-05-25 23:39:44'),(907,'default','added',15508,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 23:41:00','2023-05-25 23:41:00'),(908,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-25 23:48:40','2023-05-25 23:48:40'),(909,'default','added',15510,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-25 23:49:38','2023-05-25 23:49:38'),(910,'default','added',15512,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-25 23:50:24','2023-05-25 23:50:24'),(911,'default','edited',15500,'App\\Transaction',NULL,2,5,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":52462.26},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"52036.9300\"}}',NULL,'2023-05-25 23:52:44','2023-05-25 23:52:44'),(912,'default','added',15514,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-25 23:54:34','2023-05-25 23:54:34'),(913,'default','added',15516,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-25 23:55:18','2023-05-25 23:55:18'),(914,'default','added',15517,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-25 23:55:27','2023-05-25 23:55:27'),(915,'default','added',15519,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-25 23:56:27','2023-05-25 23:56:27'),(916,'default','added',15521,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-05-26 00:00:35','2023-05-26 00:00:35'),(917,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:02:59','2023-05-26 00:02:59'),(918,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:03:55','2023-05-26 00:03:55'),(919,'default','added',15523,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-26 00:05:31','2023-05-26 00:05:31'),(920,'default','added',15525,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-26 00:11:14','2023-05-26 00:11:14'),(921,'default','added',15527,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-26 00:14:03','2023-05-26 00:14:03'),(922,'default','added',15529,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"pending\"}}',NULL,'2023-05-26 00:14:57','2023-05-26 00:14:57'),(923,'default','added',15531,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"in_transit\"}}',NULL,'2023-05-26 00:16:07','2023-05-26 00:16:07'),(924,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:18:11','2023-05-26 00:18:11'),(925,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:19:20','2023-05-26 00:19:20'),(926,'default','added',20,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Demo Jutial\"}',NULL,'2023-05-26 00:20:29','2023-05-26 00:20:29'),(927,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:20:40','2023-05-26 00:20:40'),(928,'default','login',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:20:45','2023-05-26 00:20:45'),(929,'default','added',15533,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":399.95}}',NULL,'2023-05-26 00:21:37','2023-05-26 00:21:37'),(930,'default','added',15534,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1305.81}}',NULL,'2023-05-26 00:21:46','2023-05-26 00:21:46'),(931,'default','logout',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:22:02','2023-05-26 00:22:02'),(932,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:22:10','2023-05-26 00:22:10'),(933,'default','edited',20,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Demo Jutial\"}',NULL,'2023-05-26 00:22:47','2023-05-26 00:22:47'),(934,'default','added',15535,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45.4}}',NULL,'2023-05-26 00:22:58','2023-05-26 00:22:58'),(935,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:23:02','2023-05-26 00:23:03'),(936,'default','login',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:23:09','2023-05-26 00:23:09'),(937,'default','logout',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:23:38','2023-05-26 00:23:38'),(938,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:23:46','2023-05-26 00:23:46'),(939,'default','edited',20,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Demo Jutial\"}',NULL,'2023-05-26 00:24:25','2023-05-26 00:24:25'),(940,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:24:37','2023-05-26 00:24:37'),(941,'default','login',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:24:44','2023-05-26 00:24:44'),(942,'default','logout',20,'App\\User',NULL,2,20,'App\\User','[]',NULL,'2023-05-26 00:25:11','2023-05-26 00:25:11'),(943,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:25:18','2023-05-26 00:25:18'),(944,'default','added',15536,'App\\Transaction',NULL,2,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":193.2}}',NULL,'2023-05-26 00:26:15','2023-05-26 00:26:15'),(945,'default','deleted',20,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Demo Jutial\",\"id\":20}',NULL,'2023-05-26 00:26:27','2023-05-26 00:26:27'),(946,'default','added',23,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Demo 2 Kashrote Kashrote\"}',NULL,'2023-05-26 00:29:11','2023-05-26 00:29:11'),(947,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:29:23','2023-05-26 00:29:23'),(948,'default','login',23,'App\\User',NULL,2,23,'App\\User','[]',NULL,'2023-05-26 00:29:29','2023-05-26 00:29:29'),(949,'default','logout',23,'App\\User',NULL,2,23,'App\\User','[]',NULL,'2023-05-26 00:30:56','2023-05-26 00:30:56'),(950,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:31:05','2023-05-26 00:31:05'),(951,'default','deleted',7,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr kashif hussain\",\"id\":7}',NULL,'2023-05-26 00:31:36','2023-05-26 00:31:36'),(952,'default','deleted',23,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Demo 2 Kashrote Kashrote\",\"id\":23}',NULL,'2023-05-26 00:31:46','2023-05-26 00:31:46'),(953,'default','added',24,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Kashif Kashrote\"}',NULL,'2023-05-26 00:33:18','2023-05-26 00:33:18'),(954,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:33:29','2023-05-26 00:33:29'),(955,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 00:33:36','2023-05-26 00:33:36'),(956,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 00:35:12','2023-05-26 00:35:12'),(957,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:35:20','2023-05-26 00:35:20'),(958,'default','deleted',5,'App\\User',NULL,2,2,'App\\User','{\"name\":\" JAMIL Hussain\",\"id\":5}',NULL,'2023-05-26 00:35:39','2023-05-26 00:35:39'),(959,'default','added',27,'App\\User',NULL,2,2,'App\\User','{\"name\":\"mr Hassan kh\"}',NULL,'2023-05-26 00:41:20','2023-05-26 00:41:20'),(960,'default','added',136,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 00:54:36','2023-05-26 00:54:36'),(961,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 01:08:38','2023-05-26 01:08:38'),(962,'default','added',15537,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":81.22}}',NULL,'2023-05-26 01:11:05','2023-05-26 01:11:05'),(963,'default','sell_deleted',15537,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":15537,\"invoice_no\":\"0305\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"81.2200\"}}',NULL,'2023-05-26 01:12:10','2023-05-26 01:12:10'),(964,'default','added',15538,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-26 01:12:48','2023-05-26 01:12:48'),(965,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 01:12:53','2023-05-26 01:12:53'),(966,'default','added',15539,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228.8}}',NULL,'2023-05-26 01:14:48','2023-05-26 01:14:48'),(967,'default','added',15540,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":820}}',NULL,'2023-05-26 01:16:57','2023-05-26 01:16:57'),(968,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 01:21:48','2023-05-26 01:21:48'),(969,'default','added',15541,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-26 01:22:04','2023-05-26 01:22:04'),(970,'default','edited',27,'App\\User',NULL,2,2,'App\\User','{\"name\":\"mr Hassan kh\"}',NULL,'2023-05-26 01:22:40','2023-05-26 01:22:40'),(971,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 01:23:07','2023-05-26 01:23:07'),(972,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 01:23:49','2023-05-26 01:23:49'),(973,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 01:24:06','2023-05-26 01:24:06'),(974,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 01:24:34','2023-05-26 01:24:34'),(975,'default','added',15542,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-26 01:24:44','2023-05-26 01:24:44'),(976,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 01:26:53','2023-05-26 01:26:53'),(977,'default','added',15543,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-05-26 01:29:10','2023-05-26 01:29:10'),(978,'default','sell_deleted',15543,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":15543,\"invoice_no\":\"2023-0311\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"370.0000\"}}',NULL,'2023-05-26 01:29:35','2023-05-26 01:29:35'),(979,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 01:35:55','2023-05-26 01:35:55'),(980,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 01:36:02','2023-05-26 01:36:02'),(981,'default','edited',24,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr Kashif Hussain\"}',NULL,'2023-05-26 01:36:35','2023-05-26 01:36:35'),(982,'default','added',15544,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-26 01:37:36','2023-05-26 01:37:36'),(983,'default','added',15545,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4552.02}}',NULL,'2023-05-26 01:44:56','2023-05-26 01:44:56'),(984,'default','added',15546,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-05-26 01:49:41','2023-05-26 01:49:41'),(985,'default','added',15547,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":612.38}}',NULL,'2023-05-26 01:51:14','2023-05-26 01:51:14'),(986,'default','added',15548,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":920}}',NULL,'2023-05-26 02:03:28','2023-05-26 02:03:28'),(987,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 02:07:25','2023-05-26 02:07:25'),(988,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-26 02:07:47','2023-05-26 02:07:47'),(989,'default','added',15549,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 02:11:29','2023-05-26 02:11:29'),(990,'default','added',15551,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-26 02:18:18','2023-05-26 02:18:18'),(991,'default','added',15552,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 02:32:38','2023-05-26 02:32:38'),(992,'default','added',15554,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":897.75}}',NULL,'2023-05-26 02:55:58','2023-05-26 02:55:58'),(993,'default','added',15555,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980.84}}',NULL,'2023-05-26 02:57:37','2023-05-26 02:57:37'),(994,'default','added',15556,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-05-26 03:04:29','2023-05-26 03:04:29'),(995,'default','added',15557,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490}}',NULL,'2023-05-26 03:07:59','2023-05-26 03:07:59'),(996,'default','added',15558,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11.52}}',NULL,'2023-05-26 03:08:36','2023-05-26 03:08:36'),(997,'default','added',15559,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24876.73}}',NULL,'2023-05-26 03:23:10','2023-05-26 03:23:10'),(998,'default','added',15560,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6205.78}}',NULL,'2023-05-26 03:33:35','2023-05-26 03:33:35'),(999,'default','added',15561,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 03:38:45','2023-05-26 03:38:45'),(1000,'default','edited',15559,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":35645.18},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"24876.7300\"}}',NULL,'2023-05-26 03:46:50','2023-05-26 03:46:50'),(1001,'default','edited',15559,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"35645.1800\"}}',NULL,'2023-05-26 03:51:04','2023-05-26 03:51:04'),(1002,'default','added',15563,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5534.34}}',NULL,'2023-05-26 03:57:27','2023-05-26 03:57:27'),(1003,'default','added',15564,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4053.97}}',NULL,'2023-05-26 04:21:34','2023-05-26 04:21:34'),(1004,'default','added',15565,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":104.2}}',NULL,'2023-05-26 04:24:58','2023-05-26 04:24:58'),(1005,'default','added',15566,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":369.3}}',NULL,'2023-05-26 04:28:57','2023-05-26 04:28:57'),(1006,'default','added',15567,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6262.99}}',NULL,'2023-05-26 04:30:07','2023-05-26 04:30:07'),(1007,'default','edited',15567,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":34954.33},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"6262.9900\"}}',NULL,'2023-05-26 05:07:29','2023-05-26 05:07:29'),(1008,'default','added',15568,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-05-26 05:22:43','2023-05-26 05:22:43'),(1009,'default','edited',15567,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"34954.3300\"}}',NULL,'2023-05-26 05:28:40','2023-05-26 05:28:40'),(1010,'default','added',15569,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-05-26 05:33:50','2023-05-26 05:33:50'),(1011,'default','added',15570,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-26 05:34:33','2023-05-26 05:34:33'),(1012,'default','added',15571,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-05-26 05:39:56','2023-05-26 05:39:56'),(1013,'default','added',15572,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7300.78}}',NULL,'2023-05-26 05:57:09','2023-05-26 05:57:09'),(1014,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-26 13:51:27','2023-05-26 13:51:27'),(1015,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-26 13:54:04','2023-05-26 13:54:04'),(1016,'default','payment_edited',5753,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-26 13:54:57','2023-05-26 13:54:57'),(1017,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-26 16:52:25','2023-05-26 16:52:25'),(1018,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-26 16:39:04','2023-05-26 16:39:04'),(1019,'default','added',15573,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-05-26 17:32:02','2023-05-26 17:32:02'),(1020,'default','added',15574,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-05-26 17:44:32','2023-05-26 17:44:32'),(1021,'default','added',15575,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-05-26 17:46:22','2023-05-26 17:46:22'),(1022,'default','added',15576,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-26 17:59:41','2023-05-26 17:59:41'),(1023,'default','added',15577,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-26 18:05:49','2023-05-26 18:05:49'),(1024,'default','added',15578,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-26 18:15:09','2023-05-26 18:15:09'),(1025,'default','payment_edited',5810,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-26 17:45:19','2023-05-26 17:45:19'),(1026,'default','added',15579,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-26 18:37:37','2023-05-26 18:37:37'),(1027,'default','added',15580,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-26 18:41:56','2023-05-26 18:41:56'),(1028,'default','added',15581,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-05-26 18:47:03','2023-05-26 18:47:03'),(1029,'default','added',15582,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":106.89}}',NULL,'2023-05-26 19:21:16','2023-05-26 19:21:16'),(1030,'default','added',15583,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-26 19:26:10','2023-05-26 19:26:10'),(1031,'default','added',15584,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-26 19:43:15','2023-05-26 19:43:15'),(1032,'default','added',15585,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3566.65}}',NULL,'2023-05-26 20:12:36','2023-05-26 20:12:36'),(1033,'default','added',15586,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":681.6}}',NULL,'2023-05-26 20:38:12','2023-05-26 20:38:12'),(1034,'default','added',15587,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1465.44}}',NULL,'2023-05-26 20:42:10','2023-05-26 20:42:10'),(1035,'default','edited',15587,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1409.84},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1465.4400\"}}',NULL,'2023-05-26 20:44:07','2023-05-26 20:44:07'),(1036,'default','added',15588,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-26 20:48:21','2023-05-26 20:48:21'),(1037,'default','added',15589,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228.1}}',NULL,'2023-05-26 20:54:29','2023-05-26 20:54:29'),(1038,'default','added',15590,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":676.05}}',NULL,'2023-05-26 21:15:03','2023-05-26 21:15:03'),(1039,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-26 21:18:37','2023-05-26 21:18:37'),(1040,'default','added',15591,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-05-26 21:19:39','2023-05-26 21:19:39'),(1041,'default','added',15592,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1309.3}}',NULL,'2023-05-26 21:23:17','2023-05-26 21:23:17'),(1042,'default','added',15593,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":712.5}}',NULL,'2023-05-26 21:25:30','2023-05-26 21:25:30'),(1043,'default','added',15594,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-05-26 21:26:44','2023-05-26 21:26:44'),(1044,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-26 21:45:09','2023-05-26 21:45:09'),(1045,'default','added',15595,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":807.5}}',NULL,'2023-05-26 21:45:57','2023-05-26 21:45:57'),(1046,'default','added',15596,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 22:03:17','2023-05-26 22:03:17'),(1047,'default','added',15598,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3081.34}}',NULL,'2023-05-26 22:09:10','2023-05-26 22:09:10'),(1048,'default','added',15599,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":796.8}}',NULL,'2023-05-26 22:09:20','2023-05-26 22:09:20'),(1049,'default','added',15600,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":320}}',NULL,'2023-05-26 22:18:21','2023-05-26 22:18:22'),(1050,'default','edited',15600,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"320.0000\"}}',NULL,'2023-05-26 22:20:47','2023-05-26 22:20:47'),(1051,'default','added',15601,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 22:26:39','2023-05-26 22:26:39'),(1052,'default','added',15603,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-26 22:38:31','2023-05-26 22:38:31'),(1053,'default','added',15605,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3010.25}}',NULL,'2023-05-26 22:52:11','2023-05-26 22:52:11'),(1054,'default','added',15606,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8.64}}',NULL,'2023-05-26 22:52:47','2023-05-26 22:52:47'),(1055,'default','added',15607,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-26 22:53:54','2023-05-26 22:53:54'),(1056,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-26 22:54:32','2023-05-26 22:54:32'),(1057,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 22:55:02','2023-05-26 22:55:02'),(1058,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-26 22:55:39','2023-05-26 22:55:39'),(1059,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 22:56:04','2023-05-26 22:56:04'),(1060,'default','added',15608,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-26 23:11:56','2023-05-26 23:11:56'),(1061,'default','added',15609,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1075}}',NULL,'2023-05-26 23:39:32','2023-05-26 23:39:32'),(1062,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-05-26 23:45:36','2023-05-26 23:45:36'),(1063,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-26 23:46:18','2023-05-26 23:46:18'),(1064,'default','added',15610,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-26 23:47:34','2023-05-26 23:47:34'),(1065,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-27 00:16:33','2023-05-27 00:16:33'),(1066,'default','added',15611,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-05-27 00:17:29','2023-05-27 00:17:29'),(1067,'default','added',15612,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1425}}',NULL,'2023-05-27 00:21:54','2023-05-27 00:21:54'),(1068,'default','added',15613,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-05-27 00:27:17','2023-05-27 00:27:17'),(1069,'default','added',137,'App\\Contact',NULL,2,24,'App\\User','[]',NULL,'2023-05-27 00:29:37','2023-05-27 00:29:37'),(1070,'default','added',15614,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-05-27 00:31:08','2023-05-27 00:31:08'),(1071,'default','added',15615,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1368.2}}',NULL,'2023-05-27 00:39:54','2023-05-27 00:39:54'),(1072,'default','edited',15614,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":569.94},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"}}',NULL,'2023-05-27 00:46:28','2023-05-27 00:46:28'),(1073,'default','added',15616,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-27 01:00:25','2023-05-27 01:00:25'),(1074,'default','added',15618,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-27 01:08:58','2023-05-27 01:08:58'),(1075,'default','added',15619,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-05-27 01:11:24','2023-05-27 01:11:24'),(1076,'default','added',15620,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-27 01:25:58','2023-05-27 01:25:58'),(1077,'default','added',15622,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-05-27 01:28:06','2023-05-27 01:28:06'),(1078,'default','added',15623,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":447}}',NULL,'2023-05-27 01:32:45','2023-05-27 01:32:45'),(1079,'default','added',15624,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":282.1}}',NULL,'2023-05-27 01:34:41','2023-05-27 01:34:41'),(1080,'default','added',15625,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-27 01:37:19','2023-05-27 01:37:19'),(1081,'default','added',15626,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-27 01:43:27','2023-05-27 01:43:27'),(1082,'default','added',15627,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-27 01:47:22','2023-05-27 01:47:22'),(1083,'default','added',15628,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1305.81}}',NULL,'2023-05-27 01:49:26','2023-05-27 01:49:26'),(1084,'default','added',15629,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":393.14}}',NULL,'2023-05-27 01:54:40','2023-05-27 01:54:40'),(1085,'default','added',15630,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1876.25}}',NULL,'2023-05-27 02:08:47','2023-05-27 02:08:47'),(1086,'default','added',15631,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":392.8}}',NULL,'2023-05-27 03:00:00','2023-05-27 03:00:00'),(1087,'default','added',15632,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":599}}',NULL,'2023-05-27 03:08:34','2023-05-27 03:08:34'),(1088,'default','added',15633,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29.7}}',NULL,'2023-05-27 03:09:25','2023-05-27 03:09:25'),(1089,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 03:12:07','2023-05-27 03:12:07'),(1090,'default','added',15634,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":315}}',NULL,'2023-05-27 03:13:04','2023-05-27 03:13:04'),(1091,'default','added',138,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 03:15:13','2023-05-27 03:15:13'),(1092,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-27 03:15:32','2023-05-27 03:15:32'),(1093,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-27 03:16:08','2023-05-27 03:16:08'),(1094,'default','edited',15614,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":569.91},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"569.9400\"}}',NULL,'2023-05-27 03:18:20','2023-05-27 03:18:20'),(1095,'default','sell_deleted',15614,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":15614,\"invoice_no\":\"2023-0366\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"569.9100\"}}',NULL,'2023-05-27 03:19:19','2023-05-27 03:19:19'),(1096,'default','added',15635,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-05-27 03:19:33','2023-05-27 03:19:33'),(1097,'default','added',15636,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24103.98}}',NULL,'2023-05-27 03:46:41','2023-05-27 03:46:41'),(1098,'default','added',15637,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-27 03:53:22','2023-05-27 03:53:23'),(1099,'default','added',15638,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74.2}}',NULL,'2023-05-27 04:26:01','2023-05-27 04:26:01'),(1100,'default','added',15639,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54.5}}',NULL,'2023-05-27 04:26:06','2023-05-27 04:26:06'),(1101,'default','added',15640,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":569.94}}',NULL,'2023-05-27 04:26:36','2023-05-27 04:26:36'),(1102,'default','added',15641,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":743.2}}',NULL,'2023-05-27 04:51:38','2023-05-27 04:51:38'),(1103,'default','added',15642,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-27 04:53:16','2023-05-27 04:53:16'),(1104,'default','added',15643,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":550}}',NULL,'2023-05-27 04:55:48','2023-05-27 04:55:48'),(1105,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 16:06:08','2023-05-27 16:06:08'),(1106,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 16:07:24','2023-05-27 16:07:24'),(1107,'default','added',15644,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-05-27 16:09:10','2023-05-27 16:09:10'),(1108,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-27 16:20:06','2023-05-27 16:20:07'),(1109,'default','added',15645,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":698.4}}',NULL,'2023-05-27 16:55:52','2023-05-27 16:55:52'),(1110,'default','added',15646,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1195.2}}',NULL,'2023-05-27 18:32:55','2023-05-27 18:32:55'),(1111,'default','added',15647,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-27 18:51:08','2023-05-27 18:51:08'),(1112,'default','added',15648,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":462.82}}',NULL,'2023-05-27 18:56:01','2023-05-27 18:56:01'),(1113,'default','added',15649,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-05-27 19:35:55','2023-05-27 19:35:55'),(1114,'default','added',15650,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":956.91}}',NULL,'2023-05-27 19:56:44','2023-05-27 19:56:44'),(1115,'default','added',15651,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-05-27 20:43:12','2023-05-27 20:43:12'),(1116,'default','added',15652,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99.4}}',NULL,'2023-05-27 20:44:28','2023-05-27 20:44:28'),(1117,'default','added',15653,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-27 20:50:01','2023-05-27 20:50:01'),(1118,'default','added',15654,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-05-27 20:51:22','2023-05-27 20:51:22'),(1119,'default','added',15655,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-27 21:26:35','2023-05-27 21:26:35'),(1120,'default','added',15656,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":123.8}}',NULL,'2023-05-27 21:30:21','2023-05-27 21:30:21'),(1121,'default','added',15657,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":238.8}}',NULL,'2023-05-27 21:38:17','2023-05-27 21:38:17'),(1122,'default','added',15658,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60.08}}',NULL,'2023-05-27 21:51:33','2023-05-27 21:51:33'),(1123,'default','added',15659,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":997.75}}',NULL,'2023-05-27 22:16:53','2023-05-27 22:16:53'),(1124,'default','added',15660,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-27 22:21:31','2023-05-27 22:21:31'),(1125,'default','added',15661,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-27 22:22:39','2023-05-27 22:22:39'),(1126,'default','added',15662,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-05-27 22:26:29','2023-05-27 22:26:29'),(1127,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-27 22:27:42','2023-05-27 22:27:42'),(1128,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 22:28:23','2023-05-27 22:28:23'),(1129,'default','added',15663,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":261.24}}',NULL,'2023-05-27 22:31:33','2023-05-27 22:31:33'),(1130,'default','added',15664,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":154.68}}',NULL,'2023-05-27 22:33:52','2023-05-27 22:33:52'),(1131,'default','added',15665,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-05-27 22:54:56','2023-05-27 22:54:56'),(1132,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-27 22:55:28','2023-05-27 22:55:28'),(1133,'default','added',29,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr zia ul haq\"}',NULL,'2023-05-27 23:03:36','2023-05-27 23:03:36'),(1134,'default','added',15666,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30.04}}',NULL,'2023-05-27 23:06:15','2023-05-27 23:06:15'),(1135,'default','added',31,'App\\User',NULL,2,2,'App\\User','{\"name\":\"Mr jameel khan\"}',NULL,'2023-05-27 23:09:31','2023-05-27 23:09:31'),(1136,'default','added',15667,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-27 23:18:52','2023-05-27 23:18:52'),(1137,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-27 23:24:30','2023-05-27 23:24:30'),(1138,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-27 23:25:05','2023-05-27 23:25:05'),(1139,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 23:32:40','2023-05-27 23:32:40'),(1140,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 23:35:19','2023-05-27 23:35:19'),(1141,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-27 23:36:55','2023-05-27 23:36:55'),(1142,'default','added',15668,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5884.69}}',NULL,'2023-05-27 23:42:11','2023-05-27 23:42:11'),(1143,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-27 23:54:35','2023-05-27 23:54:35'),(1144,'default','added',15669,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":61.2}}',NULL,'2023-05-27 23:57:44','2023-05-27 23:57:44'),(1145,'default','added',15670,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-05-27 23:58:33','2023-05-27 23:58:33'),(1146,'default','edited',15669,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43.38},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"61.2000\"}}',NULL,'2023-05-28 00:01:05','2023-05-28 00:01:05'),(1147,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-28 00:06:03','2023-05-28 00:06:03'),(1148,'default','added',15671,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":230}}',NULL,'2023-05-28 00:50:08','2023-05-28 00:50:08'),(1149,'default','added',15672,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-05-28 00:55:54','2023-05-28 00:55:54'),(1150,'default','added',15673,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-05-28 01:04:10','2023-05-28 01:04:10'),(1151,'default','added',15674,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":188.1}}',NULL,'2023-05-28 01:09:31','2023-05-28 01:09:31'),(1152,'default','added',15675,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-28 01:15:09','2023-05-28 01:15:09'),(1153,'default','added',15676,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":681.25}}',NULL,'2023-05-28 01:17:49','2023-05-28 01:17:49'),(1154,'default','added',15677,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-28 01:17:58','2023-05-28 01:17:58'),(1155,'default','added',15678,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-28 01:33:00','2023-05-28 01:33:00'),(1156,'default','added',15679,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2381.34}}',NULL,'2023-05-28 01:35:52','2023-05-28 01:35:52'),(1157,'default','added',15680,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":999}}',NULL,'2023-05-28 01:43:42','2023-05-28 01:43:42'),(1158,'default','added',15681,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-05-28 01:53:56','2023-05-28 01:53:56'),(1159,'default','added',15682,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1463.75}}',NULL,'2023-05-28 01:56:41','2023-05-28 01:56:41'),(1160,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-28 02:00:01','2023-05-28 02:00:01'),(1161,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-28 02:00:16','2023-05-28 02:00:16'),(1162,'default','added',15683,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-28 02:05:13','2023-05-28 02:05:13'),(1163,'default','added',15684,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-28 02:08:48','2023-05-28 02:08:48'),(1164,'default','added',15685,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-28 02:09:29','2023-05-28 02:09:29'),(1165,'default','added',15686,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":825.48}}',NULL,'2023-05-28 02:15:36','2023-05-28 02:15:36'),(1166,'default','added',15687,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":464.58}}',NULL,'2023-05-28 02:24:17','2023-05-28 02:24:17'),(1167,'default','added',15688,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-28 02:33:13','2023-05-28 02:33:13'),(1168,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-28 02:44:19','2023-05-28 02:44:19'),(1169,'default','added',15689,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1241.3}}',NULL,'2023-05-28 02:48:11','2023-05-28 02:48:11'),(1170,'default','added',15690,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40.9}}',NULL,'2023-05-28 02:52:36','2023-05-28 02:52:36'),(1171,'default','added',15691,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":376}}',NULL,'2023-05-28 03:02:49','2023-05-28 03:02:49'),(1172,'default','added',15692,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-28 03:08:00','2023-05-28 03:08:00'),(1173,'default','added',15693,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2814.4}}',NULL,'2023-05-28 03:24:10','2023-05-28 03:24:10'),(1174,'default','added',15694,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1624}}',NULL,'2023-05-28 03:49:59','2023-05-28 03:49:59'),(1175,'default','added',15695,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":37491.68}}',NULL,'2023-05-28 03:56:35','2023-05-28 03:56:35'),(1176,'default','added',15696,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2640}}',NULL,'2023-05-28 04:02:12','2023-05-28 04:02:12'),(1177,'default','added',15697,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.2}}',NULL,'2023-05-28 04:04:41','2023-05-28 04:04:41'),(1178,'default','added',15698,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-28 04:17:22','2023-05-28 04:17:22'),(1179,'default','added',15699,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1151.3}}',NULL,'2023-05-28 04:30:34','2023-05-28 04:30:34'),(1180,'default','added',15700,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.17}}',NULL,'2023-05-28 04:31:54','2023-05-28 04:31:54'),(1181,'default','added',15701,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":780}}',NULL,'2023-05-28 04:46:03','2023-05-28 04:46:03'),(1182,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-28 15:02:43','2023-05-28 15:02:43'),(1183,'default','added',15702,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2487.58}}',NULL,'2023-05-28 15:57:21','2023-05-28 15:57:21'),(1184,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-28 16:01:51','2023-05-28 16:01:51'),(1185,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-28 16:10:14','2023-05-28 16:10:14'),(1186,'default','added',15703,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":304.67}}',NULL,'2023-05-28 16:13:37','2023-05-28 16:13:37'),(1187,'default','added',15704,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-28 17:25:53','2023-05-28 17:25:53'),(1188,'default','added',15705,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490.42}}',NULL,'2023-05-28 17:33:39','2023-05-28 17:33:39'),(1189,'default','added',15706,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-28 17:35:24','2023-05-28 17:35:24'),(1190,'default','added',15707,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-28 17:43:30','2023-05-28 17:43:30'),(1191,'default','added',15708,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-05-28 17:47:10','2023-05-28 17:47:10'),(1192,'default','added',15709,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1285.71}}',NULL,'2023-05-28 17:53:53','2023-05-28 17:53:53'),(1193,'default','added',15710,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-28 17:55:21','2023-05-28 17:55:21'),(1194,'default','added',15711,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2841.62}}',NULL,'2023-05-28 18:21:04','2023-05-28 18:21:04'),(1195,'default','added',15712,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71}}',NULL,'2023-05-28 19:04:44','2023-05-28 19:04:44'),(1196,'default','added',15713,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.6}}',NULL,'2023-05-28 19:07:13','2023-05-28 19:07:13'),(1197,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-28 18:47:27','2023-05-28 18:47:27'),(1198,'default','added',15714,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":440}}',NULL,'2023-05-28 19:26:44','2023-05-28 19:26:44'),(1199,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-28 19:04:44','2023-05-28 19:04:44'),(1200,'default','added',15715,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.6}}',NULL,'2023-05-28 19:40:57','2023-05-28 19:40:57'),(1201,'default','added',15716,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-05-28 19:42:37','2023-05-28 19:42:37'),(1202,'default','added',15717,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-28 19:45:48','2023-05-28 19:45:48'),(1203,'default','added',15718,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100.55}}',NULL,'2023-05-28 19:54:49','2023-05-28 19:54:49'),(1204,'default','added',15719,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48.65}}',NULL,'2023-05-28 20:20:26','2023-05-28 20:20:26'),(1205,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-28 20:22:54','2023-05-28 20:22:54'),(1206,'default','added',139,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-28 20:23:59','2023-05-28 20:23:59'),(1207,'default','added',15720,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-05-28 20:25:15','2023-05-28 20:25:15'),(1208,'default','added',15721,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-05-28 20:30:53','2023-05-28 20:30:53'),(1209,'default','added',15722,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":332.6}}',NULL,'2023-05-28 20:42:14','2023-05-28 20:42:14'),(1210,'default','added',15723,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-05-28 21:13:04','2023-05-28 21:13:04'),(1211,'default','added',15724,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":727.4}}',NULL,'2023-05-28 21:18:45','2023-05-28 21:18:45'),(1212,'default','added',15725,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-05-28 21:24:33','2023-05-28 21:24:33'),(1213,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-28 21:50:35','2023-05-28 21:50:36'),(1214,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-28 21:51:05','2023-05-28 21:51:05'),(1215,'default','added',15726,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-28 21:59:48','2023-05-28 21:59:48'),(1216,'default','added',15727,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":920}}',NULL,'2023-05-28 22:33:05','2023-05-28 22:33:05'),(1217,'default','added',15728,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":444.93}}',NULL,'2023-05-28 22:38:46','2023-05-28 22:38:46'),(1218,'default','added',15729,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":96}}',NULL,'2023-05-28 22:42:05','2023-05-28 22:42:05'),(1219,'default','added',15730,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-28 22:48:25','2023-05-28 22:48:25'),(1220,'default','added',15731,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-05-28 22:56:57','2023-05-28 22:56:57'),(1221,'default','added',15732,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.84}}',NULL,'2023-05-28 23:13:43','2023-05-28 23:13:43'),(1222,'default','added',15733,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":111.5}}',NULL,'2023-05-28 23:35:00','2023-05-28 23:35:00'),(1223,'default','added',15734,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1457.75}}',NULL,'2023-05-28 23:52:37','2023-05-28 23:52:37'),(1224,'default','added',15735,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-29 00:01:28','2023-05-29 00:01:28'),(1225,'default','added',15736,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-29 00:01:59','2023-05-29 00:01:59'),(1226,'default','added',15737,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":704.03}}',NULL,'2023-05-29 00:05:40','2023-05-29 00:05:40'),(1227,'default','added',15738,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":193.75}}',NULL,'2023-05-29 00:50:20','2023-05-29 00:50:20'),(1228,'default','added',15739,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1287}}',NULL,'2023-05-29 00:54:59','2023-05-29 00:54:59'),(1229,'default','added',15740,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":362.99}}',NULL,'2023-05-29 01:00:20','2023-05-29 01:00:20'),(1230,'default','added',15741,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":290}}',NULL,'2023-05-29 01:05:15','2023-05-29 01:05:15'),(1231,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-29 00:38:33','2023-05-29 00:38:33'),(1232,'default','added',15742,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1531.29}}',NULL,'2023-05-29 01:15:19','2023-05-29 01:15:19'),(1233,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-29 01:17:41','2023-05-29 01:17:41'),(1234,'default','added',15743,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":565}}',NULL,'2023-05-29 01:18:47','2023-05-29 01:18:47'),(1235,'default','added',15744,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":183.35}}',NULL,'2023-05-29 01:19:15','2023-05-29 01:19:15'),(1236,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-29 01:22:03','2023-05-29 01:22:03'),(1237,'default','added',15745,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":588.7}}',NULL,'2023-05-29 01:25:55','2023-05-29 01:25:55'),(1238,'default','added',15746,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-05-29 01:33:06','2023-05-29 01:33:06'),(1239,'default','added',15747,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":312.55}}',NULL,'2023-05-29 01:55:50','2023-05-29 01:55:50'),(1240,'default','added',15748,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-29 01:59:28','2023-05-29 01:59:28'),(1241,'default','added',15749,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-05-29 02:10:32','2023-05-29 02:10:32'),(1242,'default','added',15750,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-05-29 02:20:29','2023-05-29 02:20:29'),(1243,'default','added',15751,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-29 02:36:57','2023-05-29 02:36:57'),(1244,'default','added',15752,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-29 02:42:44','2023-05-29 02:42:44'),(1245,'default','added',15753,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2638.74}}',NULL,'2023-05-29 02:46:42','2023-05-29 02:46:42'),(1246,'default','added',15754,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2305.81}}',NULL,'2023-05-29 02:49:11','2023-05-29 02:49:11'),(1247,'default','added',15755,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8214.16}}',NULL,'2023-05-29 03:18:02','2023-05-29 03:18:02'),(1248,'default','added',15756,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":840}}',NULL,'2023-05-29 03:37:39','2023-05-29 03:37:39'),(1249,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-29 03:40:07','2023-05-29 03:40:07'),(1250,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-29 03:43:14','2023-05-29 03:43:14'),(1251,'default','added',15757,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-29 03:56:36','2023-05-29 03:56:36'),(1252,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-29 04:01:52','2023-05-29 04:01:52'),(1253,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-29 04:02:21','2023-05-29 04:02:21'),(1254,'default','sell_deleted',15738,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":15738,\"invoice_no\":\"2023-0483\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"193.7500\"}}',NULL,'2023-05-29 04:07:11','2023-05-29 04:07:11'),(1255,'default','added',15758,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-05-29 04:16:14','2023-05-29 04:16:14'),(1256,'default','added',15759,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-05-29 04:17:20','2023-05-29 04:17:20'),(1257,'default','added',15760,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-05-29 04:38:41','2023-05-29 04:38:41'),(1258,'default','added',15761,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-29 04:48:26','2023-05-29 04:48:26'),(1259,'default','added',15762,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980.84}}',NULL,'2023-05-29 04:55:04','2023-05-29 04:55:04'),(1260,'default','added',15763,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12070.09}}',NULL,'2023-05-29 05:13:43','2023-05-29 05:13:43'),(1261,'default','added',15764,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1237.5}}',NULL,'2023-05-29 05:15:48','2023-05-29 05:15:48'),(1262,'default','added',15765,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-29 05:16:06','2023-05-29 05:16:06'),(1263,'default','added',15766,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":188.16}}',NULL,'2023-05-29 05:29:07','2023-05-29 05:29:07'),(1264,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-29 14:46:43','2023-05-29 14:46:43'),(1265,'default','added',15767,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-29 14:49:55','2023-05-29 14:49:55'),(1266,'default','added',15768,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":457.4}}',NULL,'2023-05-29 15:40:52','2023-05-29 15:40:52'),(1267,'default','added',15769,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2949.6}}',NULL,'2023-05-29 15:50:34','2023-05-29 15:50:34'),(1268,'default','added',15770,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-29 15:52:28','2023-05-29 15:52:28'),(1269,'default','added',15771,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-05-29 16:12:26','2023-05-29 16:12:26'),(1270,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-29 16:18:32','2023-05-29 16:18:32'),(1271,'default','added',15772,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-05-29 16:38:17','2023-05-29 16:38:17'),(1272,'default','added',15773,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-05-29 16:40:55','2023-05-29 16:40:55'),(1273,'default','added',15774,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":101.39}}',NULL,'2023-05-29 16:43:51','2023-05-29 16:43:51'),(1274,'default','added',15775,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5068.8}}',NULL,'2023-05-29 17:07:59','2023-05-29 17:07:59'),(1275,'default','added',15776,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":655.6}}',NULL,'2023-05-29 17:15:26','2023-05-29 17:15:26'),(1276,'default','added',15777,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-05-29 17:17:37','2023-05-29 17:17:37'),(1277,'default','edited',15775,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5068.8000\"}}',NULL,'2023-05-29 17:23:55','2023-05-29 17:23:55'),(1278,'default','added',15778,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2099.44}}',NULL,'2023-05-29 17:47:47','2023-05-29 17:47:47'),(1279,'default','added',15779,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370.6}}',NULL,'2023-05-29 17:56:02','2023-05-29 17:56:02'),(1280,'default','added',15780,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-29 17:57:50','2023-05-29 17:57:50'),(1281,'default','added',15781,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":124.28}}',NULL,'2023-05-29 18:02:57','2023-05-29 18:02:57'),(1282,'default','added',15782,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-05-29 18:04:47','2023-05-29 18:04:47'),(1283,'default','added',15783,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-29 18:22:28','2023-05-29 18:22:28'),(1284,'default','added',15784,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31936.66}}',NULL,'2023-05-29 18:24:26','2023-05-29 18:24:26'),(1285,'default','added',15785,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":172.25}}',NULL,'2023-05-29 18:26:37','2023-05-29 18:26:37'),(1286,'default','added',15786,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2942.5}}',NULL,'2023-05-29 18:45:53','2023-05-29 18:45:53'),(1287,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-29 18:46:53','2023-05-29 18:46:53'),(1288,'default','edited',15786,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3142.5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2942.5000\"}}',NULL,'2023-05-29 18:49:43','2023-05-29 18:49:43'),(1289,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-29 19:16:33','2023-05-29 19:16:33'),(1290,'default','added',15787,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-29 19:21:33','2023-05-29 19:21:33'),(1291,'default','added',15788,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490.42}}',NULL,'2023-05-29 19:26:38','2023-05-29 19:26:38'),(1292,'default','added',15789,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-29 20:26:23','2023-05-29 20:26:23'),(1293,'default','added',15790,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55.82}}',NULL,'2023-05-29 20:40:14','2023-05-29 20:40:14'),(1294,'default','login',17,'App\\User',NULL,6,17,'App\\User','[]',NULL,'2023-05-29 20:12:59','2023-05-29 20:12:59'),(1295,'default','edited',15784,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13022.3},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"31936.6600\"}}',NULL,'2023-05-29 20:43:09','2023-05-29 20:43:09'),(1296,'default','added',15791,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1174}}',NULL,'2023-05-29 20:51:17','2023-05-29 20:51:17'),(1297,'default','added',15792,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-29 20:54:34','2023-05-29 20:54:34'),(1298,'default','added',15793,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":101.2}}',NULL,'2023-05-29 20:57:51','2023-05-29 20:57:51'),(1299,'default','login',17,'App\\User',NULL,6,17,'App\\User','[]',NULL,'2023-05-29 20:35:04','2023-05-29 20:35:05'),(1300,'default','added',15794,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130.55}}',NULL,'2023-05-29 21:10:56','2023-05-29 21:10:56'),(1301,'default','added',15795,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":647.4}}',NULL,'2023-05-29 21:12:14','2023-05-29 21:12:14'),(1302,'default','added',15796,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-29 21:31:09','2023-05-29 21:31:09'),(1303,'default','added',15797,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-29 21:33:11','2023-05-29 21:33:11'),(1304,'default','added',15799,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-29 21:52:25','2023-05-29 21:52:25'),(1305,'default','added',15800,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-05-29 21:53:11','2023-05-29 21:53:11'),(1306,'default','added',15801,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240.39}}',NULL,'2023-05-29 21:59:46','2023-05-29 21:59:46'),(1307,'default','login',17,'App\\User',NULL,6,17,'App\\User','[]',NULL,'2023-05-29 21:44:21','2023-05-29 21:44:21'),(1308,'default','added',15802,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19.72}}',NULL,'2023-05-29 22:22:17','2023-05-29 22:22:17'),(1309,'default','added',15803,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-29 22:40:02','2023-05-29 22:40:02'),(1310,'default','added',15804,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-29 22:43:37','2023-05-29 22:43:37'),(1311,'default','added',15805,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60.08}}',NULL,'2023-05-29 22:47:09','2023-05-29 22:47:09'),(1312,'default','added',15806,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-05-29 22:49:02','2023-05-29 22:49:02'),(1313,'default','added',15807,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.36}}',NULL,'2023-05-29 23:00:27','2023-05-29 23:00:27'),(1314,'default','added',15808,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-29 23:03:32','2023-05-29 23:03:32'),(1315,'default','added',15810,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-05-29 23:15:09','2023-05-29 23:15:09'),(1316,'default','added',15811,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-05-29 23:23:11','2023-05-29 23:23:11'),(1317,'default','added',15812,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-05-29 23:24:10','2023-05-29 23:24:10'),(1318,'default','added',15813,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-05-29 23:25:22','2023-05-29 23:25:22'),(1319,'default','added',15814,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2023-05-29 23:26:06','2023-05-29 23:26:06'),(1320,'default','added',15815,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-29 23:27:20','2023-05-29 23:27:20'),(1321,'default','added',15816,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-29 23:32:11','2023-05-29 23:32:11'),(1322,'default','added',15817,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1528.68}}',NULL,'2023-05-29 23:32:34','2023-05-29 23:32:34'),(1323,'default','added',15818,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155}}',NULL,'2023-05-29 23:50:45','2023-05-29 23:50:45'),(1324,'default','added',15819,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 00:03:04','2023-05-30 00:03:04'),(1325,'default','added',15821,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129.23}}',NULL,'2023-05-30 00:07:52','2023-05-30 00:07:52'),(1326,'default','added',15822,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-30 00:12:22','2023-05-30 00:12:22'),(1327,'default','added',15823,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 00:14:57','2023-05-30 00:14:57'),(1328,'default','edited',15822,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20.0000\"}}',NULL,'2023-05-30 00:23:39','2023-05-30 00:23:39'),(1329,'default','added',15825,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2713.4}}',NULL,'2023-05-30 00:33:09','2023-05-30 00:33:09'),(1330,'default','added',15826,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":206.9}}',NULL,'2023-05-30 00:43:08','2023-05-30 00:43:08'),(1331,'default','added',15827,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1152.33}}',NULL,'2023-05-30 00:51:31','2023-05-30 00:51:31'),(1332,'default','added',15828,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-05-30 00:54:24','2023-05-30 00:54:24'),(1333,'default','added',15829,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":66.92}}',NULL,'2023-05-30 01:03:07','2023-05-30 01:03:07'),(1334,'default','added',15830,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":312.5}}',NULL,'2023-05-30 01:07:58','2023-05-30 01:07:58'),(1335,'default','added',15831,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1376.1}}',NULL,'2023-05-30 01:09:00','2023-05-30 01:09:00'),(1336,'default','added',15832,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 01:10:10','2023-05-30 01:10:10'),(1337,'default','added',15834,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64.4}}',NULL,'2023-05-30 01:17:57','2023-05-30 01:17:57'),(1338,'default','added',15835,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":560.11}}',NULL,'2023-05-30 01:21:05','2023-05-30 01:21:05'),(1339,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-30 01:25:35','2023-05-30 01:25:35'),(1340,'default','added',15836,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16.5}}',NULL,'2023-05-30 01:28:49','2023-05-30 01:28:49'),(1341,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 00:58:49','2023-05-30 00:58:49'),(1342,'default','added',15837,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-05-30 01:32:33','2023-05-30 01:32:33'),(1343,'default','added',15838,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2540.79}}',NULL,'2023-05-30 01:44:27','2023-05-30 01:44:27'),(1344,'default','added',15839,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980.57}}',NULL,'2023-05-30 01:46:27','2023-05-30 01:46:27'),(1345,'default','added',15840,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":203.4}}',NULL,'2023-05-30 01:48:18','2023-05-30 01:48:18'),(1346,'default','added',15841,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":394.25}}',NULL,'2023-05-30 01:58:43','2023-05-30 01:58:43'),(1347,'default','added',15842,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":343.75}}',NULL,'2023-05-30 02:06:37','2023-05-30 02:06:37'),(1348,'default','added',15843,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-05-30 02:09:31','2023-05-30 02:09:31'),(1349,'default','added',15844,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-05-30 02:12:47','2023-05-30 02:12:47'),(1350,'default','added',15845,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 02:36:03','2023-05-30 02:36:03'),(1351,'default','added',15847,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":975}}',NULL,'2023-05-30 03:16:59','2023-05-30 03:16:59'),(1352,'default','added',15848,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2263.73}}',NULL,'2023-05-30 03:21:17','2023-05-30 03:21:17'),(1353,'default','added',15849,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71}}',NULL,'2023-05-30 03:22:26','2023-05-30 03:22:26'),(1354,'default','added',15850,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3652.11}}',NULL,'2023-05-30 03:24:05','2023-05-30 03:24:05'),(1355,'default','added',15851,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2725.04}}',NULL,'2023-05-30 03:49:21','2023-05-30 03:49:21'),(1356,'default','added',15852,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720.9}}',NULL,'2023-05-30 03:51:05','2023-05-30 03:51:05'),(1357,'default','added',15853,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-30 03:55:27','2023-05-30 03:55:27'),(1358,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-30 04:08:03','2023-05-30 04:08:03'),(1359,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-30 04:08:19','2023-05-30 04:08:19'),(1360,'default','added',15854,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":751.26}}',NULL,'2023-05-30 04:35:59','2023-05-30 04:35:59'),(1361,'default','added',15855,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2999.94}}',NULL,'2023-05-30 04:46:23','2023-05-30 04:46:23'),(1362,'default','added',15856,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1020}}',NULL,'2023-05-30 04:51:46','2023-05-30 04:51:46'),(1363,'default','added',15857,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1792.05}}',NULL,'2023-05-30 05:15:04','2023-05-30 05:15:04'),(1364,'default','added',15858,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-05-30 05:24:37','2023-05-30 05:24:37'),(1365,'default','added',15859,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}',NULL,'2023-05-30 05:32:30','2023-05-30 05:32:30'),(1366,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 06:50:58','2023-05-30 06:50:58'),(1367,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-30 14:06:57','2023-05-30 14:06:57'),(1368,'default','added',15860,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237.5}}',NULL,'2023-05-30 14:10:28','2023-05-30 14:10:28'),(1369,'default','added',15861,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-05-30 14:18:44','2023-05-30 14:18:44'),(1370,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-30 15:17:18','2023-05-30 15:17:18'),(1371,'default','added',15862,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33.74}}',NULL,'2023-05-30 15:19:17','2023-05-30 15:19:17'),(1372,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-30 15:34:54','2023-05-30 15:34:54'),(1373,'default','added',15863,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":873.9}}',NULL,'2023-05-30 15:57:38','2023-05-30 15:57:38'),(1374,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-30 16:19:36','2023-05-30 16:19:36'),(1375,'default','added',15864,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-05-30 16:45:36','2023-05-30 16:45:36'),(1376,'default','added',15865,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":377.95}}',NULL,'2023-05-30 16:47:50','2023-05-30 16:47:50'),(1377,'default','added',15866,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-30 16:51:55','2023-05-30 16:51:55'),(1378,'default','added',15867,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-30 16:53:19','2023-05-30 16:53:19'),(1379,'default','added',15868,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":779}}',NULL,'2023-05-30 16:59:44','2023-05-30 16:59:44'),(1380,'default','added',15869,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-05-30 17:02:00','2023-05-30 17:02:00'),(1381,'default','added',15870,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-30 17:31:14','2023-05-30 17:31:14'),(1382,'default','added',15871,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-05-30 17:39:55','2023-05-30 17:39:56'),(1383,'default','added',15872,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":172.05}}',NULL,'2023-05-30 17:51:39','2023-05-30 17:51:39'),(1384,'default','added',15873,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 18:14:47','2023-05-30 18:14:47'),(1385,'default','added',15875,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-05-30 18:18:52','2023-05-30 18:18:52'),(1386,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-30 18:35:50','2023-05-30 18:35:50'),(1387,'default','added',15876,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-05-30 18:39:51','2023-05-30 18:39:51'),(1388,'default','added',15877,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-05-30 19:38:06','2023-05-30 19:38:06'),(1389,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-30 20:10:59','2023-05-30 20:10:59'),(1390,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-30 20:11:19','2023-05-30 20:11:19'),(1391,'default','added',15878,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":840}}',NULL,'2023-05-30 20:14:58','2023-05-30 20:14:58'),(1392,'default','added',15879,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-05-30 20:45:24','2023-05-30 20:45:24'),(1393,'default','added',15880,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-30 21:02:36','2023-05-30 21:02:36'),(1394,'default','added',15881,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335.4}}',NULL,'2023-05-30 21:07:48','2023-05-30 21:07:48'),(1395,'default','added',15882,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-30 21:23:11','2023-05-30 21:23:11'),(1396,'default','added',15883,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-30 21:24:07','2023-05-30 21:24:07'),(1397,'default','added',15884,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-05-30 21:26:28','2023-05-30 21:26:28'),(1398,'default','added',15885,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2023-05-30 21:30:56','2023-05-30 21:30:56'),(1399,'default','added',15886,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 21:47:26','2023-05-30 21:47:26'),(1400,'default','added',15888,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":291}}',NULL,'2023-05-30 21:49:19','2023-05-30 21:49:19'),(1401,'default','added',15889,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":902.5}}',NULL,'2023-05-30 22:18:26','2023-05-30 22:18:26'),(1402,'default','added',15890,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195.1}}',NULL,'2023-05-30 22:20:03','2023-05-30 22:20:03'),(1403,'default','added',15891,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-30 22:40:36','2023-05-30 22:40:36'),(1404,'default','logout',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-30 22:44:44','2023-05-30 22:44:44'),(1405,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-30 22:45:11','2023-05-30 22:45:11'),(1406,'default','added',15893,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-05-30 22:19:18','2023-05-30 22:19:18'),(1407,'default','added',15894,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2160}}',NULL,'2023-05-30 22:20:40','2023-05-30 22:20:40'),(1408,'default','payment_edited',5809,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:21:45','2023-05-30 22:21:45'),(1409,'default','payment_edited',5835,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:22:15','2023-05-30 22:22:15'),(1410,'default','payment_edited',5814,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:22:52','2023-05-30 22:22:52'),(1411,'default','payment_edited',5823,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:23:30','2023-05-30 22:23:30'),(1412,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:26:06','2023-05-30 22:26:07'),(1413,'default','added',15895,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":387.24}}',NULL,'2023-05-30 22:57:08','2023-05-30 22:57:08'),(1414,'default','payment_edited',5868,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26400.0000\"}}',NULL,'2023-05-30 22:27:09','2023-05-30 22:27:09'),(1415,'default','payment_edited',5803,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:27:09','2023-05-30 22:27:09'),(1416,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:28:32','2023-05-30 22:28:32'),(1417,'default','payment_edited',5809,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-05-30 22:29:47','2023-05-30 22:29:47'),(1418,'default','added',15896,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":319.82}}',NULL,'2023-05-30 23:14:52','2023-05-30 23:14:52'),(1419,'default','added',15897,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90.55}}',NULL,'2023-05-30 23:23:25','2023-05-30 23:23:25'),(1420,'default','added',15898,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-05-30 23:28:27','2023-05-30 23:28:27'),(1421,'default','added',15899,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":287.38}}',NULL,'2023-05-30 23:32:21','2023-05-30 23:32:22'),(1422,'default','added',15900,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100.55}}',NULL,'2023-05-30 23:33:21','2023-05-30 23:33:21'),(1423,'default','added',15901,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300.6}}',NULL,'2023-05-30 23:35:38','2023-05-30 23:35:38'),(1424,'default','added',15902,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-05-30 23:43:08','2023-05-30 23:43:08'),(1425,'default','added',15903,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-30 23:44:18','2023-05-30 23:44:18'),(1426,'default','added',15904,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":923.34}}',NULL,'2023-05-30 23:57:12','2023-05-30 23:57:12'),(1427,'default','added',15905,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":446.53}}',NULL,'2023-05-31 00:04:51','2023-05-31 00:04:51'),(1428,'default','added',15906,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3921.62}}',NULL,'2023-05-31 00:41:33','2023-05-31 00:41:33'),(1429,'default','added',15907,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-05-31 00:44:19','2023-05-31 00:44:19'),(1430,'default','added',15908,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":174644.16}}',NULL,'2023-05-31 00:51:30','2023-05-31 00:51:30'),(1431,'default','added',15909,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-05-31 00:54:13','2023-05-31 00:54:13'),(1432,'default','added',15910,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":259.58}}',NULL,'2023-05-31 01:10:30','2023-05-31 01:10:30'),(1433,'default','added',15911,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":386.96}}',NULL,'2023-05-31 01:15:09','2023-05-31 01:15:09'),(1434,'default','added',15912,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2593.56}}',NULL,'2023-05-31 01:19:26','2023-05-31 01:19:26'),(1435,'default','added',15913,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-31 01:19:26','2023-05-31 01:19:26'),(1436,'default','added',15914,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-31 01:32:38','2023-05-31 01:32:38'),(1437,'default','added',15915,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-31 01:52:58','2023-05-31 01:52:58'),(1438,'default','added',15916,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18733.09}}',NULL,'2023-05-31 02:05:07','2023-05-31 02:05:07'),(1439,'default','added',15917,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-31 02:20:27','2023-05-31 02:20:27'),(1440,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-05-31 02:26:46','2023-05-31 02:26:46'),(1441,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 02:27:31','2023-05-31 02:27:31'),(1442,'default','added',15919,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-05-31 02:31:56','2023-05-31 02:31:56'),(1443,'default','added',15920,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":171}}',NULL,'2023-05-31 02:40:45','2023-05-31 02:40:45'),(1444,'default','added',15921,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":280}}',NULL,'2023-05-31 02:43:31','2023-05-31 02:43:31'),(1445,'default','added',15922,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.2}}',NULL,'2023-05-31 02:45:11','2023-05-31 02:45:11'),(1446,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 02:46:00','2023-05-31 02:46:00'),(1447,'default','added',15923,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2263.73}}',NULL,'2023-05-31 02:50:52','2023-05-31 02:50:52'),(1448,'default','added',15924,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2490.42}}',NULL,'2023-05-31 03:15:35','2023-05-31 03:15:35'),(1449,'default','added',15925,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.6}}',NULL,'2023-05-31 03:21:22','2023-05-31 03:21:22'),(1450,'default','added',15926,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1002.1}}',NULL,'2023-05-31 03:29:40','2023-05-31 03:29:40'),(1451,'default','added',15927,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":760}}',NULL,'2023-05-31 03:45:41','2023-05-31 03:45:41'),(1452,'default','added',15928,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7321.17}}',NULL,'2023-05-31 03:49:47','2023-05-31 03:49:47'),(1453,'default','added',15929,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":485.8}}',NULL,'2023-05-31 03:54:20','2023-05-31 03:54:20'),(1454,'default','added',15930,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9.7}}',NULL,'2023-05-31 04:14:34','2023-05-31 04:14:34'),(1455,'default','added',15931,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-05-31 05:05:45','2023-05-31 05:05:45'),(1456,'default','added',15932,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.88}}',NULL,'2023-05-31 05:10:18','2023-05-31 05:10:18'),(1457,'default','added',15933,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275.51}}',NULL,'2023-05-31 05:20:56','2023-05-31 05:20:56'),(1458,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-05-31 14:03:58','2023-05-31 14:03:58'),(1459,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-31 14:04:32','2023-05-31 14:04:32'),(1460,'default','added',15934,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-31 14:34:50','2023-05-31 14:34:50'),(1461,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-31 14:38:30','2023-05-31 14:38:30'),(1462,'default','added',15935,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":895.8}}',NULL,'2023-05-31 15:36:11','2023-05-31 15:36:11'),(1463,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-05-31 16:17:08','2023-05-31 16:17:08'),(1464,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 16:41:34','2023-05-31 16:41:34'),(1465,'default','added',140,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 16:43:15','2023-05-31 16:43:15'),(1466,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 17:12:54','2023-05-31 17:12:54'),(1467,'default','added',15936,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":15817}}',NULL,'2023-05-31 17:36:39','2023-05-31 17:36:39'),(1468,'default','added',15937,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-05-31 18:40:57','2023-05-31 18:40:57'),(1469,'default','added',15938,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-05-31 18:42:10','2023-05-31 18:42:10'),(1470,'default','added',15939,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-05-31 18:42:55','2023-05-31 18:42:55'),(1471,'default','added',15940,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":310}}',NULL,'2023-05-31 18:49:58','2023-05-31 18:49:58'),(1472,'default','added',15941,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-05-31 19:37:08','2023-05-31 19:37:08'),(1473,'default','added',15942,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-31 19:40:11','2023-05-31 19:40:11'),(1474,'default','added',15943,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59.7}}',NULL,'2023-05-31 19:49:38','2023-05-31 19:49:38'),(1475,'default','added',15944,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-31 20:01:14','2023-05-31 20:01:14'),(1476,'default','added',15945,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":461.5}}',NULL,'2023-05-31 20:09:37','2023-05-31 20:09:37'),(1477,'default','edited',15945,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"461.5000\"}}',NULL,'2023-05-31 20:10:32','2023-05-31 20:10:32'),(1478,'default','added',15946,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}',NULL,'2023-05-31 20:38:15','2023-05-31 20:38:15'),(1479,'default','added',15947,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-31 20:41:50','2023-05-31 20:41:50'),(1480,'default','added',15948,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-05-31 20:46:36','2023-05-31 20:46:36'),(1481,'default','added',15949,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245.16}}',NULL,'2023-05-31 20:50:54','2023-05-31 20:50:54'),(1482,'default','added',15950,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2371.56}}',NULL,'2023-05-31 20:57:59','2023-05-31 20:57:59'),(1483,'default','added',15951,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-05-31 20:59:07','2023-05-31 20:59:07'),(1484,'default','added',15952,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-05-31 21:03:06','2023-05-31 21:03:06'),(1485,'default','added',15953,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-05-31 21:13:16','2023-05-31 21:13:16'),(1486,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-05-31 21:14:04','2023-05-31 21:14:04'),(1487,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 21:14:46','2023-05-31 21:14:46'),(1488,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 21:14:46','2023-05-31 21:14:46'),(1489,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-05-31 21:15:12','2023-05-31 21:15:12'),(1490,'default','added',15954,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-05-31 21:35:12','2023-05-31 21:35:12'),(1491,'default','added',15955,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-05-31 21:37:18','2023-05-31 21:37:18'),(1492,'default','added',15956,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":914.8}}',NULL,'2023-05-31 21:45:08','2023-05-31 21:45:08'),(1493,'default','edited',15928,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13165.19},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7321.1700\"}}',NULL,'2023-05-31 21:48:44','2023-05-31 21:48:44'),(1494,'default','added',15957,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110.2}}',NULL,'2023-05-31 22:10:00','2023-05-31 22:10:00'),(1495,'default','added',15958,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-05-31 22:33:34','2023-05-31 22:33:34'),(1496,'default','added',15959,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":230}}',NULL,'2023-05-31 22:37:33','2023-05-31 22:37:33'),(1497,'default','edited',15928,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31695.96},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"13165.1900\"}}',NULL,'2023-05-31 22:43:22','2023-05-31 22:43:22'),(1498,'default','added',15960,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-05-31 22:50:36','2023-05-31 22:50:36'),(1499,'default','added',15961,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2112.09}}',NULL,'2023-05-31 23:05:57','2023-05-31 23:05:57'),(1500,'default','added',15962,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1945.72}}',NULL,'2023-05-31 23:38:37','2023-05-31 23:38:37'),(1501,'default','added',15963,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":16048.45}}',NULL,'2023-05-31 23:54:13','2023-05-31 23:54:13'),(1502,'default','added',15964,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-05-31 23:58:18','2023-05-31 23:58:18'),(1503,'default','added',15966,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.07}}',NULL,'2023-06-01 00:06:48','2023-06-01 00:06:48'),(1504,'default','added',15967,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-01 00:15:05','2023-06-01 00:15:05'),(1505,'default','added',15968,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":216.6}}',NULL,'2023-06-01 00:17:47','2023-06-01 00:17:47'),(1506,'default','added',15969,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":54590.04}}',NULL,'2023-06-01 00:18:12','2023-06-01 00:18:12'),(1507,'default','added',15970,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-01 00:19:08','2023-06-01 00:19:08'),(1508,'default','added',15971,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":736.25}}',NULL,'2023-06-01 00:20:54','2023-06-01 00:20:54'),(1509,'default','added',15972,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":653.68}}',NULL,'2023-06-01 00:22:31','2023-06-01 00:22:31'),(1510,'default','edited',15936,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":15961},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"15817.0000\"}}',NULL,'2023-06-01 00:24:05','2023-06-01 00:24:05'),(1511,'default','added',15973,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340.2}}',NULL,'2023-06-01 00:29:10','2023-06-01 00:29:10'),(1512,'default','added',15974,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.1}}',NULL,'2023-06-01 00:42:53','2023-06-01 00:42:53'),(1513,'default','edited',15146,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-01 00:46:06','2023-06-01 00:46:06'),(1514,'default','edited',15196,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"17797.8100\"}}',NULL,'2023-06-01 00:57:30','2023-06-01 00:57:30'),(1515,'default','edited',15199,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4151.74},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"4151.7400\"}}',NULL,'2023-06-01 00:59:22','2023-06-01 00:59:22'),(1516,'default','edited',15196,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-01 01:04:20','2023-06-01 01:04:20'),(1517,'default','edited',15146,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-01 01:06:31','2023-06-01 01:06:31'),(1518,'default','edited',15196,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-01 01:10:57','2023-06-01 01:10:57'),(1519,'default','added',15975,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-01 01:35:16','2023-06-01 01:35:16'),(1520,'default','added',15976,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-01 01:40:07','2023-06-01 01:40:07'),(1521,'default','added',15977,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10.75}}',NULL,'2023-06-01 01:46:49','2023-06-01 01:46:49'),(1522,'default','added',15978,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45.05}}',NULL,'2023-06-01 01:50:36','2023-06-01 01:50:36'),(1523,'default','edited',15963,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":16003.09},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"16048.4500\"}}',NULL,'2023-06-01 01:54:49','2023-06-01 01:54:49'),(1524,'default','added',15979,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-01 02:02:00','2023-06-01 02:02:00'),(1525,'default','edited',15227,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13679.97},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"14786.9400\"}}',NULL,'2023-06-01 02:04:08','2023-06-01 02:04:08'),(1526,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-01 02:07:47','2023-06-01 02:07:47'),(1527,'default','added',15980,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.39}}',NULL,'2023-06-01 02:12:11','2023-06-01 02:12:12'),(1528,'default','added',15981,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":219.45}}',NULL,'2023-06-01 02:21:06','2023-06-01 02:21:06'),(1529,'default','added',15982,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-01 02:25:08','2023-06-01 02:25:08'),(1530,'default','added',15983,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-01 02:26:25','2023-06-01 02:26:25'),(1531,'default','added',15984,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":901}}',NULL,'2023-06-01 02:33:41','2023-06-01 02:33:41'),(1532,'default','added',15985,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-06-01 02:39:56','2023-06-01 02:39:56'),(1533,'default','added',15986,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-01 02:57:19','2023-06-01 02:57:19'),(1534,'default','added',15987,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1841.06}}',NULL,'2023-06-01 02:58:50','2023-06-01 02:58:50'),(1535,'default','added',15988,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":674.5}}',NULL,'2023-06-01 03:00:29','2023-06-01 03:00:29'),(1536,'default','added',15989,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-01 03:04:37','2023-06-01 03:04:37'),(1537,'default','added',15990,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":269.78}}',NULL,'2023-06-01 03:24:09','2023-06-01 03:24:09'),(1538,'default','added',15991,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720}}',NULL,'2023-06-01 03:37:16','2023-06-01 03:37:16'),(1539,'default','added',15992,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":372.72}}',NULL,'2023-06-01 04:07:52','2023-06-01 04:07:52'),(1540,'default','added',15993,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":145.12}}',NULL,'2023-06-01 04:11:13','2023-06-01 04:11:13'),(1541,'default','added',15994,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-01 04:27:26','2023-06-01 04:27:26'),(1542,'default','added',15995,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-01 04:28:25','2023-06-01 04:28:25'),(1543,'default','added',15996,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-01 04:34:54','2023-06-01 04:34:54'),(1544,'default','added',15997,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-01 04:38:37','2023-06-01 04:38:37'),(1545,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-01 04:40:31','2023-06-01 04:40:31'),(1546,'default','added',15998,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-01 05:11:15','2023-06-01 05:11:15'),(1547,'default','added',15999,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":305.9}}',NULL,'2023-06-01 05:17:48','2023-06-01 05:17:48'),(1548,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-01 14:49:55','2023-06-01 14:49:55'),(1549,'default','added',16000,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187.04}}',NULL,'2023-06-01 15:00:05','2023-06-01 15:00:05'),(1550,'default','payment_edited',5808,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:31:49','2023-06-01 14:31:49'),(1551,'default','payment_edited',5867,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26400.0000\"}}',NULL,'2023-06-01 14:33:05','2023-06-01 14:33:05'),(1552,'default','payment_edited',5816,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:33:05','2023-06-01 14:33:05'),(1553,'default','added',16001,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":633}}',NULL,'2023-06-01 15:04:31','2023-06-01 15:04:31'),(1554,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:35:30','2023-06-01 14:35:30'),(1555,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:37:23','2023-06-01 14:37:23'),(1556,'default','payment_edited',5843,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:38:26','2023-06-01 14:38:26'),(1557,'default','payment_edited',5830,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:39:39','2023-06-01 14:39:39'),(1558,'default','payment_edited',5866,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6960.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6960.0000\"}}',NULL,'2023-06-01 14:42:38','2023-06-01 14:42:38'),(1559,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:43:23','2023-06-01 14:43:23'),(1560,'default','payment_edited',5804,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:47:09','2023-06-01 14:47:09'),(1561,'default','payment_edited',5753,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:49:37','2023-06-01 14:49:37'),(1562,'default','payment_edited',5869,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14060.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14060.0000\"}}',NULL,'2023-06-01 14:52:54','2023-06-01 14:52:54'),(1563,'default','payment_edited',5807,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:52:54','2023-06-01 14:52:54'),(1564,'default','payment_edited',5840,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:53:50','2023-06-01 14:53:50'),(1565,'default','added',16002,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8592}}',NULL,'2023-06-01 14:55:01','2023-06-01 14:55:01'),(1566,'default','payment_edited',5805,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 14:58:33','2023-06-01 14:58:33'),(1567,'default','added',16003,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3769.6}}',NULL,'2023-06-01 15:33:28','2023-06-01 15:33:28'),(1568,'default','payment_edited',5821,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 15:13:58','2023-06-01 15:13:58'),(1569,'default','payment_edited',5838,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 15:14:46','2023-06-01 15:14:46'),(1570,'default','added',16004,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11412}}',NULL,'2023-06-01 15:26:40','2023-06-01 15:26:40'),(1571,'default','added',16005,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":54.8}}',NULL,'2023-06-01 16:03:58','2023-06-01 16:03:58'),(1572,'default','added',16006,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-01 16:11:33','2023-06-01 16:11:33'),(1573,'default','added',16007,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1950}}',NULL,'2023-06-01 15:44:40','2023-06-01 15:44:40'),(1574,'default','added',16008,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-01 16:14:59','2023-06-01 16:14:59'),(1575,'default','added',16009,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-06-01 15:48:45','2023-06-01 15:48:45'),(1576,'default','added',16010,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-06-01 15:49:28','2023-06-01 15:49:28'),(1577,'default','added',16011,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-06-01 15:50:59','2023-06-01 15:50:59'),(1578,'default','added',16012,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-06-01 15:51:54','2023-06-01 15:51:54'),(1579,'default','added',16013,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-01 17:32:28','2023-06-01 17:32:28'),(1580,'default','added',16014,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-01 17:33:11','2023-06-01 17:33:11'),(1581,'default','added',16015,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-06-01 17:34:51','2023-06-01 17:34:51'),(1582,'default','added',16016,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":287.1}}',NULL,'2023-06-01 17:36:09','2023-06-01 17:36:09'),(1583,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-01 18:32:18','2023-06-01 18:32:18'),(1584,'default','added',16017,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1285.71}}',NULL,'2023-06-01 19:19:35','2023-06-01 19:19:35'),(1585,'default','added',16018,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":199.5}}',NULL,'2023-06-01 19:23:13','2023-06-01 19:23:13'),(1586,'default','added',16019,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":661.5}}',NULL,'2023-06-01 19:40:32','2023-06-01 19:40:32'),(1587,'default','added',16020,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5803.62}}',NULL,'2023-06-01 19:58:03','2023-06-01 19:58:03'),(1588,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-01 21:24:08','2023-06-01 21:24:08'),(1589,'default','added',16021,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1670.56}}',NULL,'2023-06-01 21:24:27','2023-06-01 21:24:27'),(1590,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-01 21:24:56','2023-06-01 21:24:57'),(1591,'default','added',16022,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":1447.5}}',NULL,'2023-06-01 21:27:32','2023-06-01 21:27:32'),(1592,'default','added',16023,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1447.5}}',NULL,'2023-06-01 21:27:32','2023-06-01 21:27:32'),(1593,'default','added',16024,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2023-06-01 21:38:12','2023-06-01 21:38:12'),(1594,'default','added',16025,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":482.68}}',NULL,'2023-06-01 21:58:37','2023-06-01 21:58:37'),(1595,'default','added',16026,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570}}',NULL,'2023-06-01 22:01:10','2023-06-01 22:01:10'),(1596,'default','added',16027,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-01 22:16:55','2023-06-01 22:16:55'),(1597,'default','added',16028,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":819.58}}',NULL,'2023-06-01 22:18:17','2023-06-01 22:18:17'),(1598,'default','added',16029,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4707.5}}',NULL,'2023-06-01 22:30:52','2023-06-01 22:30:52'),(1599,'default','added',16030,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2008.7}}',NULL,'2023-06-01 22:35:07','2023-06-01 22:35:07'),(1600,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 22:06:48','2023-06-01 22:06:48'),(1601,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 22:07:52','2023-06-01 22:07:52'),(1602,'default','added',16031,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1479.46}}',NULL,'2023-06-01 23:25:26','2023-06-01 23:25:26'),(1603,'default','added',16032,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":339}}',NULL,'2023-06-01 23:25:52','2023-06-01 23:25:52'),(1604,'default','added',16033,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-01 23:26:44','2023-06-01 23:26:44'),(1605,'default','added',16034,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":505.4}}',NULL,'2023-06-01 23:27:43','2023-06-01 23:27:43'),(1606,'default','added',16035,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4889.48}}',NULL,'2023-06-01 23:36:32','2023-06-01 23:36:32'),(1607,'default','added',16036,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":142.5}}',NULL,'2023-06-02 00:00:16','2023-06-02 00:00:17'),(1608,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 23:34:48','2023-06-01 23:34:48'),(1609,'default','added',16037,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-02 00:08:19','2023-06-02 00:08:19'),(1610,'default','payment_edited',5810,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 23:38:26','2023-06-01 23:38:26'),(1611,'default','added',16038,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":332.5}}',NULL,'2023-06-02 00:08:54','2023-06-02 00:08:54'),(1612,'default','payment_edited',5832,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 23:39:29','2023-06-01 23:39:29'),(1613,'default','payment_edited',5797,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 23:39:53','2023-06-01 23:39:53'),(1614,'default','payment_edited',5838,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-01 23:41:02','2023-06-01 23:41:02'),(1615,'default','added',16039,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":922.58}}',NULL,'2023-06-02 00:29:51','2023-06-02 00:29:51'),(1616,'default','added',16040,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70.47}}',NULL,'2023-06-02 00:38:01','2023-06-02 00:38:01'),(1617,'default','added',16041,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":128.2}}',NULL,'2023-06-02 00:50:18','2023-06-02 00:50:18'),(1618,'default','added',16042,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":872.55}}',NULL,'2023-06-02 00:52:53','2023-06-02 00:52:53'),(1619,'default','added',16043,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.21}}',NULL,'2023-06-02 00:53:04','2023-06-02 00:53:04'),(1620,'default','added',16044,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1078.42}}',NULL,'2023-06-02 00:59:04','2023-06-02 00:59:04'),(1621,'default','added',16045,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":93.32}}',NULL,'2023-06-02 01:01:50','2023-06-02 01:01:50'),(1622,'default','added',16046,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47.82}}',NULL,'2023-06-02 01:33:21','2023-06-02 01:33:21'),(1623,'default','added',16047,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":333.6}}',NULL,'2023-06-02 01:45:27','2023-06-02 01:45:27'),(1624,'default','added',16048,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":331.5}}',NULL,'2023-06-02 02:04:12','2023-06-02 02:04:12'),(1625,'default','added',16049,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-02 02:13:20','2023-06-02 02:13:20'),(1626,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-02 02:19:23','2023-06-02 02:19:23'),(1627,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-02 02:22:27','2023-06-02 02:22:27'),(1628,'default','added',16050,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":498.75}}',NULL,'2023-06-02 02:29:04','2023-06-02 02:29:04'),(1629,'default','added',16051,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-02 02:40:57','2023-06-02 02:40:57'),(1630,'default','added',16052,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.99}}',NULL,'2023-06-02 02:54:23','2023-06-02 02:54:23'),(1631,'default','added',16053,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-02 03:02:27','2023-06-02 03:02:27'),(1632,'default','added',16054,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-02 03:18:17','2023-06-02 03:18:17'),(1633,'default','added',16055,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68.7}}',NULL,'2023-06-02 03:25:25','2023-06-02 03:25:25'),(1634,'default','added',16056,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-02 03:38:04','2023-06-02 03:38:04'),(1635,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-02 03:38:38','2023-06-02 03:38:38'),(1636,'default','added',16057,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-02 03:43:46','2023-06-02 03:43:46'),(1637,'default','added',16058,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-02 03:53:03','2023-06-02 03:53:03'),(1638,'default','added',16059,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-02 04:00:46','2023-06-02 04:00:46'),(1639,'default','added',16060,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":248.23}}',NULL,'2023-06-02 04:16:39','2023-06-02 04:16:39'),(1640,'default','added',16061,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":327.78}}',NULL,'2023-06-02 04:18:06','2023-06-02 04:18:06'),(1641,'default','added',16062,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-02 04:39:32','2023-06-02 04:39:32'),(1642,'default','added',16063,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":794.35}}',NULL,'2023-06-02 05:16:01','2023-06-02 05:16:01'),(1643,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 05:01:27','2023-06-02 05:01:27'),(1644,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 05:03:26','2023-06-02 05:03:26'),(1645,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 13:55:24','2023-06-02 13:55:24'),(1646,'default','payment_edited',5831,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 14:03:31','2023-06-02 14:03:31'),(1647,'default','added',16064,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3126}}',NULL,'2023-06-02 14:10:38','2023-06-02 14:10:38'),(1648,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-02 15:00:00','2023-06-02 15:00:00'),(1649,'default','added',16065,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99}}',NULL,'2023-06-02 15:00:58','2023-06-02 15:00:58'),(1650,'default','added',16066,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-02 15:25:27','2023-06-02 15:25:27'),(1651,'default','added',16067,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-06-02 15:02:22','2023-06-02 15:02:22'),(1652,'default','added',16068,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2208}}',NULL,'2023-06-02 15:03:41','2023-06-02 15:03:41'),(1653,'default','added',16069,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-02 15:35:35','2023-06-02 15:35:35'),(1654,'default','added',16070,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-02 15:36:41','2023-06-02 15:36:41'),(1655,'default','added',16071,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":757.12}}',NULL,'2023-06-02 16:02:17','2023-06-02 16:02:17'),(1656,'default','added',16072,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-02 16:08:27','2023-06-02 16:08:27'),(1657,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-02 16:28:18','2023-06-02 16:28:18'),(1658,'default','added',16073,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-02 16:50:18','2023-06-02 16:50:18'),(1659,'default','added',16074,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350.63}}',NULL,'2023-06-02 16:52:23','2023-06-02 16:52:23'),(1660,'default','added',16075,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-02 17:56:05','2023-06-02 17:56:05'),(1661,'default','added',16076,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-02 17:56:51','2023-06-02 17:56:51'),(1662,'default','added',16077,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-02 18:06:41','2023-06-02 18:06:41'),(1663,'default','payment_edited',5828,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:38:32','2023-06-02 17:38:32'),(1664,'default','payment_edited',5828,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:39:06','2023-06-02 17:39:06'),(1665,'default','payment_edited',5814,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:41:10','2023-06-02 17:41:10'),(1666,'default','payment_edited',5814,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:41:49','2023-06-02 17:41:49'),(1667,'default','added',16078,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335}}',NULL,'2023-06-02 18:13:00','2023-06-02 18:13:00'),(1668,'default','payment_edited',5801,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:46:13','2023-06-02 17:46:13'),(1669,'default','edited',97,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:51:29','2023-06-02 17:51:29'),(1670,'default','edited',97,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:53:20','2023-06-02 17:53:20'),(1671,'default','added',16079,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-02 18:25:17','2023-06-02 18:25:17'),(1672,'default','edited',91,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:55:41','2023-06-02 17:55:41'),(1673,'default','payment_edited',5817,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:56:35','2023-06-02 17:56:35'),(1674,'default','added',16080,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":243.75}}',NULL,'2023-06-02 18:27:41','2023-06-02 18:27:41'),(1675,'default','payment_edited',5819,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:58:32','2023-06-02 17:58:32'),(1676,'default','payment_edited',5819,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:59:08','2023-06-02 17:59:08'),(1677,'default','payment_edited',15422,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15096.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15096.0000\"}}',NULL,'2023-06-02 17:59:08','2023-06-02 17:59:08'),(1678,'default','payment_edited',16010,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-06-02 17:59:08','2023-06-02 17:59:08'),(1679,'default','payment_edited',5798,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 17:59:40','2023-06-02 17:59:40'),(1680,'default','edited',96,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:01:32','2023-06-02 18:01:32'),(1681,'default','edited',96,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:01:37','2023-06-02 18:01:37'),(1682,'default','edited',67,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:02:20','2023-06-02 18:02:20'),(1683,'default','payment_edited',5796,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:04:44','2023-06-02 18:04:44'),(1684,'default','payment_edited',5804,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:06:26','2023-06-02 18:06:26'),(1685,'default','payment_edited',5756,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:07:32','2023-06-02 18:07:32'),(1686,'default','payment_edited',5756,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:08:07','2023-06-02 18:08:07'),(1687,'default','added',16081,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-02 18:09:26','2023-06-02 18:09:26'),(1688,'default','payment_edited',5844,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:13:53','2023-06-02 18:13:53'),(1689,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"90150.0000\"}}',NULL,'2023-06-02 18:13:53','2023-06-02 18:13:53'),(1690,'default','payment_edited',5838,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:25:07','2023-06-02 18:25:07'),(1691,'default','edited',114,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:27:55','2023-06-02 18:27:55'),(1692,'default','edited',110,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:34:42','2023-06-02 18:34:42'),(1693,'default','edited',108,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:37:56','2023-06-02 18:37:56'),(1694,'default','edited',91,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:49:13','2023-06-02 18:49:13'),(1695,'default','edited',50,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:49:38','2023-06-02 18:49:38'),(1696,'default','edited',90,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:50:44','2023-06-02 18:50:44'),(1697,'default','edited',77,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:51:23','2023-06-02 18:51:23'),(1698,'default','edited',123,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 18:59:52','2023-06-02 18:59:52'),(1699,'default','edited',81,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:01:00','2023-06-02 19:01:00'),(1700,'default','edited',63,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:01:51','2023-06-02 19:01:51'),(1701,'default','payment_edited',5807,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:06:09','2023-06-02 19:06:09'),(1702,'default','added',16082,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-02 19:42:34','2023-06-02 19:42:34'),(1703,'default','added',16083,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":679.1}}',NULL,'2023-06-02 19:47:56','2023-06-02 19:47:56'),(1704,'default','added',16084,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-06-02 19:48:52','2023-06-02 19:48:52'),(1705,'default','added',16085,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":286.23}}',NULL,'2023-06-02 19:59:33','2023-06-02 19:59:33'),(1706,'default','edited',47,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:39:53','2023-06-02 19:39:53'),(1707,'default','edited',73,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:41:50','2023-06-02 19:41:50'),(1708,'default','edited',94,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:42:47','2023-06-02 19:42:48'),(1709,'default','added',16086,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-02 20:14:56','2023-06-02 20:14:56'),(1710,'default','added',16087,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60.08}}',NULL,'2023-06-02 20:15:23','2023-06-02 20:15:23'),(1711,'default','payment_edited',5803,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:46:11','2023-06-02 19:46:11'),(1712,'default','payment_edited',5797,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:49:56','2023-06-02 19:49:56'),(1713,'default','payment_edited',5866,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6960.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6960.0000\"}}',NULL,'2023-06-02 19:51:26','2023-06-02 19:51:26'),(1714,'default','payment_edited',5833,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 19:51:26','2023-06-02 19:51:26'),(1715,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-02 20:22:56','2023-06-02 20:22:57'),(1716,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-02 20:41:14','2023-06-02 20:41:14'),(1717,'default','added',16088,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-02 21:00:49','2023-06-02 21:00:49'),(1718,'default','added',16089,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5532.11}}',NULL,'2023-06-02 21:03:01','2023-06-02 21:03:01'),(1719,'default','added',16090,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-02 21:09:38','2023-06-02 21:09:38'),(1720,'default','payment_edited',5826,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 20:51:00','2023-06-02 20:51:00'),(1721,'default','added',16091,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":193.33}}',NULL,'2023-06-02 21:23:08','2023-06-02 21:23:08'),(1722,'default','added',16092,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-02 21:24:37','2023-06-02 21:24:37'),(1723,'default','added',16093,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1318.09}}',NULL,'2023-06-02 21:35:09','2023-06-02 21:35:09'),(1724,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-02 21:37:43','2023-06-02 21:37:43'),(1725,'default','added',16094,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":968.95}}',NULL,'2023-06-02 21:57:14','2023-06-02 21:57:14'),(1726,'default','added',16095,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":560}}',NULL,'2023-06-02 21:27:59','2023-06-02 21:27:59'),(1727,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-02 22:00:15','2023-06-02 22:00:15'),(1728,'default','edited',62,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 21:30:55','2023-06-02 21:30:55'),(1729,'default','edited',60,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 21:32:58','2023-06-02 21:32:58'),(1730,'default','payment_edited',5789,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 21:33:39','2023-06-02 21:33:39'),(1731,'default','added',16096,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-02 22:13:40','2023-06-02 22:13:40'),(1732,'default','added',16097,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-02 22:18:27','2023-06-02 22:18:27'),(1733,'default','added',16098,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-02 22:20:06','2023-06-02 22:20:06'),(1734,'default','payment_edited',5784,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 21:51:53','2023-06-02 21:51:53'),(1735,'default','added',16099,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-06-02 21:55:51','2023-06-02 21:55:51'),(1736,'default','edited',53,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 21:58:54','2023-06-02 21:58:54'),(1737,'default','added',16100,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-02 22:29:42','2023-06-02 22:29:42'),(1738,'default','edited',52,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 22:00:47','2023-06-02 22:00:47'),(1739,'default','edited',51,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 22:01:50','2023-06-02 22:01:50'),(1740,'default','edited',50,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 22:04:03','2023-06-02 22:04:03'),(1741,'default','edited',49,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 22:05:46','2023-06-02 22:05:46'),(1742,'default','payment_edited',5775,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 22:09:05','2023-06-02 22:09:05'),(1743,'default','added',16101,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":427.5}}',NULL,'2023-06-02 22:41:15','2023-06-02 22:41:16'),(1744,'default','added',16102,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-02 22:58:26','2023-06-02 22:58:26'),(1745,'default','added',16103,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1064}}',NULL,'2023-06-02 22:59:21','2023-06-02 22:59:21'),(1746,'default','added',16104,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":342.4}}',NULL,'2023-06-02 23:08:28','2023-06-02 23:08:28'),(1747,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-02 23:18:11','2023-06-02 23:18:11'),(1748,'default','added',16105,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":573.13}}',NULL,'2023-06-02 23:23:21','2023-06-02 23:23:21'),(1749,'default','added',16106,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1130.01}}',NULL,'2023-06-02 23:25:26','2023-06-02 23:25:26'),(1750,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-02 23:04:20','2023-06-02 23:04:20'),(1751,'default','added',16107,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237.6}}',NULL,'2023-06-02 23:35:45','2023-06-02 23:35:45'),(1752,'default','added',16108,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":323.42}}',NULL,'2023-06-03 00:00:37','2023-06-03 00:00:37'),(1753,'default','added',16109,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-03 00:05:15','2023-06-03 00:05:15'),(1754,'default','added',16110,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4196.28}}',NULL,'2023-06-03 00:12:06','2023-06-03 00:12:06'),(1755,'default','added',16111,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980}}',NULL,'2023-06-03 00:26:15','2023-06-03 00:26:15'),(1756,'default','added',16112,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-03 00:30:07','2023-06-03 00:30:07'),(1757,'default','added',16113,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2326.45}}',NULL,'2023-06-03 00:45:39','2023-06-03 00:45:40'),(1758,'default','added',16114,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3594.82}}',NULL,'2023-06-03 00:46:05','2023-06-03 00:46:05'),(1759,'default','added',16115,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2806.85}}',NULL,'2023-06-03 00:53:12','2023-06-03 00:53:12'),(1760,'default','added',16116,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4604.98}}',NULL,'2023-06-03 01:03:00','2023-06-03 01:03:00'),(1761,'default','added',16117,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-03 01:15:10','2023-06-03 01:15:10'),(1762,'default','added',16118,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-03 01:21:22','2023-06-03 01:21:22'),(1763,'default','added',16119,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-03 01:22:56','2023-06-03 01:22:56'),(1764,'default','added',16120,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13506.9}}',NULL,'2023-06-03 01:36:35','2023-06-03 01:36:35'),(1765,'default','added',16121,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.58}}',NULL,'2023-06-03 01:57:11','2023-06-03 01:57:11'),(1766,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-03 01:58:24','2023-06-03 01:58:24'),(1767,'default','added',16122,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":390}}',NULL,'2023-06-03 01:59:16','2023-06-03 01:59:16'),(1768,'default','added',16123,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6349.28}}',NULL,'2023-06-03 02:23:22','2023-06-03 02:23:22'),(1769,'default','added',16124,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8574.91}}',NULL,'2023-06-03 02:42:21','2023-06-03 02:42:21'),(1770,'default','added',16125,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2063.47}}',NULL,'2023-06-03 02:45:57','2023-06-03 02:45:57'),(1771,'default','added',16126,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-03 02:46:46','2023-06-03 02:46:46'),(1772,'default','added',16127,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":215.08}}',NULL,'2023-06-03 03:09:01','2023-06-03 03:09:01'),(1773,'default','added',16128,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1269.2}}',NULL,'2023-06-03 03:51:08','2023-06-03 03:51:08'),(1774,'default','added',16129,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-03 03:52:43','2023-06-03 03:52:43'),(1775,'default','added',16130,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10.24}}',NULL,'2023-06-03 03:55:17','2023-06-03 03:55:17'),(1776,'default','added',16131,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":285}}',NULL,'2023-06-03 04:02:46','2023-06-03 04:02:46'),(1777,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-03 04:03:40','2023-06-03 04:03:40'),(1778,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-03 04:04:00','2023-06-03 04:04:00'),(1779,'default','added',16132,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6184.68}}',NULL,'2023-06-03 04:10:00','2023-06-03 04:10:00'),(1780,'default','added',16133,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":355.4}}',NULL,'2023-06-03 04:11:44','2023-06-03 04:11:44'),(1781,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-03 04:12:56','2023-06-03 04:12:56'),(1782,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-03 04:13:59','2023-06-03 04:13:59'),(1783,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-03 04:17:08','2023-06-03 04:17:08'),(1784,'default','added',16134,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-03 04:17:40','2023-06-03 04:17:40'),(1785,'default','added',16135,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1832.55}}',NULL,'2023-06-03 04:19:05','2023-06-03 04:19:05'),(1786,'default','added',16136,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":906.5}}',NULL,'2023-06-03 04:19:31','2023-06-03 04:19:31'),(1787,'default','added',16137,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2426.01}}',NULL,'2023-06-03 04:28:21','2023-06-03 04:28:21'),(1788,'default','added',16138,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11655.59}}',NULL,'2023-06-03 04:34:18','2023-06-03 04:34:18'),(1789,'default','added',16139,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-03 04:44:06','2023-06-03 04:44:06'),(1790,'default','added',16140,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7608.62}}',NULL,'2023-06-03 05:09:56','2023-06-03 05:09:56'),(1791,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-03 15:14:58','2023-06-03 15:14:58'),(1792,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-03 14:52:46','2023-06-03 14:52:46'),(1793,'default','added',16141,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-03 14:59:19','2023-06-03 14:59:19'),(1794,'default','added',16142,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":527.63}}',NULL,'2023-06-03 15:30:27','2023-06-03 15:30:27'),(1795,'default','added',16143,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-06-03 15:33:04','2023-06-03 15:33:04'),(1796,'default','added',16144,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59.4}}',NULL,'2023-06-03 15:33:42','2023-06-03 15:33:42'),(1797,'default','added',16145,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":640.56}}',NULL,'2023-06-03 15:52:43','2023-06-03 15:52:43'),(1798,'default','added',16146,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-06-03 15:22:52','2023-06-03 15:22:52'),(1799,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-03 16:38:19','2023-06-03 16:38:19'),(1800,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-03 16:38:37','2023-06-03 16:38:37'),(1801,'default','added',16147,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133}}',NULL,'2023-06-03 16:43:50','2023-06-03 16:43:50'),(1802,'default','added',16148,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-03 16:54:19','2023-06-03 16:54:19'),(1803,'default','added',16149,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-03 16:54:54','2023-06-03 16:54:54'),(1804,'default','added',16150,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":603.29}}',NULL,'2023-06-03 16:56:52','2023-06-03 16:56:52'),(1805,'default','added',16151,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":26453.88}}',NULL,'2023-06-03 17:07:40','2023-06-03 17:07:40'),(1806,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-03 17:36:45','2023-06-03 17:36:45'),(1807,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-03 17:37:14','2023-06-03 17:37:14'),(1808,'default','added',16152,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1467.75}}',NULL,'2023-06-03 17:38:25','2023-06-03 17:38:25'),(1809,'default','added',16153,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5279.25}}',NULL,'2023-06-03 17:39:07','2023-06-03 17:39:07'),(1810,'default','added',16154,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-03 17:47:16','2023-06-03 17:47:16'),(1811,'default','added',16155,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1955}}',NULL,'2023-06-03 17:24:13','2023-06-03 17:24:13'),(1812,'default','added',16156,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1076.16}}',NULL,'2023-06-03 18:09:18','2023-06-03 18:09:18'),(1813,'default','added',16157,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6565.03}}',NULL,'2023-06-03 18:29:34','2023-06-03 18:29:34'),(1814,'default','added',16158,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":376.2}}',NULL,'2023-06-03 18:33:00','2023-06-03 18:33:00'),(1815,'default','added',16159,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-06-03 18:37:59','2023-06-03 18:37:59'),(1816,'default','added',16160,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570}}',NULL,'2023-06-03 18:39:42','2023-06-03 18:39:42'),(1817,'default','payment_edited',5842,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-03 18:13:04','2023-06-03 18:13:05'),(1818,'default','added',16161,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11149.01}}',NULL,'2023-06-03 19:03:10','2023-06-03 19:03:10'),(1819,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-03 18:43:28','2023-06-03 18:43:28'),(1820,'default','added',16162,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":362.5}}',NULL,'2023-06-03 19:34:01','2023-06-03 19:34:01'),(1821,'default','added',16163,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":363.73}}',NULL,'2023-06-03 19:36:30','2023-06-03 19:36:30'),(1822,'default','added',16164,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3003.75}}',NULL,'2023-06-03 19:43:18','2023-06-03 19:43:18'),(1823,'default','added',16165,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7905.72}}',NULL,'2023-06-03 19:44:53','2023-06-03 19:44:53'),(1824,'default','added',16166,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-03 19:56:50','2023-06-03 19:56:50'),(1825,'default','added',16167,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1037.26}}',NULL,'2023-06-03 20:09:30','2023-06-03 20:09:30'),(1826,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-03 20:10:25','2023-06-03 20:10:25'),(1827,'default','added',16168,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":418}}',NULL,'2023-06-03 20:20:25','2023-06-03 20:20:25'),(1828,'default','added',16169,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":470}}',NULL,'2023-06-03 20:26:15','2023-06-03 20:26:15'),(1829,'default','added',16170,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281.68}}',NULL,'2023-06-03 20:27:43','2023-06-03 20:27:43'),(1830,'default','added',16171,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15.3}}',NULL,'2023-06-03 20:31:28','2023-06-03 20:31:28'),(1831,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-03 21:10:35','2023-06-03 21:10:35'),(1832,'default','added',16172,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10656.6}}',NULL,'2023-06-03 21:11:14','2023-06-03 21:11:14'),(1833,'default','added',16173,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":567.3}}',NULL,'2023-06-03 21:15:43','2023-06-03 21:15:43'),(1834,'default','added',16174,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":689.85}}',NULL,'2023-06-03 21:19:30','2023-06-03 21:19:30'),(1835,'default','added',16175,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1263.97}}',NULL,'2023-06-03 21:26:03','2023-06-03 21:26:03'),(1836,'default','added',16176,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71}}',NULL,'2023-06-03 21:31:33','2023-06-03 21:31:33'),(1837,'default','added',16177,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-03 21:34:17','2023-06-03 21:34:17'),(1838,'default','added',16178,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-03 21:37:04','2023-06-03 21:37:04'),(1839,'default','added',16179,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":667.8}}',NULL,'2023-06-03 21:46:36','2023-06-03 21:46:36'),(1840,'default','added',16180,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":218.01}}',NULL,'2023-06-03 21:47:57','2023-06-03 21:47:57'),(1841,'default','added',16181,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1299.31}}',NULL,'2023-06-03 21:52:14','2023-06-03 21:52:14'),(1842,'default','added',16182,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9852.97}}',NULL,'2023-06-03 21:55:24','2023-06-03 21:55:24'),(1843,'default','added',16183,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-03 22:10:10','2023-06-03 22:10:10'),(1844,'default','added',16184,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-03 22:13:59','2023-06-03 22:13:59'),(1845,'default','added',16185,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-03 22:18:00','2023-06-03 22:18:00'),(1846,'default','added',16186,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13149.89}}',NULL,'2023-06-03 22:21:31','2023-06-03 22:21:31'),(1847,'default','added',16187,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":588.2}}',NULL,'2023-06-03 22:32:12','2023-06-03 22:32:12'),(1848,'default','added',16188,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-03 22:34:45','2023-06-03 22:34:46'),(1849,'default','added',16189,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9664.94}}',NULL,'2023-06-03 22:52:10','2023-06-03 22:52:10'),(1850,'default','added',16190,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120.7}}',NULL,'2023-06-03 22:58:08','2023-06-03 22:58:08'),(1851,'default','added',16191,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":141.5}}',NULL,'2023-06-03 23:04:37','2023-06-03 23:04:37'),(1852,'default','added',16192,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-04 00:08:55','2023-06-04 00:08:55'),(1853,'default','added',16193,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":491.91}}',NULL,'2023-06-04 00:09:42','2023-06-04 00:09:42'),(1854,'default','added',16194,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525}}',NULL,'2023-06-04 00:09:45','2023-06-04 00:09:45'),(1855,'default','added',16195,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":598.5}}',NULL,'2023-06-04 00:13:06','2023-06-04 00:13:06'),(1856,'default','added',16196,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":365.54}}',NULL,'2023-06-04 00:13:22','2023-06-04 00:13:22'),(1857,'default','added',16197,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":617.38}}',NULL,'2023-06-04 00:15:52','2023-06-04 00:15:52'),(1858,'default','added',16198,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-04 00:24:23','2023-06-04 00:24:23'),(1859,'default','added',16199,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":598.5}}',NULL,'2023-06-04 00:26:31','2023-06-04 00:26:31'),(1860,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-04 00:30:28','2023-06-04 00:30:28'),(1861,'default','added',16200,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-06-04 00:35:55','2023-06-04 00:35:55'),(1862,'default','added',16201,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2023-06-04 00:41:22','2023-06-04 00:41:22'),(1863,'default','added',16202,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1924.19}}',NULL,'2023-06-04 00:47:05','2023-06-04 00:47:05'),(1864,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-04 00:51:01','2023-06-04 00:51:01'),(1865,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 00:51:18','2023-06-04 00:51:18'),(1866,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 00:53:55','2023-06-04 00:53:55'),(1867,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-04 00:57:13','2023-06-04 00:57:13'),(1868,'default','added',16203,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":562.5}}',NULL,'2023-06-04 00:59:43','2023-06-04 00:59:43'),(1869,'default','added',16204,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-04 01:01:40','2023-06-04 01:01:40'),(1870,'default','added',16205,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1507.75}}',NULL,'2023-06-04 01:06:44','2023-06-04 01:06:44'),(1871,'default','added',16206,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":565}}',NULL,'2023-06-04 01:11:30','2023-06-04 01:11:30'),(1872,'default','added',16207,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":290}}',NULL,'2023-06-04 01:13:13','2023-06-04 01:13:13'),(1873,'default','added',16208,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-04 01:14:10','2023-06-04 01:14:10'),(1874,'default','added',16209,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5104.68}}',NULL,'2023-06-04 01:17:01','2023-06-04 01:17:01'),(1875,'default','added',16210,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":137.4}}',NULL,'2023-06-04 01:18:57','2023-06-04 01:18:57'),(1876,'default','added',16211,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1376.1}}',NULL,'2023-06-04 01:20:17','2023-06-04 01:20:17'),(1877,'default','added',16212,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":708.62}}',NULL,'2023-06-04 01:28:33','2023-06-04 01:28:33'),(1878,'default','added',16213,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":248.23}}',NULL,'2023-06-04 01:39:01','2023-06-04 01:39:01'),(1879,'default','added',16214,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1463.15}}',NULL,'2023-06-04 01:42:06','2023-06-04 01:42:06'),(1880,'default','added',16215,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-04 01:44:17','2023-06-04 01:44:17'),(1881,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-04 01:47:02','2023-06-04 01:47:02'),(1882,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 01:48:22','2023-06-04 01:48:22'),(1883,'default','added',16216,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":312.06}}',NULL,'2023-06-04 01:49:09','2023-06-04 01:49:09'),(1884,'default','added',16217,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-06-04 01:50:51','2023-06-04 01:50:51'),(1885,'default','added',16218,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":747.5}}',NULL,'2023-06-04 01:56:36','2023-06-04 01:56:36'),(1886,'default','added',16219,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100.23}}',NULL,'2023-06-04 01:59:59','2023-06-04 01:59:59'),(1887,'default','added',16220,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":730}}',NULL,'2023-06-04 02:05:10','2023-06-04 02:05:10'),(1888,'default','added',16221,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1549.81}}',NULL,'2023-06-04 02:07:59','2023-06-04 02:07:59'),(1889,'default','added',16222,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-04 02:10:18','2023-06-04 02:10:18'),(1890,'default','added',16223,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":151.2}}',NULL,'2023-06-04 02:26:55','2023-06-04 02:26:55'),(1891,'default','added',16224,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":399}}',NULL,'2023-06-04 02:30:57','2023-06-04 02:30:57'),(1892,'default','added',16225,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2023-06-04 02:35:39','2023-06-04 02:35:39'),(1893,'default','added',16226,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":413.8}}',NULL,'2023-06-04 03:08:25','2023-06-04 03:08:25'),(1894,'default','added',16227,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-04 03:09:15','2023-06-04 03:09:15'),(1895,'default','added',16228,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1399.8}}',NULL,'2023-06-04 03:14:21','2023-06-04 03:14:21'),(1896,'default','added',16229,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-04 03:20:12','2023-06-04 03:20:12'),(1897,'default','added',16230,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":234.05}}',NULL,'2023-06-04 03:33:28','2023-06-04 03:33:28'),(1898,'default','added',16231,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":770}}',NULL,'2023-06-04 03:43:19','2023-06-04 03:43:19'),(1899,'default','added',16232,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":418.02}}',NULL,'2023-06-04 03:45:26','2023-06-04 03:45:26'),(1900,'default','added',16233,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-04 03:50:53','2023-06-04 03:50:53'),(1901,'default','added',16234,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1296.99}}',NULL,'2023-06-04 04:01:01','2023-06-04 04:01:01'),(1902,'default','added',16235,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2023-06-04 04:20:23','2023-06-04 04:20:23'),(1903,'default','added',16236,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.16}}',NULL,'2023-06-04 04:23:24','2023-06-04 04:23:24'),(1904,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 04:27:26','2023-06-04 04:27:26'),(1905,'default','added',16237,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":224.8}}',NULL,'2023-06-04 04:46:50','2023-06-04 04:46:50'),(1906,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 04:48:34','2023-06-04 04:48:34'),(1907,'default','added',16238,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":583.3}}',NULL,'2023-06-04 05:07:14','2023-06-04 05:07:14'),(1908,'default','added',16239,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2217.18}}',NULL,'2023-06-04 05:15:15','2023-06-04 05:15:15'),(1909,'default','added',16240,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-04 05:16:44','2023-06-04 05:16:44'),(1910,'default','added',16241,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.57}}',NULL,'2023-06-04 05:19:04','2023-06-04 05:19:04'),(1911,'default','added',16242,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3830.96}}',NULL,'2023-06-04 05:20:57','2023-06-04 05:20:57'),(1912,'default','added',16243,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28.8}}',NULL,'2023-06-04 05:22:00','2023-06-04 05:22:00'),(1913,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-04 14:58:55','2023-06-04 14:58:55'),(1914,'default','added',16244,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-04 14:59:51','2023-06-04 14:59:51'),(1915,'default','added',16245,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":518.7}}',NULL,'2023-06-04 15:08:32','2023-06-04 15:08:32'),(1916,'default','added',16246,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":569}}',NULL,'2023-06-04 15:36:01','2023-06-04 15:36:01'),(1917,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-04 15:48:51','2023-06-04 15:48:51'),(1918,'default','added',16247,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-06-04 15:52:37','2023-06-04 15:52:37'),(1919,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-04 16:35:35','2023-06-04 16:35:35'),(1920,'default','added',16248,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1158.3}}',NULL,'2023-06-04 16:39:08','2023-06-04 16:39:08'),(1921,'default','payment_edited',5780,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-04 16:09:24','2023-06-04 16:09:24'),(1922,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-04 16:25:36','2023-06-04 16:25:36'),(1923,'default','added',16249,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-04 16:56:36','2023-06-04 16:56:36'),(1924,'default','added',16250,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.1}}',NULL,'2023-06-04 16:57:36','2023-06-04 16:57:36'),(1925,'default','added',16251,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-04 16:58:03','2023-06-04 16:58:03'),(1926,'default','added',16252,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97.65}}',NULL,'2023-06-04 17:15:37','2023-06-04 17:15:37'),(1927,'default','added',16253,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.4}}',NULL,'2023-06-04 17:48:22','2023-06-04 17:48:22'),(1928,'default','added',16254,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}',NULL,'2023-06-04 18:02:37','2023-06-04 18:02:37'),(1929,'default','added',16255,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-06-04 18:04:35','2023-06-04 18:04:35'),(1930,'default','added',16256,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580}}',NULL,'2023-06-04 18:19:45','2023-06-04 18:19:45'),(1931,'default','added',16257,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":497.15}}',NULL,'2023-06-04 18:26:26','2023-06-04 18:26:26'),(1932,'default','added',16258,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-04 18:51:18','2023-06-04 18:51:18'),(1933,'default','added',16259,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-04 18:53:29','2023-06-04 18:53:29'),(1934,'default','added',16260,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":578.28}}',NULL,'2023-06-04 19:33:09','2023-06-04 19:33:09'),(1935,'default','added',16261,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-04 19:38:12','2023-06-04 19:38:12'),(1936,'default','added',16262,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34.52}}',NULL,'2023-06-04 19:40:06','2023-06-04 19:40:06'),(1937,'default','added',16263,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":520}}',NULL,'2023-06-04 20:07:41','2023-06-04 20:07:41'),(1938,'default','added',16264,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-04 20:13:44','2023-06-04 20:13:44'),(1939,'default','added',16265,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980.84}}',NULL,'2023-06-04 21:31:54','2023-06-04 21:31:54'),(1940,'default','added',16266,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":478.33}}',NULL,'2023-06-04 21:33:08','2023-06-04 21:33:08'),(1941,'default','added',16267,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-04 21:42:59','2023-06-04 21:42:59'),(1942,'default','added',16268,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-04 21:44:00','2023-06-04 21:44:00'),(1943,'default','added',16269,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":264.52}}',NULL,'2023-06-04 21:46:06','2023-06-04 21:46:06'),(1944,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 21:50:37','2023-06-04 21:50:37'),(1945,'default','added',16270,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.58}}',NULL,'2023-06-04 21:51:35','2023-06-04 21:51:35'),(1946,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-04 22:00:13','2023-06-04 22:00:13'),(1947,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 22:00:51','2023-06-04 22:00:51'),(1948,'default','added',16271,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":609.18}}',NULL,'2023-06-04 22:09:07','2023-06-04 22:09:07'),(1949,'default','added',16272,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":291.31}}',NULL,'2023-06-04 22:22:00','2023-06-04 22:22:00'),(1950,'default','added',16273,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":168.46}}',NULL,'2023-06-04 22:29:20','2023-06-04 22:29:20'),(1951,'default','added',16274,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-04 22:39:34','2023-06-04 22:39:34'),(1952,'default','added',16275,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-04 22:41:46','2023-06-04 22:41:46'),(1953,'default','added',16276,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-06-04 22:42:58','2023-06-04 22:42:58'),(1954,'default','added',16277,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-06-04 22:43:56','2023-06-04 22:43:56'),(1955,'default','added',16278,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570}}',NULL,'2023-06-04 22:51:34','2023-06-04 22:51:34'),(1956,'default','added',16279,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281.68}}',NULL,'2023-06-04 23:10:50','2023-06-04 23:10:50'),(1957,'default','added',16280,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71.1}}',NULL,'2023-06-04 23:37:06','2023-06-04 23:37:06'),(1958,'default','added',16281,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-04 23:44:34','2023-06-04 23:44:34'),(1959,'default','added',16282,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-04 23:47:27','2023-06-04 23:47:27'),(1960,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-04 23:58:16','2023-06-04 23:58:16'),(1961,'default','added',16283,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":152.1}}',NULL,'2023-06-05 00:02:50','2023-06-05 00:02:50'),(1962,'default','added',16284,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-05 00:03:40','2023-06-05 00:03:40'),(1963,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-04 23:58:27','2023-06-04 23:58:27'),(1964,'default','added',16285,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-06-05 00:01:52','2023-06-05 00:01:52'),(1965,'default','added',16286,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":971.67}}',NULL,'2023-06-05 00:35:56','2023-06-05 00:35:56'),(1966,'default','added',16287,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2475}}',NULL,'2023-06-05 00:39:57','2023-06-05 00:39:57'),(1967,'default','added',16288,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":78.1}}',NULL,'2023-06-05 00:42:26','2023-06-05 00:42:26'),(1968,'default','added',16289,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36.97}}',NULL,'2023-06-05 01:15:42','2023-06-05 01:15:43'),(1969,'default','added',16290,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":538.84}}',NULL,'2023-06-05 01:16:41','2023-06-05 01:16:41'),(1970,'default','added',16291,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":312.5}}',NULL,'2023-06-05 01:21:05','2023-06-05 01:21:05'),(1971,'default','added',16292,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-06-05 01:24:49','2023-06-05 01:24:49'),(1972,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-05 01:25:08','2023-06-05 01:25:09'),(1973,'default','added',16293,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1053.72}}',NULL,'2023-06-05 01:26:55','2023-06-05 01:26:55'),(1974,'default','added',16294,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-06-05 01:30:41','2023-06-05 01:30:41'),(1975,'default','added',16295,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1101.24}}',NULL,'2023-06-05 01:37:10','2023-06-05 01:37:10'),(1976,'default','added',16296,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":319.9}}',NULL,'2023-06-05 01:37:50','2023-06-05 01:37:50'),(1977,'default','added',16297,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":299.1}}',NULL,'2023-06-05 01:48:16','2023-06-05 01:48:16'),(1978,'default','added',16298,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-06-05 01:51:39','2023-06-05 01:51:39'),(1979,'default','added',16299,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18.7}}',NULL,'2023-06-05 01:52:53','2023-06-05 01:52:53'),(1980,'default','added',16300,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98.01}}',NULL,'2023-06-05 02:06:31','2023-06-05 02:06:31'),(1981,'default','added',16301,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-05 02:08:40','2023-06-05 02:08:40'),(1982,'default','added',16302,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6927.68}}',NULL,'2023-06-05 02:15:42','2023-06-05 02:15:42'),(1983,'default','added',16303,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":584.12}}',NULL,'2023-06-05 02:28:08','2023-06-05 02:28:08'),(1984,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 02:31:00','2023-06-05 02:31:00'),(1985,'default','added',16304,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":412}}',NULL,'2023-06-05 02:33:29','2023-06-05 02:33:29'),(1986,'default','added',16305,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":337.58}}',NULL,'2023-06-05 02:46:37','2023-06-05 02:46:37'),(1987,'default','added',16306,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-05 02:56:04','2023-06-05 02:56:04'),(1988,'default','added',16307,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3097.8}}',NULL,'2023-06-05 03:04:25','2023-06-05 03:04:25'),(1989,'default','added',16308,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":285}}',NULL,'2023-06-05 03:05:09','2023-06-05 03:05:09'),(1990,'default','added',16309,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-05 03:14:04','2023-06-05 03:14:04'),(1991,'default','added',16310,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":199.5}}',NULL,'2023-06-05 03:16:34','2023-06-05 03:16:34'),(1992,'default','added',16311,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-05 03:47:48','2023-06-05 03:47:48'),(1993,'default','added',16312,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2183.11}}',NULL,'2023-06-05 03:58:44','2023-06-05 03:58:44'),(1994,'default','added',16313,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138.6}}',NULL,'2023-06-05 04:08:06','2023-06-05 04:08:06'),(1995,'default','added',16314,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2023-06-05 04:22:03','2023-06-05 04:22:03'),(1996,'default','added',16315,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.3}}',NULL,'2023-06-05 04:29:59','2023-06-05 04:29:59'),(1997,'default','added',16316,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":413.1}}',NULL,'2023-06-05 04:31:59','2023-06-05 04:31:59'),(1998,'default','added',16317,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":413.1}}',NULL,'2023-06-05 04:32:04','2023-06-05 04:32:04'),(1999,'default','edited',16316,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":413.1},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"413.1000\"}}',NULL,'2023-06-05 04:32:05','2023-06-05 04:32:05'),(2000,'default','added',16318,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":995}}',NULL,'2023-06-05 04:35:24','2023-06-05 04:35:24'),(2001,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-05 04:50:25','2023-06-05 04:50:25'),(2002,'default','added',16319,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86.48}}',NULL,'2023-06-05 04:57:42','2023-06-05 04:57:42'),(2003,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 05:02:26','2023-06-05 05:02:26'),(2004,'default','added',16320,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-05 05:06:08','2023-06-05 05:06:08'),(2005,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 05:10:31','2023-06-05 05:10:31'),(2006,'default','edited',15559,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-05 05:11:38','2023-06-05 05:11:38'),(2007,'default','added',16321,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1711.34}}',NULL,'2023-06-05 05:15:04','2023-06-05 05:15:04'),(2008,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-05 14:06:35','2023-06-05 14:06:35'),(2009,'default','added',16322,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2682.9}}',NULL,'2023-06-05 14:46:07','2023-06-05 14:46:07'),(2010,'default','edited',16322,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2832.9},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2682.9000\"}}',NULL,'2023-06-05 14:56:24','2023-06-05 14:56:24'),(2011,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-05 15:00:41','2023-06-05 15:00:41'),(2012,'default','added',16323,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3603}}',NULL,'2023-06-05 15:34:33','2023-06-05 15:34:33'),(2013,'default','added',16324,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3023.2}}',NULL,'2023-06-05 15:44:56','2023-06-05 15:44:56'),(2014,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-05 15:46:36','2023-06-05 15:46:36'),(2015,'default','added',16325,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5158.82}}',NULL,'2023-06-05 15:47:04','2023-06-05 15:47:04'),(2016,'default','edited',16324,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2572.72},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3023.2000\"}}',NULL,'2023-06-05 15:59:56','2023-06-05 15:59:56'),(2017,'default','added',16326,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-05 16:04:23','2023-06-05 16:04:23'),(2018,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 16:39:46','2023-06-05 16:39:46'),(2019,'default','payment_edited',5818,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 16:41:07','2023-06-05 16:41:07'),(2020,'default','payment_edited',5800,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 16:41:40','2023-06-05 16:41:40'),(2021,'default','added',16327,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-05 17:06:44','2023-06-05 17:06:44'),(2022,'default','added',16328,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-05 17:25:57','2023-06-05 17:25:57'),(2023,'default','added',16329,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":287.44}}',NULL,'2023-06-05 17:37:22','2023-06-05 17:37:22'),(2024,'default','added',16330,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":212.5}}',NULL,'2023-06-05 17:47:54','2023-06-05 17:47:54'),(2025,'default','added',16331,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-05 17:48:12','2023-06-05 17:48:12'),(2026,'default','added',16332,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-05 18:35:02','2023-06-05 18:35:03'),(2027,'default','added',16333,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21.76}}',NULL,'2023-06-05 18:44:14','2023-06-05 18:44:14'),(2028,'default','added',16334,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":14357.25}}',NULL,'2023-06-05 18:45:48','2023-06-05 18:45:48'),(2029,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 19:39:06','2023-06-05 19:39:06'),(2030,'default','added',141,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 19:41:13','2023-06-05 19:41:13'),(2031,'default','added',16335,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":378.7}}',NULL,'2023-06-05 19:47:13','2023-06-05 19:47:13'),(2032,'default','added',16336,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-06-05 19:47:18','2023-06-05 19:47:18'),(2033,'default','added',16337,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":153.09}}',NULL,'2023-06-05 19:48:36','2023-06-05 19:48:36'),(2034,'default','added',16338,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":398.97}}',NULL,'2023-06-05 19:50:48','2023-06-05 19:50:48'),(2035,'default','added',16339,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.91}}',NULL,'2023-06-05 20:12:58','2023-06-05 20:12:58'),(2036,'default','added',16340,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1961.67}}',NULL,'2023-06-05 20:28:27','2023-06-05 20:28:27'),(2037,'default','added',16341,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-05 20:30:07','2023-06-05 20:30:07'),(2038,'default','added',16342,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1197.02}}',NULL,'2023-06-05 20:44:49','2023-06-05 20:44:49'),(2039,'default','added',16343,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294.5}}',NULL,'2023-06-05 20:46:33','2023-06-05 20:46:33'),(2040,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-05 21:06:11','2023-06-05 21:06:11'),(2041,'default','added',16344,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":174.49}}',NULL,'2023-06-05 21:26:16','2023-06-05 21:26:16'),(2042,'default','added',16345,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64.88}}',NULL,'2023-06-05 21:45:02','2023-06-05 21:45:02'),(2043,'default','added',16346,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-05 21:51:40','2023-06-05 21:51:40'),(2044,'default','added',16347,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":189.4}}',NULL,'2023-06-05 21:54:40','2023-06-05 21:54:40'),(2045,'default','added',16348,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1422}}',NULL,'2023-06-05 22:06:23','2023-06-05 22:06:23'),(2046,'default','added',16349,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1524.69}}',NULL,'2023-06-05 22:09:27','2023-06-05 22:09:27'),(2047,'default','added',16350,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.8}}',NULL,'2023-06-05 22:17:47','2023-06-05 22:17:47'),(2048,'default','added',16351,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":168.3}}',NULL,'2023-06-05 22:19:21','2023-06-05 22:19:21'),(2049,'default','added',16352,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":337.26}}',NULL,'2023-06-05 22:39:10','2023-06-05 22:39:10'),(2050,'default','added',16353,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.05}}',NULL,'2023-06-05 22:39:57','2023-06-05 22:39:57'),(2051,'default','added',16354,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":315}}',NULL,'2023-06-05 22:40:04','2023-06-05 22:40:04'),(2052,'default','added',16355,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-05 22:43:11','2023-06-05 22:43:11'),(2053,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:43:43','2023-06-05 22:43:43'),(2054,'default','payment_edited',5792,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:46:42','2023-06-05 22:46:42'),(2055,'default','payment_edited',5791,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:47:30','2023-06-05 22:47:30'),(2056,'default','payment_edited',5790,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:48:07','2023-06-05 22:48:07'),(2057,'default','payment_edited',5789,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:48:42','2023-06-05 22:48:42'),(2058,'default','payment_edited',5788,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:49:12','2023-06-05 22:49:12'),(2059,'default','payment_edited',5787,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:49:38','2023-06-05 22:49:38'),(2060,'default','payment_edited',5786,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:50:07','2023-06-05 22:50:07'),(2061,'default','payment_edited',5785,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:50:42','2023-06-05 22:50:43'),(2062,'default','payment_edited',5784,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:51:18','2023-06-05 22:51:18'),(2063,'default','payment_edited',5782,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:51:54','2023-06-05 22:51:54'),(2064,'default','payment_edited',5781,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:52:33','2023-06-05 22:52:33'),(2065,'default','payment_edited',5778,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:53:22','2023-06-05 22:53:22'),(2066,'default','payment_edited',5752,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-05 22:54:55','2023-06-05 22:54:55'),(2067,'default','added',16356,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":141.95}}',NULL,'2023-06-05 23:01:09','2023-06-05 23:01:09'),(2068,'default','added',16357,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1594.23}}',NULL,'2023-06-05 23:04:44','2023-06-05 23:04:44'),(2069,'default','added',16358,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-05 23:12:30','2023-06-05 23:12:30'),(2070,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-05 23:32:01','2023-06-05 23:32:01'),(2071,'default','added',16359,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1713}}',NULL,'2023-06-05 23:36:23','2023-06-05 23:36:23'),(2072,'default','added',16360,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":346.5}}',NULL,'2023-06-05 23:54:48','2023-06-05 23:54:48'),(2073,'default','added',16361,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-05 23:55:29','2023-06-05 23:55:29'),(2074,'default','added',16362,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265}}',NULL,'2023-06-06 00:02:59','2023-06-06 00:02:59'),(2075,'default','added',16363,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":443.75}}',NULL,'2023-06-06 00:09:11','2023-06-06 00:09:11'),(2076,'default','added',16364,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-06 00:10:40','2023-06-06 00:10:40'),(2077,'default','added',16365,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":694.9}}',NULL,'2023-06-06 00:15:48','2023-06-06 00:15:48'),(2078,'default','added',16366,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":599}}',NULL,'2023-06-06 00:35:37','2023-06-06 00:35:37'),(2079,'default','added',16367,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.53}}',NULL,'2023-06-06 00:37:24','2023-06-06 00:37:24'),(2080,'default','added',16368,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-06 00:52:53','2023-06-06 00:52:53'),(2081,'default','added',16369,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.08}}',NULL,'2023-06-06 00:58:50','2023-06-06 00:58:50'),(2082,'default','added',16370,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":840}}',NULL,'2023-06-06 01:05:40','2023-06-06 01:05:40'),(2083,'default','added',16371,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-06 01:08:59','2023-06-06 01:08:59'),(2084,'default','added',16372,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":310}}',NULL,'2023-06-06 01:11:14','2023-06-06 01:11:15'),(2085,'default','added',16373,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-06 01:21:05','2023-06-06 01:21:05'),(2086,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-06 01:22:33','2023-06-06 01:22:33'),(2087,'default','added',16374,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-06-06 01:22:52','2023-06-06 01:22:52'),(2088,'default','added',16375,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":291.6}}',NULL,'2023-06-06 01:24:37','2023-06-06 01:24:37'),(2089,'default','added',16376,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-06 01:34:49','2023-06-06 01:34:49'),(2090,'default','added',16377,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":916.46}}',NULL,'2023-06-06 01:36:40','2023-06-06 01:36:40'),(2091,'default','added',16378,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":141.44}}',NULL,'2023-06-06 01:38:21','2023-06-06 01:38:21'),(2092,'default','added',16379,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":183.35}}',NULL,'2023-06-06 01:45:00','2023-06-06 01:45:00'),(2093,'default','added',16380,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1006.25}}',NULL,'2023-06-06 01:51:09','2023-06-06 01:51:09'),(2094,'default','added',16381,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":487.5}}',NULL,'2023-06-06 01:52:35','2023-06-06 01:52:35'),(2095,'default','added',16382,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":216.6}}',NULL,'2023-06-06 01:54:43','2023-06-06 01:54:43'),(2096,'default','added',16383,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":412.5}}',NULL,'2023-06-06 01:56:27','2023-06-06 01:56:27'),(2097,'default','added',16384,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-06 02:00:08','2023-06-06 02:00:08'),(2098,'default','added',16385,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":113.6}}',NULL,'2023-06-06 02:05:25','2023-06-06 02:05:25'),(2099,'default','added',16386,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":165}}',NULL,'2023-06-06 02:07:32','2023-06-06 02:07:32'),(2100,'default','added',16387,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72.1}}',NULL,'2023-06-06 02:13:29','2023-06-06 02:13:29'),(2101,'default','added',16388,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95.97}}',NULL,'2023-06-06 02:32:23','2023-06-06 02:32:23'),(2102,'default','added',16389,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":274.96}}',NULL,'2023-06-06 02:41:18','2023-06-06 02:41:18'),(2103,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 02:50:24','2023-06-06 02:50:24'),(2104,'default','added',16390,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":691.47}}',NULL,'2023-06-06 02:54:24','2023-06-06 02:54:24'),(2105,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-06 03:01:41','2023-06-06 03:01:41'),(2106,'default','added',16391,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-06 03:11:30','2023-06-06 03:11:30'),(2107,'default','added',16392,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-06 03:14:14','2023-06-06 03:14:14'),(2108,'default','added',16393,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":405.94}}',NULL,'2023-06-06 03:17:44','2023-06-06 03:17:44'),(2109,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-06 03:30:22','2023-06-06 03:30:22'),(2110,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-06 03:30:42','2023-06-06 03:30:42'),(2111,'default','edited',16390,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":407.62},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"691.4700\"}}',NULL,'2023-06-06 03:32:31','2023-06-06 03:32:31'),(2112,'default','added',16394,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2610.2}}',NULL,'2023-06-06 03:33:33','2023-06-06 03:33:33'),(2113,'default','added',16395,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":283.85}}',NULL,'2023-06-06 03:38:05','2023-06-06 03:38:05'),(2114,'default','added',16396,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47}}',NULL,'2023-06-06 03:54:07','2023-06-06 03:54:07'),(2115,'default','added',16397,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":201.07}}',NULL,'2023-06-06 03:56:01','2023-06-06 03:56:01'),(2116,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 04:36:09','2023-06-06 04:36:09'),(2117,'default','edited',123,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 04:38:31','2023-06-06 04:38:31'),(2118,'default','payment_edited',5843,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 04:38:58','2023-06-06 04:38:58'),(2119,'default','added',16398,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":285}}',NULL,'2023-06-06 05:02:32','2023-06-06 05:02:32'),(2120,'default','added',16399,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":345.1}}',NULL,'2023-06-06 05:05:04','2023-06-06 05:05:04'),(2121,'default','added',16400,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":510.24}}',NULL,'2023-06-06 05:10:11','2023-06-06 05:10:11'),(2122,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"90150.0000\"}}',NULL,'2023-06-06 05:16:45','2023-06-06 05:16:45'),(2123,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-06 13:51:12','2023-06-06 13:51:12'),(2124,'default','added',16401,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-06-06 14:11:22','2023-06-06 14:11:22'),(2125,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 14:46:41','2023-06-06 14:46:41'),(2126,'default','added',16402,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16884}}',NULL,'2023-06-06 14:58:05','2023-06-06 14:58:05'),(2127,'default','added',16403,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":299.58}}',NULL,'2023-06-06 15:05:50','2023-06-06 15:05:50'),(2128,'default','added',16404,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-06-06 15:12:33','2023-06-06 15:12:33'),(2129,'default','added',16405,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1894}}',NULL,'2023-06-06 15:46:58','2023-06-06 15:46:58'),(2130,'default','added',16406,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-06 15:53:00','2023-06-06 15:53:00'),(2131,'default','added',16407,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-06-06 16:18:56','2023-06-06 16:18:56'),(2132,'default','added',16408,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-06 16:25:13','2023-06-06 16:25:13'),(2133,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-06 16:41:53','2023-06-06 16:41:53'),(2134,'default','added',16409,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":975}}',NULL,'2023-06-06 17:03:30','2023-06-06 17:03:30'),(2135,'default','added',16410,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1772.29}}',NULL,'2023-06-06 17:21:12','2023-06-06 17:21:12'),(2136,'default','payment_edited',16004,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11412.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11412.0000\"}}',NULL,'2023-06-06 17:27:49','2023-06-06 17:27:49'),(2137,'default','added',16411,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1454.92}}',NULL,'2023-06-06 17:32:49','2023-06-06 17:32:49'),(2138,'default','edited',16410,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3457.84},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1772.2900\"}}',NULL,'2023-06-06 17:35:17','2023-06-06 17:35:17'),(2139,'default','added',16412,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-06 17:45:25','2023-06-06 17:45:25'),(2140,'default','added',16413,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-06 17:56:12','2023-06-06 17:56:12'),(2141,'default','added',16414,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-06 18:03:42','2023-06-06 18:03:42'),(2142,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-06 18:18:25','2023-06-06 18:18:25'),(2143,'default','added',16415,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":975}}',NULL,'2023-06-06 18:26:34','2023-06-06 18:26:34'),(2144,'default','edited',16410,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7642.8},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3457.8400\"}}',NULL,'2023-06-06 18:27:19','2023-06-06 18:27:19'),(2145,'default','added',16416,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":390}}',NULL,'2023-06-06 18:33:07','2023-06-06 18:33:07'),(2146,'default','edited',16410,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20831.2},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7642.8000\"}}',NULL,'2023-06-06 18:49:29','2023-06-06 18:49:29'),(2147,'default','added',16417,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1961.67}}',NULL,'2023-06-06 19:10:58','2023-06-06 19:10:58'),(2148,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-06 19:14:32','2023-06-06 19:14:32'),(2149,'default','added',16418,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1173.75}}',NULL,'2023-06-06 19:16:43','2023-06-06 19:16:43'),(2150,'default','added',16419,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":247.5}}',NULL,'2023-06-06 19:19:34','2023-06-06 19:19:34'),(2151,'default','added',16420,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":383.63}}',NULL,'2023-06-06 19:20:49','2023-06-06 19:20:49'),(2152,'default','added',16421,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-06 19:25:43','2023-06-06 19:25:43'),(2153,'default','added',16422,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3327.1}}',NULL,'2023-06-06 19:30:13','2023-06-06 19:30:13'),(2154,'default','added',16423,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-06 19:30:50','2023-06-06 19:30:50'),(2155,'default','added',16424,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":712.5}}',NULL,'2023-06-06 19:41:11','2023-06-06 19:41:11'),(2156,'default','added',16425,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-06 19:43:03','2023-06-06 19:43:03'),(2157,'default','added',16426,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-06-06 19:45:33','2023-06-06 19:45:33'),(2158,'default','added',16427,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-06 20:04:12','2023-06-06 20:04:12'),(2159,'default','added',16428,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138.6}}',NULL,'2023-06-06 20:11:07','2023-06-06 20:11:07'),(2160,'default','added',16429,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-06 20:14:33','2023-06-06 20:14:33'),(2161,'default','added',16430,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-06 20:17:51','2023-06-06 20:17:52'),(2162,'default','added',16431,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":43794.32}}',NULL,'2023-06-06 20:27:06','2023-06-06 20:27:06'),(2163,'default','added',16432,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-06 20:31:57','2023-06-06 20:31:57'),(2164,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 20:43:37','2023-06-06 20:43:37'),(2165,'default','payment_edited',5829,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 20:44:43','2023-06-06 20:44:43'),(2166,'default','added',16433,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4989.6}}',NULL,'2023-06-06 20:46:07','2023-06-06 20:46:07'),(2167,'default','added',16434,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2.23}}',NULL,'2023-06-06 21:02:52','2023-06-06 21:02:52'),(2168,'default','added',16435,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-06-06 21:05:21','2023-06-06 21:05:21'),(2169,'default','added',16436,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97.6}}',NULL,'2023-06-06 21:09:12','2023-06-06 21:09:12'),(2170,'default','added',16437,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":520}}',NULL,'2023-06-06 21:15:07','2023-06-06 21:15:07'),(2171,'default','added',16438,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":417.89}}',NULL,'2023-06-06 21:19:11','2023-06-06 21:19:11'),(2172,'default','added',16439,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374.34}}',NULL,'2023-06-06 21:32:25','2023-06-06 21:32:25'),(2173,'default','added',16440,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85.56}}',NULL,'2023-06-06 21:45:47','2023-06-06 21:45:47'),(2174,'default','added',16441,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":694.59}}',NULL,'2023-06-06 21:51:04','2023-06-06 21:51:04'),(2175,'default','added',16442,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":34744.65}}',NULL,'2023-06-06 22:09:36','2023-06-06 22:09:36'),(2176,'default','added',16443,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2023-06-06 22:12:30','2023-06-06 22:12:30'),(2177,'default','added',16444,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":392.6}}',NULL,'2023-06-06 22:13:58','2023-06-06 22:13:58'),(2178,'default','added',16445,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":960}}',NULL,'2023-06-06 22:28:48','2023-06-06 22:28:48'),(2179,'default','added',16446,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":215}}',NULL,'2023-06-06 22:33:29','2023-06-06 22:33:29'),(2180,'default','added',142,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-06-06 22:42:24','2023-06-06 22:42:24'),(2181,'default','added',16447,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-06 22:57:00','2023-06-06 22:57:00'),(2182,'default','added',16448,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":582.65}}',NULL,'2023-06-06 23:02:46','2023-06-06 23:02:46'),(2183,'default','added',16449,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":81.2}}',NULL,'2023-06-06 23:03:20','2023-06-06 23:03:20'),(2184,'default','added',16450,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-06 23:05:03','2023-06-06 23:05:03'),(2185,'default','added',16451,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-06-06 23:10:26','2023-06-06 23:10:26'),(2186,'default','added',16452,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-06 23:18:02','2023-06-06 23:18:02'),(2187,'default','added',16453,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":36890.2}}',NULL,'2023-06-06 23:22:17','2023-06-06 23:22:17'),(2188,'default','added',16454,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-06 23:22:53','2023-06-06 23:22:53'),(2189,'default','added',16455,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2.23}}',NULL,'2023-06-06 23:24:23','2023-06-06 23:24:23'),(2190,'default','added',16456,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":711.4}}',NULL,'2023-06-06 23:28:11','2023-06-06 23:28:11'),(2191,'default','added',16457,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-06-06 23:32:48','2023-06-06 23:32:48'),(2192,'default','added',16458,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":399.3}}',NULL,'2023-06-06 23:44:33','2023-06-06 23:44:33'),(2193,'default','added',16459,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4552.88}}',NULL,'2023-06-06 23:51:01','2023-06-06 23:51:01'),(2194,'default','added',16460,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-06 23:53:40','2023-06-06 23:53:40'),(2195,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-06 23:56:08','2023-06-06 23:56:08'),(2196,'default','added',16461,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-06 23:57:01','2023-06-06 23:57:01'),(2197,'default','added',16462,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-06-07 00:02:40','2023-06-07 00:02:40'),(2198,'default','added',16463,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":460.71}}',NULL,'2023-06-07 00:06:21','2023-06-07 00:06:21'),(2199,'default','added',16464,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2358.75}}',NULL,'2023-06-07 00:09:50','2023-06-07 00:09:50'),(2200,'default','added',16465,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":163.26}}',NULL,'2023-06-07 00:14:48','2023-06-07 00:14:48'),(2201,'default','added',16466,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-07 00:21:45','2023-06-07 00:21:45'),(2202,'default','added',16467,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-07 00:24:35','2023-06-07 00:24:35'),(2203,'default','added',16468,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-07 00:24:48','2023-06-07 00:24:48'),(2204,'default','added',16469,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147.25}}',NULL,'2023-06-07 00:29:37','2023-06-07 00:29:37'),(2205,'default','added',16470,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1572.5}}',NULL,'2023-06-07 00:35:40','2023-06-07 00:35:40'),(2206,'default','payment_edited',5813,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:45:05','2023-06-07 00:45:05'),(2207,'default','payment_edited',5810,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:46:26','2023-06-07 00:46:26'),(2208,'default','added',16471,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-07 00:47:03','2023-06-07 00:47:03'),(2209,'default','payment_edited',5805,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:47:43','2023-06-07 00:47:43'),(2210,'default','payment_edited',5874,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21000.0000\"}}',NULL,'2023-06-07 00:47:43','2023-06-07 00:47:43'),(2211,'default','payment_edited',5756,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:48:38','2023-06-07 00:48:38'),(2212,'default','payment_edited',5833,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:51:13','2023-06-07 00:51:13'),(2213,'default','payment_edited',5833,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:52:08','2023-06-07 00:52:08'),(2214,'default','added',16472,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-07 00:52:14','2023-06-07 00:52:14'),(2215,'default','added',16473,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":447.96}}',NULL,'2023-06-07 00:52:55','2023-06-07 00:52:55'),(2216,'default','payment_edited',5817,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:53:21','2023-06-07 00:53:21'),(2217,'default','payment_edited',5820,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 00:55:14','2023-06-07 00:55:14'),(2218,'default','added',16474,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4.85}}',NULL,'2023-06-07 00:57:55','2023-06-07 00:57:55'),(2219,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-07 00:59:13','2023-06-07 00:59:13'),(2220,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-07 00:59:51','2023-06-07 00:59:51'),(2221,'default','added',16475,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-07 01:00:59','2023-06-07 01:00:59'),(2222,'default','payment_edited',5831,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 01:06:10','2023-06-07 01:06:10'),(2223,'default','added',16476,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":738.13}}',NULL,'2023-06-07 01:09:10','2023-06-07 01:09:10'),(2224,'default','added',16477,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1240}}',NULL,'2023-06-07 01:09:39','2023-06-07 01:09:39'),(2225,'default','added',16478,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.36}}',NULL,'2023-06-07 01:23:25','2023-06-07 01:23:25'),(2226,'default','added',16479,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.94}}',NULL,'2023-06-07 01:40:38','2023-06-07 01:40:38'),(2227,'default','added',16480,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-06-07 01:43:11','2023-06-07 01:43:11'),(2228,'default','added',16481,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.08}}',NULL,'2023-06-07 01:43:56','2023-06-07 01:43:56'),(2229,'default','added',16482,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-06-07 01:57:04','2023-06-07 01:57:04'),(2230,'default','added',16483,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2230}}',NULL,'2023-06-07 01:57:37','2023-06-07 01:57:37'),(2231,'default','added',16484,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-06-07 01:59:09','2023-06-07 01:59:09'),(2232,'default','added',16485,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-07 02:01:44','2023-06-07 02:01:44'),(2233,'default','added',16486,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":880}}',NULL,'2023-06-07 02:29:54','2023-06-07 02:29:54'),(2234,'default','added',16487,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1649.44}}',NULL,'2023-06-07 02:30:39','2023-06-07 02:30:39'),(2235,'default','payment_edited',5834,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 02:33:14','2023-06-07 02:33:14'),(2236,'default','added',16488,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":148.65}}',NULL,'2023-06-07 02:34:07','2023-06-07 02:34:07'),(2237,'default','added',16489,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":864}}',NULL,'2023-06-07 02:34:08','2023-06-07 02:34:08'),(2238,'default','added',16490,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-07 02:50:39','2023-06-07 02:50:39'),(2239,'default','added',16491,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.58}}',NULL,'2023-06-07 02:52:46','2023-06-07 02:52:46'),(2240,'default','added',16492,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-07 03:02:48','2023-06-07 03:02:48'),(2241,'default','added',16493,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-06-07 03:06:34','2023-06-07 03:06:34'),(2242,'default','added',16494,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.99}}',NULL,'2023-06-07 03:12:39','2023-06-07 03:12:39'),(2243,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-07 03:20:24','2023-06-07 03:20:24'),(2244,'default','added',16495,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":101.2}}',NULL,'2023-06-07 03:33:25','2023-06-07 03:33:25'),(2245,'default','added',16496,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86.93}}',NULL,'2023-06-07 03:40:32','2023-06-07 03:40:32'),(2246,'default','added',16497,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":181.1}}',NULL,'2023-06-07 04:00:00','2023-06-07 04:00:00'),(2247,'default','added',16498,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":941.4}}',NULL,'2023-06-07 04:06:19','2023-06-07 04:06:19'),(2248,'default','added',16499,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-07 04:17:32','2023-06-07 04:17:32'),(2249,'default','added',16500,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1144.86}}',NULL,'2023-06-07 04:18:08','2023-06-07 04:18:08'),(2250,'default','added',16501,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":789.36}}',NULL,'2023-06-07 04:24:54','2023-06-07 04:24:54'),(2251,'default','added',16502,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-07 04:28:16','2023-06-07 04:28:16'),(2252,'default','added',16503,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":518.84}}',NULL,'2023-06-07 04:32:54','2023-06-07 04:32:54'),(2253,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-07 14:16:04','2023-06-07 14:16:04'),(2254,'default','added',16504,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1459.4}}',NULL,'2023-06-07 14:30:16','2023-06-07 14:30:16'),(2255,'default','added',16505,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":927}}',NULL,'2023-06-07 15:29:15','2023-06-07 15:29:15'),(2256,'default','added',16506,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29.7}}',NULL,'2023-06-07 15:40:44','2023-06-07 15:40:44'),(2257,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-07 15:42:21','2023-06-07 15:42:21'),(2258,'default','added',16507,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":193}}',NULL,'2023-06-07 15:43:27','2023-06-07 15:43:27'),(2259,'default','added',16508,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}',NULL,'2023-06-07 16:13:43','2023-06-07 16:13:43'),(2260,'default','added',16509,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1038.15}}',NULL,'2023-06-07 16:21:00','2023-06-07 16:21:00'),(2261,'default','added',16510,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.42}}',NULL,'2023-06-07 16:26:49','2023-06-07 16:26:49'),(2262,'default','added',16511,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1699.3}}',NULL,'2023-06-07 16:40:34','2023-06-07 16:40:34'),(2263,'default','added',16512,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.9}}',NULL,'2023-06-07 17:11:05','2023-06-07 17:11:05'),(2264,'default','added',16513,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24}}',NULL,'2023-06-07 17:20:10','2023-06-07 17:20:10'),(2265,'default','added',16514,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-07 17:41:36','2023-06-07 17:41:36'),(2266,'default','added',16515,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":168.3}}',NULL,'2023-06-07 18:04:14','2023-06-07 18:04:14'),(2267,'default','added',16516,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1513.75}}',NULL,'2023-06-07 18:07:45','2023-06-07 18:07:45'),(2268,'default','added',16517,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-07 18:24:54','2023-06-07 18:24:54'),(2269,'default','added',16518,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-06-07 18:45:47','2023-06-07 18:45:47'),(2270,'default','added',16519,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43}}',NULL,'2023-06-07 18:57:50','2023-06-07 18:57:50'),(2271,'default','added',16520,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":362.5}}',NULL,'2023-06-07 19:03:53','2023-06-07 19:03:53'),(2272,'default','edited',16520,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"362.5000\"}}',NULL,'2023-06-07 19:06:50','2023-06-07 19:06:50'),(2274,'default','added',16521,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1119.54}}',NULL,'2023-06-07 19:20:12','2023-06-07 19:20:12'),(2275,'default','added',16522,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-06-07 19:22:03','2023-06-07 19:22:03'),(2276,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-07 19:29:48','2023-06-07 19:29:48'),(2277,'default','added',16523,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":734}}',NULL,'2023-06-07 19:29:56','2023-06-07 19:29:56'),(2278,'default','added',16524,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-07 19:46:26','2023-06-07 19:46:26'),(2279,'default','added',16525,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-07 19:54:52','2023-06-07 19:54:52'),(2280,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-07 20:17:37','2023-06-07 20:17:37'),(2281,'default','added',16526,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":576.6}}',NULL,'2023-06-07 20:18:17','2023-06-07 20:18:17'),(2282,'default','edited',16526,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"576.6000\"}}',NULL,'2023-06-07 20:20:06','2023-06-07 20:20:06'),(2283,'default','added',16527,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-07 20:20:35','2023-06-07 20:20:35'),(2284,'default','added',16528,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":399}}',NULL,'2023-06-07 20:26:14','2023-06-07 20:26:14'),(2285,'default','added',16529,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700.25}}',NULL,'2023-06-07 20:26:53','2023-06-07 20:26:53'),(2286,'default','added',16530,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":213.75}}',NULL,'2023-06-07 20:29:11','2023-06-07 20:29:11'),(2287,'default','added',16531,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":209.08}}',NULL,'2023-06-07 20:49:44','2023-06-07 20:49:44'),(2288,'default','added',16532,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23495.94}}',NULL,'2023-06-07 20:52:31','2023-06-07 20:52:31'),(2289,'default','added',16533,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1164.5}}',NULL,'2023-06-07 20:57:41','2023-06-07 20:57:41'),(2290,'default','added',16534,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":21054.93}}',NULL,'2023-06-07 21:00:46','2023-06-07 21:00:46'),(2291,'default','added',16535,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":576}}',NULL,'2023-06-07 21:02:39','2023-06-07 21:02:39'),(2292,'default','added',16536,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-07 21:14:07','2023-06-07 21:14:07'),(2293,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-07 21:16:34','2023-06-07 21:16:34'),(2294,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-07 21:16:50','2023-06-07 21:16:50'),(2295,'default','added',16537,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1300.5}}',NULL,'2023-06-07 21:19:37','2023-06-07 21:19:37'),(2296,'default','added',16538,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":680}}',NULL,'2023-06-07 21:31:41','2023-06-07 21:31:41'),(2297,'default','added',16539,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2469}}',NULL,'2023-06-07 21:33:27','2023-06-07 21:33:27'),(2298,'default','added',16540,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1187.5}}',NULL,'2023-06-07 21:47:54','2023-06-07 21:47:54'),(2299,'default','added',16541,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1546.4}}',NULL,'2023-06-07 22:15:29','2023-06-07 22:15:29'),(2300,'default','added',16542,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":15278.5}}',NULL,'2023-06-07 22:25:12','2023-06-07 22:25:12'),(2301,'default','added',16543,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5505}}',NULL,'2023-06-07 22:34:11','2023-06-07 22:34:11'),(2302,'default','added',16544,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70.4}}',NULL,'2023-06-07 22:37:50','2023-06-07 22:37:50'),(2303,'default','added',16545,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90.12}}',NULL,'2023-06-07 22:58:31','2023-06-07 22:58:31'),(2304,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-07 23:00:52','2023-06-07 23:00:52'),(2305,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-07 23:01:42','2023-06-07 23:01:42'),(2306,'default','added',16546,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1274.78}}',NULL,'2023-06-07 23:02:44','2023-06-07 23:02:44'),(2307,'default','added',16547,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":16600.93}}',NULL,'2023-06-07 23:10:55','2023-06-07 23:10:55'),(2308,'default','added',16548,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-07 23:18:42','2023-06-07 23:18:42'),(2309,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:35:18','2023-06-07 23:35:18'),(2310,'default','payment_edited',5809,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:37:15','2023-06-07 23:37:15'),(2311,'default','payment_edited',5818,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:38:23','2023-06-07 23:38:23'),(2312,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:39:53','2023-06-07 23:39:53'),(2313,'default','payment_edited',5795,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:40:47','2023-06-07 23:40:47'),(2314,'default','payment_edited',5870,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17326.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17326.0000\"}}',NULL,'2023-06-07 23:40:47','2023-06-07 23:40:47'),(2315,'default','added',16549,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-07 23:40:50','2023-06-07 23:40:50'),(2316,'default','payment_edited',5842,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:41:30','2023-06-07 23:41:30'),(2317,'default','payment_edited',5830,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:43:41','2023-06-07 23:43:41'),(2318,'default','payment_edited',5830,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-07 23:44:16','2023-06-07 23:44:16'),(2319,'default','added',16550,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9.86}}',NULL,'2023-06-07 23:44:54','2023-06-07 23:44:54'),(2320,'default','added',16551,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":855}}',NULL,'2023-06-07 23:51:16','2023-06-07 23:51:16'),(2321,'default','added',16552,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1669.8}}',NULL,'2023-06-07 23:52:04','2023-06-07 23:52:04'),(2322,'default','added',16553,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1104}}',NULL,'2023-06-07 23:53:10','2023-06-07 23:53:10'),(2323,'default','added',16554,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-07 23:54:17','2023-06-07 23:54:17'),(2324,'default','added',16555,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-06-08 00:21:02','2023-06-08 00:21:02'),(2325,'default','added',16556,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-08 00:27:25','2023-06-08 00:27:25'),(2326,'default','added',16557,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-08 00:28:52','2023-06-08 00:28:52'),(2327,'default','added',16558,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133.81}}',NULL,'2023-06-08 00:30:39','2023-06-08 00:30:39'),(2328,'default','added',16559,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4200.73}}',NULL,'2023-06-08 00:33:32','2023-06-08 00:33:32'),(2329,'default','added',16560,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129}}',NULL,'2023-06-08 00:37:11','2023-06-08 00:37:11'),(2330,'default','added',16561,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.8}}',NULL,'2023-06-08 00:37:29','2023-06-08 00:37:29'),(2331,'default','added',16562,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3305.72}}',NULL,'2023-06-08 00:44:05','2023-06-08 00:44:05'),(2332,'default','added',16563,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":718.42}}',NULL,'2023-06-08 00:44:56','2023-06-08 00:44:56'),(2333,'default','added',16564,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-08 00:49:15','2023-06-08 00:49:15'),(2334,'default','added',16565,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1672.8}}',NULL,'2023-06-08 00:51:32','2023-06-08 00:51:32'),(2335,'default','added',16566,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.6}}',NULL,'2023-06-08 00:52:01','2023-06-08 00:52:01'),(2336,'default','added',16567,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5269.95}}',NULL,'2023-06-08 01:00:17','2023-06-08 01:00:17'),(2337,'default','added',16568,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1237.5}}',NULL,'2023-06-08 01:04:24','2023-06-08 01:04:25'),(2338,'default','added',16569,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-08 01:05:48','2023-06-08 01:05:48'),(2339,'default','added',16570,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800}}',NULL,'2023-06-08 01:09:09','2023-06-08 01:09:09'),(2340,'default','added',16571,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":642.5}}',NULL,'2023-06-08 01:14:06','2023-06-08 01:14:06'),(2341,'default','added',16572,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2203.53}}',NULL,'2023-06-08 01:16:48','2023-06-08 01:16:48'),(2342,'default','added',16573,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-08 01:21:54','2023-06-08 01:21:54'),(2343,'default','added',16574,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-08 01:27:29','2023-06-08 01:27:29'),(2344,'default','added',16575,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":963.75}}',NULL,'2023-06-08 01:31:28','2023-06-08 01:31:28'),(2345,'default','added',16576,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41}}',NULL,'2023-06-08 01:59:53','2023-06-08 01:59:53'),(2346,'default','added',16577,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":104.44}}',NULL,'2023-06-08 02:02:14','2023-06-08 02:02:14'),(2347,'default','added',16578,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":438.8}}',NULL,'2023-06-08 02:18:39','2023-06-08 02:18:39'),(2348,'default','added',16579,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2023-06-08 02:31:00','2023-06-08 02:31:00'),(2349,'default','added',16580,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-08 02:35:08','2023-06-08 02:35:08'),(2350,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-08 02:45:18','2023-06-08 02:45:18'),(2351,'default','added',16581,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":178.07}}',NULL,'2023-06-08 02:46:07','2023-06-08 02:46:07'),(2352,'default','added',16582,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":202.7}}',NULL,'2023-06-08 02:56:50','2023-06-08 02:56:50'),(2353,'default','added',16583,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}',NULL,'2023-06-08 02:59:06','2023-06-08 02:59:06'),(2354,'default','added',16584,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1013.6}}',NULL,'2023-06-08 03:00:39','2023-06-08 03:00:39'),(2355,'default','added',16585,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-08 03:03:31','2023-06-08 03:03:31'),(2356,'default','added',16586,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-08 03:04:54','2023-06-08 03:04:54'),(2357,'default','added',16587,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-08 03:32:48','2023-06-08 03:32:48'),(2358,'default','added',16588,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-08 03:53:57','2023-06-08 03:53:57'),(2359,'default','added',16589,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":642.51}}',NULL,'2023-06-08 04:06:50','2023-06-08 04:06:50'),(2360,'default','added',16590,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":609.64}}',NULL,'2023-06-08 04:08:32','2023-06-08 04:08:32'),(2361,'default','added',16591,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":106.59}}',NULL,'2023-06-08 04:34:18','2023-06-08 04:34:18'),(2362,'default','added',16592,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-08 04:36:23','2023-06-08 04:36:23'),(2363,'default','added',16593,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-08 04:36:58','2023-06-08 04:36:58'),(2364,'default','added',16594,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-08 04:37:41','2023-06-08 04:37:41'),(2365,'default','added',16595,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.28}}',NULL,'2023-06-08 04:46:07','2023-06-08 04:46:07'),(2366,'default','added',16596,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48.01}}',NULL,'2023-06-08 04:54:22','2023-06-08 04:54:22'),(2367,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-08 13:58:13','2023-06-08 13:58:13'),(2368,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 14:27:15','2023-06-08 14:27:15'),(2369,'default','added',16597,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-08 14:31:21','2023-06-08 14:31:21'),(2370,'default','added',16598,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-08 15:03:21','2023-06-08 15:03:21'),(2371,'default','added',16599,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":63756}}',NULL,'2023-06-08 15:03:36','2023-06-08 15:03:36'),(2372,'default','added',16600,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":842.34}}',NULL,'2023-06-08 15:16:30','2023-06-08 15:16:30'),(2373,'default','added',16601,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":629.3}}',NULL,'2023-06-08 15:39:16','2023-06-08 15:39:16'),(2374,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 15:43:40','2023-06-08 15:43:40'),(2375,'default','added',16602,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":137.1}}',NULL,'2023-06-08 15:58:26','2023-06-08 15:58:26'),(2376,'default','added',16603,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2023-06-08 16:03:05','2023-06-08 16:03:05'),(2377,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-08 16:07:49','2023-06-08 16:07:49'),(2378,'default','added',16604,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":655.54}}',NULL,'2023-06-08 16:08:11','2023-06-08 16:08:11'),(2379,'default','added',16605,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-08 16:13:30','2023-06-08 16:13:30'),(2380,'default','added',16606,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-08 16:30:55','2023-06-08 16:30:55'),(2381,'default','added',16607,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-08 16:35:44','2023-06-08 16:35:44'),(2382,'default','added',16608,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-08 16:36:05','2023-06-08 16:36:05'),(2383,'default','added',16609,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18.53}}',NULL,'2023-06-08 16:40:59','2023-06-08 16:40:59'),(2384,'default','added',16610,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-08 17:10:58','2023-06-08 17:10:58'),(2385,'default','added',16611,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":332}}',NULL,'2023-06-08 17:28:17','2023-06-08 17:28:17'),(2386,'default','added',16612,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-08 17:30:55','2023-06-08 17:30:55'),(2387,'default','added',16613,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2621}}',NULL,'2023-06-08 17:52:23','2023-06-08 17:52:23'),(2388,'default','added',16614,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":235.2}}',NULL,'2023-06-08 18:07:27','2023-06-08 18:07:27'),(2389,'default','edited',16614,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":235.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"235.2000\"}}',NULL,'2023-06-08 18:10:30','2023-06-08 18:10:30'),(2390,'default','added',16615,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-08 18:22:17','2023-06-08 18:22:17'),(2391,'default','added',16616,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":87.4}}',NULL,'2023-06-08 18:36:36','2023-06-08 18:36:36'),(2392,'default','added',16617,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1002.4}}',NULL,'2023-06-08 18:44:09','2023-06-08 18:44:09'),(2393,'default','added',16618,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1220.01}}',NULL,'2023-06-08 18:54:33','2023-06-08 18:54:33'),(2394,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 19:01:42','2023-06-08 19:01:42'),(2395,'default','added',16619,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-08 19:23:54','2023-06-08 19:23:54'),(2396,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 19:44:13','2023-06-08 19:44:13'),(2397,'default','payment_edited',5827,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 19:49:23','2023-06-08 19:49:23'),(2398,'default','payment_edited',5825,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-08 19:51:43','2023-06-08 19:51:43'),(2399,'default','added',16620,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":108}}',NULL,'2023-06-08 19:53:26','2023-06-08 19:53:26'),(2400,'default','added',16621,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2529.61}}',NULL,'2023-06-08 20:01:08','2023-06-08 20:01:08'),(2401,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-08 20:03:10','2023-06-08 20:03:11'),(2402,'default','added',16622,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38}}',NULL,'2023-06-08 20:06:52','2023-06-08 20:06:52'),(2403,'default','added',16623,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":519.2}}',NULL,'2023-06-08 20:33:16','2023-06-08 20:33:16'),(2404,'default','added',16624,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55}}',NULL,'2023-06-08 20:49:39','2023-06-08 20:49:39'),(2405,'default','added',16625,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":299.07}}',NULL,'2023-06-08 21:16:38','2023-06-08 21:16:38'),(2406,'default','added',16626,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490.42}}',NULL,'2023-06-08 21:35:25','2023-06-08 21:35:25'),(2407,'default','added',16627,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-08 21:38:38','2023-06-08 21:38:38'),(2408,'default','added',16628,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-08 21:42:01','2023-06-08 21:42:01'),(2409,'default','added',16629,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1474.19}}',NULL,'2023-06-08 21:43:42','2023-06-08 21:43:42'),(2410,'default','added',16630,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-08 21:55:44','2023-06-08 21:55:44'),(2411,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-08 22:03:45','2023-06-08 22:03:45'),(2412,'default','added',16631,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-08 22:15:29','2023-06-08 22:15:29'),(2413,'default','added',16632,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-08 22:28:48','2023-06-08 22:28:48'),(2414,'default','added',16633,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-08 23:09:56','2023-06-08 23:09:56'),(2415,'default','added',16634,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1704.03}}',NULL,'2023-06-08 23:22:48','2023-06-08 23:22:48'),(2416,'default','added',16635,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":630}}',NULL,'2023-06-08 23:23:15','2023-06-08 23:23:15'),(2417,'default','added',16636,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-08 23:27:07','2023-06-08 23:27:07'),(2418,'default','added',16637,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":260}}',NULL,'2023-06-08 23:32:15','2023-06-08 23:32:15'),(2419,'default','added',16638,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1719.2}}',NULL,'2023-06-08 23:39:04','2023-06-08 23:39:04'),(2420,'default','added',16639,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":789.36}}',NULL,'2023-06-08 23:45:10','2023-06-08 23:45:10'),(2421,'default','added',16640,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-08 23:50:28','2023-06-08 23:50:28'),(2422,'default','added',16641,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-09 00:08:06','2023-06-09 00:08:06'),(2423,'default','added',16642,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-06-09 00:17:06','2023-06-09 00:17:06'),(2424,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-09 00:18:17','2023-06-09 00:18:17'),(2425,'default','added',16643,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1108.33}}',NULL,'2023-06-09 00:20:16','2023-06-09 00:20:16'),(2426,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 00:21:55','2023-06-09 00:21:55'),(2427,'default','added',16644,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2502}}',NULL,'2023-06-09 00:30:00','2023-06-09 00:30:00'),(2428,'default','added',16645,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-06-09 00:33:42','2023-06-09 00:33:42'),(2429,'default','added',16646,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.75}}',NULL,'2023-06-09 00:39:13','2023-06-09 00:39:13'),(2430,'default','added',16647,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-09 00:51:34','2023-06-09 00:51:34'),(2431,'default','added',16648,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198.4}}',NULL,'2023-06-09 01:02:09','2023-06-09 01:02:09'),(2432,'default','added',16649,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198.4}}',NULL,'2023-06-09 01:02:23','2023-06-09 01:02:23'),(2433,'default','added',16650,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720}}',NULL,'2023-06-09 01:27:06','2023-06-09 01:27:06'),(2434,'default','added',16651,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133.7}}',NULL,'2023-06-09 01:27:27','2023-06-09 01:27:27'),(2435,'default','added',16652,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":324}}',NULL,'2023-06-09 01:35:44','2023-06-09 01:35:44'),(2436,'default','added',16653,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":227.7}}',NULL,'2023-06-09 01:38:01','2023-06-09 01:38:01'),(2437,'default','added',16654,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-06-09 01:38:59','2023-06-09 01:38:59'),(2438,'default','added',16655,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":530}}',NULL,'2023-06-09 01:46:20','2023-06-09 01:46:20'),(2439,'default','added',16656,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":279.3}}',NULL,'2023-06-09 01:52:16','2023-06-09 01:52:16'),(2440,'default','added',16657,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.57}}',NULL,'2023-06-09 01:56:44','2023-06-09 01:56:44'),(2441,'default','added',16658,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":230}}',NULL,'2023-06-09 02:03:47','2023-06-09 02:03:47'),(2442,'default','added',16659,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-06-09 02:07:53','2023-06-09 02:07:53'),(2443,'default','added',16660,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-09 02:09:56','2023-06-09 02:09:56'),(2444,'default','added',16661,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-09 02:10:29','2023-06-09 02:10:29'),(2445,'default','added',16662,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-09 02:12:20','2023-06-09 02:12:20'),(2446,'default','added',16663,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-09 02:13:33','2023-06-09 02:13:33'),(2447,'default','added',16664,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76}}',NULL,'2023-06-09 02:20:54','2023-06-09 02:20:54'),(2448,'default','added',16665,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":142.5}}',NULL,'2023-06-09 02:21:31','2023-06-09 02:21:31'),(2449,'default','added',16666,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}',NULL,'2023-06-09 02:35:49','2023-06-09 02:35:49'),(2450,'default','added',16667,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-09 03:00:14','2023-06-09 03:00:14'),(2451,'default','added',16668,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237.5}}',NULL,'2023-06-09 03:22:24','2023-06-09 03:22:24'),(2452,'default','added',16669,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.83}}',NULL,'2023-06-09 03:28:58','2023-06-09 03:28:58'),(2453,'default','added',16670,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":178.05}}',NULL,'2023-06-09 03:38:37','2023-06-09 03:38:37'),(2454,'default','added',16671,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-09 03:41:20','2023-06-09 03:41:20'),(2455,'default','added',16672,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}',NULL,'2023-06-09 03:47:38','2023-06-09 03:47:38'),(2456,'default','added',16673,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-09 03:52:33','2023-06-09 03:52:33'),(2457,'default','added',16674,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-06-09 03:57:47','2023-06-09 03:57:47'),(2458,'default','added',16675,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":453.87}}',NULL,'2023-06-09 03:58:07','2023-06-09 03:58:07'),(2459,'default','added',16676,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29.02}}',NULL,'2023-06-09 04:19:56','2023-06-09 04:19:56'),(2460,'default','added',16677,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-09 04:33:57','2023-06-09 04:33:57'),(2461,'default','added',16678,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-09 04:40:52','2023-06-09 04:40:52'),(2462,'default','added',16679,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":149.81}}',NULL,'2023-06-09 04:42:10','2023-06-09 04:42:10'),(2463,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-09 06:02:01','2023-06-09 06:02:01'),(2464,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 17:00:37','2023-06-09 17:00:37'),(2465,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-09 17:02:21','2023-06-09 17:02:21'),(2466,'default','added',16680,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-09 17:07:19','2023-06-09 17:07:19'),(2467,'default','added',16681,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":486.3}}',NULL,'2023-06-09 17:08:19','2023-06-09 17:08:19'),(2468,'default','added',16682,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-06-09 17:24:10','2023-06-09 17:24:10'),(2469,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 17:32:24','2023-06-09 17:32:24'),(2470,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-09 17:50:46','2023-06-09 17:50:46'),(2471,'default','added',16683,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1488.6}}',NULL,'2023-06-09 17:55:11','2023-06-09 17:55:11'),(2472,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-09 18:09:31','2023-06-09 18:09:31'),(2473,'default','added',16684,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68.7}}',NULL,'2023-06-09 18:16:27','2023-06-09 18:16:27'),(2474,'default','added',16685,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-09 18:19:06','2023-06-09 18:19:06'),(2475,'default','added',16686,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1059.1}}',NULL,'2023-06-09 18:46:25','2023-06-09 18:46:25'),(2476,'default','added',16687,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-06-09 18:48:47','2023-06-09 18:48:47'),(2477,'default','edited',16687,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":297.3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"}}',NULL,'2023-06-09 18:59:51','2023-06-09 18:59:51'),(2478,'default','added',16688,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":260}}',NULL,'2023-06-09 19:43:12','2023-06-09 19:43:12'),(2479,'default','added',16689,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-06-09 20:07:55','2023-06-09 20:07:55'),(2480,'default','added',16690,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-09 20:08:33','2023-06-09 20:08:33'),(2481,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 20:14:52','2023-06-09 20:14:52'),(2482,'default','added',16691,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-09 20:50:22','2023-06-09 20:50:22'),(2483,'default','added',16692,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":365.75}}',NULL,'2023-06-09 20:51:05','2023-06-09 20:51:05'),(2484,'default','added',16693,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-09 20:53:48','2023-06-09 20:53:48'),(2485,'default','added',16694,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-09 20:55:52','2023-06-09 20:55:52'),(2486,'default','edited',16693,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}',NULL,'2023-06-09 20:57:15','2023-06-09 20:57:15'),(2487,'default','payment_edited',5830,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:11:59','2023-06-09 21:11:59'),(2488,'default','added',16695,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":295.11}}',NULL,'2023-06-09 21:12:37','2023-06-09 21:12:37'),(2489,'default','payment_edited',5754,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:13:26','2023-06-09 21:13:26'),(2490,'default','added',16696,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1020.8}}',NULL,'2023-06-09 21:13:55','2023-06-09 21:13:55'),(2491,'default','payment_edited',5809,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:14:33','2023-06-09 21:14:33'),(2492,'default','payment_edited',5790,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:16:40','2023-06-09 21:16:40'),(2493,'default','payment_edited',5821,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:18:06','2023-06-09 21:18:06'),(2494,'default','payment_edited',5789,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:18:55','2023-06-09 21:18:55'),(2495,'default','payment_edited',5784,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:19:39','2023-06-09 21:19:39'),(2496,'default','payment_edited',16099,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-06-09 21:20:32','2023-06-09 21:20:32'),(2497,'default','payment_edited',5783,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:20:32','2023-06-09 21:20:32'),(2498,'default','payment_edited',5779,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:21:23','2023-06-09 21:21:23'),(2499,'default','payment_edited',5778,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:21:55','2023-06-09 21:21:55'),(2500,'default','payment_edited',5776,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:22:36','2023-06-09 21:22:36'),(2501,'default','payment_edited',5775,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 21:23:16','2023-06-09 21:23:16'),(2502,'default','added',16697,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3390}}',NULL,'2023-06-09 21:25:16','2023-06-09 21:25:16'),(2503,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-09 21:28:29','2023-06-09 21:28:29'),(2504,'default','added',16698,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":158.8}}',NULL,'2023-06-09 21:29:46','2023-06-09 21:29:46'),(2505,'default','edited',16698,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79.4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"158.8000\"}}',NULL,'2023-06-09 21:31:17','2023-06-09 21:31:17'),(2506,'default','added',16699,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":305.48}}',NULL,'2023-06-09 21:37:54','2023-06-09 21:37:54'),(2507,'default','added',16700,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-09 21:45:05','2023-06-09 21:45:05'),(2508,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-09 21:47:11','2023-06-09 21:47:11'),(2509,'default','added',16701,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-09 21:55:59','2023-06-09 21:55:59'),(2510,'default','added',16702,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7446}}',NULL,'2023-06-09 22:02:38','2023-06-09 22:02:38'),(2511,'default','edited',16702,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7446},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7446.0000\"}}',NULL,'2023-06-09 22:03:24','2023-06-09 22:03:24'),(2512,'default','sell_deleted',16702,'App\\Transaction',NULL,3,3,'App\\User','{\"id\":16702,\"invoice_no\":\"0051\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7446.0000\"}}',NULL,'2023-06-09 22:08:34','2023-06-09 22:08:34'),(2513,'default','added',16703,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2371.56}}',NULL,'2023-06-09 22:16:06','2023-06-09 22:16:07'),(2514,'default','added',16704,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-09 22:18:32','2023-06-09 22:18:32'),(2515,'default','added',143,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 22:18:39','2023-06-09 22:18:39'),(2516,'default','added',16705,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-09 22:22:21','2023-06-09 22:22:21'),(2517,'default','added',16706,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-06-09 22:23:18','2023-06-09 22:23:18'),(2518,'default','added',16707,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":191}}',NULL,'2023-06-09 22:31:19','2023-06-09 22:31:19'),(2519,'default','added',16708,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-09 22:31:46','2023-06-09 22:31:46'),(2520,'default','added',16709,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":308.2}}',NULL,'2023-06-09 22:36:19','2023-06-09 22:36:19'),(2521,'default','added',16710,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.21}}',NULL,'2023-06-09 22:45:14','2023-06-09 22:45:14'),(2522,'default','added',16711,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-09 22:52:18','2023-06-09 22:52:18'),(2523,'default','added',16712,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-09 23:01:26','2023-06-09 23:01:26'),(2524,'default','added',16713,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":378.18}}',NULL,'2023-06-09 23:02:53','2023-06-09 23:02:53'),(2525,'default','added',16714,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-09 23:07:04','2023-06-09 23:07:04'),(2526,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-09 23:21:43','2023-06-09 23:21:43'),(2527,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-09 23:35:14','2023-06-09 23:35:14'),(2528,'default','added',16715,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490.42}}',NULL,'2023-06-09 23:36:12','2023-06-09 23:36:12'),(2529,'default','added',16716,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-09 23:39:55','2023-06-09 23:39:55'),(2530,'default','added',16717,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8538}}',NULL,'2023-06-09 23:41:42','2023-06-09 23:41:42'),(2531,'default','added',16718,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.58}}',NULL,'2023-06-09 23:44:45','2023-06-09 23:44:45'),(2532,'default','added',16719,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3750.24}}',NULL,'2023-06-09 23:47:25','2023-06-09 23:47:25'),(2533,'default','added',16720,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-10 00:00:08','2023-06-10 00:00:08'),(2534,'default','added',16721,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":470.26}}',NULL,'2023-06-10 00:12:55','2023-06-10 00:12:55'),(2535,'default','added',16722,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-10 00:46:44','2023-06-10 00:46:44'),(2536,'default','added',16723,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-10 00:47:24','2023-06-10 00:47:24'),(2537,'default','added',16724,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":597.18}}',NULL,'2023-06-10 01:02:05','2023-06-10 01:02:05'),(2538,'default','added',16725,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20.52}}',NULL,'2023-06-10 01:03:06','2023-06-10 01:03:06'),(2539,'default','added',16726,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.58}}',NULL,'2023-06-10 01:08:49','2023-06-10 01:08:49'),(2540,'default','added',16727,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-10 01:09:49','2023-06-10 01:09:49'),(2541,'default','added',16728,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-10 01:14:47','2023-06-10 01:14:47'),(2542,'default','added',16729,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1305.81}}',NULL,'2023-06-10 01:19:06','2023-06-10 01:19:06'),(2543,'default','added',16730,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":179.34}}',NULL,'2023-06-10 01:29:33','2023-06-10 01:29:33'),(2544,'default','added',16731,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19.62}}',NULL,'2023-06-10 01:53:59','2023-06-10 01:53:59'),(2545,'default','added',16732,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-06-10 02:26:55','2023-06-10 02:26:55'),(2546,'default','added',16733,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76.95}}',NULL,'2023-06-10 02:27:41','2023-06-10 02:27:41'),(2547,'default','added',16734,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-10 02:32:25','2023-06-10 02:32:25'),(2548,'default','added',16735,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1143.84}}',NULL,'2023-06-10 02:37:40','2023-06-10 02:37:40'),(2549,'default','added',16736,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-10 02:45:09','2023-06-10 02:45:09'),(2550,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-10 02:59:38','2023-06-10 02:59:38'),(2551,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 03:00:37','2023-06-10 03:00:37'),(2552,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 03:02:22','2023-06-10 03:02:22'),(2553,'default','added',16737,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":128.9}}',NULL,'2023-06-10 03:03:04','2023-06-10 03:03:04'),(2554,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-10 03:04:28','2023-06-10 03:04:28'),(2555,'default','added',16738,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-10 03:17:57','2023-06-10 03:17:57'),(2556,'default','added',16739,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":312.9}}',NULL,'2023-06-10 03:51:23','2023-06-10 03:51:23'),(2557,'default','added',16740,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":278.67}}',NULL,'2023-06-10 04:05:09','2023-06-10 04:05:09'),(2558,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 04:05:27','2023-06-10 04:05:27'),(2559,'default','added',16741,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-10 04:09:47','2023-06-10 04:09:47'),(2560,'default','added',16742,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-10 04:23:20','2023-06-10 04:23:20'),(2561,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 15:40:19','2023-06-10 15:40:19'),(2562,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-10 15:41:39','2023-06-10 15:41:39'),(2563,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-10 15:41:54','2023-06-10 15:41:54'),(2564,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-10 15:47:06','2023-06-10 15:47:07'),(2565,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-10 15:49:33','2023-06-10 15:49:33'),(2566,'default','added',16743,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-06-10 15:55:20','2023-06-10 15:55:20'),(2567,'default','added',16744,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1345}}',NULL,'2023-06-10 16:00:53','2023-06-10 16:00:53'),(2568,'default','added',16745,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-10 16:01:49','2023-06-10 16:01:49'),(2569,'default','added',16746,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.79}}',NULL,'2023-06-10 16:02:56','2023-06-10 16:02:56'),(2570,'default','added',16747,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1942.4}}',NULL,'2023-06-10 16:08:05','2023-06-10 16:08:05'),(2571,'default','added',16748,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-10 16:27:49','2023-06-10 16:27:49'),(2572,'default','added',16749,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-06-10 16:46:05','2023-06-10 16:46:06'),(2573,'default','added',16750,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13237.12}}',NULL,'2023-06-10 16:55:24','2023-06-10 16:55:24'),(2574,'default','added',16751,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-10 16:57:12','2023-06-10 16:57:12'),(2575,'default','added',16752,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450.96}}',NULL,'2023-06-10 17:10:11','2023-06-10 17:10:11'),(2576,'default','added',16753,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.53}}',NULL,'2023-06-10 17:21:30','2023-06-10 17:21:30'),(2577,'default','added',16754,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":106.1}}',NULL,'2023-06-10 17:31:44','2023-06-10 17:31:44'),(2578,'default','added',16755,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":15646.16}}',NULL,'2023-06-10 17:55:47','2023-06-10 17:55:47'),(2579,'default','added',16756,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-10 18:07:50','2023-06-10 18:07:50'),(2580,'default','added',16757,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29.7}}',NULL,'2023-06-10 18:09:43','2023-06-10 18:09:43'),(2581,'default','added',16758,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.72}}',NULL,'2023-06-10 18:29:02','2023-06-10 18:29:02'),(2582,'default','added',16759,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20.76}}',NULL,'2023-06-10 18:38:20','2023-06-10 18:38:20'),(2583,'default','added',16760,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-10 18:41:31','2023-06-10 18:41:31'),(2584,'default','added',16761,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-10 18:52:38','2023-06-10 18:52:38'),(2585,'default','added',16762,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":828.47}}',NULL,'2023-06-10 19:00:05','2023-06-10 19:00:05'),(2586,'default','added',16763,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-10 19:32:32','2023-06-10 19:32:32'),(2587,'default','added',16764,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28.25}}',NULL,'2023-06-10 19:32:32','2023-06-10 19:32:32'),(2588,'default','added',16765,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":153}}',NULL,'2023-06-10 19:37:45','2023-06-10 19:37:45'),(2589,'default','added',16766,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1753.9}}',NULL,'2023-06-10 20:02:16','2023-06-10 20:02:16'),(2590,'default','added',16767,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.1}}',NULL,'2023-06-10 20:50:48','2023-06-10 20:50:48'),(2591,'default','added',16768,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":223.62}}',NULL,'2023-06-10 21:00:42','2023-06-10 21:00:42'),(2592,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 21:30:32','2023-06-10 21:30:33'),(2593,'default','added',16769,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-10 21:45:14','2023-06-10 21:45:14'),(2594,'default','added',16770,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":65954}}',NULL,'2023-06-10 22:16:34','2023-06-10 22:16:34'),(2595,'default','added',16771,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":472.1}}',NULL,'2023-06-10 22:18:08','2023-06-10 22:18:08'),(2596,'default','added',16772,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.05}}',NULL,'2023-06-10 22:19:04','2023-06-10 22:19:04'),(2597,'default','added',16773,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72}}',NULL,'2023-06-10 22:45:18','2023-06-10 22:45:19'),(2598,'default','added',16774,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":260.6}}',NULL,'2023-06-10 22:46:05','2023-06-10 22:46:05'),(2599,'default','added',16775,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-10 22:47:47','2023-06-10 22:47:47'),(2600,'default','added',16776,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-10 22:55:44','2023-06-10 22:55:44'),(2601,'default','added',16777,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5438.73}}',NULL,'2023-06-10 22:57:59','2023-06-10 22:57:59'),(2602,'default','added',16778,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-06-10 23:10:38','2023-06-10 23:10:38'),(2603,'default','added',16779,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1237.5}}',NULL,'2023-06-10 23:14:05','2023-06-10 23:14:05'),(2604,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-10 23:16:44','2023-06-10 23:16:44'),(2605,'default','added',16780,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-10 23:18:44','2023-06-10 23:18:44'),(2606,'default','added',16781,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-10 23:20:03','2023-06-10 23:20:03'),(2607,'default','added',16782,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2529.61}}',NULL,'2023-06-10 23:21:24','2023-06-10 23:21:24'),(2608,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-10 23:31:57','2023-06-10 23:31:57'),(2609,'default','added',16783,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1180}}',NULL,'2023-06-10 23:41:58','2023-06-10 23:41:58'),(2610,'default','edited',16705,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-10 23:51:34','2023-06-10 23:51:34'),(2611,'default','added',16784,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-06-10 23:53:08','2023-06-10 23:53:08'),(2612,'default','edited',16705,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-10 23:56:16','2023-06-10 23:56:16'),(2613,'default','edited',16705,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-10 23:56:21','2023-06-10 23:56:21'),(2614,'default','added',16785,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5305.07}}',NULL,'2023-06-10 23:58:36','2023-06-10 23:58:36'),(2615,'default','added',16786,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525.88}}',NULL,'2023-06-11 00:09:09','2023-06-11 00:09:09'),(2616,'default','added',16787,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-11 00:11:34','2023-06-11 00:11:34'),(2617,'default','added',16788,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1292.84}}',NULL,'2023-06-11 00:14:28','2023-06-11 00:14:28'),(2618,'default','added',16789,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-11 00:15:52','2023-06-11 00:15:52'),(2619,'default','added',16790,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-11 00:18:42','2023-06-11 00:18:42'),(2620,'default','logout',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-11 00:23:28','2023-06-11 00:23:28'),(2621,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-11 00:23:58','2023-06-11 00:23:58'),(2622,'default','added',16791,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-06-11 00:28:26','2023-06-11 00:28:26'),(2623,'default','added',16792,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-11 00:35:12','2023-06-11 00:35:12'),(2624,'default','added',16793,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47}}',NULL,'2023-06-11 00:36:06','2023-06-11 00:36:06'),(2625,'default','added',16794,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":279.88}}',NULL,'2023-06-11 00:37:14','2023-06-11 00:37:14'),(2626,'default','added',16795,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-11 00:39:18','2023-06-11 00:39:18'),(2627,'default','added',16796,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-11 00:39:33','2023-06-11 00:39:33'),(2628,'default','added',16797,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-11 01:01:37','2023-06-11 01:01:37'),(2629,'default','added',16798,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-11 01:10:37','2023-06-11 01:10:37'),(2630,'default','added',16799,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.57}}',NULL,'2023-06-11 01:21:52','2023-06-11 01:21:52'),(2631,'default','added',16800,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-11 01:49:41','2023-06-11 01:49:41'),(2632,'default','added',16801,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":578.8}}',NULL,'2023-06-11 01:56:22','2023-06-11 01:56:22'),(2633,'default','added',16802,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":232.58}}',NULL,'2023-06-11 02:20:32','2023-06-11 02:20:32'),(2634,'default','added',16803,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":665}}',NULL,'2023-06-11 02:45:46','2023-06-11 02:45:46'),(2635,'default','added',16804,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480.85}}',NULL,'2023-06-11 02:48:44','2023-06-11 02:48:44'),(2636,'default','added',16805,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40.8}}',NULL,'2023-06-11 02:54:26','2023-06-11 02:54:26'),(2637,'default','added',16806,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":541.5}}',NULL,'2023-06-11 02:57:06','2023-06-11 02:57:06'),(2638,'default','added',16807,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-11 03:12:00','2023-06-11 03:12:00'),(2639,'default','added',16808,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-11 03:22:33','2023-06-11 03:22:33'),(2640,'default','added',16809,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":504.75}}',NULL,'2023-06-11 03:26:47','2023-06-11 03:26:47'),(2641,'default','added',16810,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-11 03:45:57','2023-06-11 03:45:57'),(2642,'default','added',16811,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-11 03:46:46','2023-06-11 03:46:46'),(2643,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-11 03:52:18','2023-06-11 03:52:18'),(2644,'default','added',16812,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74.5}}',NULL,'2023-06-11 03:54:50','2023-06-11 03:54:50'),(2645,'default','added',16813,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":58.4}}',NULL,'2023-06-11 03:59:12','2023-06-11 03:59:12'),(2646,'default','added',16814,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":116.8}}',NULL,'2023-06-11 03:59:53','2023-06-11 03:59:53'),(2647,'default','added',16815,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2051.61}}',NULL,'2023-06-11 04:08:47','2023-06-11 04:08:47'),(2648,'default','added',16816,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-11 04:26:17','2023-06-11 04:26:17'),(2649,'default','added',16817,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1190.2}}',NULL,'2023-06-11 04:28:23','2023-06-11 04:28:23'),(2650,'default','added',16818,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2479.92}}',NULL,'2023-06-11 04:29:26','2023-06-11 04:29:26'),(2651,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-11 14:45:18','2023-06-11 14:45:19'),(2652,'default','added',16819,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":513}}',NULL,'2023-06-11 14:47:52','2023-06-11 14:47:52'),(2653,'default','added',16820,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-11 15:07:27','2023-06-11 15:07:27'),(2654,'default','added',16821,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-11 15:33:37','2023-06-11 15:33:37'),(2655,'default','added',16822,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396.3}}',NULL,'2023-06-11 15:44:17','2023-06-11 15:44:17'),(2656,'default','added',16823,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36.5}}',NULL,'2023-06-11 15:48:11','2023-06-11 15:48:11'),(2657,'default','added',16824,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115}}',NULL,'2023-06-11 15:56:17','2023-06-11 15:56:17'),(2658,'default','added',16825,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":655.5}}',NULL,'2023-06-11 16:12:13','2023-06-11 16:12:13'),(2659,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-11 16:33:11','2023-06-11 16:33:11'),(2660,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-11 16:34:10','2023-06-11 16:34:10'),(2661,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-11 16:35:36','2023-06-11 16:35:36'),(2662,'default','added',16826,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-06-11 16:36:10','2023-06-11 16:36:10'),(2663,'default','added',16827,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270}}',NULL,'2023-06-11 16:38:05','2023-06-11 16:38:05'),(2664,'default','added',16828,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":310}}',NULL,'2023-06-11 17:06:37','2023-06-11 17:06:37'),(2665,'default','added',16829,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-11 17:10:00','2023-06-11 17:10:00'),(2666,'default','added',16830,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1002.5}}',NULL,'2023-06-11 17:18:09','2023-06-11 17:18:09'),(2667,'default','added',16831,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450.96}}',NULL,'2023-06-11 17:19:58','2023-06-11 17:19:58'),(2668,'default','added',16832,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-11 17:21:51','2023-06-11 17:21:51'),(2669,'default','added',16833,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-11 17:28:37','2023-06-11 17:28:37'),(2670,'default','added',16834,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-11 17:35:27','2023-06-11 17:35:27'),(2671,'default','added',16835,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.57}}',NULL,'2023-06-11 17:40:36','2023-06-11 17:40:36'),(2672,'default','added',16836,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-11 17:43:27','2023-06-11 17:43:27'),(2673,'default','added',16837,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1289.26}}',NULL,'2023-06-11 18:07:38','2023-06-11 18:07:38'),(2674,'default','added',16838,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1089}}',NULL,'2023-06-11 18:07:46','2023-06-11 18:07:46'),(2675,'default','added',16839,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1495}}',NULL,'2023-06-11 18:12:41','2023-06-11 18:12:41'),(2676,'default','added',16840,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3264}}',NULL,'2023-06-11 18:14:09','2023-06-11 18:14:09'),(2677,'default','added',16841,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-11 18:16:33','2023-06-11 18:16:33'),(2678,'default','added',16842,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1252.6}}',NULL,'2023-06-11 18:21:15','2023-06-11 18:21:15'),(2679,'default','added',16843,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":285}}',NULL,'2023-06-11 18:22:37','2023-06-11 18:22:37'),(2680,'default','added',16844,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":336.6}}',NULL,'2023-06-11 18:23:37','2023-06-11 18:23:37'),(2681,'default','added',16845,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-11 18:24:30','2023-06-11 18:24:30'),(2682,'default','added',16846,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-11 18:25:23','2023-06-11 18:25:23'),(2683,'default','added',16847,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.06}}',NULL,'2023-06-11 18:29:21','2023-06-11 18:29:21'),(2684,'default','added',16848,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":234.6}}',NULL,'2023-06-11 18:33:30','2023-06-11 18:33:30'),(2685,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-11 18:57:39','2023-06-11 18:57:39'),(2686,'default','added',16849,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":356.4}}',NULL,'2023-06-11 19:16:23','2023-06-11 19:16:23'),(2687,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-11 19:20:36','2023-06-11 19:20:36'),(2688,'default','added',16850,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":131.7}}',NULL,'2023-06-11 19:21:01','2023-06-11 19:21:01'),(2689,'default','added',16851,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":239.45}}',NULL,'2023-06-11 19:33:23','2023-06-11 19:33:23'),(2690,'default','added',16852,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-11 19:37:18','2023-06-11 19:37:18'),(2691,'default','added',16853,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":169.88}}',NULL,'2023-06-11 21:01:23','2023-06-11 21:01:24'),(2692,'default','added',16854,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1010.66}}',NULL,'2023-06-11 21:16:09','2023-06-11 21:16:09'),(2693,'default','added',16855,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1472.5}}',NULL,'2023-06-11 21:18:18','2023-06-11 21:18:18'),(2694,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-11 21:28:15','2023-06-11 21:28:15'),(2695,'default','added',16856,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":630}}',NULL,'2023-06-11 21:29:00','2023-06-11 21:29:00'),(2696,'default','added',16857,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-11 21:42:28','2023-06-11 21:42:28'),(2697,'default','added',16858,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-11 22:08:08','2023-06-11 22:08:08'),(2698,'default','added',16859,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-11 22:31:29','2023-06-11 22:31:29'),(2699,'default','added',16860,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2023-06-11 23:00:38','2023-06-11 23:00:38'),(2700,'default','added',16861,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-11 23:04:56','2023-06-11 23:04:56'),(2701,'default','added',16862,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-11 23:19:55','2023-06-11 23:19:55'),(2702,'default','po_deleted',16705,'App\\Transaction',NULL,3,3,'App\\User','{\"id\":16705,\"ref_no\":\"A150\"}',NULL,'2023-06-11 23:22:01','2023-06-11 23:22:01'),(2703,'default','added',16863,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-11 23:27:26','2023-06-11 23:27:26'),(2704,'default','added',16864,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53}}',NULL,'2023-06-11 23:33:35','2023-06-11 23:33:35'),(2705,'default','added',16865,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-11 23:36:17','2023-06-11 23:36:17'),(2706,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-11 23:38:21','2023-06-11 23:38:21'),(2707,'default','added',16866,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-11 23:39:51','2023-06-11 23:39:51'),(2708,'default','added',16867,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":269.88}}',NULL,'2023-06-11 23:40:43','2023-06-11 23:40:43'),(2709,'default','added',16868,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":128.54}}',NULL,'2023-06-11 23:53:05','2023-06-11 23:53:05'),(2710,'default','added',16869,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-12 00:05:26','2023-06-12 00:05:26'),(2711,'default','added',16870,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-12 00:08:11','2023-06-12 00:08:11'),(2712,'default','added',16871,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":261.69}}',NULL,'2023-06-12 00:15:31','2023-06-12 00:15:31'),(2713,'default','added',16872,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":729.12}}',NULL,'2023-06-12 00:20:00','2023-06-12 00:20:00'),(2714,'default','added',16873,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-12 00:38:22','2023-06-12 00:38:22'),(2715,'default','added',16874,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-06-12 00:39:50','2023-06-12 00:39:50'),(2716,'default','added',16875,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-12 00:47:27','2023-06-12 00:47:27'),(2717,'default','added',16876,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-12 00:55:19','2023-06-12 00:55:19'),(2718,'default','added',16877,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":693.75}}',NULL,'2023-06-12 00:59:56','2023-06-12 00:59:56'),(2719,'default','added',16878,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-12 01:08:13','2023-06-12 01:08:13'),(2720,'default','added',16879,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":660}}',NULL,'2023-06-12 01:12:34','2023-06-12 01:12:34'),(2721,'default','added',16880,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":78.72}}',NULL,'2023-06-12 01:20:44','2023-06-12 01:20:44'),(2722,'default','added',16881,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-12 01:24:09','2023-06-12 01:24:09'),(2723,'default','added',16882,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-12 01:24:59','2023-06-12 01:24:59'),(2724,'default','added',16883,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.52}}',NULL,'2023-06-12 01:26:55','2023-06-12 01:26:55'),(2725,'default','added',16884,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":620}}',NULL,'2023-06-12 01:26:56','2023-06-12 01:26:56'),(2726,'default','added',16885,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22.6}}',NULL,'2023-06-12 01:28:20','2023-06-12 01:28:20'),(2727,'default','added',16886,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":156}}',NULL,'2023-06-12 01:35:10','2023-06-12 01:35:10'),(2728,'default','added',16887,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-12 01:39:05','2023-06-12 01:39:05'),(2729,'default','added',16888,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155}}',NULL,'2023-06-12 01:40:50','2023-06-12 01:40:50'),(2730,'default','added',16889,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}',NULL,'2023-06-12 01:45:32','2023-06-12 01:45:32'),(2731,'default','added',16890,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450.96}}',NULL,'2023-06-12 01:46:35','2023-06-12 01:46:35'),(2732,'default','added',16891,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41.3}}',NULL,'2023-06-12 01:53:03','2023-06-12 01:53:03'),(2733,'default','added',16892,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":84.32}}',NULL,'2023-06-12 02:09:23','2023-06-12 02:09:23'),(2734,'default','added',16893,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":272.94}}',NULL,'2023-06-12 02:12:25','2023-06-12 02:12:25'),(2735,'default','added',16894,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":551.39}}',NULL,'2023-06-12 02:12:26','2023-06-12 02:12:26'),(2736,'default','added',16895,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-12 02:18:54','2023-06-12 02:18:54'),(2737,'default','added',16896,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2003.14}}',NULL,'2023-06-12 02:38:37','2023-06-12 02:38:37'),(2738,'default','added',16897,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":287.1}}',NULL,'2023-06-12 02:44:57','2023-06-12 02:44:57'),(2739,'default','added',16898,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":838.08}}',NULL,'2023-06-12 02:52:53','2023-06-12 02:52:53'),(2740,'default','added',16899,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":701.86}}',NULL,'2023-06-12 02:58:26','2023-06-12 02:58:26'),(2741,'default','added',16900,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":327.48}}',NULL,'2023-06-12 03:00:23','2023-06-12 03:00:23'),(2742,'default','added',16901,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-12 03:11:04','2023-06-12 03:11:04'),(2743,'default','added',16902,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":872.8}}',NULL,'2023-06-12 03:14:26','2023-06-12 03:14:26'),(2744,'default','added',16903,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1013.58}}',NULL,'2023-06-12 03:30:20','2023-06-12 03:30:20'),(2745,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-12 03:37:19','2023-06-12 03:37:19'),(2746,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-12 03:37:42','2023-06-12 03:37:42'),(2747,'default','added',16904,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2534.4}}',NULL,'2023-06-12 03:39:45','2023-06-12 03:39:45'),(2748,'default','added',16905,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2000}}',NULL,'2023-06-12 03:40:19','2023-06-12 03:40:19'),(2749,'default','added',16906,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":599}}',NULL,'2023-06-12 03:54:58','2023-06-12 03:54:58'),(2750,'default','added',16907,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-12 03:58:42','2023-06-12 03:58:42'),(2751,'default','added',16908,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-12 04:00:18','2023-06-12 04:00:18'),(2752,'default','added',16909,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23.5}}',NULL,'2023-06-12 04:00:42','2023-06-12 04:00:42'),(2753,'default','added',16910,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97.69}}',NULL,'2023-06-12 04:02:56','2023-06-12 04:02:56'),(2754,'default','added',16911,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":465.5}}',NULL,'2023-06-12 04:03:00','2023-06-12 04:03:00'),(2755,'default','added',16912,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.51}}',NULL,'2023-06-12 04:27:51','2023-06-12 04:27:51'),(2756,'default','added',16913,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-12 04:43:32','2023-06-12 04:43:32'),(2757,'default','added',16914,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-12 04:48:43','2023-06-12 04:48:43'),(2758,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-12 04:52:35','2023-06-12 04:52:35'),(2759,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-12 13:20:11','2023-06-12 13:20:11'),(2760,'default','added',16915,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-12 13:24:21','2023-06-12 13:24:21'),(2761,'default','added',16916,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":640.84}}',NULL,'2023-06-12 13:50:57','2023-06-12 13:50:57'),(2762,'default','added',16917,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72.88}}',NULL,'2023-06-12 14:06:00','2023-06-12 14:06:00'),(2763,'default','added',16918,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":635.54}}',NULL,'2023-06-12 15:10:27','2023-06-12 15:10:27'),(2764,'default','added',16919,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":513.66}}',NULL,'2023-06-12 15:34:32','2023-06-12 15:34:32'),(2765,'default','added',16920,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-12 15:36:47','2023-06-12 15:36:47'),(2766,'default','added',16921,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-12 16:31:44','2023-06-12 16:31:44'),(2767,'default','added',16922,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133}}',NULL,'2023-06-12 16:42:26','2023-06-12 16:42:26'),(2768,'default','added',16923,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-12 16:43:43','2023-06-12 16:43:43'),(2769,'default','added',16924,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-12 16:45:17','2023-06-12 16:45:17'),(2770,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-12 16:56:44','2023-06-12 16:56:44'),(2771,'default','added',16925,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":155.12}}',NULL,'2023-06-12 17:13:43','2023-06-12 17:13:43'),(2772,'default','added',16926,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-12 17:20:31','2023-06-12 17:20:31'),(2773,'default','added',16927,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-12 17:20:47','2023-06-12 17:20:47'),(2774,'default','added',16928,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-12 17:23:10','2023-06-12 17:23:10'),(2775,'default','added',16929,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-12 17:26:56','2023-06-12 17:26:56'),(2776,'default','added',16930,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-12 17:39:57','2023-06-12 17:39:57'),(2777,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 18:02:09','2023-06-12 18:02:09'),(2778,'default','added',16931,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-12 18:09:50','2023-06-12 18:09:50'),(2779,'default','payment_edited',16717,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8538.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8538.0000\"}}',NULL,'2023-06-12 18:09:50','2023-06-12 18:09:50'),(2780,'default','added',16932,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":365.82}}',NULL,'2023-06-12 18:11:46','2023-06-12 18:11:46'),(2781,'default','added',16933,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.53}}',NULL,'2023-06-12 18:22:08','2023-06-12 18:22:08'),(2782,'default','added',16934,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68.7}}',NULL,'2023-06-12 18:26:59','2023-06-12 18:26:59'),(2783,'default','added',16935,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":855}}',NULL,'2023-06-12 18:32:06','2023-06-12 18:32:06'),(2784,'default','added',16936,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-12 18:33:27','2023-06-12 18:33:27'),(2785,'default','added',16937,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":310}}',NULL,'2023-06-12 18:52:08','2023-06-12 18:52:08'),(2786,'default','added',16938,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":342}}',NULL,'2023-06-12 18:54:50','2023-06-12 18:54:50'),(2787,'default','added',16939,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18}}',NULL,'2023-06-12 18:56:14','2023-06-12 18:56:14'),(2788,'default','added',16940,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-12 19:07:50','2023-06-12 19:07:50'),(2789,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-12 19:18:16','2023-06-12 19:18:16'),(2790,'default','added',16941,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":509.9}}',NULL,'2023-06-12 19:20:02','2023-06-12 19:20:02'),(2791,'default','added',16942,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":318.25}}',NULL,'2023-06-12 19:23:47','2023-06-12 19:23:47'),(2792,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-12 19:57:16','2023-06-12 19:57:16'),(2793,'default','edited',16942,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2634.16},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"318.2500\"}}',NULL,'2023-06-12 19:57:18','2023-06-12 19:57:18'),(2794,'default','added',16943,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-12 20:01:28','2023-06-12 20:01:28'),(2795,'default','added',16944,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-12 20:04:14','2023-06-12 20:04:14'),(2796,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 20:35:39','2023-06-12 20:35:39'),(2797,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 20:35:49','2023-06-12 20:35:49'),(2798,'default','edited',16863,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 20:43:34','2023-06-12 20:43:34'),(2799,'default','shipping_edited',16862,'App\\Transaction',NULL,3,3,'App\\User','{\"update_note\":null}',NULL,'2023-06-12 20:44:28','2023-06-12 20:44:28'),(2800,'default','added',16945,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20404.02}}',NULL,'2023-06-12 20:52:03','2023-06-12 20:52:03'),(2801,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 20:59:08','2023-06-12 20:59:08'),(2802,'default','status_updated',16863,'App\\Transaction',NULL,3,3,'App\\User','{\"from\":\"ordered\",\"to\":\"completed\"}',NULL,'2023-06-12 21:01:12','2023-06-12 21:01:12'),(2803,'default','status_updated',16862,'App\\Transaction',NULL,3,3,'App\\User','{\"from\":\"ordered\",\"to\":\"completed\"}',NULL,'2023-06-12 21:03:52','2023-06-12 21:03:52'),(2804,'default','added',16946,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":123.5}}',NULL,'2023-06-12 21:32:44','2023-06-12 21:32:44'),(2805,'default','added',16947,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2397165.3}}',NULL,'2023-06-12 21:37:32','2023-06-12 21:37:32'),(2806,'default','added',16948,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-12 21:39:12','2023-06-12 21:39:12'),(2807,'default','added',16949,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":703724.1}}',NULL,'2023-06-12 21:41:46','2023-06-12 21:41:46'),(2808,'default','added',16950,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-12 21:51:24','2023-06-12 21:51:24'),(2809,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 21:53:49','2023-06-12 21:53:49'),(2810,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-06-12 21:55:11','2023-06-12 21:55:11'),(2811,'default','added',16951,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-12 21:59:04','2023-06-12 21:59:04'),(2812,'default','edited',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:02:22','2023-06-12 22:02:22'),(2813,'default','edited',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:02:24','2023-06-12 22:02:25'),(2814,'default','edited',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:02:33','2023-06-12 22:02:33'),(2815,'default','edited',124,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:02:40','2023-06-12 22:02:41'),(2816,'default','added',16952,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-12 22:03:26','2023-06-12 22:03:26'),(2817,'default','added',16953,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":427.5}}',NULL,'2023-06-12 22:04:54','2023-06-12 22:04:54'),(2818,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-06-12 22:05:39','2023-06-12 22:05:40'),(2819,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-12 22:06:13','2023-06-12 22:06:14'),(2820,'default','added',16954,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":341026}}',NULL,'2023-06-12 22:07:39','2023-06-12 22:07:39'),(2821,'default','login',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 22:38:41','2023-06-12 22:38:41'),(2822,'default','added',16956,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":531.44}}',NULL,'2023-06-12 22:18:09','2023-06-12 22:18:09'),(2823,'default','logout',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 22:50:03','2023-06-12 22:50:03'),(2824,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:20:19','2023-06-12 22:20:19'),(2825,'default','added',16957,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.6}}',NULL,'2023-06-12 22:27:55','2023-06-12 22:27:55'),(2826,'default','edited',123,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:28:17','2023-06-12 22:28:17'),(2827,'default','added',16958,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":58625}}',NULL,'2023-06-12 22:30:17','2023-06-12 22:30:17'),(2828,'default','added',16959,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":48245}}',NULL,'2023-06-12 22:33:00','2023-06-12 22:33:00'),(2829,'default','login',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 23:05:49','2023-06-12 23:05:49'),(2830,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:36:43','2023-06-12 22:36:43'),(2831,'default','login',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 23:07:36','2023-06-12 23:07:36'),(2832,'default','login',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 23:07:36','2023-06-12 23:07:36'),(2833,'default','login',32,'App\\User',NULL,7,32,'App\\User','[]',NULL,'2023-06-12 23:08:53','2023-06-12 23:08:53'),(2834,'default','added',16960,'App\\Transaction',NULL,7,32,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-12 23:09:23','2023-06-12 23:09:23'),(2835,'default','added',16961,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2625.1}}',NULL,'2023-06-12 22:45:28','2023-06-12 22:45:28'),(2836,'default','added',16962,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":174}}',NULL,'2023-06-12 22:47:37','2023-06-12 22:47:37'),(2837,'default','edited',96,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-12 22:50:19','2023-06-12 22:50:19'),(2838,'default','added',16963,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1293.75}}',NULL,'2023-06-12 22:51:00','2023-06-12 22:51:00'),(2839,'default','added',16964,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-12 22:51:37','2023-06-12 22:51:37'),(2840,'default','added',16965,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":24525}}',NULL,'2023-06-12 22:53:18','2023-06-12 22:53:18'),(2841,'default','added',16966,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":93.86}}',NULL,'2023-06-12 22:54:48','2023-06-12 22:54:48'),(2842,'default','edited',16945,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"20404.0200\"}}',NULL,'2023-06-12 23:09:00','2023-06-12 23:09:00'),(2843,'default','added',16967,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":384.3}}',NULL,'2023-06-12 23:09:41','2023-06-12 23:09:41'),(2844,'default','added',16968,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":739.3}}',NULL,'2023-06-12 23:28:10','2023-06-12 23:28:10'),(2845,'default','added',16969,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":534.68}}',NULL,'2023-06-12 23:47:11','2023-06-12 23:47:11'),(2846,'default','added',16970,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-12 23:54:17','2023-06-12 23:54:17'),(2847,'default','added',16971,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":940}}',NULL,'2023-06-12 23:57:40','2023-06-12 23:57:40'),(2848,'default','added',16972,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-13 00:02:02','2023-06-13 00:02:02'),(2849,'default','added',16973,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.01}}',NULL,'2023-06-13 00:04:19','2023-06-13 00:04:19'),(2850,'default','added',16974,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":19935.34}}',NULL,'2023-06-13 00:10:25','2023-06-13 00:10:25'),(2851,'default','added',16975,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":376.04}}',NULL,'2023-06-13 00:16:27','2023-06-13 00:16:27'),(2852,'default','edited',16974,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20545.54},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"19935.3400\"}}',NULL,'2023-06-13 00:21:37','2023-06-13 00:21:37'),(2853,'default','added',16976,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-13 00:25:35','2023-06-13 00:25:35'),(2854,'default','added',16977,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-13 00:25:38','2023-06-13 00:25:38'),(2855,'default','added',16978,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2832.08}}',NULL,'2023-06-13 00:36:17','2023-06-13 00:36:17'),(2856,'default','added',16979,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":219.94}}',NULL,'2023-06-13 00:38:57','2023-06-13 00:38:57'),(2857,'default','added',16980,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":410}}',NULL,'2023-06-13 00:40:07','2023-06-13 00:40:07'),(2858,'default','added',16981,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-13 00:48:23','2023-06-13 00:48:23'),(2859,'default','added',16982,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":532.11}}',NULL,'2023-06-13 00:49:25','2023-06-13 00:49:25'),(2860,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 01:05:57','2023-06-13 01:05:57'),(2861,'default','added',16983,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":92250}}',NULL,'2023-06-13 01:09:18','2023-06-13 01:09:18'),(2862,'default','added',16984,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":331.1}}',NULL,'2023-06-13 01:15:30','2023-06-13 01:15:30'),(2863,'default','added',16985,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-13 01:26:54','2023-06-13 01:26:54'),(2864,'default','added',16986,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27800}}',NULL,'2023-06-13 01:27:59','2023-06-13 01:27:59'),(2865,'default','edited',94,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 01:31:25','2023-06-13 01:31:25'),(2866,'default','added',16987,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2067.12}}',NULL,'2023-06-13 01:32:38','2023-06-13 01:32:38'),(2867,'default','added',16988,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27800}}',NULL,'2023-06-13 01:32:50','2023-06-13 01:32:50'),(2868,'default','added',16989,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":72400}}',NULL,'2023-06-13 01:34:18','2023-06-13 01:34:18'),(2869,'default','added',16990,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13775}}',NULL,'2023-06-13 01:35:37','2023-06-13 01:35:37'),(2870,'default','added',16991,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 01:36:52','2023-06-13 01:36:52'),(2871,'default','added',16992,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 01:37:43','2023-06-13 01:37:43'),(2872,'default','added',16993,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":49975}}',NULL,'2023-06-13 01:39:12','2023-06-13 01:39:12'),(2873,'default','edited',86,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 01:41:16','2023-06-13 01:41:16'),(2874,'default','added',16994,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":36200}}',NULL,'2023-06-13 01:42:30','2023-06-13 01:42:30'),(2875,'default','payment_edited',5812,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 01:51:58','2023-06-13 01:51:58'),(2876,'default','payment_edited',16599,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"63756.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"63756.0000\"}}',NULL,'2023-06-13 01:51:58','2023-06-13 01:51:58'),(2877,'default','added',16995,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":117.67}}',NULL,'2023-06-13 01:52:00','2023-06-13 01:52:00'),(2878,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-13 01:52:54','2023-06-13 01:52:54'),(2879,'default','added',16996,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2023-06-13 01:53:37','2023-06-13 01:53:37'),(2880,'default','added',16997,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":126120}}',NULL,'2023-06-13 01:54:17','2023-06-13 01:54:17'),(2881,'default','added',16998,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3740}}',NULL,'2023-06-13 01:54:54','2023-06-13 01:54:54'),(2882,'default','added',16999,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":62150}}',NULL,'2023-06-13 01:55:40','2023-06-13 01:55:40'),(2883,'default','added',17000,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":33175}}',NULL,'2023-06-13 01:57:26','2023-06-13 01:57:26'),(2884,'default','edited',82,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 01:59:21','2023-06-13 01:59:21'),(2885,'default','added',17001,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 02:00:47','2023-06-13 02:00:47'),(2886,'default','added',17002,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41325}}',NULL,'2023-06-13 02:02:09','2023-06-13 02:02:10'),(2887,'default','added',17003,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":171850}}',NULL,'2023-06-13 02:03:59','2023-06-13 02:03:59'),(2888,'default','added',17004,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-13 02:05:17','2023-06-13 02:05:17'),(2889,'default','added',17005,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16915}}',NULL,'2023-06-13 02:05:53','2023-06-13 02:05:53'),(2890,'default','added',17006,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2023-06-13 02:06:29','2023-06-13 02:06:29'),(2891,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 02:07:41','2023-06-13 02:07:41'),(2892,'default','edited',76,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 02:09:44','2023-06-13 02:09:44'),(2893,'default','added',17007,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22425}}',NULL,'2023-06-13 02:10:45','2023-06-13 02:10:45'),(2894,'default','added',17008,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":58625}}',NULL,'2023-06-13 02:11:54','2023-06-13 02:11:54'),(2895,'default','edited',73,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 02:13:49','2023-06-13 02:13:49'),(2896,'default','added',17009,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":36200}}',NULL,'2023-06-13 02:14:45','2023-06-13 02:14:45'),(2897,'default','added',17010,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 02:15:30','2023-06-13 02:15:30'),(2898,'default','added',17011,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27550}}',NULL,'2023-06-13 02:16:16','2023-06-13 02:16:16'),(2899,'default','added',17012,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 02:17:02','2023-06-13 02:17:02'),(2900,'default','added',17013,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 02:17:58','2023-06-13 02:17:58'),(2901,'default','added',17014,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28025}}',NULL,'2023-06-13 02:19:47','2023-06-13 02:19:47'),(2902,'default','added',17015,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 02:20:32','2023-06-13 02:20:32'),(2903,'default','added',17016,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.4}}',NULL,'2023-06-13 02:21:39','2023-06-13 02:21:39'),(2904,'default','added',17017,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":543.36}}',NULL,'2023-06-13 02:23:48','2023-06-13 02:23:48'),(2905,'default','added',17018,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30916}}',NULL,'2023-06-13 02:27:33','2023-06-13 02:27:33'),(2906,'default','added',17019,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23337.25}}',NULL,'2023-06-13 02:44:05','2023-06-13 02:44:05'),(2907,'default','added',17020,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-13 02:45:02','2023-06-13 02:45:02'),(2908,'default','added',17021,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":571.42}}',NULL,'2023-06-13 02:47:23','2023-06-13 02:47:23'),(2909,'default','added',17022,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1064.22}}',NULL,'2023-06-13 02:48:21','2023-06-13 02:48:21'),(2910,'default','added',17023,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-13 02:51:24','2023-06-13 02:51:24'),(2911,'default','added',17024,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":159.6}}',NULL,'2023-06-13 02:59:01','2023-06-13 02:59:01'),(2912,'default','added',17025,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-06-13 03:01:44','2023-06-13 03:01:44'),(2913,'default','added',17026,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-13 03:06:09','2023-06-13 03:06:09'),(2914,'default','added',17027,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":151.2}}',NULL,'2023-06-13 03:13:13','2023-06-13 03:13:13'),(2915,'default','added',17028,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-06-13 03:18:48','2023-06-13 03:18:48'),(2916,'default','added',17029,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-13 03:19:16','2023-06-13 03:19:16'),(2917,'default','added',17030,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570}}',NULL,'2023-06-13 03:28:38','2023-06-13 03:28:38'),(2918,'default','added',17031,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-13 03:37:34','2023-06-13 03:37:34'),(2919,'default','added',17032,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":991.5}}',NULL,'2023-06-13 03:47:35','2023-06-13 03:47:35'),(2920,'default','added',17033,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396.9}}',NULL,'2023-06-13 03:56:50','2023-06-13 03:56:50'),(2921,'default','added',17034,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1170.5}}',NULL,'2023-06-13 04:06:05','2023-06-13 04:06:05'),(2922,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-13 04:06:55','2023-06-13 04:06:55'),(2923,'default','added',17035,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":157916}}',NULL,'2023-06-13 04:10:44','2023-06-13 04:10:44'),(2924,'default','added',17036,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":759.06}}',NULL,'2023-06-13 04:11:28','2023-06-13 04:11:28'),(2925,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-13 04:13:55','2023-06-13 04:13:55'),(2926,'default','added',17037,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95.28}}',NULL,'2023-06-13 04:15:27','2023-06-13 04:15:27'),(2927,'default','added',17038,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18156}}',NULL,'2023-06-13 04:16:25','2023-06-13 04:16:25'),(2928,'default','added',145,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 04:20:08','2023-06-13 04:20:08'),(2929,'default','added',17039,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":534.43}}',NULL,'2023-06-13 04:20:45','2023-06-13 04:20:45'),(2930,'default','edited',17039,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":534.43},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"534.4300\"}}',NULL,'2023-06-13 04:20:46','2023-06-13 04:20:46'),(2931,'default','added',17040,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15875}}',NULL,'2023-06-13 04:21:08','2023-06-13 04:21:08'),(2932,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-13 04:21:43','2023-06-13 04:21:43'),(2933,'default','added',17041,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13775}}',NULL,'2023-06-13 04:21:56','2023-06-13 04:21:56'),(2934,'default','edited',68,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 04:26:58','2023-06-13 04:26:58'),(2935,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-13 04:27:21','2023-06-13 04:27:21'),(2936,'default','added',17042,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":35946}}',NULL,'2023-06-13 04:29:52','2023-06-13 04:29:52'),(2937,'default','edited',111,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 04:31:15','2023-06-13 04:31:16'),(2938,'default','added',17043,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22425}}',NULL,'2023-06-13 04:32:32','2023-06-13 04:32:32'),(2939,'default','added',17044,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-13 04:35:54','2023-06-13 04:35:55'),(2940,'default','added',17045,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":76574}}',NULL,'2023-06-13 04:38:23','2023-06-13 04:38:23'),(2941,'default','added',17046,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-06-13 04:41:36','2023-06-13 04:41:36'),(2942,'default','added',17047,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5081.58}}',NULL,'2023-06-13 04:41:40','2023-06-13 04:41:40'),(2943,'default','edited',104,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 04:47:40','2023-06-13 04:47:40'),(2944,'default','added',17048,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":85266}}',NULL,'2023-06-13 04:52:39','2023-06-13 04:52:39'),(2945,'default','added',17049,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":218}}',NULL,'2023-06-13 04:53:11','2023-06-13 04:53:11'),(2946,'default','added',17050,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-13 04:53:26','2023-06-13 04:53:26'),(2947,'default','added',17051,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1728}}',NULL,'2023-06-13 04:53:32','2023-06-13 04:53:32'),(2948,'default','added',17052,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10700}}',NULL,'2023-06-13 04:54:31','2023-06-13 04:54:31'),(2949,'default','added',17053,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18965}}',NULL,'2023-06-13 04:55:44','2023-06-13 04:55:44'),(2950,'default','edited',16949,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":703724.1},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"703724.1000\"}}',NULL,'2023-06-13 05:03:20','2023-06-13 05:03:20'),(2951,'default','edited',16947,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2397165.3},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2397165.3000\"}}',NULL,'2023-06-13 05:05:29','2023-06-13 05:05:29'),(2952,'default','edited',109,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 05:11:53','2023-06-13 05:11:53'),(2953,'default','added',17054,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":84813}}',NULL,'2023-06-13 05:21:12','2023-06-13 05:21:12'),(2954,'default','edited',95,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 05:22:09','2023-06-13 05:22:09'),(2955,'default','added',17055,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":65825}}',NULL,'2023-06-13 05:25:28','2023-06-13 05:25:28'),(2956,'default','added',17056,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-13 05:26:15','2023-06-13 05:26:15'),(2957,'default','added',17057,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5510}}',NULL,'2023-06-13 05:27:10','2023-06-13 05:27:10'),(2958,'default','added',17058,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":59980}}',NULL,'2023-06-13 05:29:19','2023-06-13 05:29:19'),(2959,'default','edited',114,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 05:32:02','2023-06-13 05:32:02'),(2960,'default','added',17059,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":45646}}',NULL,'2023-06-13 05:34:03','2023-06-13 05:34:03'),(2961,'default','added',17060,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4296}}',NULL,'2023-06-13 05:36:48','2023-06-13 05:36:48'),(2962,'default','edited',105,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 05:37:37','2023-06-13 05:37:37'),(2963,'default','edited',5872,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":830646.63},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"813808.5500\"}}',NULL,'2023-06-13 05:46:37','2023-06-13 05:46:37'),(2964,'default','edited',17055,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":65105},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"65825.0000\"}}',NULL,'2023-06-13 05:53:10','2023-06-13 05:53:10'),(2965,'default','edited',17058,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":65180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"59980.0000\"}}',NULL,'2023-06-13 05:55:36','2023-06-13 05:55:36'),(2966,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-13 06:21:17','2023-06-13 06:21:17'),(2967,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 13:42:24','2023-06-13 13:42:24'),(2968,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-13 13:46:26','2023-06-13 13:46:26'),(2969,'default','added',17061,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17574}}',NULL,'2023-06-13 13:48:26','2023-06-13 13:48:26'),(2970,'default','added',17062,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18260}}',NULL,'2023-06-13 13:49:21','2023-06-13 13:49:21'),(2971,'default','edited',5872,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":836106.69},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"830646.6300\"}}',NULL,'2023-06-13 13:51:42','2023-06-13 13:51:42'),(2972,'default','edited',17062,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18260},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18260.0000\"}}',NULL,'2023-06-13 13:54:05','2023-06-13 13:54:05'),(2973,'default','added',17063,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5510}}',NULL,'2023-06-13 13:54:52','2023-06-13 13:54:52'),(2974,'default','added',146,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 13:56:35','2023-06-13 13:56:35'),(2975,'default','added',17064,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25245}}',NULL,'2023-06-13 13:58:01','2023-06-13 13:58:01'),(2976,'default','added',17065,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":36200}}',NULL,'2023-06-13 13:58:51','2023-06-13 13:58:51'),(2977,'default','added',17066,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8700}}',NULL,'2023-06-13 13:59:57','2023-06-13 13:59:57'),(2978,'default','added',17067,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11040}}',NULL,'2023-06-13 14:00:41','2023-06-13 14:00:41'),(2979,'default','added',17068,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-13 14:08:48','2023-06-13 14:08:48'),(2980,'default','added',17069,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":49058}}',NULL,'2023-06-13 14:09:32','2023-06-13 14:09:32'),(2981,'default','added',17070,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1376.1}}',NULL,'2023-06-13 14:09:40','2023-06-13 14:09:40'),(2982,'default','added',17071,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20880}}',NULL,'2023-06-13 14:16:22','2023-06-13 14:16:22'),(2983,'default','added',17072,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2760}}',NULL,'2023-06-13 14:17:10','2023-06-13 14:17:10'),(2984,'default','added',17073,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":24840}}',NULL,'2023-06-13 14:19:05','2023-06-13 14:19:05'),(2985,'default','added',17074,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3720}}',NULL,'2023-06-13 14:19:59','2023-06-13 14:19:59'),(2986,'default','added',17075,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8736}}',NULL,'2023-06-13 14:22:04','2023-06-13 14:22:04'),(2987,'default','added',17076,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18260}}',NULL,'2023-06-13 14:23:29','2023-06-13 14:23:29'),(2988,'default','payment_edited',15423,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5412.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5412.0000\"}}',NULL,'2023-06-13 14:24:06','2023-06-13 14:24:06'),(2989,'default','payment_edited',16999,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"62150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"62150.0000\"}}',NULL,'2023-06-13 14:24:06','2023-06-13 14:24:06'),(2990,'default','payment_edited',17009,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"36200.0000\"}}',NULL,'2023-06-13 14:24:40','2023-06-13 14:24:40'),(2991,'default','payment_edited',16959,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"48245.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"48245.0000\"}}',NULL,'2023-06-13 14:25:09','2023-06-13 14:25:09'),(2992,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 14:50:17','2023-06-13 14:50:17'),(2993,'default','added',17077,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25245}}',NULL,'2023-06-13 14:57:53','2023-06-13 14:57:53'),(2994,'default','added',17078,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47250}}',NULL,'2023-06-13 15:11:33','2023-06-13 15:11:33'),(2995,'default','added',17079,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8000}}',NULL,'2023-06-13 15:17:20','2023-06-13 15:17:20'),(2996,'default','added',17080,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":67005}}',NULL,'2023-06-13 15:27:34','2023-06-13 15:27:34'),(2997,'default','added',17081,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18360}}',NULL,'2023-06-13 15:42:22','2023-06-13 15:42:22'),(2998,'default','added',17082,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5520}}',NULL,'2023-06-13 15:42:52','2023-06-13 15:42:52'),(2999,'default','added',17083,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":146}}',NULL,'2023-06-13 15:43:19','2023-06-13 15:43:19'),(3000,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-13 15:43:36','2023-06-13 15:43:36'),(3001,'default','added',17084,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":665.2}}',NULL,'2023-06-13 15:44:49','2023-06-13 15:44:49'),(3002,'default','added',17085,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-13 15:45:49','2023-06-13 15:45:49'),(3003,'default','added',17086,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":296.9}}',NULL,'2023-06-13 15:58:14','2023-06-13 15:58:14'),(3004,'default','added',17087,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":256.5}}',NULL,'2023-06-13 16:41:16','2023-06-13 16:41:16'),(3005,'default','added',17088,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":530}}',NULL,'2023-06-13 16:51:38','2023-06-13 16:51:38'),(3006,'default','added',17089,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":385.7}}',NULL,'2023-06-13 16:52:36','2023-06-13 16:52:36'),(3007,'default','payment_edited',16959,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"48245.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"48245.0000\"}}',NULL,'2023-06-13 16:55:39','2023-06-13 16:55:39'),(3008,'default','added',17090,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":192.7}}',NULL,'2023-06-13 16:55:50','2023-06-13 16:55:50'),(3009,'default','payment_edited',5840,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 16:56:34','2023-06-13 16:56:34'),(3010,'default','payment_edited',16983,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"92250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"92250.0000\"}}',NULL,'2023-06-13 16:57:02','2023-06-13 16:57:02'),(3011,'default','payment_edited',17053,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18965.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18965.0000\"}}',NULL,'2023-06-13 16:57:30','2023-06-13 16:57:30'),(3012,'default','payment_edited',5832,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 16:58:09','2023-06-13 16:58:09'),(3013,'default','payment_edited',17042,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35946.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"35946.0000\"}}',NULL,'2023-06-13 16:58:40','2023-06-13 16:58:40'),(3014,'default','payment_edited',17045,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"76574.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"76574.0000\"}}',NULL,'2023-06-13 16:59:19','2023-06-13 16:59:19'),(3015,'default','payment_edited',5827,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 16:59:43','2023-06-13 16:59:43'),(3016,'default','payment_edited',17061,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"17574.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17574.0000\"}}',NULL,'2023-06-13 16:59:43','2023-06-13 16:59:43'),(3017,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 17:00:19','2023-06-13 17:00:19'),(3018,'default','added',17091,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":329.95}}',NULL,'2023-06-13 17:02:22','2023-06-13 17:02:22'),(3019,'default','added',17092,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2755}}',NULL,'2023-06-13 17:07:58','2023-06-13 17:07:58'),(3020,'default','added',17093,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2755}}',NULL,'2023-06-13 17:44:24','2023-06-13 17:44:24'),(3021,'default','added',17094,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3134.4}}',NULL,'2023-06-13 18:02:56','2023-06-13 18:02:56'),(3022,'default','added',17095,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17.8}}',NULL,'2023-06-13 18:03:23','2023-06-13 18:03:23'),(3023,'default','added',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":30417.04}}',NULL,'2023-06-13 18:13:34','2023-06-13 18:13:34'),(3024,'default','added',17097,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99.73}}',NULL,'2023-06-13 18:16:03','2023-06-13 18:16:03'),(3025,'default','added',17098,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-13 18:22:47','2023-06-13 18:22:47'),(3026,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":37345.88},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"30417.0400\"}}',NULL,'2023-06-13 18:27:01','2023-06-13 18:27:01'),(3027,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":38024.11},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"37345.8800\"}}',NULL,'2023-06-13 18:34:55','2023-06-13 18:34:55'),(3028,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":55530.43},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"38024.1100\"}}',NULL,'2023-06-13 19:08:12','2023-06-13 19:08:12'),(3029,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":60435.28},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"55530.4300\"}}',NULL,'2023-06-13 19:10:18','2023-06-13 19:10:18'),(3030,'default','added',17099,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370}}',NULL,'2023-06-13 19:10:27','2023-06-13 19:10:27'),(3031,'default','added',17100,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1981.48}}',NULL,'2023-06-13 19:17:32','2023-06-13 19:17:33'),(3032,'default','added',17101,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2740.46}}',NULL,'2023-06-13 19:24:15','2023-06-13 19:24:15'),(3033,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"60435.2800\"}}',NULL,'2023-06-13 19:25:10','2023-06-13 19:25:10'),(3034,'default','added',17102,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1262.38}}',NULL,'2023-06-13 19:27:14','2023-06-13 19:27:14'),(3035,'default','added',17103,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":142}}',NULL,'2023-06-13 19:34:28','2023-06-13 19:34:28'),(3036,'default','added',17104,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":560}}',NULL,'2023-06-13 19:34:47','2023-06-13 19:34:47'),(3037,'default','added',17105,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.95}}',NULL,'2023-06-13 20:10:44','2023-06-13 20:10:44'),(3038,'default','added',17106,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.16}}',NULL,'2023-06-13 20:13:32','2023-06-13 20:13:32'),(3039,'default','added',17107,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-13 20:33:17','2023-06-13 20:33:17'),(3040,'default','added',17108,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-13 20:36:38','2023-06-13 20:36:38'),(3041,'default','added',17109,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1290}}',NULL,'2023-06-13 20:41:38','2023-06-13 20:41:38'),(3042,'default','added',17110,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":724.12}}',NULL,'2023-06-13 20:53:57','2023-06-13 20:53:57'),(3043,'default','added',17111,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-13 20:55:50','2023-06-13 20:55:50'),(3044,'default','added',17112,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-13 21:01:28','2023-06-13 21:01:28'),(3045,'default','added',17113,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-13 21:05:58','2023-06-13 21:05:58'),(3046,'default','added',17114,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-13 21:19:05','2023-06-13 21:19:05'),(3047,'default','added',17115,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":439.88}}',NULL,'2023-06-13 21:22:36','2023-06-13 21:22:36'),(3048,'default','added',17116,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-13 21:30:13','2023-06-13 21:30:13'),(3049,'default','added',17117,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-13 21:30:31','2023-06-13 21:30:31'),(3050,'default','added',17118,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19}}',NULL,'2023-06-13 21:34:28','2023-06-13 21:34:28'),(3051,'default','added',17119,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-13 21:51:33','2023-06-13 21:51:33'),(3052,'default','added',17120,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":414.36}}',NULL,'2023-06-13 21:58:52','2023-06-13 21:58:52'),(3053,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-13 21:59:15','2023-06-13 21:59:15'),(3054,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 22:46:50','2023-06-13 22:46:50'),(3055,'default','payment_edited',5818,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 22:49:25','2023-06-13 22:49:25'),(3056,'default','payment_edited',17041,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"13775.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13775.0000\"}}',NULL,'2023-06-13 22:49:25','2023-06-13 22:49:25'),(3057,'default','added',17121,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-13 22:51:40','2023-06-13 22:51:40'),(3058,'default','added',17122,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95.7}}',NULL,'2023-06-13 22:56:39','2023-06-13 22:56:39'),(3059,'default','added',17123,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":137.06}}',NULL,'2023-06-13 22:57:57','2023-06-13 22:57:57'),(3060,'default','added',17124,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2023-06-13 23:04:10','2023-06-13 23:04:10'),(3061,'default','added',17125,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":427.5}}',NULL,'2023-06-13 23:10:28','2023-06-13 23:10:28'),(3062,'default','added',17126,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":536.4}}',NULL,'2023-06-13 23:26:05','2023-06-13 23:26:05'),(3063,'default','payment_edited',5817,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 23:26:23','2023-06-13 23:26:23'),(3064,'default','payment_edited',16990,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13775.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13775.0000\"}}',NULL,'2023-06-13 23:26:23','2023-06-13 23:26:23'),(3065,'default','payment_edited',16991,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-13 23:29:26','2023-06-13 23:29:26'),(3066,'default','payment_edited',16992,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-13 23:30:50','2023-06-13 23:30:50'),(3067,'default','payment_edited',16993,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"49975.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"49975.0000\"}}',NULL,'2023-06-13 23:32:59','2023-06-13 23:32:59'),(3068,'default','payment_edited',16999,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"62150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"62150.0000\"}}',NULL,'2023-06-13 23:36:02','2023-06-13 23:36:02'),(3069,'default','added',17127,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1470}}',NULL,'2023-06-13 23:36:03','2023-06-13 23:36:03'),(3070,'default','payment_edited',17000,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33175.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"33175.0000\"}}',NULL,'2023-06-13 23:37:56','2023-06-13 23:37:56'),(3071,'default','payment_edited',5807,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-13 23:39:38','2023-06-13 23:39:38'),(3072,'default','payment_edited',17003,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"171850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"171850.0000\"}}',NULL,'2023-06-13 23:40:50','2023-06-13 23:40:50'),(3073,'default','added',17128,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":464.23}}',NULL,'2023-06-14 00:00:52','2023-06-14 00:00:52'),(3074,'default','added',17129,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.01}}',NULL,'2023-06-14 00:12:33','2023-06-14 00:12:33'),(3075,'default','added',17130,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-14 00:14:14','2023-06-14 00:14:14'),(3076,'default','added',17131,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2003.99}}',NULL,'2023-06-14 00:36:41','2023-06-14 00:36:41'),(3077,'default','added',17132,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":182.55}}',NULL,'2023-06-14 01:08:06','2023-06-14 01:08:06'),(3078,'default','payment_edited',5829,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-14 01:15:48','2023-06-14 01:15:48'),(3079,'default','added',17133,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570.53}}',NULL,'2023-06-14 01:17:07','2023-06-14 01:17:07'),(3080,'default','payment_edited',5831,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-14 01:17:39','2023-06-14 01:17:39'),(3081,'default','payment_edited',5843,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-14 01:18:58','2023-06-14 01:18:58'),(3082,'default','payment_edited',16958,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58625.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"58625.0000\"}}',NULL,'2023-06-14 01:18:58','2023-06-14 01:18:58'),(3083,'default','payment_edited',17012,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-14 01:21:07','2023-06-14 01:21:07'),(3084,'default','payment_edited',17005,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16915.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16915.0000\"}}',NULL,'2023-06-14 01:29:05','2023-06-14 01:29:05'),(3085,'default','added',17134,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-14 01:37:56','2023-06-14 01:37:56'),(3086,'default','added',17135,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2121.45}}',NULL,'2023-06-14 01:38:06','2023-06-14 01:38:06'),(3087,'default','payment_edited',17015,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-14 01:42:24','2023-06-14 01:42:24'),(3088,'default','added',17136,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2760}}',NULL,'2023-06-14 01:43:38','2023-06-14 01:43:38'),(3089,'default','added',17137,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-14 01:44:05','2023-06-14 01:44:05'),(3090,'default','added',17138,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450.96}}',NULL,'2023-06-14 02:13:30','2023-06-14 02:13:30'),(3091,'default','added',17139,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-14 02:15:25','2023-06-14 02:15:25'),(3092,'default','added',17140,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":274.84}}',NULL,'2023-06-14 02:36:27','2023-06-14 02:36:27'),(3093,'default','added',17141,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":676.44}}',NULL,'2023-06-14 02:53:23','2023-06-14 02:53:23'),(3094,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-14 05:01:03','2023-06-14 05:01:03'),(3095,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-14 14:01:37','2023-06-14 14:01:37'),(3096,'default','added',17142,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1296.42}}',NULL,'2023-06-14 14:05:55','2023-06-14 14:05:55'),(3097,'default','added',17143,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":538.93}}',NULL,'2023-06-14 14:06:42','2023-06-14 14:06:42'),(3098,'default','added',17144,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":779.34}}',NULL,'2023-06-14 14:21:39','2023-06-14 14:21:39'),(3099,'default','added',17145,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-14 14:23:46','2023-06-14 14:23:46'),(3100,'default','added',17146,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-06-14 15:15:31','2023-06-14 15:15:31'),(3101,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-14 16:42:03','2023-06-14 16:42:03'),(3102,'default','added',17147,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":146.1}}',NULL,'2023-06-14 16:44:20','2023-06-14 16:44:20'),(3103,'default','added',17148,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-06-14 16:46:12','2023-06-14 16:46:12'),(3104,'default','added',17149,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45.8}}',NULL,'2023-06-14 16:47:10','2023-06-14 16:47:10'),(3105,'default','added',17150,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2067.15}}',NULL,'2023-06-14 17:16:48','2023-06-14 17:16:48'),(3106,'default','added',17151,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-14 17:24:05','2023-06-14 17:24:05'),(3107,'default','added',17152,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":356.4}}',NULL,'2023-06-14 17:38:22','2023-06-14 17:38:22'),(3108,'default','added',17153,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-14 17:41:43','2023-06-14 17:41:43'),(3109,'default','added',17154,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":26091.68}}',NULL,'2023-06-14 17:42:50','2023-06-14 17:42:50'),(3110,'default','added',17155,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-14 17:48:51','2023-06-14 17:48:51'),(3111,'default','added',17156,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":884.6}}',NULL,'2023-06-14 17:57:54','2023-06-14 17:57:54'),(3112,'default','added',17157,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2492.52}}',NULL,'2023-06-14 18:43:38','2023-06-14 18:43:38'),(3113,'default','added',17158,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":179.4}}',NULL,'2023-06-14 19:34:25','2023-06-14 19:34:25'),(3114,'default','added',17159,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-14 20:02:18','2023-06-14 20:02:18'),(3115,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-14 20:08:41','2023-06-14 20:08:41'),(3116,'default','added',17160,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-14 20:31:30','2023-06-14 20:31:30'),(3117,'default','added',17161,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380.18}}',NULL,'2023-06-14 20:55:35','2023-06-14 20:55:35'),(3118,'default','added',17162,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":316.1}}',NULL,'2023-06-14 21:04:57','2023-06-14 21:04:57'),(3119,'default','added',17163,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-14 21:23:54','2023-06-14 21:23:54'),(3120,'default','edited',17163,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"120.0000\"}}',NULL,'2023-06-14 21:25:17','2023-06-14 21:25:17'),(3121,'default','added',17164,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":449}}',NULL,'2023-06-14 21:33:26','2023-06-14 21:33:26'),(3122,'default','added',17165,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265}}',NULL,'2023-06-14 21:36:55','2023-06-14 21:36:55'),(3123,'default','added',17166,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":213.3}}',NULL,'2023-06-14 21:42:53','2023-06-14 21:42:53'),(3124,'default','added',17167,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2446.24}}',NULL,'2023-06-14 21:44:37','2023-06-14 21:44:37'),(3125,'default','added',17168,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":61.04}}',NULL,'2023-06-14 21:45:42','2023-06-14 21:45:42'),(3126,'default','added',17169,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":470}}',NULL,'2023-06-14 21:48:13','2023-06-14 21:48:13'),(3127,'default','added',17170,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2023-06-14 21:48:29','2023-06-14 21:48:29'),(3128,'default','added',17171,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1111.49}}',NULL,'2023-06-14 21:57:11','2023-06-14 21:57:11'),(3129,'default','added',17172,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-06-14 22:15:48','2023-06-14 22:15:48'),(3130,'default','added',17173,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":462.8}}',NULL,'2023-06-14 22:49:08','2023-06-14 22:49:08'),(3131,'default','added',17174,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":326.04}}',NULL,'2023-06-14 22:54:57','2023-06-14 22:54:57'),(3132,'default','added',17175,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-14 22:54:59','2023-06-14 22:54:59'),(3133,'default','added',17176,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140.41}}',NULL,'2023-06-14 23:14:34','2023-06-14 23:14:34'),(3134,'default','added',17177,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114.3}}',NULL,'2023-06-14 23:32:06','2023-06-14 23:32:06'),(3135,'default','added',17178,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2140.79}}',NULL,'2023-06-14 23:44:18','2023-06-14 23:44:18'),(3136,'default','added',17179,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4270}}',NULL,'2023-06-14 23:45:51','2023-06-14 23:45:51'),(3137,'default','added',17180,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.01}}',NULL,'2023-06-14 23:55:01','2023-06-14 23:55:01'),(3138,'default','added',17181,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-14 23:57:43','2023-06-14 23:57:43'),(3139,'default','added',17182,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":179.96}}',NULL,'2023-06-14 23:58:28','2023-06-14 23:58:28'),(3140,'default','added',17183,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":119.4}}',NULL,'2023-06-15 00:04:41','2023-06-15 00:04:41'),(3141,'default','added',17184,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-15 00:17:44','2023-06-15 00:17:44'),(3142,'default','added',17185,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":46559.79}}',NULL,'2023-06-15 00:20:56','2023-06-15 00:20:56'),(3143,'default','added',17186,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":845.03}}',NULL,'2023-06-15 00:25:10','2023-06-15 00:25:10'),(3144,'default','added',17187,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-15 00:32:21','2023-06-15 00:32:21'),(3145,'default','added',17188,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-15 00:35:14','2023-06-15 00:35:14'),(3146,'default','added',17189,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42621.75}}',NULL,'2023-06-15 00:42:56','2023-06-15 00:42:56'),(3147,'default','added',147,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-06-15 00:44:20','2023-06-15 00:44:20'),(3148,'default','added',17190,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6186.88}}',NULL,'2023-06-15 00:50:04','2023-06-15 00:50:04'),(3149,'default','added',17191,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720}}',NULL,'2023-06-15 01:02:30','2023-06-15 01:02:30'),(3150,'default','added',17192,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-15 01:07:49','2023-06-15 01:07:49'),(3151,'default','added',17193,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396}}',NULL,'2023-06-15 01:18:30','2023-06-15 01:18:30'),(3152,'default','added',17194,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":825.12}}',NULL,'2023-06-15 01:21:15','2023-06-15 01:21:15'),(3153,'default','added',17195,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8.64}}',NULL,'2023-06-15 01:22:45','2023-06-15 01:22:45'),(3154,'default','added',17196,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-15 01:27:13','2023-06-15 01:27:13'),(3155,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-15 01:27:37','2023-06-15 01:27:37'),(3156,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-15 01:27:52','2023-06-15 01:27:52'),(3157,'default','added',17197,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":550}}',NULL,'2023-06-15 01:35:05','2023-06-15 01:35:05'),(3158,'default','added',17198,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340}}',NULL,'2023-06-15 01:36:07','2023-06-15 01:36:07'),(3159,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-15 01:36:27','2023-06-15 01:36:27'),(3160,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-15 01:37:07','2023-06-15 01:37:07'),(3161,'default','added',17199,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-15 01:43:13','2023-06-15 01:43:13'),(3162,'default','added',17200,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":435}}',NULL,'2023-06-15 02:10:41','2023-06-15 02:10:41'),(3163,'default','added',17201,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1575}}',NULL,'2023-06-15 02:17:57','2023-06-15 02:17:57'),(3164,'default','added',17202,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-15 02:26:15','2023-06-15 02:26:15'),(3165,'default','added',17203,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":77.99}}',NULL,'2023-06-15 02:29:16','2023-06-15 02:29:16'),(3166,'default','added',17204,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":108.1}}',NULL,'2023-06-15 02:43:46','2023-06-15 02:43:46'),(3167,'default','added',17205,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1261.82}}',NULL,'2023-06-15 02:45:37','2023-06-15 02:45:37'),(3168,'default','added',17206,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41.3}}',NULL,'2023-06-15 03:09:45','2023-06-15 03:09:45'),(3169,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-15 03:17:36','2023-06-15 03:17:36'),(3170,'default','added',17207,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64.5}}',NULL,'2023-06-15 03:28:14','2023-06-15 03:28:14'),(3171,'default','added',17208,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-06-15 03:30:36','2023-06-15 03:30:36'),(3172,'default','added',17209,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":680.6}}',NULL,'2023-06-15 03:44:40','2023-06-15 03:44:40'),(3173,'default','added',17210,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":798.35}}',NULL,'2023-06-15 04:01:07','2023-06-15 04:01:07'),(3174,'default','added',17211,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-15 04:02:10','2023-06-15 04:02:10'),(3175,'default','added',17212,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80.4}}',NULL,'2023-06-15 04:03:59','2023-06-15 04:03:59'),(3176,'default','added',17213,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":128.31}}',NULL,'2023-06-15 04:13:52','2023-06-15 04:13:52'),(3177,'default','added',17214,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48}}',NULL,'2023-06-15 04:14:50','2023-06-15 04:14:50'),(3178,'default','added',17215,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":522.5}}',NULL,'2023-06-15 04:28:30','2023-06-15 04:28:30'),(3179,'default','added',17216,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":755.72}}',NULL,'2023-06-15 04:35:08','2023-06-15 04:35:08'),(3180,'default','added',17217,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":411.72}}',NULL,'2023-06-15 04:44:54','2023-06-15 04:44:54'),(3181,'default','added',17218,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-15 04:46:23','2023-06-15 04:46:23'),(3182,'default','added',17219,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":686.75}}',NULL,'2023-06-15 05:01:25','2023-06-15 05:01:25'),(3183,'default','added',17220,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":218.63}}',NULL,'2023-06-15 05:11:55','2023-06-15 05:11:55'),(3184,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-15 14:07:50','2023-06-15 14:07:51'),(3185,'default','added',17221,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1376.1}}',NULL,'2023-06-15 14:09:11','2023-06-15 14:09:11'),(3186,'default','added',17222,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-15 14:10:52','2023-06-15 14:10:52'),(3187,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:12:30','2023-06-15 14:12:30'),(3188,'default','payment_edited',5837,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:35:52','2023-06-15 14:35:52'),(3189,'default','added',17223,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":291.9}}',NULL,'2023-06-15 14:38:30','2023-06-15 14:38:30'),(3190,'default','payment_edited',5802,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:40:48','2023-06-15 14:40:48'),(3191,'default','payment_edited',17008,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58625.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"58625.0000\"}}',NULL,'2023-06-15 14:40:48','2023-06-15 14:40:48'),(3192,'default','payment_edited',5799,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:43:23','2023-06-15 14:43:23'),(3193,'default','payment_edited',16009,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-06-15 14:43:23','2023-06-15 14:43:23'),(3194,'default','payment_edited',17056,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-15 14:43:23','2023-06-15 14:43:23'),(3195,'default','payment_edited',17014,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28025.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28025.0000\"}}',NULL,'2023-06-15 14:44:49','2023-06-15 14:44:49'),(3196,'default','payment_edited',17012,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-15 14:45:39','2023-06-15 14:45:39'),(3197,'default','payment_edited',5792,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:46:25','2023-06-15 14:46:25'),(3198,'default','added',17224,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":279.3}}',NULL,'2023-06-15 14:47:17','2023-06-15 14:47:17'),(3199,'default','payment_edited',5791,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:47:22','2023-06-15 14:47:22'),(3200,'default','payment_edited',5785,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:49:28','2023-06-15 14:49:28'),(3201,'default','payment_edited',5783,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:50:22','2023-06-15 14:50:22'),(3202,'default','payment_edited',5782,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:51:37','2023-06-15 14:51:37'),(3203,'default','payment_edited',5781,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:52:19','2023-06-15 14:52:19'),(3204,'default','payment_edited',5779,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 14:52:54','2023-06-15 14:52:54'),(3205,'default','payment_edited',17066,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8700.0000\"}}',NULL,'2023-06-15 14:54:11','2023-06-15 14:54:11'),(3206,'default','payment_edited',17073,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"24840.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"24840.0000\"}}',NULL,'2023-06-15 14:54:12','2023-06-15 14:54:12'),(3207,'default','added',17225,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25950}}',NULL,'2023-06-15 14:58:13','2023-06-15 14:58:13'),(3208,'default','payment_edited',17225,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"25950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"25950.0000\"}}',NULL,'2023-06-15 14:59:15','2023-06-15 14:59:15'),(3209,'default','added',17226,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-06-15 15:02:14','2023-06-15 15:02:14'),(3210,'default','added',17227,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5230}}',NULL,'2023-06-15 15:18:59','2023-06-15 15:18:59'),(3211,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-15 15:34:10','2023-06-15 15:34:10'),(3212,'default','added',17228,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4140.8}}',NULL,'2023-06-15 15:34:54','2023-06-15 15:34:54'),(3213,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-15 16:56:18','2023-06-15 16:56:18'),(3214,'default','added',17229,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6180}}',NULL,'2023-06-15 17:14:53','2023-06-15 17:14:53'),(3215,'default','added',17230,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-06-15 17:16:31','2023-06-15 17:16:31'),(3216,'default','added',17231,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2638.72}}',NULL,'2023-06-15 17:18:14','2023-06-15 17:18:14'),(3217,'default','added',17232,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-06-15 17:18:18','2023-06-15 17:18:18'),(3218,'default','payment_edited',5873,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"90150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"90150.0000\"}}',NULL,'2023-06-15 17:25:01','2023-06-15 17:25:01'),(3219,'default','payment_edited',5876,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3120.0000\"}}',NULL,'2023-06-15 17:25:01','2023-06-15 17:25:01'),(3220,'default','payment_edited',16285,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-06-15 17:25:01','2023-06-15 17:25:01'),(3221,'default','payment_edited',16954,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"341026.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"341026.0000\"}}',NULL,'2023-06-15 17:25:01','2023-06-15 17:25:01'),(3222,'default','added',17233,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396.6}}',NULL,'2023-06-15 17:26:36','2023-06-15 17:26:36'),(3223,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 17:33:53','2023-06-15 17:33:53'),(3224,'default','added',17234,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-15 17:36:28','2023-06-15 17:36:28'),(3225,'default','added',17235,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":145.44}}',NULL,'2023-06-15 17:56:54','2023-06-15 17:56:54'),(3226,'default','added',17236,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":134.85}}',NULL,'2023-06-15 18:00:44','2023-06-15 18:00:44'),(3227,'default','added',17237,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3240}}',NULL,'2023-06-15 18:03:28','2023-06-15 18:03:28'),(3228,'default','added',17238,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28.5}}',NULL,'2023-06-15 18:12:18','2023-06-15 18:12:18'),(3229,'default','added',17239,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-15 18:21:58','2023-06-15 18:21:58'),(3230,'default','added',17240,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":189.51}}',NULL,'2023-06-15 18:25:06','2023-06-15 18:25:06'),(3231,'default','added',17241,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-15 18:25:59','2023-06-15 18:25:59'),(3232,'default','added',17242,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":99}}',NULL,'2023-06-15 18:43:49','2023-06-15 18:43:49'),(3233,'default','added',17243,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37.06}}',NULL,'2023-06-15 19:33:58','2023-06-15 19:33:58'),(3234,'default','added',17244,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":849}}',NULL,'2023-06-15 19:50:35','2023-06-15 19:50:35'),(3235,'default','added',17245,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":943.75}}',NULL,'2023-06-15 20:16:37','2023-06-15 20:16:37'),(3236,'default','added',17246,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":163.6}}',NULL,'2023-06-15 20:22:25','2023-06-15 20:22:25'),(3237,'default','added',17247,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":109.88}}',NULL,'2023-06-15 20:31:09','2023-06-15 20:31:09'),(3238,'default','added',17248,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":989.4}}',NULL,'2023-06-15 20:36:39','2023-06-15 20:36:39'),(3239,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 20:53:47','2023-06-15 20:53:47'),(3240,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-15 20:59:11','2023-06-15 20:59:11'),(3241,'default','added',17249,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-15 20:59:12','2023-06-15 20:59:12'),(3242,'default','added',17250,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":612.5}}',NULL,'2023-06-15 21:00:15','2023-06-15 21:00:15'),(3243,'default','payment_edited',17002,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"41325.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"41325.0000\"}}',NULL,'2023-06-15 21:03:05','2023-06-15 21:03:05'),(3244,'default','edited',17096,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-15 21:04:22','2023-06-15 21:04:22'),(3245,'default','added',17251,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3842}}',NULL,'2023-06-15 21:07:13','2023-06-15 21:07:13'),(3246,'default','edited',17154,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":36586.86},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"26091.6800\"}}',NULL,'2023-06-15 21:16:16','2023-06-15 21:16:16'),(3247,'default','added',17252,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-15 21:16:16','2023-06-15 21:16:16'),(3248,'default','added',17253,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4020}}',NULL,'2023-06-15 21:19:09','2023-06-15 21:19:09'),(3249,'default','added',17254,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3347.5}}',NULL,'2023-06-15 21:31:29','2023-06-15 21:31:29'),(3250,'default','added',17255,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2948.38}}',NULL,'2023-06-15 21:33:54','2023-06-15 21:33:54'),(3251,'default','added',17256,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3096}}',NULL,'2023-06-15 21:36:05','2023-06-15 21:36:05'),(3252,'default','added',17257,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-15 21:40:24','2023-06-15 21:40:24'),(3253,'default','added',17258,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":25950}}',NULL,'2023-06-15 21:44:19','2023-06-15 21:44:19'),(3254,'default','added',17259,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13775}}',NULL,'2023-06-15 21:45:45','2023-06-15 21:45:45'),(3255,'default','added',17260,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-15 21:48:14','2023-06-15 21:48:14'),(3256,'default','added',17261,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3220}}',NULL,'2023-06-15 21:50:20','2023-06-15 21:50:20'),(3257,'default','added',17262,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15570}}',NULL,'2023-06-15 21:51:06','2023-06-15 21:51:06'),(3258,'default','added',17263,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5520}}',NULL,'2023-06-15 21:52:10','2023-06-15 21:52:10'),(3259,'default','added',17264,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-15 22:00:13','2023-06-15 22:00:13'),(3260,'default','added',17265,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-06-15 22:15:56','2023-06-15 22:15:56'),(3261,'default','added',17266,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-15 22:31:30','2023-06-15 22:31:30'),(3262,'default','added',17267,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-06-15 22:32:36','2023-06-15 22:32:36'),(3263,'default','added',17269,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":302.73}}',NULL,'2023-06-15 22:46:04','2023-06-15 22:46:04'),(3264,'default','added',17270,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-15 23:09:30','2023-06-15 23:09:30'),(3265,'default','added',17271,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-06-15 23:11:28','2023-06-15 23:11:28'),(3266,'default','added',17272,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-15 23:17:12','2023-06-15 23:17:12'),(3267,'default','added',17273,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1102.03}}',NULL,'2023-06-15 23:26:20','2023-06-15 23:26:20'),(3268,'default','added',17274,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-15 23:26:38','2023-06-15 23:26:38'),(3269,'default','added',17277,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":523.4}}',NULL,'2023-06-15 23:36:04','2023-06-15 23:36:04'),(3270,'default','edited',17272,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":789.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"240.0000\"}}',NULL,'2023-06-15 23:42:22','2023-06-15 23:42:22'),(3271,'default','added',17278,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"status\":\"final\"}}',NULL,'2023-06-15 23:43:09','2023-06-15 23:43:09'),(3272,'default','added',17280,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":660}}',NULL,'2023-06-15 23:43:14','2023-06-15 23:43:14'),(3273,'default','added',17281,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-15 23:44:27','2023-06-15 23:44:27'),(3274,'default','added',17282,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370.6}}',NULL,'2023-06-15 23:47:00','2023-06-15 23:47:00'),(3275,'default','added',17283,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":676.44}}',NULL,'2023-06-15 23:50:22','2023-06-15 23:50:22'),(3276,'default','added',148,'App\\Contact',NULL,2,31,'App\\User','[]',NULL,'2023-06-16 00:15:47','2023-06-16 00:15:47'),(3277,'default','added',17284,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":865.5}}',NULL,'2023-06-16 00:18:35','2023-06-16 00:18:35'),(3278,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-16 00:29:40','2023-06-16 00:29:40'),(3279,'default','added',17285,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27500}}',NULL,'2023-06-16 00:30:55','2023-06-16 00:30:55'),(3280,'default','edited',101,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-16 00:33:25','2023-06-16 00:33:25'),(3281,'default','edited',101,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-16 00:33:34','2023-06-16 00:33:34'),(3282,'default','edited',101,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-16 00:36:54','2023-06-16 00:36:54'),(3283,'default','added',17286,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":55100}}',NULL,'2023-06-16 00:37:38','2023-06-16 00:37:38'),(3284,'default','added',17287,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-16 00:50:43','2023-06-16 00:50:43'),(3285,'default','added',17288,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":412.02}}',NULL,'2023-06-16 00:51:04','2023-06-16 00:51:04'),(3286,'default','added',17289,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":309.26}}',NULL,'2023-06-16 00:58:22','2023-06-16 00:58:22'),(3287,'default','added',17290,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":83.06}}',NULL,'2023-06-16 01:00:16','2023-06-16 01:00:16'),(3288,'default','added',17291,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":39752.91}}',NULL,'2023-06-16 01:04:31','2023-06-16 01:04:31'),(3289,'default','added',17292,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11811.5}}',NULL,'2023-06-16 01:13:05','2023-06-16 01:13:05'),(3290,'default','added',17293,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-06-16 01:22:23','2023-06-16 01:22:23'),(3291,'default','added',17294,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-16 01:30:29','2023-06-16 01:30:29'),(3292,'default','added',17295,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":587}}',NULL,'2023-06-16 01:39:02','2023-06-16 01:39:02'),(3293,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-16 01:39:39','2023-06-16 01:39:39'),(3294,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 01:39:58','2023-06-16 01:39:58'),(3295,'default','added',17296,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79.4}}',NULL,'2023-06-16 01:44:47','2023-06-16 01:44:47'),(3296,'default','logout',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-16 01:49:29','2023-06-16 01:49:29'),(3297,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-16 01:49:47','2023-06-16 01:49:47'),(3298,'default','added',17297,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":240}}',NULL,'2023-06-16 01:51:45','2023-06-16 01:51:45'),(3299,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:02:58','2023-06-16 02:02:58'),(3300,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:03:24','2023-06-16 02:03:24'),(3301,'default','added',17298,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":83.62}}',NULL,'2023-06-16 02:03:34','2023-06-16 02:03:34'),(3302,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:03:36','2023-06-16 02:03:36'),(3303,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:03:53','2023-06-16 02:03:53'),(3304,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:04:04','2023-06-16 02:04:04'),(3305,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-16 02:04:38','2023-06-16 02:04:39'),(3306,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-16 02:16:06','2023-06-16 02:16:06'),(3307,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 02:16:29','2023-06-16 02:16:29'),(3308,'default','added',17299,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97.65}}',NULL,'2023-06-16 02:16:36','2023-06-16 02:16:36'),(3309,'default','added',17300,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-16 02:34:14','2023-06-16 02:34:14'),(3310,'default','added',17301,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24526.39}}',NULL,'2023-06-16 02:35:27','2023-06-16 02:35:27'),(3311,'default','added',17302,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":230}}',NULL,'2023-06-16 02:37:17','2023-06-16 02:37:17'),(3312,'default','added',17303,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220.9}}',NULL,'2023-06-16 02:37:32','2023-06-16 02:37:32'),(3313,'default','added',17304,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":535.48}}',NULL,'2023-06-16 03:14:09','2023-06-16 03:14:09'),(3314,'default','added',17305,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 03:25:10','2023-06-16 03:25:10'),(3315,'default','added',17306,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-16 03:38:08','2023-06-16 03:38:08'),(3316,'default','added',17307,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":49656.19}}',NULL,'2023-06-16 03:46:12','2023-06-16 03:46:12'),(3317,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 03:46:49','2023-06-16 03:46:49'),(3318,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-16 03:47:08','2023-06-16 03:47:08'),(3319,'default','added',17308,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89}}',NULL,'2023-06-16 04:09:18','2023-06-16 04:09:18'),(3320,'default','added',17309,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-16 04:10:59','2023-06-16 04:10:59'),(3321,'default','added',17310,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":336}}',NULL,'2023-06-16 04:45:40','2023-06-16 04:45:40'),(3322,'default','added',17311,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1287}}',NULL,'2023-06-16 04:48:27','2023-06-16 04:48:27'),(3323,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 05:15:13','2023-06-16 05:15:13'),(3324,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-16 13:38:52','2023-06-16 13:38:52'),(3325,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-16 13:45:36','2023-06-16 13:45:36'),(3326,'default','payment_edited',17286,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"55100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"55100.0000\"}}',NULL,'2023-06-16 13:46:55','2023-06-16 13:46:55'),(3327,'default','added',17312,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-06-16 13:47:46','2023-06-16 13:47:46'),(3328,'default','added',17313,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 13:51:29','2023-06-16 13:51:29'),(3329,'default','added',17314,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1728.67}}',NULL,'2023-06-16 14:19:49','2023-06-16 14:19:49'),(3330,'default','added',17315,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3143.17}}',NULL,'2023-06-16 14:21:46','2023-06-16 14:21:46'),(3331,'default','added',17316,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":299.57}}',NULL,'2023-06-16 14:28:58','2023-06-16 14:28:58'),(3332,'default','added',17317,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":292}}',NULL,'2023-06-16 15:34:17','2023-06-16 15:34:17'),(3333,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-16 15:46:34','2023-06-16 15:46:34'),(3334,'default','added',17318,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-16 15:47:40','2023-06-16 15:47:40'),(3335,'default','added',17319,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 15:52:30','2023-06-16 15:52:30'),(3336,'default','added',17320,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-16 15:54:08','2023-06-16 15:54:08'),(3337,'default','added',17321,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-16 16:07:58','2023-06-16 16:07:58'),(3338,'default','added',17322,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 16:09:29','2023-06-16 16:09:29'),(3339,'default','added',17323,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 16:38:12','2023-06-16 16:38:12'),(3340,'default','added',17324,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-16 17:15:09','2023-06-16 17:15:09'),(3341,'default','added',17325,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-16 17:15:32','2023-06-16 17:15:32'),(3342,'default','added',17326,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68.53}}',NULL,'2023-06-16 17:15:51','2023-06-16 17:15:51'),(3343,'default','added',17327,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-16 17:17:10','2023-06-16 17:17:10'),(3344,'default','added',17328,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":427.5}}',NULL,'2023-06-16 17:19:51','2023-06-16 17:19:51'),(3345,'default','added',17329,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1130.84}}',NULL,'2023-06-16 17:27:27','2023-06-16 17:27:27'),(3346,'default','added',17330,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-16 17:29:13','2023-06-16 17:29:13'),(3347,'default','added',17331,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335}}',NULL,'2023-06-16 17:35:46','2023-06-16 17:35:46'),(3348,'default','added',17332,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-06-16 17:54:07','2023-06-16 17:54:07'),(3349,'default','added',17333,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1546.01}}',NULL,'2023-06-16 18:39:46','2023-06-16 18:39:46'),(3350,'default','added',17334,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.6}}',NULL,'2023-06-16 18:46:31','2023-06-16 18:46:31'),(3351,'default','added',17335,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-16 19:01:19','2023-06-16 19:01:19'),(3352,'default','added',17336,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-16 19:18:39','2023-06-16 19:18:39'),(3353,'default','added',17337,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":102.28}}',NULL,'2023-06-16 19:39:53','2023-06-16 19:39:53'),(3354,'default','added',17338,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":670}}',NULL,'2023-06-16 20:04:59','2023-06-16 20:04:59'),(3355,'default','added',17339,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-16 20:05:43','2023-06-16 20:05:43'),(3356,'default','added',17340,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":295.61}}',NULL,'2023-06-16 20:19:25','2023-06-16 20:19:25'),(3357,'default','added',17341,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-16 20:26:15','2023-06-16 20:26:15'),(3358,'default','added',17342,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-16 20:29:06','2023-06-16 20:29:06'),(3359,'default','added',17345,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475.02}}',NULL,'2023-06-16 21:05:46','2023-06-16 21:05:46'),(3360,'default','added',17346,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-16 21:14:53','2023-06-16 21:14:53'),(3361,'default','added',17347,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":436.05}}',NULL,'2023-06-16 21:21:11','2023-06-16 21:21:11'),(3362,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-16 21:31:16','2023-06-16 21:31:16'),(3363,'default','added',17348,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":256.6}}',NULL,'2023-06-16 21:44:39','2023-06-16 21:44:39'),(3364,'default','added',17349,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-16 21:48:25','2023-06-16 21:48:25'),(3365,'default','added',17350,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-16 21:57:17','2023-06-16 21:57:17'),(3366,'default','added',17351,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94.53}}',NULL,'2023-06-16 22:03:04','2023-06-16 22:03:04'),(3367,'default','added',17352,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-16 22:21:58','2023-06-16 22:21:58'),(3368,'default','added',17353,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.58}}',NULL,'2023-06-16 22:23:42','2023-06-16 22:23:42'),(3369,'default','added',17354,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":822.2}}',NULL,'2023-06-16 22:50:31','2023-06-16 22:50:31'),(3370,'default','added',17355,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":588.28}}',NULL,'2023-06-16 22:54:23','2023-06-16 22:54:23'),(3371,'default','added',17356,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-16 22:59:04','2023-06-16 22:59:04'),(3372,'default','added',17357,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-16 23:07:01','2023-06-16 23:07:01'),(3373,'default','added',17358,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-16 23:25:48','2023-06-16 23:25:48'),(3374,'default','added',17359,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-16 23:26:06','2023-06-16 23:26:06'),(3375,'default','added',17360,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-16 23:44:01','2023-06-16 23:44:01'),(3376,'default','added',17361,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":217.14}}',NULL,'2023-06-16 23:56:27','2023-06-16 23:56:27'),(3377,'default','added',17362,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-17 00:03:25','2023-06-17 00:03:25'),(3378,'default','added',17363,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-17 00:09:54','2023-06-17 00:09:54'),(3379,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 00:16:52','2023-06-17 00:16:52'),(3380,'default','added',17364,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-17 00:22:54','2023-06-17 00:22:54'),(3381,'default','added',17365,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-17 00:27:00','2023-06-17 00:27:00'),(3382,'default','added',17366,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3087.2}}',NULL,'2023-06-17 00:41:05','2023-06-17 00:41:05'),(3383,'default','added',17367,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540}}',NULL,'2023-06-17 00:43:25','2023-06-17 00:43:25'),(3384,'default','added',17368,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":470}}',NULL,'2023-06-17 00:52:49','2023-06-17 00:52:49'),(3385,'default','added',17369,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97.3}}',NULL,'2023-06-17 00:58:35','2023-06-17 00:58:35'),(3386,'default','payment_edited',17000,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33175.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33175.0000\"}}',NULL,'2023-06-17 00:59:43','2023-06-17 00:59:43'),(3387,'default','payment_edited',17009,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36200.0000\"}}',NULL,'2023-06-17 01:02:18','2023-06-17 01:02:18'),(3388,'default','payment_edited',5825,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 01:03:25','2023-06-17 01:03:25'),(3389,'default','added',17370,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-06-17 01:08:06','2023-06-17 01:08:06'),(3390,'default','added',17371,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4989}}',NULL,'2023-06-17 01:11:46','2023-06-17 01:11:46'),(3391,'default','added',17372,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17687}}',NULL,'2023-06-17 01:14:09','2023-06-17 01:14:09'),(3392,'default','added',17373,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2023-06-17 01:29:06','2023-06-17 01:29:06'),(3393,'default','added',17374,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":589.34}}',NULL,'2023-06-17 01:34:54','2023-06-17 01:34:55'),(3394,'default','added',17375,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-17 01:35:19','2023-06-17 01:35:19'),(3395,'default','added',17376,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":886.38}}',NULL,'2023-06-17 01:36:38','2023-06-17 01:36:38'),(3396,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-17 01:45:48','2023-06-17 01:45:48'),(3397,'default','added',17377,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":285.3}}',NULL,'2023-06-17 02:05:12','2023-06-17 02:05:12'),(3398,'default','added',17378,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-06-17 02:07:13','2023-06-17 02:07:13'),(3399,'default','added',17379,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53.4}}',NULL,'2023-06-17 02:10:36','2023-06-17 02:10:36'),(3400,'default','added',17380,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2698.6}}',NULL,'2023-06-17 02:19:53','2023-06-17 02:19:53'),(3401,'default','added',17381,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1140}}',NULL,'2023-06-17 02:24:33','2023-06-17 02:24:33'),(3402,'default','added',17382,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2023-06-17 02:26:15','2023-06-17 02:26:15'),(3403,'default','added',17383,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":849}}',NULL,'2023-06-17 02:36:01','2023-06-17 02:36:01'),(3404,'default','added',17384,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2501.49}}',NULL,'2023-06-17 02:37:04','2023-06-17 02:37:04'),(3405,'default','added',17385,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2023-06-17 02:38:54','2023-06-17 02:38:54'),(3406,'default','added',17386,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2558.92}}',NULL,'2023-06-17 02:42:28','2023-06-17 02:42:28'),(3407,'default','added',17387,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-17 02:42:50','2023-06-17 02:42:50'),(3408,'default','added',17388,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":432.25}}',NULL,'2023-06-17 02:49:14','2023-06-17 02:49:14'),(3409,'default','added',17389,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1877.04}}',NULL,'2023-06-17 03:01:17','2023-06-17 03:01:17'),(3410,'default','added',17390,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2732.4}}',NULL,'2023-06-17 03:01:47','2023-06-17 03:01:47'),(3411,'default','added',17391,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":603.87}}',NULL,'2023-06-17 03:04:35','2023-06-17 03:04:35'),(3412,'default','added',17392,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":339.22}}',NULL,'2023-06-17 03:20:55','2023-06-17 03:20:55'),(3413,'default','added',17393,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":398.2}}',NULL,'2023-06-17 03:21:53','2023-06-17 03:21:53'),(3414,'default','added',17394,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":718}}',NULL,'2023-06-17 03:30:39','2023-06-17 03:30:39'),(3415,'default','added',17395,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":83.82}}',NULL,'2023-06-17 03:30:42','2023-06-17 03:30:42'),(3416,'default','added',17396,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":339.5}}',NULL,'2023-06-17 03:54:18','2023-06-17 03:54:18'),(3417,'default','added',17397,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147.12}}',NULL,'2023-06-17 04:27:58','2023-06-17 04:27:58'),(3418,'default','added',17398,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-17 04:31:22','2023-06-17 04:31:22'),(3419,'default','added',17399,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-17 04:33:41','2023-06-17 04:33:41'),(3420,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-17 05:08:50','2023-06-17 05:08:50'),(3421,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-17 13:50:27','2023-06-17 13:50:27'),(3422,'default','added',17400,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":161.5}}',NULL,'2023-06-17 13:51:22','2023-06-17 13:51:22'),(3423,'default','added',17401,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-17 14:13:45','2023-06-17 14:13:45'),(3424,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 14:15:35','2023-06-17 14:15:35'),(3425,'default','added',17402,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":96.6}}',NULL,'2023-06-17 14:24:13','2023-06-17 14:24:13'),(3426,'default','added',17403,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-17 14:37:52','2023-06-17 14:37:52'),(3427,'default','added',17404,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2372.01}}',NULL,'2023-06-17 14:42:39','2023-06-17 14:42:39'),(3428,'default','added',17405,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1805.9}}',NULL,'2023-06-17 14:44:06','2023-06-17 14:44:06'),(3429,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-17 14:44:35','2023-06-17 14:44:35'),(3430,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 14:52:13','2023-06-17 14:52:13'),(3431,'default','added',17406,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22.8}}',NULL,'2023-06-17 14:55:12','2023-06-17 14:55:12'),(3432,'default','edited',17371,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3259},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4989.0000\"}}',NULL,'2023-06-17 14:55:44','2023-06-17 14:55:44'),(3433,'default','edited',17262,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10380},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15570.0000\"}}',NULL,'2023-06-17 14:56:29','2023-06-17 14:56:29'),(3434,'default','edited',17262,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5190},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10380.0000\"}}',NULL,'2023-06-17 15:00:48','2023-06-17 15:00:48'),(3435,'default','added',17407,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":82730}}',NULL,'2023-06-17 15:02:54','2023-06-17 15:02:54'),(3436,'default','added',17408,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16900}}',NULL,'2023-06-17 15:03:30','2023-06-17 15:03:30'),(3437,'default','added',17409,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8450}}',NULL,'2023-06-17 15:04:11','2023-06-17 15:04:11'),(3438,'default','added',17410,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-17 15:05:24','2023-06-17 15:05:24'),(3439,'default','added',17411,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-17 15:06:01','2023-06-17 15:06:01'),(3440,'default','added',149,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 15:08:00','2023-06-17 15:08:00'),(3441,'default','added',17412,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":47485}}',NULL,'2023-06-17 15:15:38','2023-06-17 15:15:38'),(3442,'default','payment_edited',17010,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-17 15:21:51','2023-06-17 15:21:51'),(3443,'default','added',17413,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2579.49}}',NULL,'2023-06-17 15:39:07','2023-06-17 15:39:07'),(3444,'default','added',17414,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":451.25}}',NULL,'2023-06-17 15:42:04','2023-06-17 15:42:05'),(3445,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-17 16:16:28','2023-06-17 16:16:28'),(3446,'default','added',17415,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-06-17 16:28:14','2023-06-17 16:28:14'),(3447,'default','added',17416,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-17 17:25:05','2023-06-17 17:25:05'),(3448,'default','added',17417,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-17 17:43:23','2023-06-17 17:43:24'),(3449,'default','added',17418,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":356.4}}',NULL,'2023-06-17 17:54:12','2023-06-17 17:54:12'),(3450,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-17 18:17:10','2023-06-17 18:17:10'),(3451,'default','added',17419,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":27550}}',NULL,'2023-06-17 18:18:00','2023-06-17 18:18:00'),(3452,'default','payment_edited',17258,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"25950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"25950.0000\"}}',NULL,'2023-06-17 18:19:04','2023-06-17 18:19:04'),(3453,'default','payment_edited',16991,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-17 18:19:40','2023-06-17 18:19:40'),(3454,'default','payment_edited',17410,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-17 18:19:40','2023-06-17 18:19:40'),(3455,'default','added',17420,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-17 18:20:13','2023-06-17 18:20:13'),(3456,'default','payment_edited',17040,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15875.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15875.0000\"}}',NULL,'2023-06-17 18:20:24','2023-06-17 18:20:24'),(3457,'default','added',17421,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":253}}',NULL,'2023-06-17 18:20:43','2023-06-17 18:20:43'),(3458,'default','payment_edited',17014,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28025.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28025.0000\"}}',NULL,'2023-06-17 18:21:26','2023-06-17 18:21:26'),(3459,'default','added',17422,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5510}}',NULL,'2023-06-17 18:21:53','2023-06-17 18:21:53'),(3460,'default','added',17423,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22.36}}',NULL,'2023-06-17 18:23:14','2023-06-17 18:23:14'),(3461,'default','added',17424,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-17 18:24:30','2023-06-17 18:24:30'),(3462,'default','added',17425,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":62392.6}}',NULL,'2023-06-17 18:36:55','2023-06-17 18:36:55'),(3463,'default','added',17426,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.34}}',NULL,'2023-06-17 18:38:26','2023-06-17 18:38:26'),(3464,'default','added',17427,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86.48}}',NULL,'2023-06-17 18:39:24','2023-06-17 18:39:24'),(3465,'default','added',17428,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":238.36}}',NULL,'2023-06-17 18:46:38','2023-06-17 18:46:38'),(3466,'default','added',17429,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-17 18:48:01','2023-06-17 18:48:01'),(3467,'default','added',17430,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2331.18}}',NULL,'2023-06-17 18:50:20','2023-06-17 18:50:20'),(3468,'default','added',17431,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4020.63}}',NULL,'2023-06-17 18:54:17','2023-06-17 18:54:17'),(3469,'default','added',17432,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":479.78}}',NULL,'2023-06-17 18:55:39','2023-06-17 18:55:39'),(3470,'default','added',17433,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-17 18:59:16','2023-06-17 18:59:16'),(3471,'default','added',17434,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":96.6}}',NULL,'2023-06-17 19:02:41','2023-06-17 19:02:41'),(3472,'default','added',17435,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-06-17 19:04:14','2023-06-17 19:04:14'),(3473,'default','added',17436,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-17 19:06:53','2023-06-17 19:06:53'),(3474,'default','added',17437,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-17 19:08:58','2023-06-17 19:08:58'),(3475,'default','added',17438,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-17 19:29:14','2023-06-17 19:29:14'),(3476,'default','added',17439,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":349.88}}',NULL,'2023-06-17 20:01:39','2023-06-17 20:01:39'),(3477,'default','added',17440,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-17 20:02:23','2023-06-17 20:02:23'),(3478,'default','added',17441,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":308.1}}',NULL,'2023-06-17 20:07:57','2023-06-17 20:07:57'),(3479,'default','added',17442,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53.49}}',NULL,'2023-06-17 20:09:45','2023-06-17 20:09:45'),(3480,'default','added',17443,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40.55}}',NULL,'2023-06-17 20:22:25','2023-06-17 20:22:25'),(3481,'default','added',17444,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44.6}}',NULL,'2023-06-17 20:31:16','2023-06-17 20:31:16'),(3482,'default','added',17445,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-17 20:57:14','2023-06-17 20:57:14'),(3483,'default','added',17446,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-17 21:05:48','2023-06-17 21:05:48'),(3484,'default','added',17447,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-17 21:14:18','2023-06-17 21:14:18'),(3485,'default','added',17448,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":290}}',NULL,'2023-06-17 21:19:13','2023-06-17 21:19:13'),(3486,'default','added',17449,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-17 21:29:14','2023-06-17 21:29:14'),(3487,'default','added',17450,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":275.51}}',NULL,'2023-06-17 21:35:26','2023-06-17 21:35:26'),(3488,'default','added',17451,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-17 21:45:35','2023-06-17 21:45:35'),(3489,'default','added',17452,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-17 21:51:49','2023-06-17 21:51:49'),(3490,'default','added',17453,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2416.22}}',NULL,'2023-06-17 21:55:38','2023-06-17 21:55:38'),(3491,'default','added',17454,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-17 22:17:24','2023-06-17 22:17:24'),(3492,'default','added',17455,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-17 22:24:09','2023-06-17 22:24:09'),(3493,'default','added',17456,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":609.33}}',NULL,'2023-06-17 22:25:14','2023-06-17 22:25:14'),(3494,'default','added',17457,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":362.85}}',NULL,'2023-06-17 22:34:23','2023-06-17 22:34:23'),(3495,'default','added',17458,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.2}}',NULL,'2023-06-17 22:36:51','2023-06-17 22:36:51'),(3496,'default','added',17459,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-17 22:44:04','2023-06-17 22:44:04'),(3497,'default','added',17460,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-06-17 22:57:06','2023-06-17 22:57:06'),(3498,'default','added',17461,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":373.92}}',NULL,'2023-06-17 23:20:07','2023-06-17 23:20:07'),(3499,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-17 23:38:20','2023-06-17 23:38:20'),(3500,'default','added',17462,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":62.81}}',NULL,'2023-06-17 23:38:50','2023-06-17 23:38:50'),(3501,'default','added',17463,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":626}}',NULL,'2023-06-17 23:39:05','2023-06-17 23:39:05'),(3502,'default','added',17464,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.7}}',NULL,'2023-06-17 23:45:47','2023-06-17 23:45:47'),(3503,'default','added',17465,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-17 23:56:45','2023-06-17 23:56:45'),(3504,'default','added',17466,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65}}',NULL,'2023-06-18 00:06:23','2023-06-18 00:06:23'),(3505,'default','added',17467,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":388}}',NULL,'2023-06-18 00:06:59','2023-06-18 00:06:59'),(3506,'default','added',17468,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-18 00:08:07','2023-06-18 00:08:07'),(3507,'default','added',17469,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-18 00:39:59','2023-06-18 00:39:59'),(3508,'default','added',17470,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":308.75}}',NULL,'2023-06-18 00:47:32','2023-06-18 00:47:32'),(3509,'default','added',17471,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400.41}}',NULL,'2023-06-18 00:49:59','2023-06-18 00:49:59'),(3510,'default','added',17472,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":283.56}}',NULL,'2023-06-18 01:06:10','2023-06-18 01:06:10'),(3511,'default','added',17473,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-18 01:18:29','2023-06-18 01:18:29'),(3512,'default','added',17474,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-18 01:32:58','2023-06-18 01:32:58'),(3513,'default','added',17475,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-18 01:44:36','2023-06-18 01:44:36'),(3514,'default','added',17476,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980.84}}',NULL,'2023-06-18 01:46:35','2023-06-18 01:46:35'),(3515,'default','added',17477,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-06-18 01:51:59','2023-06-18 01:51:59'),(3516,'default','edited',17475,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"180.0000\"}}',NULL,'2023-06-18 01:53:46','2023-06-18 01:53:46'),(3517,'default','added',17478,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":566.4}}',NULL,'2023-06-18 01:54:58','2023-06-18 01:54:58'),(3518,'default','added',17479,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450.96}}',NULL,'2023-06-18 01:58:26','2023-06-18 01:58:26'),(3519,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-18 02:29:45','2023-06-18 02:29:45'),(3520,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-18 02:33:12','2023-06-18 02:33:12'),(3521,'default','added',17480,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53.4}}',NULL,'2023-06-18 02:33:58','2023-06-18 02:33:58'),(3522,'default','added',17481,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":117.15}}',NULL,'2023-06-18 02:39:28','2023-06-18 02:39:28'),(3523,'default','added',17482,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-18 02:47:21','2023-06-18 02:47:21'),(3524,'default','added',17483,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-18 03:07:04','2023-06-18 03:07:04'),(3525,'default','added',17484,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-06-18 03:10:17','2023-06-18 03:10:17'),(3526,'default','added',17485,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":698.23}}',NULL,'2023-06-18 03:27:52','2023-06-18 03:27:52'),(3527,'default','added',17486,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-06-18 03:30:41','2023-06-18 03:30:41'),(3528,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-18 03:34:37','2023-06-18 03:34:37'),(3529,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-18 03:34:55','2023-06-18 03:34:55'),(3530,'default','added',17487,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":160.9}}',NULL,'2023-06-18 03:38:52','2023-06-18 03:38:52'),(3531,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-18 03:39:17','2023-06-18 03:39:17'),(3532,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-18 03:39:36','2023-06-18 03:39:36'),(3533,'default','added',17488,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7.71}}',NULL,'2023-06-18 04:17:23','2023-06-18 04:17:23'),(3534,'default','added',17489,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":292}}',NULL,'2023-06-18 04:20:59','2023-06-18 04:20:59'),(3535,'default','logout',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-18 04:21:23','2023-06-18 04:21:23'),(3536,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-18 04:21:58','2023-06-18 04:21:58'),(3537,'default','added',17490,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-18 04:31:15','2023-06-18 04:31:15'),(3538,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-18 14:02:20','2023-06-18 14:02:20'),(3539,'default','added',17491,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-18 14:06:28','2023-06-18 14:06:28'),(3540,'default','added',17492,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":737.5}}',NULL,'2023-06-18 14:49:21','2023-06-18 14:49:21'),(3541,'default','added',17493,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1336.2}}',NULL,'2023-06-18 15:13:19','2023-06-18 15:13:19'),(3542,'default','added',17494,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1138}}',NULL,'2023-06-18 15:33:49','2023-06-18 15:33:49'),(3543,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-18 15:43:30','2023-06-18 15:43:30'),(3544,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-18 15:47:11','2023-06-18 15:47:11'),(3545,'default','added',17495,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":111.8}}',NULL,'2023-06-18 15:47:18','2023-06-18 15:47:18'),(3546,'default','added',17496,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-18 15:49:19','2023-06-18 15:49:19'),(3547,'default','added',17497,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6.3}}',NULL,'2023-06-18 15:50:07','2023-06-18 15:50:07'),(3548,'default','added',17498,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-18 16:08:49','2023-06-18 16:08:49'),(3549,'default','added',17499,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1980.89}}',NULL,'2023-06-18 16:10:07','2023-06-18 16:10:07'),(3550,'default','added',17500,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":154}}',NULL,'2023-06-18 16:22:01','2023-06-18 16:22:01'),(3551,'default','added',17501,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":740.01}}',NULL,'2023-06-18 16:24:53','2023-06-18 16:24:53'),(3552,'default','added',17502,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1314.9}}',NULL,'2023-06-18 16:39:11','2023-06-18 16:39:11'),(3553,'default','added',17503,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39.05}}',NULL,'2023-06-18 16:41:17','2023-06-18 16:41:17'),(3554,'default','added',17504,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":548}}',NULL,'2023-06-18 16:57:47','2023-06-18 16:57:47'),(3555,'default','added',17505,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":329.98}}',NULL,'2023-06-18 17:15:25','2023-06-18 17:15:25'),(3556,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-18 17:51:34','2023-06-18 17:51:34'),(3557,'default','added',17506,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":253.81}}',NULL,'2023-06-18 17:59:05','2023-06-18 17:59:05'),(3558,'default','added',17507,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-18 18:01:33','2023-06-18 18:01:33'),(3559,'default','added',17508,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":164}}',NULL,'2023-06-18 18:06:04','2023-06-18 18:06:04'),(3560,'default','added',17509,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":426.4}}',NULL,'2023-06-18 18:11:31','2023-06-18 18:11:31'),(3561,'default','added',17510,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":159.3}}',NULL,'2023-06-18 18:13:05','2023-06-18 18:13:05'),(3562,'default','added',17511,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-18 18:19:48','2023-06-18 18:19:48'),(3563,'default','added',17512,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-18 18:22:00','2023-06-18 18:22:00'),(3564,'default','added',17513,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":793.75}}',NULL,'2023-06-18 18:33:54','2023-06-18 18:33:54'),(3565,'default','added',17514,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":277.2}}',NULL,'2023-06-18 18:37:40','2023-06-18 18:37:40'),(3566,'default','added',17515,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-18 18:55:36','2023-06-18 18:55:36'),(3567,'default','added',17516,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}',NULL,'2023-06-18 18:57:04','2023-06-18 18:57:04'),(3568,'default','added',17517,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":290}}',NULL,'2023-06-18 19:10:05','2023-06-18 19:10:05'),(3569,'default','added',17518,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":775}}',NULL,'2023-06-18 19:20:33','2023-06-18 19:20:33'),(3570,'default','added',17519,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228}}',NULL,'2023-06-18 19:45:57','2023-06-18 19:45:57'),(3571,'default','added',17520,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-18 19:55:11','2023-06-18 19:55:11'),(3572,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-18 20:07:14','2023-06-18 20:07:14'),(3573,'default','added',17521,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":417.5}}',NULL,'2023-06-18 20:14:48','2023-06-18 20:14:48'),(3574,'default','added',17522,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":422.1}}',NULL,'2023-06-18 20:49:21','2023-06-18 20:49:21'),(3575,'default','added',17523,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":320}}',NULL,'2023-06-18 20:49:36','2023-06-18 20:49:36'),(3576,'default','added',17524,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":635.7}}',NULL,'2023-06-18 21:26:24','2023-06-18 21:26:24'),(3577,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-18 21:35:52','2023-06-18 21:35:53'),(3578,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-18 21:41:39','2023-06-18 21:41:39'),(3579,'default','added',17525,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71630}}',NULL,'2023-06-18 21:49:57','2023-06-18 21:49:57'),(3580,'default','payment_edited',17018,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30916.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"30916.0000\"}}',NULL,'2023-06-18 21:52:29','2023-06-18 21:52:29'),(3581,'default','payment_edited',16983,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"92250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"92250.0000\"}}',NULL,'2023-06-18 21:54:16','2023-06-18 21:54:16'),(3582,'default','payment_edited',17407,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"82730.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"82730.0000\"}}',NULL,'2023-06-18 21:54:16','2023-06-18 21:54:16'),(3583,'default','added',17526,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.8}}',NULL,'2023-06-18 21:54:56','2023-06-18 21:54:56'),(3584,'default','added',17527,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-18 21:55:46','2023-06-18 21:55:46'),(3585,'default','added',17528,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-18 21:56:44','2023-06-18 21:56:44'),(3586,'default','added',17529,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-18 22:05:29','2023-06-18 22:05:29'),(3587,'default','added',17530,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-18 22:08:16','2023-06-18 22:08:16'),(3588,'default','added',17531,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9.05}}',NULL,'2023-06-18 22:11:54','2023-06-18 22:11:54'),(3589,'default','added',17532,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2.26}}',NULL,'2023-06-18 22:24:31','2023-06-18 22:24:31'),(3590,'default','added',17533,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-06-18 22:42:02','2023-06-18 22:42:02'),(3591,'default','added',17534,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":653.75}}',NULL,'2023-06-18 22:45:26','2023-06-18 22:45:26'),(3592,'default','added',17535,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294.01}}',NULL,'2023-06-18 22:52:25','2023-06-18 22:52:25'),(3593,'default','added',17536,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.53}}',NULL,'2023-06-18 23:02:24','2023-06-18 23:02:24'),(3594,'default','added',17537,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-18 23:02:51','2023-06-18 23:02:51'),(3595,'default','added',17538,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-18 23:07:23','2023-06-18 23:07:23'),(3596,'default','added',17539,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":357.11}}',NULL,'2023-06-18 23:07:24','2023-06-18 23:07:24'),(3597,'default','added',17540,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-18 23:23:10','2023-06-18 23:23:10'),(3598,'default','added',17541,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-18 23:23:53','2023-06-18 23:23:53'),(3599,'default','added',17542,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":230.55}}',NULL,'2023-06-18 23:29:57','2023-06-18 23:29:57'),(3600,'default','added',17543,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":279.34}}',NULL,'2023-06-18 23:31:42','2023-06-18 23:31:42'),(3601,'default','added',17544,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-18 23:35:24','2023-06-18 23:35:24'),(3602,'default','added',17545,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-18 23:35:54','2023-06-18 23:35:54'),(3603,'default','added',17546,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-18 23:36:29','2023-06-18 23:36:29'),(3604,'default','added',17547,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2023-06-18 23:54:19','2023-06-18 23:54:19'),(3605,'default','added',17548,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-18 23:55:40','2023-06-18 23:55:40'),(3606,'default','added',17549,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-18 23:59:22','2023-06-18 23:59:22'),(3607,'default','added',17550,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":209.54}}',NULL,'2023-06-19 00:01:24','2023-06-19 00:01:24'),(3608,'default','added',17551,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-06-19 00:22:26','2023-06-19 00:22:26'),(3609,'default','added',150,'App\\Contact',NULL,2,31,'App\\User','[]',NULL,'2023-06-19 01:01:45','2023-06-19 01:01:45'),(3610,'default','added',17552,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-19 01:02:40','2023-06-19 01:02:40'),(3611,'default','added',17553,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8010}}',NULL,'2023-06-19 01:06:58','2023-06-19 01:06:58'),(3612,'default','added',17554,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":33931.9}}',NULL,'2023-06-19 01:14:16','2023-06-19 01:14:16'),(3613,'default','added',17555,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5480.09}}',NULL,'2023-06-19 01:18:33','2023-06-19 01:18:33'),(3614,'default','added',17556,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-19 01:25:36','2023-06-19 01:25:36'),(3615,'default','added',17557,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110}}',NULL,'2023-06-19 01:33:17','2023-06-19 01:33:17'),(3616,'default','added',17558,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":197.7}}',NULL,'2023-06-19 01:42:09','2023-06-19 01:42:09'),(3617,'default','added',17559,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1394.83}}',NULL,'2023-06-19 01:49:04','2023-06-19 01:49:04'),(3618,'default','added',17560,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-06-19 01:50:30','2023-06-19 01:50:30'),(3619,'default','added',17561,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-06-19 02:06:22','2023-06-19 02:06:22'),(3620,'default','added',17562,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1189.04}}',NULL,'2023-06-19 02:11:04','2023-06-19 02:11:04'),(3621,'default','added',17563,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":288.95}}',NULL,'2023-06-19 02:18:31','2023-06-19 02:18:31'),(3622,'default','added',17564,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":564.72}}',NULL,'2023-06-19 02:54:06','2023-06-19 02:54:06'),(3623,'default','added',17565,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":174.32}}',NULL,'2023-06-19 02:55:22','2023-06-19 02:55:22'),(3624,'default','added',17566,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1159.12}}',NULL,'2023-06-19 03:00:44','2023-06-19 03:00:44'),(3625,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-19 03:08:40','2023-06-19 03:08:40'),(3626,'default','added',17567,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":189.56}}',NULL,'2023-06-19 03:10:07','2023-06-19 03:10:07'),(3627,'default','added',17568,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1108.81}}',NULL,'2023-06-19 03:13:07','2023-06-19 03:13:07'),(3628,'default','added',17569,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.4}}',NULL,'2023-06-19 03:24:14','2023-06-19 03:24:14'),(3629,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-19 03:27:22','2023-06-19 03:27:22'),(3630,'default','added',17570,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":262.8}}',NULL,'2023-06-19 03:42:22','2023-06-19 03:42:22'),(3631,'default','added',17571,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}',NULL,'2023-06-19 03:46:08','2023-06-19 03:46:08'),(3632,'default','added',17572,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-19 03:46:26','2023-06-19 03:46:26'),(3633,'default','added',17573,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114}}',NULL,'2023-06-19 04:08:26','2023-06-19 04:08:26'),(3634,'default','added',17574,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":172.05}}',NULL,'2023-06-19 04:21:09','2023-06-19 04:21:09'),(3635,'default','added',17575,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":239.42}}',NULL,'2023-06-19 04:30:37','2023-06-19 04:30:37'),(3636,'default','added',17576,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-06-19 04:36:11','2023-06-19 04:36:11'),(3637,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-19 13:53:48','2023-06-19 13:53:48'),(3638,'default','added',17577,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-19 14:46:07','2023-06-19 14:46:07'),(3639,'default','added',17578,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2277.5}}',NULL,'2023-06-19 15:30:56','2023-06-19 15:30:56'),(3640,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-19 15:42:45','2023-06-19 15:42:45'),(3641,'default','added',17579,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":234.6}}',NULL,'2023-06-19 15:54:26','2023-06-19 15:54:26'),(3642,'default','added',17580,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-19 16:10:31','2023-06-19 16:10:31'),(3643,'default','added',17581,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":157.5}}',NULL,'2023-06-19 16:18:37','2023-06-19 16:18:37'),(3644,'default','edited',17581,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":46.46},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"157.5000\"}}',NULL,'2023-06-19 16:20:24','2023-06-19 16:20:24'),(3645,'default','added',17582,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":636.5}}',NULL,'2023-06-19 16:37:11','2023-06-19 16:37:11'),(3646,'default','added',17583,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-19 16:38:19','2023-06-19 16:38:19'),(3647,'default','added',17584,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":193.2}}',NULL,'2023-06-19 16:55:22','2023-06-19 16:55:22'),(3648,'default','added',17585,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-19 17:14:32','2023-06-19 17:14:32'),(3649,'default','added',17586,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525}}',NULL,'2023-06-19 17:29:23','2023-06-19 17:29:23'),(3650,'default','added',17587,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-19 17:31:35','2023-06-19 17:31:35'),(3651,'default','added',17588,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":278.24}}',NULL,'2023-06-19 17:35:27','2023-06-19 17:35:27'),(3652,'default','added',17589,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-19 17:36:13','2023-06-19 17:36:13'),(3653,'default','added',17590,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":356.4}}',NULL,'2023-06-19 17:44:58','2023-06-19 17:44:58'),(3654,'default','added',17591,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33.2}}',NULL,'2023-06-19 17:46:32','2023-06-19 17:46:32'),(3655,'default','added',17592,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69.3}}',NULL,'2023-06-19 18:09:40','2023-06-19 18:09:40'),(3656,'default','added',17593,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-19 18:17:57','2023-06-19 18:17:57'),(3657,'default','added',17594,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3750}}',NULL,'2023-06-19 18:20:32','2023-06-19 18:20:32'),(3658,'default','added',17595,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":719}}',NULL,'2023-06-19 18:21:28','2023-06-19 18:21:28'),(3659,'default','added',17596,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":210}}',NULL,'2023-06-19 18:27:07','2023-06-19 18:27:07'),(3660,'default','added',17597,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-19 18:27:51','2023-06-19 18:27:51'),(3661,'default','added',17598,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-19 18:37:06','2023-06-19 18:37:06'),(3662,'default','added',17599,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-19 19:25:06','2023-06-19 19:25:06'),(3663,'default','added',17600,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":279.76}}',NULL,'2023-06-19 19:32:48','2023-06-19 19:32:48'),(3664,'default','added',17601,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270.12}}',NULL,'2023-06-19 19:42:36','2023-06-19 19:42:36'),(3665,'default','added',17602,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1877.04}}',NULL,'2023-06-19 19:46:32','2023-06-19 19:46:32'),(3666,'default','added',17603,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-19 20:33:25','2023-06-19 20:33:25'),(3667,'default','added',17604,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-06-19 21:23:14','2023-06-19 21:23:14'),(3668,'default','added',17605,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":228.25}}',NULL,'2023-06-19 21:43:56','2023-06-19 21:43:56'),(3669,'default','added',17606,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":169.88}}',NULL,'2023-06-19 21:54:06','2023-06-19 21:54:06'),(3670,'default','added',17607,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196.57}}',NULL,'2023-06-19 21:55:37','2023-06-19 21:55:37'),(3671,'default','added',17608,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":358.26}}',NULL,'2023-06-19 21:58:59','2023-06-19 21:58:59'),(3672,'default','added',17609,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":184.5}}',NULL,'2023-06-19 22:34:25','2023-06-19 22:34:25'),(3673,'default','added',17610,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1885.57}}',NULL,'2023-06-19 23:10:21','2023-06-19 23:10:21'),(3674,'default','added',17611,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":806.26}}',NULL,'2023-06-19 23:19:17','2023-06-19 23:19:17'),(3675,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-19 23:19:22','2023-06-19 23:19:22'),(3676,'default','added',17612,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71}}',NULL,'2023-06-19 23:20:42','2023-06-19 23:20:42'),(3677,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-19 23:21:56','2023-06-19 23:21:56'),(3678,'default','added',17613,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-19 23:22:21','2023-06-19 23:22:21'),(3679,'default','added',17614,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1306.46}}',NULL,'2023-06-19 23:22:50','2023-06-19 23:22:50'),(3680,'default','added',17615,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3276}}',NULL,'2023-06-19 23:27:42','2023-06-19 23:27:42'),(3681,'default','added',151,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-19 23:28:47','2023-06-19 23:28:47'),(3682,'default','added',17616,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":358.8}}',NULL,'2023-06-19 23:30:29','2023-06-19 23:30:29'),(3683,'default','added',17617,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":331.25}}',NULL,'2023-06-19 23:31:42','2023-06-19 23:31:42'),(3684,'default','added',17618,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41400}}',NULL,'2023-06-19 23:31:56','2023-06-19 23:31:56'),(3685,'default','added',17619,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133}}',NULL,'2023-06-19 23:34:10','2023-06-19 23:34:10'),(3686,'default','payment_edited',5796,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-19 23:39:22','2023-06-19 23:39:22'),(3687,'default','payment_edited',17056,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-19 23:40:19','2023-06-19 23:40:19'),(3688,'default','payment_edited',17005,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16915.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16915.0000\"}}',NULL,'2023-06-19 23:41:05','2023-06-19 23:41:05'),(3689,'default','payment_edited',17412,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"47485.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"47485.0000\"}}',NULL,'2023-06-19 23:41:47','2023-06-19 23:41:47'),(3690,'default','payment_edited',5831,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-19 23:42:29','2023-06-19 23:42:29'),(3691,'default','payment_edited',16011,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-06-19 23:43:19','2023-06-19 23:43:19'),(3692,'default','payment_edited',16986,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27800.0000\"}}',NULL,'2023-06-19 23:43:19','2023-06-19 23:43:19'),(3693,'default','payment_edited',5841,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-19 23:43:51','2023-06-19 23:43:51'),(3694,'default','added',17620,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-06-19 23:44:40','2023-06-19 23:44:40'),(3695,'default','added',17621,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":278.12}}',NULL,'2023-06-19 23:51:32','2023-06-19 23:51:32'),(3696,'default','added',17622,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-19 23:52:32','2023-06-19 23:52:32'),(3697,'default','added',17623,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98.85}}',NULL,'2023-06-20 00:13:48','2023-06-20 00:13:48'),(3698,'default','added',17624,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-20 00:15:19','2023-06-20 00:15:19'),(3699,'default','added',17625,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-20 00:17:36','2023-06-20 00:17:36'),(3700,'default','added',17626,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130.05}}',NULL,'2023-06-20 00:18:11','2023-06-20 00:18:11'),(3701,'default','added',17627,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118.8}}',NULL,'2023-06-20 00:34:21','2023-06-20 00:34:21'),(3702,'default','added',17628,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65.6}}',NULL,'2023-06-20 00:41:57','2023-06-20 00:41:57'),(3703,'default','added',17629,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1474.19}}',NULL,'2023-06-20 00:43:16','2023-06-20 00:43:16'),(3704,'default','added',17630,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-20 00:46:43','2023-06-20 00:46:43'),(3705,'default','added',17631,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":339}}',NULL,'2023-06-20 00:58:25','2023-06-20 00:58:25'),(3706,'default','added',17632,'App\\Transaction',NULL,2,24,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50.8}}',NULL,'2023-06-20 01:13:46','2023-06-20 01:13:46'),(3707,'default','added',17633,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1474.19}}',NULL,'2023-06-20 01:17:07','2023-06-20 01:17:07'),(3708,'default','added',17634,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.4}}',NULL,'2023-06-20 01:26:53','2023-06-20 01:26:53'),(3709,'default','added',17635,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-20 01:27:38','2023-06-20 01:27:38'),(3710,'default','added',17636,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":458.3}}',NULL,'2023-06-20 01:32:26','2023-06-20 01:32:26'),(3711,'default','added',17637,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-20 01:34:15','2023-06-20 01:34:15'),(3712,'default','added',17638,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":573.16}}',NULL,'2023-06-20 01:48:23','2023-06-20 01:48:23'),(3713,'default','added',17639,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-20 01:49:44','2023-06-20 01:49:44'),(3714,'default','added',17640,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-06-20 01:53:04','2023-06-20 01:53:04'),(3715,'default','added',17641,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-20 01:57:18','2023-06-20 01:57:18'),(3716,'default','added',17642,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1109.79}}',NULL,'2023-06-20 01:58:37','2023-06-20 01:58:37'),(3717,'default','added',17643,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":999}}',NULL,'2023-06-20 02:19:34','2023-06-20 02:19:34'),(3718,'default','added',17644,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-20 02:26:22','2023-06-20 02:26:22'),(3719,'default','added',17645,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-20 02:28:37','2023-06-20 02:28:37'),(3720,'default','added',17646,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":114.1}}',NULL,'2023-06-20 02:36:25','2023-06-20 02:36:26'),(3721,'default','added',17647,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-20 02:42:42','2023-06-20 02:42:42'),(3722,'default','added',17648,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.14}}',NULL,'2023-06-20 02:56:15','2023-06-20 02:56:15'),(3723,'default','added',17649,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265.98}}',NULL,'2023-06-20 03:05:27','2023-06-20 03:05:27'),(3724,'default','added',17650,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.7}}',NULL,'2023-06-20 03:15:02','2023-06-20 03:15:02'),(3725,'default','added',17651,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":195.98}}',NULL,'2023-06-20 03:21:00','2023-06-20 03:21:00'),(3726,'default','added',17652,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245}}',NULL,'2023-06-20 03:24:39','2023-06-20 03:24:39'),(3727,'default','added',17653,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220.8}}',NULL,'2023-06-20 03:36:15','2023-06-20 03:36:15'),(3728,'default','added',17654,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":323.12}}',NULL,'2023-06-20 03:53:25','2023-06-20 03:53:25'),(3729,'default','added',17655,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4183.84}}',NULL,'2023-06-20 04:04:34','2023-06-20 04:04:34'),(3730,'default','added',17656,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":623.71}}',NULL,'2023-06-20 04:06:20','2023-06-20 04:06:20'),(3731,'default','added',17657,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":522.1}}',NULL,'2023-06-20 04:12:22','2023-06-20 04:12:22'),(3732,'default','added',17658,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98.8}}',NULL,'2023-06-20 04:14:06','2023-06-20 04:14:06'),(3733,'default','login',24,'App\\User',NULL,2,24,'App\\User','[]',NULL,'2023-06-20 04:14:31','2023-06-20 04:14:31'),(3734,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-20 14:22:12','2023-06-20 14:22:12'),(3735,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-20 14:59:09','2023-06-20 14:59:09'),(3736,'default','added',17659,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550.53}}',NULL,'2023-06-20 15:01:44','2023-06-20 15:01:44'),(3737,'default','added',17660,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525}}',NULL,'2023-06-20 15:20:12','2023-06-20 15:20:12'),(3738,'default','added',17661,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-20 15:22:38','2023-06-20 15:22:38'),(3739,'default','added',17662,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725.8}}',NULL,'2023-06-20 15:39:08','2023-06-20 15:39:08'),(3740,'default','added',17663,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":97}}',NULL,'2023-06-20 15:47:21','2023-06-20 15:47:21'),(3741,'default','added',17664,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":123.8}}',NULL,'2023-06-20 15:56:23','2023-06-20 15:56:23'),(3742,'default','added',17665,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":399.88}}',NULL,'2023-06-20 16:14:48','2023-06-20 16:14:48'),(3743,'default','added',17666,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72.11}}',NULL,'2023-06-20 16:18:14','2023-06-20 16:18:14'),(3744,'default','added',17667,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":115.4}}',NULL,'2023-06-20 16:33:20','2023-06-20 16:33:20'),(3745,'default','added',17668,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85.35}}',NULL,'2023-06-20 16:35:46','2023-06-20 16:35:46'),(3746,'default','added',17669,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":133.5}}',NULL,'2023-06-20 17:10:05','2023-06-20 17:10:05'),(3747,'default','added',17670,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-20 17:27:28','2023-06-20 17:27:28'),(3748,'default','added',17671,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":741.08}}',NULL,'2023-06-20 18:11:17','2023-06-20 18:11:18'),(3749,'default','added',17672,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-20 18:22:19','2023-06-20 18:22:19'),(3750,'default','added',17673,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-20 18:49:53','2023-06-20 18:49:53'),(3751,'default','added',17674,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1980.89}}',NULL,'2023-06-20 18:56:20','2023-06-20 18:56:20'),(3752,'default','added',17675,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-20 19:29:45','2023-06-20 19:29:45'),(3753,'default','added',17676,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187.5}}',NULL,'2023-06-20 20:01:37','2023-06-20 20:01:38'),(3754,'default','added',17677,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":296.9}}',NULL,'2023-06-20 20:33:10','2023-06-20 20:33:10'),(3755,'default','added',17678,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-06-20 20:47:49','2023-06-20 20:47:49'),(3756,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-20 21:14:08','2023-06-20 21:14:09'),(3757,'default','added',17679,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-06-20 21:33:10','2023-06-20 21:33:10'),(3758,'default','added',17680,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-20 21:34:06','2023-06-20 21:34:06'),(3759,'default','added',17681,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2023-06-20 21:35:01','2023-06-20 21:35:01'),(3760,'default','added',17682,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-20 21:42:20','2023-06-20 21:42:20'),(3761,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-21 00:17:14','2023-06-21 00:17:14'),(3762,'default','added',17683,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":520}}',NULL,'2023-06-21 00:39:14','2023-06-21 00:39:14'),(3763,'default','added',17684,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-21 00:56:34','2023-06-21 00:56:34'),(3764,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-21 00:59:56','2023-06-21 00:59:56'),(3765,'default','login',27,'App\\User',NULL,2,27,'App\\User','[]',NULL,'2023-06-21 01:05:44','2023-06-21 01:05:44'),(3766,'default','added',17685,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3520.48}}',NULL,'2023-06-21 01:09:44','2023-06-21 01:09:44'),(3767,'default','added',17686,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-06-21 01:10:19','2023-06-21 01:10:19'),(3768,'default','added',17687,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294}}',NULL,'2023-06-21 01:10:20','2023-06-21 01:10:20'),(3769,'default','added',17688,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":701.22}}',NULL,'2023-06-21 01:12:08','2023-06-21 01:12:08'),(3770,'default','added',17689,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-21 01:14:25','2023-06-21 01:14:25'),(3771,'default','added',17690,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5750.69}}',NULL,'2023-06-21 01:15:00','2023-06-21 01:15:00'),(3772,'default','added',17691,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":294}}',NULL,'2023-06-21 01:17:45','2023-06-21 01:17:45'),(3773,'default','added',17692,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5268.23}}',NULL,'2023-06-21 01:25:58','2023-06-21 01:25:58'),(3774,'default','added',17693,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":313.5}}',NULL,'2023-06-21 01:28:01','2023-06-21 01:28:01'),(3775,'default','added',17694,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":403.81}}',NULL,'2023-06-21 01:29:43','2023-06-21 01:29:43'),(3776,'default','added',17695,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":168.44}}',NULL,'2023-06-21 01:33:02','2023-06-21 01:33:02'),(3777,'default','added',17696,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":95}}',NULL,'2023-06-21 01:38:39','2023-06-21 01:38:39'),(3778,'default','added',17697,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":270}}',NULL,'2023-06-21 01:41:24','2023-06-21 01:41:24'),(3779,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 01:46:09','2023-06-21 01:46:09'),(3780,'default','added',17698,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47.06}}',NULL,'2023-06-21 01:47:30','2023-06-21 01:47:30'),(3781,'default','added',17699,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19250}}',NULL,'2023-06-21 01:47:47','2023-06-21 01:47:47'),(3782,'default','payment_edited',17407,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"82730.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"82730.0000\"}}',NULL,'2023-06-21 01:56:49','2023-06-21 01:56:49'),(3783,'default','payment_edited',5840,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 01:58:45','2023-06-21 01:58:45'),(3784,'default','payment_edited',17062,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18260.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18260.0000\"}}',NULL,'2023-06-21 01:58:45','2023-06-21 01:58:45'),(3785,'default','payment_edited',17062,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18260.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18260.0000\"}}',NULL,'2023-06-21 01:59:19','2023-06-21 01:59:19'),(3786,'default','added',17700,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8250}}',NULL,'2023-06-21 02:03:08','2023-06-21 02:03:08'),(3787,'default','added',17701,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2576.76}}',NULL,'2023-06-21 02:05:18','2023-06-21 02:05:18'),(3788,'default','added',17702,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-21 02:06:11','2023-06-21 02:06:11'),(3789,'default','added',17703,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":131.7}}',NULL,'2023-06-21 02:19:45','2023-06-21 02:19:45'),(3790,'default','added',17704,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":127.92}}',NULL,'2023-06-21 02:26:33','2023-06-21 02:26:33'),(3791,'default','added',17705,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":112.28}}',NULL,'2023-06-21 02:33:16','2023-06-21 02:33:16'),(3792,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-21 02:51:48','2023-06-21 02:51:48'),(3793,'default','added',17706,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":313.7}}',NULL,'2023-06-21 03:02:42','2023-06-21 03:02:42'),(3794,'default','added',17707,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-21 03:23:04','2023-06-21 03:23:04'),(3795,'default','added',17708,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-21 03:23:39','2023-06-21 03:23:39'),(3796,'default','added',17709,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-06-21 03:25:03','2023-06-21 03:25:03'),(3797,'default','added',17710,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26.7}}',NULL,'2023-06-21 03:29:02','2023-06-21 03:29:02'),(3798,'default','added',17711,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-21 03:39:29','2023-06-21 03:39:29'),(3799,'default','added',17712,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":286.27}}',NULL,'2023-06-21 03:44:46','2023-06-21 03:44:46'),(3800,'default','added',17713,'App\\Transaction',NULL,2,27,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":119.61}}',NULL,'2023-06-21 03:52:06','2023-06-21 03:52:06'),(3801,'default','added',17714,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-21 03:59:20','2023-06-21 03:59:20'),(3802,'default','added',17715,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1022.5}}',NULL,'2023-06-21 04:02:55','2023-06-21 04:02:55'),(3803,'default','added',17716,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":348.8}}',NULL,'2023-06-21 04:10:35','2023-06-21 04:10:35'),(3804,'default','added',17717,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2466.22}}',NULL,'2023-06-21 04:32:27','2023-06-21 04:32:27'),(3805,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 13:09:20','2023-06-21 13:09:20'),(3806,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 13:36:13','2023-06-21 13:36:13'),(3807,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-21 13:46:24','2023-06-21 13:46:24'),(3808,'default','added',17718,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1287}}',NULL,'2023-06-21 13:52:31','2023-06-21 13:52:31'),(3809,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 14:15:19','2023-06-21 14:15:19'),(3810,'default','added',17719,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":188.1}}',NULL,'2023-06-21 14:31:38','2023-06-21 14:31:38'),(3811,'default','added',17720,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-21 14:32:01','2023-06-21 14:32:01'),(3812,'default','added',17721,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":674479.1}}',NULL,'2023-06-21 14:52:30','2023-06-21 14:52:30'),(3813,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-21 15:02:31','2023-06-21 15:02:31'),(3814,'default','added',17722,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":534.43}}',NULL,'2023-06-21 15:27:21','2023-06-21 15:27:21'),(3815,'default','added',17723,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":377.95}}',NULL,'2023-06-21 15:28:30','2023-06-21 15:28:30'),(3816,'default','added',17724,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":505.4}}',NULL,'2023-06-21 15:28:39','2023-06-21 15:28:39'),(3817,'default','payment_edited',5833,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 15:39:39','2023-06-21 15:39:39'),(3818,'default','edited',88,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 15:56:51','2023-06-21 15:56:51'),(3819,'default','added',17725,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":107552}}',NULL,'2023-06-21 15:58:49','2023-06-21 15:58:49'),(3820,'default','added',17726,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3246}}',NULL,'2023-06-21 16:05:16','2023-06-21 16:05:16'),(3821,'default','added',17727,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":552}}',NULL,'2023-06-21 16:06:09','2023-06-21 16:06:09'),(3822,'default','added',17728,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118.8}}',NULL,'2023-06-21 16:11:34','2023-06-21 16:11:34'),(3823,'default','added',17729,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":563.06}}',NULL,'2023-06-21 16:14:00','2023-06-21 16:14:00'),(3824,'default','added',17730,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2023-06-21 16:25:53','2023-06-21 16:25:53'),(3825,'default','added',17731,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-06-21 16:46:54','2023-06-21 16:46:54'),(3826,'default','added',17732,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":760}}',NULL,'2023-06-21 17:04:22','2023-06-21 17:04:22'),(3827,'default','added',17733,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16.02}}',NULL,'2023-06-21 17:04:35','2023-06-21 17:04:35'),(3828,'default','added',17734,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-06-21 17:07:31','2023-06-21 17:07:31'),(3829,'default','edited',63,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 17:14:49','2023-06-21 17:14:49'),(3830,'default','added',17735,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28056}}',NULL,'2023-06-21 17:15:05','2023-06-21 17:15:05'),(3831,'default','added',17736,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-21 17:21:41','2023-06-21 17:21:41'),(3832,'default','added',17737,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-06-21 17:27:22','2023-06-21 17:27:22'),(3833,'default','added',17738,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-06-21 17:38:45','2023-06-21 17:38:45'),(3834,'default','added',17739,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-21 17:39:51','2023-06-21 17:39:51'),(3835,'default','added',17740,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":119.38}}',NULL,'2023-06-21 18:02:53','2023-06-21 18:02:53'),(3836,'default','added',17741,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-06-21 18:12:20','2023-06-21 18:12:20'),(3837,'default','payment_edited',17260,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-21 18:24:10','2023-06-21 18:24:10'),(3838,'default','added',17742,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":417.9}}',NULL,'2023-06-21 18:24:12','2023-06-21 18:24:12'),(3839,'default','payment_edited',17008,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58625.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58625.0000\"}}',NULL,'2023-06-21 18:25:12','2023-06-21 18:25:12'),(3840,'default','payment_edited',17014,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28025.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28025.0000\"}}',NULL,'2023-06-21 18:26:11','2023-06-21 18:26:11'),(3841,'default','payment_edited',16992,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-21 18:27:01','2023-06-21 18:27:01'),(3842,'default','payment_edited',17286,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"55100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"55100.0000\"}}',NULL,'2023-06-21 18:27:47','2023-06-21 18:27:47'),(3843,'default','added',17743,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-21 18:27:52','2023-06-21 18:27:52'),(3844,'default','added',17744,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-06-21 18:30:07','2023-06-21 18:30:07'),(3845,'default','added',17745,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":405.4}}',NULL,'2023-06-21 18:31:50','2023-06-21 18:31:50'),(3846,'default','added',17746,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":313.5}}',NULL,'2023-06-21 18:37:45','2023-06-21 18:37:45'),(3847,'default','added',17747,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":178.4}}',NULL,'2023-06-21 18:38:49','2023-06-21 18:38:49'),(3848,'default','added',17748,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-06-21 18:43:11','2023-06-21 18:43:11'),(3849,'default','added',17749,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1837.02}}',NULL,'2023-06-21 19:03:44','2023-06-21 19:03:44'),(3850,'default','added',17750,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-06-21 19:34:07','2023-06-21 19:34:07'),(3851,'default','added',17751,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-21 19:42:40','2023-06-21 19:42:40'),(3852,'default','added',17752,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-21 19:56:49','2023-06-21 19:56:49'),(3853,'default','added',17753,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63.16}}',NULL,'2023-06-21 20:03:07','2023-06-21 20:03:07'),(3854,'default','added',17754,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}',NULL,'2023-06-21 20:16:15','2023-06-21 20:16:15'),(3855,'default','added',17755,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-21 20:19:25','2023-06-21 20:19:25'),(3856,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-21 20:21:19','2023-06-21 20:21:19'),(3857,'default','added',17756,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51.13}}',NULL,'2023-06-21 20:21:52','2023-06-21 20:21:52'),(3858,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-21 20:25:13','2023-06-21 20:25:13'),(3859,'default','added',17757,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-21 20:58:55','2023-06-21 20:58:55'),(3860,'default','added',17758,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2023-06-21 21:23:21','2023-06-21 21:23:21'),(3861,'default','added',17759,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":159.3}}',NULL,'2023-06-21 21:29:47','2023-06-21 21:29:47'),(3862,'default','added',17760,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":741.13}}',NULL,'2023-06-21 21:46:08','2023-06-21 21:46:08'),(3863,'default','added',17761,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-21 21:59:36','2023-06-21 21:59:36'),(3864,'default','added',17762,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335.55}}',NULL,'2023-06-21 22:09:24','2023-06-21 22:09:24'),(3865,'default','added',17763,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-21 22:24:59','2023-06-21 22:24:59'),(3866,'default','added',17764,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":599}}',NULL,'2023-06-21 22:26:19','2023-06-21 22:26:19'),(3867,'default','added',17765,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2023-06-21 22:26:49','2023-06-21 22:26:49'),(3868,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-21 22:27:27','2023-06-21 22:27:27'),(3869,'default','added',17766,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":743.05}}',NULL,'2023-06-21 22:30:22','2023-06-21 22:30:22'),(3870,'default','added',17767,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53.22}}',NULL,'2023-06-21 22:32:32','2023-06-21 22:32:32'),(3871,'default','added',17768,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":130}}',NULL,'2023-06-21 22:35:37','2023-06-21 22:35:38'),(3872,'default','added',17769,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2023-06-21 22:36:52','2023-06-21 22:36:52'),(3873,'default','added',17770,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":138.6}}',NULL,'2023-06-21 22:48:34','2023-06-21 22:48:34'),(3874,'default','added',17771,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":393}}',NULL,'2023-06-21 22:59:55','2023-06-21 22:59:55'),(3875,'default','added',17772,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1688.04}}',NULL,'2023-06-21 23:00:35','2023-06-21 23:00:35'),(3876,'default','added',17773,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":460}}',NULL,'2023-06-21 23:07:51','2023-06-21 23:07:51'),(3877,'default','added',17774,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":217.2}}',NULL,'2023-06-21 23:14:50','2023-06-21 23:14:50'),(3878,'default','added',17775,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":469}}',NULL,'2023-06-21 23:15:14','2023-06-21 23:15:14'),(3879,'default','added',17776,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":974.06}}',NULL,'2023-06-21 23:15:59','2023-06-21 23:15:59'),(3880,'default','added',17777,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-06-21 23:21:35','2023-06-21 23:21:35'),(3881,'default','added',17778,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-21 23:22:30','2023-06-21 23:22:30'),(3882,'default','added',17779,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-21 23:23:51','2023-06-21 23:23:51'),(3883,'default','added',17780,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-06-21 23:33:34','2023-06-21 23:33:34'),(3884,'default','added',17781,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":277.8}}',NULL,'2023-06-21 23:36:11','2023-06-21 23:36:11'),(3885,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-21 23:37:22','2023-06-21 23:37:22'),(3886,'default','added',17782,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":353.75}}',NULL,'2023-06-21 23:37:33','2023-06-21 23:37:33'),(3887,'default','added',17783,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":407.01}}',NULL,'2023-06-21 23:41:36','2023-06-21 23:41:36'),(3888,'default','added',17784,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-21 23:45:09','2023-06-21 23:45:09'),(3889,'default','added',17785,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-22 00:08:27','2023-06-22 00:08:27'),(3890,'default','added',17786,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":525.1}}',NULL,'2023-06-22 00:17:51','2023-06-22 00:17:51'),(3891,'default','added',17787,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2488.3}}',NULL,'2023-06-22 00:21:33','2023-06-22 00:21:33'),(3892,'default','added',152,'App\\Contact',NULL,2,4,'App\\User','[]',NULL,'2023-06-22 00:21:59','2023-06-22 00:21:59'),(3893,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-22 00:24:13','2023-06-22 00:24:13'),(3894,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 00:24:37','2023-06-22 00:24:37'),(3895,'default','added',17788,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":104.55}}',NULL,'2023-06-22 00:27:30','2023-06-22 00:27:30'),(3896,'default','added',17789,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1638}}',NULL,'2023-06-22 00:37:08','2023-06-22 00:37:08'),(3897,'default','added',17790,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":71.5}}',NULL,'2023-06-22 00:43:31','2023-06-22 00:43:31'),(3898,'default','added',17791,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88.52}}',NULL,'2023-06-22 00:43:47','2023-06-22 00:43:47'),(3899,'default','added',17792,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16800}}',NULL,'2023-06-22 00:44:43','2023-06-22 00:44:43'),(3900,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 00:46:28','2023-06-22 00:46:28'),(3901,'default','added',153,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-22 00:48:30','2023-06-22 00:48:30'),(3902,'default','added',154,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 00:49:48','2023-06-22 00:49:48'),(3903,'default','added',17793,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":490}}',NULL,'2023-06-22 00:51:26','2023-06-22 00:51:26'),(3904,'default','added',17794,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8108}}',NULL,'2023-06-22 00:51:38','2023-06-22 00:51:38'),(3905,'default','added',17795,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":387.5}}',NULL,'2023-06-22 00:56:58','2023-06-22 00:56:58'),(3906,'default','added',17796,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":438.08}}',NULL,'2023-06-22 00:57:40','2023-06-22 00:57:40'),(3907,'default','added',17797,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":45464}}',NULL,'2023-06-22 00:58:26','2023-06-22 00:58:26'),(3908,'default','edited',99,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2023-06-22 01:00:54','2023-06-22 01:00:54'),(3909,'default','added',17798,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":136250}}',NULL,'2023-06-22 01:07:01','2023-06-22 01:07:01'),(3910,'default','added',17799,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360.73}}',NULL,'2023-06-22 01:08:53','2023-06-22 01:08:53'),(3911,'default','added',17800,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198.51}}',NULL,'2023-06-22 01:27:41','2023-06-22 01:27:41'),(3912,'default','added',17801,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3258}}',NULL,'2023-06-22 01:33:36','2023-06-22 01:33:36'),(3913,'default','added',17802,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":327.08}}',NULL,'2023-06-22 01:34:01','2023-06-22 01:34:01'),(3914,'default','added',17803,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":728.01}}',NULL,'2023-06-22 01:39:15','2023-06-22 01:39:15'),(3915,'default','added',17804,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-22 01:43:12','2023-06-22 01:43:12'),(3916,'default','added',17805,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":332.07}}',NULL,'2023-06-22 01:44:46','2023-06-22 01:44:46'),(3917,'default','added',17806,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":695}}',NULL,'2023-06-22 01:46:27','2023-06-22 01:46:27'),(3918,'default','added',17807,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-06-22 01:48:52','2023-06-22 01:48:52'),(3919,'default','edited',17801,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":3258},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"3258.0000\"}}',NULL,'2023-06-22 02:00:15','2023-06-22 02:00:15'),(3920,'default','added',155,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 02:01:34','2023-06-22 02:01:34'),(3921,'default','added',17808,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":282.1}}',NULL,'2023-06-22 02:04:19','2023-06-22 02:04:19'),(3922,'default','added',17809,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-06-22 02:08:44','2023-06-22 02:08:44'),(3923,'default','added',17810,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-22 02:16:52','2023-06-22 02:16:52'),(3924,'default','added',17811,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1638}}',NULL,'2023-06-22 02:18:40','2023-06-22 02:18:40'),(3925,'default','added',17812,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2276.01}}',NULL,'2023-06-22 02:24:54','2023-06-22 02:24:54'),(3926,'default','added',17813,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-06-22 02:30:50','2023-06-22 02:30:50'),(3927,'default','added',17814,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":976.7}}',NULL,'2023-06-22 02:45:53','2023-06-22 02:45:53'),(3928,'default','added',17815,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":104639.8}}',NULL,'2023-06-22 03:01:40','2023-06-22 03:01:40'),(3929,'default','edited',17813,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":290.2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"120.0000\"}}',NULL,'2023-06-22 03:04:29','2023-06-22 03:04:29'),(3930,'default','added',17816,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":77.99}}',NULL,'2023-06-22 03:09:51','2023-06-22 03:09:51'),(3931,'default','edited',17815,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":111379.8},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"104639.8000\"}}',NULL,'2023-06-22 03:25:07','2023-06-22 03:25:07'),(3932,'default','edited',17815,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"111379.8000\"}}',NULL,'2023-06-22 03:28:40','2023-06-22 03:28:40'),(3933,'default','added',17817,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190.31}}',NULL,'2023-06-22 03:43:29','2023-06-22 03:43:29'),(3934,'default','added',17818,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35.2}}',NULL,'2023-06-22 03:45:46','2023-06-22 03:45:46'),(3935,'default','added',17819,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":147.49}}',NULL,'2023-06-22 04:00:20','2023-06-22 04:00:20'),(3936,'default','added',17820,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":937.78}}',NULL,'2023-06-22 04:01:50','2023-06-22 04:01:50'),(3937,'default','added',17821,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-22 04:12:06','2023-06-22 04:12:07'),(3938,'default','edited',17815,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}',NULL,'2023-06-22 04:12:21','2023-06-22 04:12:21'),(3939,'default','added',17822,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-06-22 04:21:11','2023-06-22 04:21:11'),(3940,'default','added',17823,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":89.88}}',NULL,'2023-06-22 04:23:52','2023-06-22 04:23:52'),(3941,'default','edited',17787,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2488.16},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2488.3000\"}}',NULL,'2023-06-22 04:40:30','2023-06-22 04:40:30'),(3942,'default','added',17824,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37.25}}',NULL,'2023-06-22 04:46:25','2023-06-22 04:46:25'),(3943,'default','added',17825,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":70970}}',NULL,'2023-06-22 04:50:08','2023-06-22 04:50:08'),(3944,'default','edited',17825,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":71570},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"70970.0000\"}}',NULL,'2023-06-22 05:04:44','2023-06-22 05:04:44'),(3945,'default','added',17826,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71}}',NULL,'2023-06-22 05:05:37','2023-06-22 05:05:37'),(3946,'default','edited',17826,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":623.71},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"623.7100\"}}',NULL,'2023-06-22 05:05:50','2023-06-22 05:05:50'),(3947,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2023-06-22 13:26:27','2023-06-22 13:26:27'),(3948,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-22 13:37:55','2023-06-22 13:37:55'),(3949,'default','payment_edited',5832,'App\\Transaction',NULL,3,3,'App\\User','[]',NULL,'2023-06-22 13:39:50','2023-06-22 13:39:50'),(3950,'default','payment_edited',17077,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"25245.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"25245.0000\"}}',NULL,'2023-06-22 13:40:50','2023-06-22 13:40:50'),(3951,'default','payment_edited',17077,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"25245.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"25245.0000\"}}',NULL,'2023-06-22 13:41:36','2023-06-22 13:41:36'),(3952,'default','added',17827,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7708}}',NULL,'2023-06-22 13:48:27','2023-06-22 13:48:27'),(3953,'default','added',17828,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":456.4}}',NULL,'2023-06-22 13:51:40','2023-06-22 13:51:40'),(3954,'default','added',17829,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":356.25}}',NULL,'2023-06-22 13:52:25','2023-06-22 13:52:25'),(3955,'default','payment_edited',16986,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27800.0000\"}}',NULL,'2023-06-22 14:11:54','2023-06-22 14:11:54'),(3956,'default','payment_edited',16988,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27800.0000\"}}',NULL,'2023-06-22 14:11:54','2023-06-22 14:11:54'),(3957,'default','payment_edited',17725,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"107552.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"107552.0000\"}}',NULL,'2023-06-22 14:15:41','2023-06-22 14:15:41'),(3958,'default','edited',17725,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":107552},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"107552.0000\"}}',NULL,'2023-06-22 14:21:04','2023-06-22 14:21:04'),(3959,'default','added',17830,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4344.19}}',NULL,'2023-06-22 15:14:05','2023-06-22 15:14:05'),(3960,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-22 15:32:52','2023-06-22 15:32:52'),(3961,'default','added',17831,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":281.68}}',NULL,'2023-06-22 15:42:57','2023-06-22 15:42:57'),(3962,'default','added',17832,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":139.39}}',NULL,'2023-06-22 16:01:59','2023-06-22 16:01:59'),(3963,'default','login',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-22 16:08:45','2023-06-22 16:08:45'),(3964,'default','added',17833,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177.2}}',NULL,'2023-06-22 16:18:19','2023-06-22 16:18:19'),(3965,'default','added',17834,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-22 16:32:57','2023-06-22 16:32:57'),(3966,'default','added',17835,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":132.66}}',NULL,'2023-06-22 16:39:04','2023-06-22 16:39:04'),(3967,'default','added',17836,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13775}}',NULL,'2023-06-22 16:42:06','2023-06-22 16:42:06'),(3968,'default','added',17837,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25.4}}',NULL,'2023-06-22 16:51:45','2023-06-22 16:51:45'),(3969,'default','added',17838,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-06-22 16:56:18','2023-06-22 16:56:18'),(3970,'default','added',17839,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18.53}}',NULL,'2023-06-22 17:04:24','2023-06-22 17:04:24'),(3971,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 17:18:45','2023-06-22 17:18:45'),(3972,'default','added',17840,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9700}}',NULL,'2023-06-22 17:24:48','2023-06-22 17:24:48'),(3973,'default','added',17841,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":775}}',NULL,'2023-06-22 17:34:49','2023-06-22 17:34:49'),(3974,'default','added',17842,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-06-22 17:41:34','2023-06-22 17:41:34'),(3975,'default','added',17843,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22040}}',NULL,'2023-06-22 18:15:09','2023-06-22 18:15:09'),(3976,'default','added',17844,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":441.77}}',NULL,'2023-06-22 18:15:59','2023-06-22 18:15:59'),(3977,'default','added',17845,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2023-06-22 18:21:17','2023-06-22 18:21:17'),(3978,'default','added',17846,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4480}}',NULL,'2023-06-22 18:23:20','2023-06-22 18:23:20'),(3979,'default','added',17847,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49.88}}',NULL,'2023-06-22 18:26:53','2023-06-22 18:26:53'),(3980,'default','payment_edited',17846,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4480.0000\"}}',NULL,'2023-06-22 18:35:41','2023-06-22 18:35:41'),(3981,'default','payment_edited',17792,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16800.0000\"}}',NULL,'2023-06-22 18:36:27','2023-06-22 18:36:27'),(3982,'default','payment_edited',17411,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-22 18:38:54','2023-06-22 18:38:54'),(3983,'default','payment_edited',16992,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27550.0000\"}}',NULL,'2023-06-22 18:39:49','2023-06-22 18:39:49'),(3984,'default','added',17848,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":215.3}}',NULL,'2023-06-22 18:45:44','2023-06-22 18:45:44'),(3985,'default','logout',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-22 18:54:39','2023-06-22 18:54:39'),(3986,'default','login',31,'App\\User',NULL,2,31,'App\\User','[]',NULL,'2023-06-22 18:55:46','2023-06-22 18:55:46'),(3987,'default','added',17849,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":109.88}}',NULL,'2023-06-22 19:03:06','2023-06-22 19:03:06'),(3988,'default','added',17850,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-22 19:04:26','2023-06-22 19:04:26'),(3989,'default','added',17851,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":952.85}}',NULL,'2023-06-22 19:04:44','2023-06-22 19:04:44'),(3990,'default','added',17852,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":218.8}}',NULL,'2023-06-22 19:06:14','2023-06-22 19:06:14'),(3991,'default','added',17853,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":630}}',NULL,'2023-06-22 19:24:07','2023-06-22 19:24:07'),(3992,'default','added',17854,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":385}}',NULL,'2023-06-22 19:24:52','2023-06-22 19:24:52'),(3993,'default','added',17855,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17.26}}',NULL,'2023-06-22 19:31:31','2023-06-22 19:31:31'),(3994,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-22 19:34:31','2023-06-22 19:34:31'),(3995,'default','login',4,'App\\User',NULL,2,4,'App\\User','[]',NULL,'2023-06-22 19:34:58','2023-06-22 19:34:58'),(3996,'default','added',17856,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":191.9}}',NULL,'2023-06-22 19:36:43','2023-06-22 19:36:43'),(3997,'default','added',17857,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":405}}',NULL,'2023-06-22 19:51:27','2023-06-22 19:51:27'),(3998,'default','added',17858,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1093.75}}',NULL,'2023-06-22 19:52:10','2023-06-22 19:52:10'),(3999,'default','added',17859,'App\\Transaction',NULL,2,29,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2534.4}}',NULL,'2023-06-22 19:53:18','2023-06-22 19:53:18'),(4000,'default','logout',29,'App\\User',NULL,2,29,'App\\User','[]',NULL,'2023-06-22 20:10:12','2023-06-22 20:10:12'),(4001,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2023-06-22 20:10:30','2023-06-22 20:10:30'),(4002,'default','added',17860,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":12596.92}}',NULL,'2023-06-22 20:13:47','2023-06-22 20:13:47'),(4003,'default','added',17862,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2543.39}}',NULL,'2023-06-22 20:15:01','2023-06-22 20:15:01'),(4004,'default','added',17863,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280.3}}',NULL,'2023-06-22 20:16:27','2023-06-22 20:16:27'),(4005,'default','sell_deleted',17863,'App\\Transaction',NULL,2,2,'App\\User','{\"id\":17863,\"invoice_no\":\"2023-2341\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"280.3000\"}}',NULL,'2023-06-22 20:16:40','2023-06-22 20:16:40'),(4006,'default','added',17864,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280.3}}',NULL,'2023-06-22 20:17:11','2023-06-22 20:17:11'),(4007,'default','added',17865,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":267.62}}',NULL,'2023-06-22 20:27:50','2023-06-22 20:27:50'),(4008,'default','added',17866,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":427.6}}',NULL,'2023-06-22 20:34:37','2023-06-22 20:34:37'),(4009,'default','added',17867,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2820.64}}',NULL,'2023-06-22 20:35:45','2023-06-22 20:35:45'),(4010,'default','added',17868,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-06-22 20:37:26','2023-06-22 20:37:26'),(4011,'default','added',17869,'App\\Transaction',NULL,2,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2563.73}}',NULL,'2023-06-22 20:40:20','2023-06-22 20:40:20'),(4012,'default','added',17870,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":82.1}}',NULL,'2023-06-22 20:42:42','2023-06-22 20:42:42'),(4013,'default','added',17871,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-06-22 20:57:47','2023-06-22 20:57:47'),(4014,'default','added',17872,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":117.6}}',NULL,'2023-06-22 20:58:51','2023-06-22 20:58:51'),(4015,'default','added',17873,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":140}}',NULL,'2023-06-22 20:59:12','2023-06-22 20:59:12'),(4016,'default','added',17874,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":370.6}}',NULL,'2023-06-22 21:02:17','2023-06-22 21:02:17'),(4017,'default','added',17875,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-22 21:04:59','2023-06-22 21:04:59'),(4018,'default','added',17876,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2023-06-22 21:15:12','2023-06-22 21:15:12'),(4019,'default','added',17877,'App\\Transaction',NULL,2,31,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2039.2}}',NULL,'2023-06-22 21:22:18','2023-06-22 21:22:18'),(4020,'default','added',17878,'App\\Transaction',NULL,2,4,'App\\User','{\"attributes\":{\"type\":\"